/***************************************************************************
                            KSpellConfig.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSPELLCONFIG_H
#define KSPELLCONFIG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 A configuration class/dialog for @ref KSpell.

 It contains all of the options settings.The options are set to default
 values by the constructor and can be reset either by using the 
 public interface or by using KSpellConfig as a widget in a dialog 
 (or, preferably a tabbed dialog using @ref KDialogBase) and letting 
 the user change the settings. This way an application that uses 
 @ref KSpell can either rely on the default settings (in the simplest 
 case), offer a dialog to configure @ref KSpell, or offer a dialog to 
 configure @ref KSpell _for_this_app_only_ (in which case, the application 
 should save the settings for use next time it is run).
 This last option might be useful in an email program, for example, where
 people may be writing in a language different from that used for
 writing papers in their word processor.

 @author David Sweet <dsweet@kde.org>

 @version $Id: KSpellConfig.h,v 1.3 2002/03/15 02:12:23 rdale Exp $

 @short 
 A configuration class/dialog for @ref KSpell.
*/
@interface KSpellConfig : QWidget 

/** 
 Constructs a KSpellConfig with default or custom settings. 

     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name spellConfig: (KSpellConfig*)spellConfig addHelpButton: (BOOL)addHelpButton;
- init;
- copyWithZone: (NSZone *) zone;
- (void) dealloc;

/** 

 The @p _ignorelist contains words you'd like @ref KSpell
 to ignore when it is spellchecking.  When you get a KSpellConfig
 object back from @ref KSpell (using @ref -[KSpell kcConfig]),
 the @p _ignorelist contains whatever was put in by you plus 
 any words the user has chosen to ignore via the dialog box.  
 It may be useful to save this list with the document being 
 edited to facilitate quicker future spellchecking.
     
*/
- setIgnoreList: (NSArray *)_ignorelist;

/** 
 Set an ISpell option.

 If @p true, don't create root-affix combinations.
     
*/
- setNoRootAffix: (BOOL)arg1;

/** 
 Set an ISpell option.

 If @p true, treat run-together words a valid.
     
*/
- setRunTogether: (BOOL)arg1;

/** 
 Set the name of the dictionary to use.
     
*/
- setDictionary: (NSString *)qs;
- setDictFromList: (BOOL)dfl;

/** 

     
*/
- setEncoding: (int)enctype;
- setClient: (int)client;

/** 
 Options reading routines.
     
*/
- (BOOL) noRootAffix;
- (BOOL) runTogether;
- (NSString *) dictionary;
- (BOOL) dictFromList;
- (int) encoding;
- (NSArray *) ignoreList;
- (int) client;

/** 
 Call this method before this class is deleted  if you want 
 the settings you have (or the user has) chosen to become the 
 global, default settings.
     
*/
- (BOOL) writeGlobalSettings;

/** 
 Use this function to activate the help information for this 
 widget. The function is particulary useful if the help button is
 not displayed as specified by the constructor. Normally you want
 to hide the help button if this widget is embedded into a larger
 dialog box that has its own help button. See kedit 
 (optiondialog.cpp) for an example 
     
*/
- activateHelp;
- fillInDialog;
- (BOOL) readGlobalSettings;

/** 
 This takes a dictionary file name (fname) and returns a language 
 abbreviation (lname; like de for German), appropriate for the
 $LANG variable, and a human-readble name (hname; like "Deutsch").

 It also truncates ".aff" at the end of fname.

 TRUE is returned if lname.-data==$LANG
     
*/
- (BOOL) interpret: (NSString *)fname lname: (NSString *)lname hname: (NSString *)hname;
- sHelp;
- sNoAff: (BOOL)arg1;
- sRunTogether: (BOOL)arg1;
- sDictionary: (BOOL)arg1;
- sPathDictionary: (BOOL)arg1;
- sSetDictionary: (int)arg1;
- sChangeEncoding: (int)arg1;
- sChangeClient: (int)arg1;
+ (int) rdictlist;
+ (int) rencoding;
+ (int) rhelp;
@end

/** Override these methods in subclasses of KSpellConfig to customise event handling behaviour */
@protocol KSpellConfigEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
