/***************************************************************************
                            KScriptClientInterface.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSCRIPTCLIENTINTERFACE_H
#define KSCRIPTCLIENTINTERFACE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

	This class is used for allowing feedback to the main system.

 @author Ian Reinhart Geiser <geiseri@kde.org>

 @short 
	This class is used for allowing feedback to the main system.
*/
@class QVariant; 

@interface  KScriptClientInterface : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
	This function will allow the main application of any errors
	that have occured during processing of the script.
		
*/
- error: (NSString *)msg;

/** 
	This function will allow the main application of any warnings
	that have occured during the processing of the script.
		
*/
- warning: (NSString *)msg;

/** 
	This function will allow the main application of any normal
	output that has occured during the processing of the script.
		
*/
- output: (NSString *)msg;

/** 
	This function will allow feedback to any progress bars in the main
	application as to how far along the script is.  This is very useful when
	a script is processing files or doing some long operation that is of a
	known duration.
		
*/
- progress: (int)percent;

/** 
	This function will allow feedback on completion of the script.
	It turns the result as a @ref -[KScriptInteface Result], and a return
	value as a @ref QVariant
		
*/
- done: (int)result returned: (QVariant *)returned;
+ (int) ResultSuccess;
+ (int) ResultFailure;
+ (int) ResultContinue;
+ (int) ResultBreak;
@end

#endif
