/***************************************************************************
                            KKeyDialog.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KKEYDIALOG_H
#define KKEYDIALOG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialogBase.h>

/**

 The KKeyDialog class is used for configuring dictionaries of key/action
 associations for KAccel and KGlobalAccel. It uses the KKeyChooser widget
 and offers buttons to set all keys to defaults and invoke on-line help.

 Three static methods are supplied which provide the most convienient interface
 to the dialog. For example you could use KAccel and KKeyDialog like this

 <pre>
 KAccel keys;

 keys.insertItem( i18n( "Zoom in" ), "Zoom in", "+" );
 keys.connectItem( "Zoom in", myWindow, SLOT( -zoomIn ) );

 keys.connectItem( -[KAccel Print], myWindow, SLOT( -print ) );

 keys.-readSettings;

 if( -[KKeyDialog configureKeys]( &keys ) ) {
	      ...
 }
 </pre>

 This will also implicitly save the settings. If you don't want this,
 you can call

 <pre>
 if( -[KKeyDialog configureKeys]( &keys, false ) ) { // do not save settings
	      ...
 }
 </pre>

 For XML-UI applications, this is much simpler. All you need to do is
 <pre>
 -[KKeyDialog configureKeys](-actionCollection, -xmlFile);
 </pre>

 @author Nicolas Hadacek <hadacek@via.ecp.fr>
 
 @version $Id: KKeyDialog.h,v 1.3 2002/03/15 02:12:21 rdale Exp $

 @short Dialog for configuration of @ref KAccel and @ref KGlobalAccel.

*/
@class KAccel; 
@class KActionCollection; 
@class KGlobalAccel; 

@interface KKeyDialog : KDialogBase 
- initWithBOOL: (BOOL)bAllowLetterShortcuts parent: (QWidget *)parent name: (NSString *)name;
- init;
- (void) dealloc;
- (BOOL) insert: (KActionCollection*)arg1;
- (BOOL) configure: (BOOL)bSaveSettings;
- (BOOL) configure;
- commitChanges;

/** 
 Pops up a modal dialog for configuring key settings. The dialog is initialized
 from a @ref KAccelBase object, and the modifications are written to that object
 when the dialog is closed.

*/
+ (int) configureKeys: (KAccel*)keys parent: (QWidget *)parent bSaveSettings: (BOOL)bSaveSettings;
+ (int) configureKeys: (KAccel*)keys ;
+ (int) configureGlobalKeys: (KGlobalAccel*)keys parent: (QWidget *)parent bSaveSettings: (BOOL)bSaveSettings;
+ (int) configureGlobalKeys: (KGlobalAccel*)keys ;

/** 
 Pops up a modal dialog for configuring key settings. The dialog is initialized
 from an action collection (for XMLGUI based applications).

*/
+ (int) configureCollection: (KActionCollection*)coll parent: (QWidget *)parent bSaveSettings: (BOOL)bSaveSettings;
+ (int) configureCollection: (KActionCollection*)coll ;
+ (int) configureKeys: (KAccel*)keys save_settings: (BOOL)save_settings parent: (QWidget *)parent;
+ (int) configureKeys: (KAccel*)keys ;
+ (int) configureGlobalKeys: (KGlobalAccel*)keys save_settings: (BOOL)save_settings parent: (QWidget *)parent;
+ (int) configureGlobalKeys: (KGlobalAccel*)keys ;
+ (int) configureCollection: (KActionCollection*)coll string: (NSString *)arg1 save_settings: (BOOL)save_settings parent: (QWidget *)parent;
+ (int) configureCollection: (KActionCollection*)coll string: (NSString *)arg1 ;
@end

/** Override these methods in subclasses of KKeyDialog to customise event handling behaviour */
@protocol KKeyDialogEventHandling

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
