/***************************************************************************
                            KFileDetailView.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILEDETAILVIEW_H
#define KFILEDETAILVIEW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KFileView.h>
#include <kdeobjc/KListView.h>

/**

 A list-view capable of showing @ref KFileItem'. Used in the filedialog
 for example. Most of the documentation is in @ref KFileView class.

 @short 
 A list-view capable of showing @ref KFileItem'.
*/
@class KActionCollection; 
@class KFileItem; 

@class KFileListViewItem; 
@class KFileViewSignaler; 

@interface KFileDetailView : KListView 
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- (void) dealloc;
- (QWidget*) widget;
- clearView;
- setAutoUpdate: (BOOL)arg1;
- setSelectionMode: (int)sm;
- updateView: (BOOL)arg1;
- updateFileView: (KFileItem*)arg1;
- removeFileItem: (KFileItem*)arg1;
- listingCompleted;
- setSelected: (KFileItem*)arg1 bool: (BOOL)arg2;
- (BOOL) isSelected: (KFileItem*)i;
- clearSelection;
- selectAll;
- invertSelection;
- setCurrentItem: (KFileItem*)arg1;
- (KFileItem*) currentFileItem;
- (KFileItem*) firstFileItem;
- (KFileItem*) nextItem: (KFileItem*)arg1;
- (KFileItem*) prevItem: (KFileItem*)arg1;
- insertFileItem: (KFileItem*)i;
- setSorting: (int)arg1;
- ensureItemVisible: (KFileItem*)arg1;
- mimeTypeDeterminationFinished;
- determineIcon: (KFileListViewItem*)item;
- (QScrollView*) scrollWidget;
- slotSelectionChanged;
@end

@class KFileViewItem; 

@class KActionCollection; 
@class KFileItem; 

@class KFileListViewItem; 
@class KFileViewSignaler; 

@interface KFileDetailView (KFileViewImplementation) <KFileViewInterface>
@end

/** Override these methods in subclasses of KFileDetailView to customise event handling behaviour */
@protocol KFileDetailViewEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- focusOutEvent:(QFocusEvent*) fe;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- leaveEvent:(QEvent*) e;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) e;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;

/** 
 A special keyPressEvent (for Konqueror-style selection).
   
*/
- konquerorKeyPressEvent:(QKeyEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsDropEvent:(QDropEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- focusInEvent:(QFocusEvent*) fe;
- imEndEvent:(QIMEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsDragLeaveEvent:(QDragLeaveEvent*) event;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsMouseDoubleClickEvent:(QMouseEvent*) e;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsDragMoveEvent:(QDragMoveEvent*) event;
- moveEvent:(QMoveEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsMouseReleaseEvent:(QMouseEvent*) arg1;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsDragEnterEvent:(QDragEnterEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsMouseMoveEvent:(QMouseEvent*) e;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsMousePressEvent:(QMouseEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;

/** 
 Reimplemented for -setFullWidth
   
*/
- viewportResizeEvent:(QResizeEvent*) e;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
