/***************************************************************************
                            kde_KToolBarButton.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KTOOLBARBUTTON
#define KDE_KTOOLBARBUTTON

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A toolbar button. This is used internally by @ref KToolBar, use the
 KToolBar methods instead.

 
 @short *
 A toolbar button.
*/

/** *
 Construct a button with an icon loaded by the button itself.
 This will trust the button to load the correct icon with the
 correct size.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KToolBarButton * kde_new_KToolBarButton(qt_QString * icon, int identifier, qt_QWidget * parent, char* name, qt_QString * txt, kde_KInstance* _instance);

/** *
 Construct a button with an existing pixmap.  It is not
 recommended that you use this as the internal icon loading code
 will almost always get it "right".

*/
kde_KToolBarButton * kde_new_KToolBarButton1(qt_QPixmap * pixmap, int identifier, qt_QWidget * parent, char* name, qt_QString * txt);

/** *
 Construct a separator button

*/
kde_KToolBarButton * kde_new_KToolBarButton2(qt_QWidget * parent, char* name);

/** *
 Standard destructor
   
*/
void kde_del_KToolBarButton( kde_KToolBarButton* p );

/** *

 Set the pixmap directly for this button.  This pixmap should be
 the active one... the dimmed and disabled pixmaps are constructed
 based on this one.  However, don't use this function unless you
 are positive that you don't want to use @ref setIcon.

*/
void kde_KToolBarButton_setPixmap(kde_KToolBarButton* instPointer,qt_QPixmap * pixmap);

/** *

 Force the button to use this pixmap as the default one rather
 then generating it using effects.

*/
void kde_KToolBarButton_setDefaultPixmap(kde_KToolBarButton* instPointer,qt_QPixmap * pixmap);

/** *

 Force the button to use this pixmap when disabled one rather then
 generating it using effects.

*/
void kde_KToolBarButton_setDisabledPixmap(kde_KToolBarButton* instPointer,qt_QPixmap * pixmap);

/** *
 Set the text for this button.  The text will be either used as a
 tooltip (IconOnly) or will be along side the icon

*/
void kde_KToolBarButton_setText(kde_KToolBarButton* instPointer,qt_QString * text);

/** *
 Set the icon for this button. The icon will be loaded internally
 with the correct size. This function is preferred over @ref setIconSet

*/
void kde_KToolBarButton_setIcon(kde_KToolBarButton* instPointer,qt_QString * icon);
void kde_KToolBarButton_setIcon1(kde_KToolBarButton* instPointer,qt_QPixmap * pixmap);

/** *
 Set the pixmaps for this toolbar button from a QIconSet.
 If you call this you don't need to call any of the other methods
 that set icons or pixmaps.

*/
void kde_KToolBarButton_setIconSet(kde_KToolBarButton* instPointer,qt_QIconSet* iconset);

/** *

 Set the active icon for this button.  The pixmap itself is loaded
 internally based on the icon size...  .. the disabled and default
 pixmaps, however will only be constructed if @ref #generate is
 true.  This function is preferred over @ref setPixmap

*/
void kde_KToolBarButton_setIcon2(kde_KToolBarButton* instPointer,qt_QString * icon, int arg1);

/** *

 Force the button to use this icon as the default one rather
 then generating it using effects.

*/
void kde_KToolBarButton_setDefaultIcon(kde_KToolBarButton* instPointer,qt_QString * icon);

/** *

 Force the button to use this icon when disabled one rather then
 generating it using effects.

*/
void kde_KToolBarButton_setDisabledIcon(kde_KToolBarButton* instPointer,qt_QString * icon);

/** *
 Turn this button on or off

*/
void kde_KToolBarButton_on(kde_KToolBarButton* instPointer,int flag);

/** *
 Toggle this button
   
*/
void kde_KToolBarButton_toggle(kde_KToolBarButton* instPointer);

/** *
 Turn this button into a toggle button or disable the toggle
 aspects of it.  This does not toggle the button itself.
 Use @ref toggle() for that.

*/
void kde_KToolBarButton_setToggle(kde_KToolBarButton* instPointer,int toggle);

/** *
 Return a pointer to this button's popup menu (if it exists)
   
*/
qt_QPopupMenu* kde_KToolBarButton_popup(kde_KToolBarButton* instPointer);

/** *
 Give this button a popup menu.  There will not be a delay when
 you press the button.  Use @ref setDelayedPopup if you want that
 behavior. You can also make the popup-menu
 "sticky", i.e. visible until a selection is made or the mouse is
 clikced elsewhere, by simply setting the second argument to true.
 This "sticky" button feature allows you to make a selection without
 having to press and hold down the mouse while making a selection.

*/
void kde_KToolBarButton_setPopup(kde_KToolBarButton* instPointer,qt_QPopupMenu* p, int toggle);

/** *
 Gives this button a delayed popup menu.

 This function allows you to add a delayed popup menu to the button.
 The popup menu is then only displayed when the button is pressed and
 held down for about half a second.  You can also make the popup-menu
 "sticky", i.e. visible until a selection is made or the mouse is
 clikced elsewhere, by simply setting the second argument to true.
 This "sticky" button feature allows you to make a selection without
 having to press and hold down the mouse while making a selection.

*/
void kde_KToolBarButton_setDelayedPopup(kde_KToolBarButton* instPointer,qt_QPopupMenu* p, int toggle);

/** *
 Turn this button into a radio button

*/
void kde_KToolBarButton_setRadio(kde_KToolBarButton* instPointer,int f);

/** *
 Toolbar buttons naturally will assume the global styles
 concerning icons, icons sizes, etc.  You can use this function to
 explicitely turn this off, if you like.

*/
void kde_KToolBarButton_setNoStyle(kde_KToolBarButton* instPointer,int no_style);

/** *
 This slot should be called whenever the toolbar mode has
 potentially changed.  This includes such events as text changing,
 orientation changing, etc.
   
*/
void kde_KToolBarButton_modeChange(kde_KToolBarButton* instPointer);
void kde_KToolBarButton_setTextLabel(kde_KToolBarButton* instPointer,qt_QString * arg1, int tipToo);
void kde_KToolBarButton_paletteChange(kde_KToolBarButton* instPointer,qt_QPalette * arg1);
void kde_KToolBarButton_drawButton(kde_KToolBarButton* instPointer,qt_QPainter * p);
int kde_KToolBarButton_eventFilter(kde_KToolBarButton* instPointer,qt_QObject * o, qt_QEvent * e);
void kde_KToolBarButton_showMenu(kde_KToolBarButton* instPointer);
qt_QSize * kde_KToolBarButton_sizeHint(kde_KToolBarButton* instPointer);
qt_QSize * kde_KToolBarButton_minimumSizeHint(kde_KToolBarButton* instPointer);
qt_QSize * kde_KToolBarButton_minimumSize(kde_KToolBarButton* instPointer);
int kde_KToolBarButton_isRaised(kde_KToolBarButton* instPointer);
int kde_KToolBarButton_isActive(kde_KToolBarButton* instPointer);
int kde_KToolBarButton_iconTextMode(kde_KToolBarButton* instPointer);
void kde_KToolBarButton_virtual_hook(kde_KToolBarButton* instPointer,int identifier, void* data);
void kde_KToolBarButton_slotClicked(kde_KToolBarButton* instPointer);
void kde_KToolBarButton_slotPressed(kde_KToolBarButton* instPointer);
void kde_KToolBarButton_slotReleased(kde_KToolBarButton* instPointer);
void kde_KToolBarButton_slotToggled(kde_KToolBarButton* instPointer);
void kde_KToolBarButton_slotDelayTimeout(kde_KToolBarButton* instPointer);

#ifdef __cplusplus
}
#endif
#endif
