/***************************************************************************
                            kde_KMainWindow.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KMAINWINDOW
#define KDE_KMAINWINDOW

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Top level widget that provides toolbars, a status line and a frame.

 It should be used as a top level (parent-less) widget.
 It manages the geometry for all its children, including your
 main widget.

 Normally, you will inherit from KMainWindow,
 then construct (or use some existing) widget as
 your main view. You can set only one main view.

 You can add as many toolbars as you like. There can be only one menubar
 and only one statusbar.

 The toolbars, menubar, and statusbar can be created by the
 KMainWindow and - unlike the old KMainWindow - may, but do not
 have to, be deleted by you. KMainWindow will handle that internally.

 Height and width can be operated independently from each other. Simply
 define the minimum/maximum height/width of your main widget and
 KMainWindow will take this into account. For fixed size windows set
 your main widget to a fixed size.

 Fixed aspect ratios (heightForWidth()) and fixed width widgets are
 not supported.

 KMainWindow will set icon, mini icon and caption, which it gets
 from @ref KApplication. It provides full session management, and
 will save its position, geometry and positions of toolbars and
 menubar on logout. If you want to save additional data, reimplement
 @ref saveProperties() and (to read them again on next login) @ref
 readProperties(). To save special data about your data, reimplement
 @ref saveGlobalProperties(). To warn user that application or
 windows have unsaved data on close or logout, reimplement @ref
 queryClose() and/or @ref queryExit().

 There is also a macro RESTORE which can restore all your windows
 on next login.

  Note that a KMainWindow per-default is created with the
  WDestructiveClose flag, i.e. it is automatically destroyed when the
  window is closed. If you do not want this behavior, specify 0 as
  widget flag in the constructor.

 
 @author Reginald Stadlbauer (reggie@kde.org) Stephan Kulow (coolo@kde.org), Matthias Ettrich (ettrich@kde.org), Chris Schlaeger (cs@kde.org), Sven Radej (radej@kde.org). Maintained by Sven Radej (radej@kde.org)

 @short KDE top level main window.
*/

/** *
 Construct a main window.

 KMainWindows must be created on the heap with 'new', like:
  <pre> KMainWindow *kmw = new KMainWindow (...</pre>

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KMainWindow * kde_new_KMainWindow(qt_QWidget * parent, char* name, int f);

/** *
 Destructor.

 Will also destroy the toolbars, and menubar if
 needed.
     
*/
void kde_del_KMainWindow( kde_KMainWindow* p );

/** *
 Retrieve the standard help menu.

 It contains entires for the
 help system (activated by F1), an optional "What's This?" entry
 (activated by Shift F1), an application specific dialog box,
 and an "About KDE" dialog box.

 Example (adding a standard help menu to your application):
 <pre>
 KPopupMenu *help = helpMenu( <myTextString> );
 menuBar()->insertItem( i18n("&Help"), help );
 </pre>

*/
kde_KPopupMenu* kde_KMainWindow_helpMenu(kde_KMainWindow* instPointer,qt_QString * aboutAppText, int showWhatsThis);

/** *
 Returns the help menu. Creates a standard help menu if none exists yet.

 It contains entries for the
 help system (activated by F1), an optional "What's This?" entry
 (activated by Shift F1), an application specific dialog box,
 and an "About KDE" dialog box. You must create the application
 specific dialog box yourself. When the "About application"
 menu entry is activated, a signal will trigger the
 @ref showAboutApplication slot. See @ref showAboutApplication for more
 information.

 Example (adding a help menu to your application):
 <pre>
 menuBar()->insertItem( i18n("&Help"), customHelpMenu() );
 </pre>

*/
kde_KPopupMenu* kde_KMainWindow_customHelpMenu(kde_KMainWindow* instPointer,int showWhatsThis);

/** *
 Restore the session specified by @p number.

 Returns @p false if this
 fails, otherwise returns @p true and shows the window.
 You should call @ref canBeRestored() first.
 If @p show is true (default), this widget will be shown automatically.
     
*/
int kde_KMainWindow_restore(kde_KMainWindow* instPointer,int number, int show);
kde_KXMLGUIFactory* kde_KMainWindow_guiFactory(kde_KMainWindow* instPointer);

/** *
 Create a GUI given a local XML file.

 If @p xmlfile is NULL,
 then it will try to construct a local XML filename like
 appnameui.rc where 'appname' is your app's name.  If that file
 does not exist, then the XML UI code will only use the global
 (standard) XML file for the layout purposes.

 Note that when passing true for the conserveMemory argument subsequent
 calls to guiFactory()->addClient/removeClient may not work as expected.
 Also retrieving references to containers like popup menus or toolbars using
 the container method will not work.

*/
void kde_KMainWindow_createGUI(kde_KMainWindow* instPointer,qt_QString * xmlfile, int _conserveMemory);

/** *
 Enables the build of a standard help menu when calling createGUI().

 The default behavior is to build one, you must call this function
 to disable it
     
*/
void kde_KMainWindow_setHelpMenuEnabled(kde_KMainWindow* instPointer,int showHelpMenu);

/** *
 Return @p true when the help menu is enabled
     
*/
int kde_KMainWindow_isHelpMenuEnabled(kde_KMainWindow* instPointer);

/** *
 Returns true, if there is a menubar

*/
int kde_KMainWindow_hasMenuBar(kde_KMainWindow* instPointer);

/** *
 Returns a pointer to the menu bar.

 If there is no menu bar yet one will be created.

*/
kde_KMenuBar* kde_KMainWindow_menuBar(kde_KMainWindow* instPointer);

/** *
 Returns a pointer to the status bar.

  If there is no
 status bar yet one will be created.
     
*/
kde_KStatusBar* kde_KMainWindow_statusBar(kde_KMainWindow* instPointer);

/** *
 Returns a pointer to the toolbar with the specified name.
 This refers to toolbars created dynamically from the XML UI
 framework.  If the toolbar does not exist one will be created.

*/
kde_KToolBar* kde_KMainWindow_toolBar(kde_KMainWindow* instPointer,char* name);

/** *

*/
kde_KAccel* kde_KMainWindow_accel(kde_KMainWindow* instPointer);
void kde_KMainWindow_setFrameBorderWidth(kde_KMainWindow* instPointer,int arg1);

/** *
 Call this to enable "auto-save" of toolbar/menubar/statusbar settings
 (and optionally window size).
 If the *bars were moved around/shown/hidden when the window is closed,
 saveMainWindowSettings( KGlobal::config(), groupName ) will be called.

 Typically, you will call setAutoSaveSettings() in your
 KMainWindow-inherited class constructor, and it will take care
 of restoring and saving automatically. Make sure you call this
 _after all_ your *bars have been created.
     
*/
void kde_KMainWindow_setAutoSaveSettings(kde_KMainWindow* instPointer,qt_QString * arg1, int saveWindowSize);

/** *
 Disable the auto-save-settings feature.
 You don't normally need to call this, ever.
     
*/
void kde_KMainWindow_resetAutoSaveSettings(kde_KMainWindow* instPointer);

/** *

*/
int kde_KMainWindow_autoSaveSettings(kde_KMainWindow* instPointer);

/** *
 Read settings for statusbar, menubar and toolbar from their respective
 groups in the config file and apply them.

*/
void kde_KMainWindow_applyMainWindowSettings(kde_KMainWindow* instPointer,kde_KConfig* config, qt_QString * groupName);

/** *
 Save settings for statusbar, menubar and toolbar to their respective
 groups in the config file @p config.

*/
void kde_KMainWindow_saveMainWindowSettings(kde_KMainWindow* instPointer,kde_KConfig* config, qt_QString * groupName);

/** *
 Sets whether KMainWindow should provide a menu that allows showing/hiding
 the available toolbars ( using @ref KToggleToolBarAction ) . In case there
 is only one toolbar configured a simple 'Show <toolbar name here>' menu item
 is shown.

 The menu / menu item is implemented using xmlgui. It will be inserted in your
 menu structure in the 'Settings' menu.

 If your application uses a non-standard xmlgui resource file then you can
 specify the exact position of the menu / menu item by adding a
 &lt;Merge name="StandardToolBarMenuHandler" /&gt;
 line to the settings menu section of your resource file ( usually appname.rc ).

 Note that you should enable this feature before calling createGUI() ( or similar ) .
 You enable/disable it anytime if you pass false to the conserveMemory argument of createGUI.

*/
void kde_KMainWindow_setStandardToolBarMenuEnabled(kde_KMainWindow* instPointer,int enable);
int kde_KMainWindow_isStandardToolBarMenuEnabled(kde_KMainWindow* instPointer);

/** *
 Returns a pointer to the mainwindows action responsible for the toolbars menu

*/
kde_KAction* kde_KMainWindow_toolBarMenuAction(kde_KMainWindow* instPointer);
void kde_KMainWindow_finalizeGUI(kde_KMainWindow* instPointer,kde_KXMLGUIClient* client);

/** *

     
*/
void kde_KMainWindow_finalizeGUI1(kde_KMainWindow* instPointer,int force);

/** *

*/
int kde_KMainWindow_initialGeometrySet(kde_KMainWindow* instPointer);

/** *

*/
qt_QSize * kde_KMainWindow_sizeForCentralWidgetSize(kde_KMainWindow* instPointer,qt_QSize * size);

/** *
 Makes a KDE compliant caption.

*/
void kde_KMainWindow_setCaption(kde_KMainWindow* instPointer,qt_QString * caption);

/** *
 Makes a KDE compliant caption.

*/
void kde_KMainWindow_setCaption1(kde_KMainWindow* instPointer,qt_QString * caption, int modified);

/** *
 Make a plain caption without any modifications.

*/
void kde_KMainWindow_setPlainCaption(kde_KMainWindow* instPointer,qt_QString * caption);

/** *
 Open the help page for the application.

  The application name is
 used as a key to determine what to display and the system will attempt
 to open <appName>/index.html.

 This method is intended for use by a help button in the toolbar or
 components outside the regular help menu. Use @ref helpMenu() when you
 want to provide access to the help system from the help menu.

 Example (adding a help button to the first toolbar):

 <pre>
 KIconLoader &loader = *KGlobal::iconLoader();
 QPixmap pixmap = loader.loadIcon( "help" );
 toolBar(0)->insertButton( pixmap, 0, SIGNAL(clicked()),
   this, SLOT(appHelpActivated()), true, i18n("Help") );
 </pre>

     
*/
void kde_KMainWindow_appHelpActivated(kde_KMainWindow* instPointer);

/** *
 Apply a state change

 Enable and disable actions as defined in the XML rc file

*/
void kde_KMainWindow_slotStateChanged(kde_KMainWindow* instPointer,qt_QString * newstate);

/** *
 Apply a state change

 Enable and disable actions as defined in the XML rc file,
 can "reverse" the state (disable the actions which should be
 enabled, and vice-versa) if specified.

*/

/** *

     
*/
void kde_KMainWindow_setSettingsDirty(kde_KMainWindow* instPointer);

/** *

 Try to restore the toplevel widget as defined by the number (1..X).

 If the session did not contain so high a number, the configuration
 is not changed and @p false returned.

 That means clients could simply do the following:
 <pre>
 if (kapp->isRestored()){
   int n = 1;
   while (KMainWindow::canBeRestored(n)){
     (new childMW)->restore(n);
     n++;
   }
 } else {
 }
 </pre>
 Note that @ref QWidget::show() is called implicitly in restore.

 With this you can easily restore all toplevel windows of your
 application.

 If your application uses different kinds of toplevel
 windows, then you can use @ref KMainWindow::classNameOfToplevel(n)
 to determine the exact type before calling the childMW
 constructor in the example from above.

 If your client has only one kind of toplevel widgets (which should
 be pretty usual) then you should use the RESTORE-macro:

 <pre>
 if (kapp->isRestored())
   RESTORE(childMW)
 else {
 }
 </pre>

 The macro expands to the term above but is easier to use and
 less code to write.

     
*/
int kde_KMainWindow_canBeRestored( int number);

/** *
 Returns the @ref className() of the @p number of the toplevel window which
 should be restored.

  This is only useful if your application uses
 different kinds of toplevel windows.
     
*/
qt_QString * kde_KMainWindow_classNameOfToplevel( int number);

/** *
 Reimplemented to call the queryClose() and queryExit() handlers.

 We recommend that you reimplement the handlers rather than @ref closeEvent().
 If you do it anyway, ensure to call the base implementation to keep
 @ref queryExit() running.
     
*/

/** *
       Called before the very last window is closed, either by the
       user or indirectly by the session manager.

       It is not recommended to do any user interaction in this
       function other than indicating severe errors. Better ask the
       user on @ref queryClose() (see below).

       However, @ref queryExit() is useful to do some final cleanups. A
       typical example would be to write configuration data back.

       Note that the application may continue to run after @ref queryExit()
       (the user may have cancelled a shutdown). The purpose of
       @ref queryExit() is purely to prepare the application (with possible
       user interaction) so it can safely be closed later (without
       user interaction).

       If you need to do serious things on exit (like shutting a
       dial-up connection down), connect to the signal
       @ref KApplication::shutDown().

       Default implementation returns @p true. Returning @p false will
       cancel the exiting. In the latter case, the last window will
       remain visible.

*/
int kde_KMainWindow_queryExit(kde_KMainWindow* instPointer);

/** *
       Called before the window is closed, either by the user or indirectly by
       the session manager.

       The purpose of this function is to prepare the window in a way that it is
       safe to close it, i.e. without the user losing some data.

       Default implementation returns true. Returning @p false will cancel
       the closing.

       Reimplement this function to prevent the user from losing data.
       Example:
       <pre>

           switch ( KMessageBox::warningYesNoCancel( this,
				   i18n("Save changes to Document Foo?")) ) {
           case KMessageBox::Yes :
             // save document here. If saving fails, return FALSE;
             return TRUE;
           case KMessageBox::No :
             return TRUE;
           default: // cancel
             return FALSE;

    </pre>

    
*/
int kde_KMainWindow_queryClose(kde_KMainWindow* instPointer);

/** *
 Save your instance-specific properties. The function is
 invoked when the session manager requests your application
 to save its state.

 You @em must @em not change the group of the @p kconfig object, since
 KMainWindow uses one group for each window.  Please
 reimplement these function in childclasses.

 Note: No user interaction is allowed
 in this function!

     
*/
void kde_KMainWindow_saveProperties(kde_KMainWindow* instPointer,kde_KConfig* arg1);

/** *
 Read your instance-specific properties.
    
*/
void kde_KMainWindow_readProperties(kde_KMainWindow* instPointer,kde_KConfig* arg1);

/** *
 Save your application-wide properties. The function is
 invoked when the session manager requests your application
 to save its state.

 This function is similar to @ref saveProperties() but is only called for
 the very first main window, regardless how many main window are open.

 Override it if you need to save other data about your documents on
 session end. sessionConfig is a config to which that data should be
 saved. Normally, you don't need this function. But if you want to save
 data about your documents that are not in opened windows you might need
 it.

 Default implementation does nothing.
     
*/
void kde_KMainWindow_saveGlobalProperties(kde_KMainWindow* instPointer,kde_KConfig* sessionConfig);

/** *
 The counterpart of @ref saveGlobalProperties().

 Read the application-specific properties in again.
     
*/
void kde_KMainWindow_readGlobalProperties(kde_KMainWindow* instPointer,kde_KConfig* sessionConfig);
void kde_KMainWindow_savePropertiesInternal(kde_KMainWindow* instPointer,kde_KConfig* arg1, int arg2);
int kde_KMainWindow_readPropertiesInternal(kde_KMainWindow* instPointer,kde_KConfig* arg1, int arg2);

/** *
 For inherited classes
     
*/
int kde_KMainWindow_settingsDirty(kde_KMainWindow* instPointer);

/** *
 For inherited classes
     
*/
qt_QString * kde_KMainWindow_settingsGroup(kde_KMainWindow* instPointer);

/** *
 For inherited classes
 Note that the group must be set before calling
     
*/
void kde_KMainWindow_saveWindowSize(kde_KMainWindow* instPointer,kde_KConfig* config);

/** *
 For inherited classes
 Note that the group must be set before calling, and that
 a -geometry on the command line has priority.
     
*/
void kde_KMainWindow_restoreWindowSize(kde_KMainWindow* instPointer,kde_KConfig* config);
void kde_KMainWindow_parseGeometry(kde_KMainWindow* instPointer,int parsewidth);
void kde_KMainWindow_virtual_hook(kde_KMainWindow* instPointer,int identifier, void* data);

/** *
 This slot does nothing.

 It must be reimplemented if you want
 to use a custom About Application dialog box. This slot is
 connected to the About Application entry in the menu returned
 by @ref customHelpMenu.

 Example:
 <pre>

 void MyMainLevel::setupInterface()
 {
   ..
   menuBar()->insertItem( i18n("&Help"), customHelpMenu() );
   ..
 }

 void MyMainLevel::showAboutApplication()
 {
   <activate your custom dialog>
 }
 </pre>
    
*/
void kde_KMainWindow_showAboutApplication(kde_KMainWindow* instPointer);

/** Casts a 'kde_KMainWindow *' to a 'kde_KXMLGUIBuilder*' */
kde_KXMLGUIBuilder* kde_KMainWindow_KXMLGUIBuilder(kde_KMainWindow* instPointer);

/** Casts a 'kde_KMainWindow *' to a 'kde_KXMLGUIClient*' */
kde_KXMLGUIClient* kde_KMainWindow_KXMLGUIClient(kde_KMainWindow* instPointer);

/** Casts a 'kde_KMainWindow *' to a 'qt_QMainWindow*' */
qt_QMainWindow* kde_KMainWindow_QMainWindow(kde_KMainWindow* instPointer);

#ifdef __cplusplus
}
#endif
#endif
