/***************************************************************************
                            kde_KConfigBase.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCONFIGBASE
#define KDE_KCONFIGBASE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Abstract base class for KDE configuration entries.

 This class forms the base for all KDE configuration. It is an
 abstract base class, meaning that you cannot directly instantiate
 objects of this class. Either use @ref KConfig (for usual KDE
 configuration) or @ref KSimpleConfig (for special needs as in ksamba), or
 even KSharedConfig (stores values in shared memory).

 All configuration entries are key, value pairs.  Each entry also
 belongs to a specific group of related entries.  All configuration
 entries that do not explicitly specify which group they are in are
 in a special group called the default group.

 If there is a $ character in an entry, KConfigBase tries to expand
 environment variable and uses its value instead of its name. You
 can avoid this feature by having two consecutive $ characters in
 your config file which get expanded to one.

 Note: the '=' char is not allowed in keys and the ']' char is not allowed in
 group name.

 @author Kalle Dalheimer <kalle@kde.org>, Preston Brown <pbrown@kde.org>

 @version $Id: kde_KConfigBase.h,v 1.5 2002/12/30 14:37:05 geiseri Exp $

 @short KDE Configuration Management abstract base class.
*/
#define KCONFIGBASE_NoAccess	0
#define KCONFIGBASE_ReadOnly	1
#define KCONFIGBASE_ReadWrite	2

/** *
 Destructs the KConfigBase object.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
void kde_del_KConfigBase( kde_KConfigBase* p );

/** *
 Specifies the group in which keys will be read and written.

  Subsequent
 calls to @ref readEntry() and @ref writeEntry() will be aplied only in the
 activated group.

 Switch back to the default group by passing a null string.

*/
void kde_KConfigBase_setGroup(kde_KConfigBase* instPointer,qt_QString * group);

/** *
 Sets the group to the "Desktop Entry" group used for
 desktop configuration files for applications, mime types, etc.
   
*/
void kde_KConfigBase_setDesktopGroup(kde_KConfigBase* instPointer);

/** *
 Returns the name of the group in which we are
  searching for keys and from which we are retrieving entries.

*/
qt_QString * kde_KConfigBase_group(kde_KConfigBase* instPointer);

/** *
 Returns true if the specified group is known about.

*/
int kde_KConfigBase_hasGroup(kde_KConfigBase* instPointer,qt_QString * group);

/** *
 Returns a list of groups that are known about.

*/
qt_QStringList* kde_KConfigBase_groupList(kde_KConfigBase* instPointer);

/** *
 Returns a the current locale.

*/
qt_QString * kde_KConfigBase_locale(kde_KConfigBase* instPointer);

/** *
 Reads the value of an entry specified by @p pKey in the current group.

*/
qt_QString * kde_KConfigBase_readEntry(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QString * aDefault);

/** *
 Reads the value of an entry specified by @p pKey in the current group.

*/
qt_QString * kde_KConfigBase_readEntry1(kde_KConfigBase* instPointer,char* pKey, qt_QString * aDefault);

/** *
 Reads the value of an entry specified by @p pKey in the current group.
 The value is treated as if it is of the given type.

 Note that only the following QVariant types are allowed : String,
 StringList, List, Font, Point, Rect, Size, Color, Int, UInt, Bool,
 Double, DateTime and Date.

*/
qt_QVariant * kde_KConfigBase_readPropertyEntry(kde_KConfigBase* instPointer,qt_QString * pKey, int arg1);

/** *
 Reads the value of an entry specified by @p pKey in the current group.
 The value is treated as if it is of the given type.

 Note that only the following QVariant types are allowed : String,
 StringList, List, Font, Point, Rect, Size, Color, Int, UInt, Bool,
 Double, DateTime and Date.

*/
qt_QVariant * kde_KConfigBase_readPropertyEntry1(kde_KConfigBase* instPointer,char* pKey, int arg1);

/** *
 Reads the value of an entry specified by @p pKey in the current group.
 The value is treated as if it is of the type of the given default value.

 Note that only the following QVariant types are allowed : String,
 StringList, List, Font, Point, Rect, Size, Color, Int, UInt, Bool,
 Double, DateTime and Date.

*/
qt_QVariant * kde_KConfigBase_readPropertyEntry2(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QVariant * adefault);

/** *
 Reads the value of an entry specified by @p pKey in the current group.
 The value is treated as if it is of the type of the given default value.

 Note that only the following QVariant types are allowed : String,
 StringList, List, Font, Point, Rect, Size, Color, Int, UInt, Bool,
 Double, DateTime and Date.

*/
qt_QVariant * kde_KConfigBase_readPropertyEntry3(kde_KConfigBase* instPointer,char* pKey, qt_QVariant * aDefault);

/** *
 Reads a list of strings.

*/

/** *
 Reads a list of strings.

*/

/** *
 Reads a list of strings.

*/

/** *
 Reads a list of strings.

*/

/** *
 Reads a path.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a path. This means, dollar expansion is activated
 for this value, so that e.g. $HOME gets expanded.

*/
qt_QString * kde_KConfigBase_readPathEntry(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QString * aDefault);

/** *
 Reads a path.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a path. This means, dollar expansion is activated
 for this value, so that e.g. $HOME gets expanded.

*/
qt_QString * kde_KConfigBase_readPathEntry1(kde_KConfigBase* instPointer,char* pKey, qt_QString * aDefault);

/** *
 Reads a numerical value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
int kde_KConfigBase_readNumEntry(kde_KConfigBase* instPointer,qt_QString * pKey, int nDefault);

/** *
 Reads a numerical value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
int kde_KConfigBase_readNumEntry1(kde_KConfigBase* instPointer,char* pKey, int nDefault);

/** *
 Reads an unsigned numerical value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
unsigned int kde_KConfigBase_readUnsignedNumEntry(kde_KConfigBase* instPointer,qt_QString * pKey, unsigned int nDefault);

/** *
 Reads an unsigned numerical value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
unsigned int kde_KConfigBase_readUnsignedNumEntry1(kde_KConfigBase* instPointer,char* pKey, unsigned int nDefault);

/** *
 Reads a numerical value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
long kde_KConfigBase_readLongNumEntry(kde_KConfigBase* instPointer,qt_QString * pKey, long nDefault);

/** *
 Reads a numerical value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
long kde_KConfigBase_readLongNumEntry1(kde_KConfigBase* instPointer,char* pKey, long nDefault);

/** *
 Read an unsigned numerical value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
unsigned long kde_KConfigBase_readUnsignedLongNumEntry(kde_KConfigBase* instPointer,qt_QString * pKey, unsigned long nDefault);

/** *
 Read an unsigned numerical value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
unsigned long kde_KConfigBase_readUnsignedLongNumEntry1(kde_KConfigBase* instPointer,char* pKey, unsigned long nDefault);

/** *
 Reads a floating point value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
double kde_KConfigBase_readDoubleNumEntry(kde_KConfigBase* instPointer,qt_QString * pKey, double nDefault);

/** *
 Reads a floating point value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it numerically.

*/
double kde_KConfigBase_readDoubleNumEntry1(kde_KConfigBase* instPointer,char* pKey, double nDefault);

/** *
 Reads a @ref QFont value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a font object.

*/
qt_QFont * kde_KConfigBase_readFontEntry(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QFont * pDefault);

/** *
 Reads a @ref QFont value.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a font object.

*/
qt_QFont * kde_KConfigBase_readFontEntry1(kde_KConfigBase* instPointer,char* pKey, qt_QFont * pDefault);

/** *
 Reads a boolean entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a boolean value. Currently "on" and "true" are
 accepted as true, everything else if false.

*/
int kde_KConfigBase_readBoolEntry(kde_KConfigBase* instPointer,qt_QString * pKey, int bDefault);

/** *
 Reads a boolean entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a boolean value. Currently "on" and "true" are
 accepted as true, everything else if false.

*/
int kde_KConfigBase_readBoolEntry1(kde_KConfigBase* instPointer,char* pKey, int bDefault);

/** *
 Reads a @ref QRect entry.

 Read the value of an entry specified by pKey in the current group
 and interpret it as a @ref QRect object.

*/
qt_QRect* kde_KConfigBase_readRectEntry(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QRect* pDefault);

/** *
 Reads a @ref QRect entry.

 Read the value of an entry specified by pKey in the current group
 and interpret it as a @ref QRect object.

*/
qt_QRect* kde_KConfigBase_readRectEntry1(kde_KConfigBase* instPointer,char* pKey, qt_QRect* pDefault);

/** *
 Reads a @ref QPoint entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a @ref QPoint object.

*/
qt_QPoint* kde_KConfigBase_readPointEntry(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QPoint* pDefault);

/** *
 Reads a @ref QPoint entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a @ref QPoint object.

*/
qt_QPoint* kde_KConfigBase_readPointEntry1(kde_KConfigBase* instPointer,char* pKey, qt_QPoint* pDefault);

/** *
 Reads a @ref QSize entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a @ref QSize object.

*/
qt_QSize * kde_KConfigBase_readSizeEntry(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QSize* pDefault);

/** *
 Reads a @ref QSize entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a @ref QSize object.

*/
qt_QSize * kde_KConfigBase_readSizeEntry1(kde_KConfigBase* instPointer,char* pKey, qt_QSize* pDefault);

/** *
 Reads a @ref QColor entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a color.

*/
qt_QColor * kde_KConfigBase_readColorEntry(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QColor* pDefault);

/** *
 Reads a @ref QColor entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a color.

*/
qt_QColor * kde_KConfigBase_readColorEntry1(kde_KConfigBase* instPointer,char* pKey, qt_QColor* pDefault);

/** *
 Reads a @ref QDateTime entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a date and time.

*/
qt_QDateTime * kde_KConfigBase_readDateTimeEntry(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QDateTime* pDefault);

/** *
 Reads a @ref QDateTime entry.

 Read the value of an entry specified by @p pKey in the current group
 and interpret it as a date and time.

*/
qt_QDateTime * kde_KConfigBase_readDateTimeEntry1(kde_KConfigBase* instPointer,char* pKey, qt_QDateTime* pDefault);

/** *
 Reads the value of an entry specified by @p pKey in the current group.
 The untranslated entry is returned, you normally do not need this.

*/
qt_QString * kde_KConfigBase_readEntryUntranslated(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QString * aDefault);

/** *
 Reads the value of an entry specified by @p pKey in the current group.
 The untranslated entry is returned, you normally do not need this.

*/
qt_QString * kde_KConfigBase_readEntryUntranslated1(kde_KConfigBase* instPointer,char* pKey, qt_QString * aDefault);

/** *
 Writes a key/value pair.

 This is stored in the most specific config file when destroying the
 config object or when calling @ref sync().

*/
void kde_KConfigBase_writeEntry(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QString * pValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a key/value pair.

 This is stored in the most specific config file when destroying the
 config object or when calling @ref sync().

*/
void kde_KConfigBase_writeEntry1(kde_KConfigBase* instPointer,char* pKey, qt_QString * pValue, int bPersistent, int bGlobal, int bNLS);

/** *
 @ref writeEntry() Overridden to accept a property.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/
void kde_KConfigBase_writeEntry2(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QVariant * rValue, int bPersistent, int bGlobal, int bNLS);

/** *
 @ref writeEntry() Overridden to accept a property.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/
void kde_KConfigBase_writeEntry3(kde_KConfigBase* instPointer,char* pKey, qt_QVariant * rValue, int bPersistent, int bGlobal, int bNLS);

/** *
 @ref writeEntry() overridden to accept a list of strings.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/

/** *
 @ref writeEntry() overridden to accept a list of strings.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/

/** *
 @ref writeEntry() overridden to accept a list of strings.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/

/** *
 @ref writeEntry() overridden to accept a list of strings.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/

/** *
 Write a (key/value) pair.

 This is stored to the most specific config file when destroying the
 config object or when calling @ref sync().

*/
void kde_KConfigBase_writeEntry10(kde_KConfigBase* instPointer,qt_QString * pKey, char* pValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Write a (key/value) pair.

 This is stored to the most specific config file when destroying the
 config object or when calling @ref sync().

*/
void kde_KConfigBase_writeEntry11(kde_KConfigBase* instPointer,char* pKey, char* pValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Write a (key/value) pair.
 Same as above, but writes a numerical value.

*/
void kde_KConfigBase_writeEntry12(kde_KConfigBase* instPointer,qt_QString * pKey, int nValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Write a (key/value) pair.
 Same as above, but writes a numerical value.

*/
void kde_KConfigBase_writeEntry13(kde_KConfigBase* instPointer,char* pKey, int nValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes an unsigned numerical value.

*/
void kde_KConfigBase_writeEntry14(kde_KConfigBase* instPointer,qt_QString * pKey, unsigned int nValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes an unsigned numerical value.

*/
void kde_KConfigBase_writeEntry15(kde_KConfigBase* instPointer,char* pKey, unsigned int nValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but write a long numerical value.

*/
void kde_KConfigBase_writeEntry16(kde_KConfigBase* instPointer,qt_QString * pKey, long nValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but write a long numerical value.

*/
void kde_KConfigBase_writeEntry17(kde_KConfigBase* instPointer,char* pKey, long nValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes an unsigned long numerical value.

*/
void kde_KConfigBase_writeEntry18(kde_KConfigBase* instPointer,qt_QString * pKey, unsigned long nValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes an unsigned long numerical value.

*/
void kde_KConfigBase_writeEntry19(kde_KConfigBase* instPointer,char* pKey, unsigned long nValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a floating-point value.

*/
void kde_KConfigBase_writeEntry20(kde_KConfigBase* instPointer,qt_QString * pKey, double nValue, int bPersistent, int bGlobal, char format, int precision, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a floating-point value.

*/
void kde_KConfigBase_writeEntry21(kde_KConfigBase* instPointer,char* pKey, double nValue, int bPersistent, int bGlobal, char format, int precision, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a boolean value.

*/
void kde_KConfigBase_writeEntry22(kde_KConfigBase* instPointer,qt_QString * pKey, int bValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a boolean value.

*/
void kde_KConfigBase_writeEntry23(kde_KConfigBase* instPointer,char* pKey, int bValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a font value.

*/
void kde_KConfigBase_writeEntry24(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QFont * rFont, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a font value.

*/
void kde_KConfigBase_writeEntry25(kde_KConfigBase* instPointer,char* pKey, qt_QFont * rFont, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but write a color entry.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/
void kde_KConfigBase_writeEntry26(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QColor * rColor, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but write a color entry.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/
void kde_KConfigBase_writeEntry27(kde_KConfigBase* instPointer,char* pKey, qt_QColor * rColor, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a date and time entry.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 @em not returned here!

*/
void kde_KConfigBase_writeEntry28(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QDateTime * rDateTime, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a date and time entry.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 @em not returned here!

*/
void kde_KConfigBase_writeEntry29(kde_KConfigBase* instPointer,char* pKey, qt_QDateTime * rDateTime, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a rectangle.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/
void kde_KConfigBase_writeEntry30(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QRect* rValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a rectangle.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/
void kde_KConfigBase_writeEntry31(kde_KConfigBase* instPointer,char* pKey, qt_QRect* rValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a point.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/
void kde_KConfigBase_writeEntry32(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QPoint* rValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a point.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/
void kde_KConfigBase_writeEntry33(kde_KConfigBase* instPointer,char* pKey, qt_QPoint* rValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a size.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/
void kde_KConfigBase_writeEntry34(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QSize * rValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a (key/value) pair.
 Same as above, but writes a size.

 Note: Unlike the other @ref writeEntry() functions, the old value is
 _not_ returned here!

*/
void kde_KConfigBase_writeEntry35(kde_KConfigBase* instPointer,char* pKey, qt_QSize * rValue, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a file path.

 It is checked whether the path is located under $HOME. If so the
 path is written out with the user's home-directory replaced with
 $HOME. The path should be read back with @ref readPathEntry()

*/
void kde_KConfigBase_writePathEntry(kde_KConfigBase* instPointer,qt_QString * pKey, qt_QString * path, int bPersistent, int bGlobal, int bNLS);

/** *
 Writes a file path.

 It is checked whether the path is located under $HOME. If so the
 path is written out with the user's home-directory replaced with
 $HOME. The path should be read back with @ref readPathEntry()

*/
void kde_KConfigBase_writePathEntry1(kde_KConfigBase* instPointer,char* pKey, qt_QString * path, int bPersistent, int bGlobal, int bNLS);

/** *
 Deletes the entry specified by @p pKey in the current group.

*/
void kde_KConfigBase_deleteEntry(kde_KConfigBase* instPointer,qt_QString * pKey, int bNLS, int bGlobal);

/** *
 Deletes the entry specified by @p pKey in the current group.

*/
void kde_KConfigBase_deleteEntry1(kde_KConfigBase* instPointer,char* pKey, int bNLS, int bGlobal);

/** *
 Deletes a configuration entry group

 If the group is not empty and bDeep is false, nothing gets
 deleted and false is returned.
 If this group is the current group and it is deleted, the
 current group is undefined and should be set with setGroup()
 before the next operation on the configuration object.

*/
int kde_KConfigBase_deleteGroup(kde_KConfigBase* instPointer,qt_QString * group, int bDeep, int bGlobal);

/** *
 Turns on or off "dollar  expansion" (see KConfigBase introduction)
  when reading config entries.
 Dollar sign expansion is initially OFF.

*/
void kde_KConfigBase_setDollarExpansion(kde_KConfigBase* instPointer,int _bExpand);

/** *
 Returns whether dollar expansion is on or off.  It is initially OFF.

*/
int kde_KConfigBase_isDollarExpansion(kde_KConfigBase* instPointer);

/** *
 Mark the config object as "clean," i.e. don't write dirty entries
 at destruction time. If @p bDeep is false, only the global dirty
 flag of the KConfig object gets cleared. If you then call
 @ref writeEntry() again, the global dirty flag is set again and all
 dirty entries will be written at a subsequent @ref sync() call.

 Classes that derive from KConfigBase should override this
 method and implement storage-specific behavior, as well as
 calling the @ref KConfigBase::rollback() explicitly in the initializer.

*/
void kde_KConfigBase_rollback(kde_KConfigBase* instPointer,int bDeep);

/** *
 Flushes all changes that currently reside only in memory
 back to disk / permanent storage. Dirty configuration entries are
 written to the most specific file available.

 Asks the back end to flush out all pending writes, and then calls
 @ref rollback().  No changes are made if the object has @p readOnly
 status.

 You should call this from your destructor in derivative classes.

*/
void kde_KConfigBase_sync(kde_KConfigBase* instPointer);

/** *
 Checks whether the config file has any dirty (modified) entries.

*/
int kde_KConfigBase_isDirty(kde_KConfigBase* instPointer);

/** *
 Sets the config object's read-only status.

   
*/
void kde_KConfigBase_setReadOnly(kde_KConfigBase* instPointer,int _ro);

/** *
 Returns the read-only status of the config object.

*/
int kde_KConfigBase_isReadOnly(kde_KConfigBase* instPointer);

/** *
 Checks whether the key has an entry in the currently active group.
 Use this to determine whether a key is not specified for the current
 group (hasKey() returns false). Keys with null data are considered
 nonexistent.

*/
int kde_KConfigBase_hasKey(kde_KConfigBase* instPointer,qt_QString * key);

/** *
 Reparses all configuration files. This is useful for programs
 that use stand alone graphical configuration tools. The base
 method implemented here only clears the group list and then
 appends the default group.

 Derivative classes should clear any internal data structures and
 then simply call @ref parseConfigFiles() when implementing this
 method.

*/
void kde_KConfigBase_reparseConfiguration(kde_KConfigBase* instPointer);

/** *
 Checks whether this configuration file can be modified.

*/
int kde_KConfigBase_isImmutable(kde_KConfigBase* instPointer);

/** *
 Checks whether it is possible to change the given group.

*/
int kde_KConfigBase_groupIsImmutable(kde_KConfigBase* instPointer,qt_QString * group);

/** *
 Checks whether it is possible to change the given entry.

*/
int kde_KConfigBase_entryIsImmutable(kde_KConfigBase* instPointer,qt_QString * key);

/** *
 Returns the state of the app-config object.

 Possible return values
 are NoAccess (the application-specific config file could not be
 opened neither read-write nor read-only), ReadOnly (the
 application-specific config file is opened read-only, but not
 read-write) and ReadWrite (the application-specific config
 file is opened read-write).

*/
int kde_KConfigBase_getConfigState(kde_KConfigBase* instPointer);

/** *
 Overloaded public methods:
   
*/
void kde_KConfigBase_setGroup1(kde_KConfigBase* instPointer,qt_QCString* pGroup);
void kde_KConfigBase_setGroup2(kde_KConfigBase* instPointer,char* pGroup);
int kde_KConfigBase_hasGroup1(kde_KConfigBase* instPointer,qt_QCString* _pGroup);
int kde_KConfigBase_hasGroup2(kde_KConfigBase* instPointer,char* _pGroup);
int kde_KConfigBase_hasKey1(kde_KConfigBase* instPointer,char* pKey);

#ifdef __cplusplus
}
#endif
#endif
