/***************************************************************************
                            kde_HTMLTableRowElement.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLTABLEROWELEMENT
#define KDE_HTMLTABLEROWELEMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A row in a table. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#edef-TR">
 TR element definition </a> in HTML 4.0.

 
 @short *
 A row in a table.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_HTMLTableRowElement * kde_new_HTMLTableRowElement();
kde_HTMLTableRowElement * kde_new_HTMLTableRowElement1(kde_HTMLTableRowElement* other);
kde_HTMLTableRowElement * kde_new_HTMLTableRowElement2(kde_DOMNode* other);
void kde_del_HTMLTableRowElement( kde_HTMLTableRowElement* p );

/** *
 The index of this row, relative to the entire table.
 This is in logical order and not in document order.
 The rowIndex does take into account sections
 (THEAD, TFOOT or TBODY) within the table,
 placing THEAD rows first in the index, followed by
 TBODY rows, followed by TFOOT rows.
     
*/
long kde_HTMLTableRowElement_rowIndex(kde_HTMLTableRowElement* instPointer);

/** *
 see @ref rowIndex

 This function is obsolete - the rowIndex property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
void kde_HTMLTableRowElement_setRowIndex(kde_HTMLTableRowElement* instPointer,long arg1);

/** *
 The index of this row, relative to the current section ( <code>
 THEAD </code> , <code> TFOOT </code> , or <code> TBODY </code>
 ).

     
*/
long kde_HTMLTableRowElement_sectionRowIndex(kde_HTMLTableRowElement* instPointer);

/** *
 see @ref sectionRowIndex

 This function is obsolete - the sectionRowIndex property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
void kde_HTMLTableRowElement_setSectionRowIndex(kde_HTMLTableRowElement* instPointer,long arg1);

/** *
 The collection of cells in this row.

     
*/
kde_HTMLCollection* kde_HTMLTableRowElement_cells(kde_HTMLTableRowElement* instPointer);

/** *
 see @ref cells

 This function is obsolete - the cells property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
void kde_HTMLTableRowElement_setCells(kde_HTMLTableRowElement* instPointer,kde_HTMLCollection* arg1);

/** *
 Horizontal alignment of data within cells of this row. See the
 <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-align-TD">
 align attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableRowElement_align(kde_HTMLTableRowElement* instPointer);

/** *
 see @ref align
     
*/
void kde_HTMLTableRowElement_setAlign(kde_HTMLTableRowElement* instPointer,kde_DOMString* arg1);

/** *
 Background color for rows. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-bgcolor">
 bgcolor attribute definition </a> in HTML 4.0. This attribute
 is deprecated in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableRowElement_bgColor(kde_HTMLTableRowElement* instPointer);

/** *
 see @ref bgColor
     
*/
void kde_HTMLTableRowElement_setBgColor(kde_HTMLTableRowElement* instPointer,kde_DOMString* arg1);

/** *
 Alignment character for cells in a column. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-char">
 char attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableRowElement_ch(kde_HTMLTableRowElement* instPointer);

/** *
 see @ref ch
     
*/
void kde_HTMLTableRowElement_setCh(kde_HTMLTableRowElement* instPointer,kde_DOMString* arg1);

/** *
 Offset of alignment character. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-charoff">
 charoff attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableRowElement_chOff(kde_HTMLTableRowElement* instPointer);

/** *
 see @ref chOff
     
*/
void kde_HTMLTableRowElement_setChOff(kde_HTMLTableRowElement* instPointer,kde_DOMString* arg1);

/** *
 Vertical alignment of data within cells of this row. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-valign">
 valign attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableRowElement_vAlign(kde_HTMLTableRowElement* instPointer);

/** *
 see @ref vAlign
     
*/
void kde_HTMLTableRowElement_setVAlign(kde_HTMLTableRowElement* instPointer,kde_DOMString* arg1);

/** *
 Insert an empty <code> TD </code> cell into this row.
 If index is -1 or equal to the number of cells, the new
 cell is appended.

     
*/
kde_HTMLElement* kde_HTMLTableRowElement_insertCell(kde_HTMLTableRowElement* instPointer,long index);

/** *
 Delete a cell from the current row.

     
*/
void kde_HTMLTableRowElement_deleteCell(kde_HTMLTableRowElement* instPointer,long index);

#ifdef __cplusplus
}
#endif
#endif
