/***************************************************************************
                            kde_DCOPObject.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_DCOPOBJECT
#define KDE_DCOPOBJECT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Provides an interface for receiving DCOP messages.

 This class provides an interface for receiving DCOP messages.  To use it,
 simply multiply-inherit from DCOPObject and from some other class, and
 then implement the @ref DCOPObject::process() method.  Because this method is
 pure virtual, you must implement the method.

 Note that it is usually more convenient to mark a section in the class with
 "k_dcop:", add your DCOP methods there and let the IDL compiler do the rest.
 Read the tutorials for more information.

 @author Preston Brown <pbrown@kde.org>, Matthias Ettrich <ettrich@kde.org>
 
 @short *
 Provides an interface for receiving DCOP messages.
*/

/** *
 Creates a DCOPObject and calculates the object id
 using its physical memory address.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_DCOPObject * kde_new_DCOPObject();

/** *
 Creates a DCOPObject and calculates the object id
 using @ref QObject::name().

*/
kde_DCOPObject * kde_new_DCOPObject1(qt_QObject * obj);

/** *
 Creates a DCOPObject with object Id @p objId.

*/
kde_DCOPObject * kde_new_DCOPObject2(qt_QCString* objId);

/** *
 Destroys the DCOPObject and removes it from the map
 of known objects.
   
*/
void kde_del_DCOPObject( kde_DCOPObject* p );

/** *
 Returns the object id of the DCOPObject.

*/
qt_QCString* kde_DCOPObject_objId(kde_DCOPObject* instPointer);

/** *
 Renames a dcop object, if no other with the same name exists
 Use with care, all dcop signals are disconnected

*/
int kde_DCOPObject_setObjId(kde_DCOPObject* instPointer,qt_QCString* objId);

/** *
 Dispatches a message.

 Usually you want to use an IDL
 compiler to automatically generate an implementation for
 this function.

 If this function returns false, then @ref processDynamic()
 is called.

 Note to implementators: remember to call the baseclasses
 implementation. It handles the functions "functions()" and
 "interfaces()" which return the lists of supported functions
 and interfaces, respectively.

*/
int kde_DCOPObject_process(kde_DCOPObject* instPointer,qt_QCString* fun, qt_QByteArray* data, qt_QCString* replyType, qt_QByteArray* replyData);

/** *
 This function is of interest when you used an IDL compiler
 to generate the implementation for @ref process() but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
int kde_DCOPObject_processDynamic(kde_DCOPObject* instPointer,qt_QCString* fun, qt_QByteArray* data, qt_QCString* replyType, qt_QByteArray* replyData);

/** *
 This function is of interest when you used an IDL compiler
 to generate the implementation for @ref functions() but
 you still want to list some functions dynamically.
 Dynamically means that the methods may appear and vanish
 during runtime.

*/
kde_QCStringList* kde_DCOPObject_functionsDynamic(kde_DCOPObject* instPointer);

/** *
 This function is of interest when you used an IDL compiler
 to generate the implementation for @ref interfaces() but
 you still want to list some interfaces dynamically.
 Dynamically means that they may appear and vanish
 during runtime.

*/
kde_QCStringList* kde_DCOPObject_interfacesDynamic(kde_DCOPObject* instPointer);

/** *
 Returns the names of the interfaces, specific ones last. The
 functions gets reimplemented by the IDL compiler. If you don't
 use the IDL compiler, consider implementing this function
 manually if you want your object to be easily explorable.

*/
kde_QCStringList* kde_DCOPObject_interfaces(kde_DCOPObject* instPointer);

/** *
 Returns the list of functions understood by the object. It gets
 reimplemented by the IDL compiler. If you don't use the IDL
 compiler, consider implementing this function manually if you
 want your object to be easily scriptable.

 Rationale: functions() allows an interpreter to do client-side
 type-casting properly.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
kde_QCStringList* kde_DCOPObject_functions(kde_DCOPObject* instPointer);

/** *
 Emit @p signal as DCOP signal from this object with @p data as
 arguments

*/
void kde_DCOPObject_emitDCOPSignal(kde_DCOPObject* instPointer,qt_QCString* signal, qt_QByteArray* data);

/** *
 Connects to a DCOP signal.

*/
int kde_DCOPObject_connectDCOPSignal(kde_DCOPObject* instPointer,qt_QCString* sender, qt_QCString* senderObj, qt_QCString* signal, qt_QCString* slot, int Volatile);

/** *
 Disconnects a DCOP signal.

 A special case is when both @p sender & @p signal are empty. In this
 case all connections related to this object in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
int kde_DCOPObject_disconnectDCOPSignal(kde_DCOPObject* instPointer,qt_QCString* sender, qt_QCString* senderObj, qt_QCString* signal, qt_QCString* slot);

/** *
 Returns the @ref DCOPClient responsible for making the call. 
 Only call this function while you are handling a DCOP call.

*/
kde_DCOPClient* kde_DCOPObject_callingDcopClient(kde_DCOPObject* instPointer);

/** *

*/
void kde_DCOPObject_setCallingDcopClient(kde_DCOPObject* instPointer,kde_DCOPClient* arg1);

/** *
 Checks whether an object with the given id is known in this process.

 @ref DCOPObjectProxy
   
*/
int kde_DCOPObject_hasObject( qt_QCString* objId);

/** *
 Try to find a dcop object with the given id.
 This function does not query the @ref DCOPObjectProxy.

*/
kde_DCOPObject* kde_DCOPObject_find( qt_QCString* objId);

/** *
 Creates an object id for the QObject @p obj. This is done
 using the @ref QObject::name() function.

*/
qt_QCString* kde_DCOPObject_objectName( qt_QObject * obj);

/** *
 The object id of this DCOPObject.
   
*/
void kde_DCOPObject_virtual_hook(kde_DCOPObject* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
