/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

  	/* ------------------------------------------------------------
 	*        Onechar handles keyboard input and takes care  of
 	*                   escape sequences
 	*--------------------------------------------------------------*/

#include "onechar.h"

int onechar(void)
{
	int x = 0;
	int trash = 0;

	x = getch();
		if (x == 27)
			{
				nodelay(stdscr, TRUE);
				x = getch(); 		/* remove '91 */

				if (x  !=  91){
					switch (x) {

						case 32 ...  57 :                   //   alt-space to alt-9,   160 - 186
						case  97 ... 122 :                //   alt-a to alt-z,     225 -  250
							x += 128;
							break;
						case  65 ... 90 :                //   alt-A to alt-Z,     225 -  250
							x += 160;
							break;

						default : {
							x =  27;
							stoptx();
						}
					}
					nodelay(stdscr, FALSE);
					
				}
				else{
					nodelay(stdscr, FALSE);

					x = getch();       /* remove '91 */

					switch (x)
					{
						case 49 :
						{
							x = getch();

							if (x == 126)
							{
								x = 158;	/* home */
								break;
							}
							else
							{
								x = x + 79;
						 		trash = getch();
								break;			/* F6 F7 F8, 134 135 136 */
							}
						}
						case 50:
						{
							x = getch();
							if (x == 126)
							{
					        			x = 160;        /* insert */
					        			break;
					  		}
							else
							{
					        			x = x + 89;
					        			trash = getch();
								break;                  /* F9 - SF4, 137, 138, 140, 141; 142, 143, 145, 146 */

					   		}
						}
						case 51:
						{
							x = getch();
							if (x == 126)
							{
								x = 161;		/* delete */
								break;
							}
							else
							{
								x = x + 98;
								trash = getch();
								break; 			/* SF5 - SF8, 147, 148, 149, 150  */
							}
						}
						case 52:			/* end */
						{
							x = 159;
							trash = getch();
							break;
						}
						case 53:			/* pgup */
						{
							x = 156;
							trash = getch();
							break;
						}
						case 54:			/* pgdwn */
						{
							x = 157;
							trash = getch();
							break;
						}
			  			case 65:
			  			{
			  				x = 152;		/* up */
			  				break;
			  			}
			 			 case 66:
			  			{
			  				x = 153;		/* dwn */
			  				break;
			  			}
			 			 case 67:
			  			{
			  				x = 154;		/* right */
			  				break;
			  			}
			  			case 68:
			  			{
			  				x = 155;		/* left */
			  				break;
			  			}
			  			case 91:
						{
			  				x = getch();
			  				if (x >= 65 && x <= 69)
			  				{
			  					x = x + 64;
			  					break;
			  				}
			  			}
						default:
						{
							x  = x;

						}
					}    // end switch
				}  // end else
			}   // end if x=27

//mvprintw(13,0, "%d", x);
//refresh();
//sleep(1);

	return (x);
}

