/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

 	/* ------------------------------------------------------------
 	*              Parse various  call  formats
 	*              Convert country data
 	*--------------------------------------------------------------*/

#include "getctydata.h"

	int getctydata(char *checkcall)
	{

	extern char prefixlines[MAX_DBLINES][17];
	extern char cqzone[];
	extern char ituzone[];
	extern char zonearray[MAX_DBLINES][3];
	extern char ituarray[MAX_DBLINES][3];
	extern int dataindex[MAX_DBLINES];
	extern int countrynr;
	extern char continent[];
	extern char datalines[MAX_DATALINES][81];
	extern int w_cty;
	extern int ve_cty;
	extern char zone_export[];

	char checkbuffer[17] = "";
	char membuffer[17] = "";
	char checkncall[17]= "";

	int i = 0, w =  0, x = 0 , ii = 0;
	int exception;
	char portable = '\0';
	int pp = 0;
	size_t loc;

	strncpy (membuffer, checkcall, 16);
	portable = '\0';
	if (strstr(checkcall, "/QRP") != NULL)
		checkcall[strlen(checkcall)-4] ='\0';


	loc = strcspn(checkcall, "/");

	if (loc > 3){

		strncpy(checkbuffer, (checkcall  +  loc + 1), (strlen(checkcall) + 1) - loc);


		if (strlen(checkbuffer)  == 1)
					checkcall[loc] = '\0';
		if (checkbuffer[0] == 'M' &&  strlen(checkbuffer)  <= 3)
					checkcall[loc] = '\0';
		if (checkbuffer[0] == 'Q' &&  strlen(checkbuffer) == 3)   /* /QRP */
			checkcall[loc]  =  '\0';
		if  (checkbuffer[0] == 'A' && strlen(checkbuffer) <= 3) /*  /A,  /AM etc */
				checkcall[loc]  =  '\0';
		if  ((strlen(checkbuffer) <= 3) && (checkbuffer[0] <= 57) && (checkbuffer[0] >= 48)) /*  /3,   etc */
				portable  =  checkbuffer[0];

	}
	loc = strcspn(checkcall, "/");


	if (loc != strlen(checkcall)){

		if (loc  <  4)
				checkcall[loc] =  '\0';	/*  "PA/DJ0LN/P   */
		else
		{                                       /*  DJ0LN/P       */

		strncpy(checkcall, checkcall, loc + 1);

	}
	}

	/* ------------------------------------------------------------*/


	if (strlen(checkbuffer) == 1) {                                     /*  /3 */
		for ( pp = strlen(checkcall)-1; pp > 0 ; pp--) {

				if ((checkcall[pp] <= '9') && (checkcall[pp] >= '0'))
					if ((checkbuffer[0] <= '9')&&(checkbuffer[0] >= '0')){
						checkcall[pp] = checkbuffer[0];
						break;
					}
			}
		}  else if (strlen(checkbuffer) > 1)
			strcpy (checkcall, checkbuffer);

	getpx(checkcall);

	/* ------------------------------------------------------------*/

	w=0;

		for (pp = 1; pp <= strlen(checkcall); pp++) {

			strncpy(checkncall , checkcall, pp);

			for  (i=0  ;  i  <= MAX_DBLINES  ;  i++){

				if ((strncmp(checkncall, prefixlines[i] , strlen(prefixlines[i])) == 0)) {

					if (strlen(checkncall) == strlen(prefixlines[i])){
						w = i;
						x = dataindex[i];
					}

				}
			}
		}

	exception = 0;

	if (strlen(zonearray[w]) > 0) {
		exception = 1;
		strncpy (cqzone,  zonearray[w], 2);
	}
	else strncpy(cqzone, datalines[x] + 26, 2);

	if (exception == 0) {

		if(x == w_cty) {
			for (ii=0; ii < strlen(checkcall); ii++) {
				if (checkcall[ii] == '7' || checkcall[ii] == '6') {
					strncpy (cqzone, "03",2);
					break;
				} else if (checkcall[ii] == '5' || checkcall[ii] == '8' || checkcall[ii] == '9' || checkcall[ii] == '0') {
					strncpy (cqzone, "04",2);
					break;
				}  else if (checkcall[ii] == '1' || checkcall[ii] == '2' || checkcall[ii] == '3' || checkcall[ii] == '4') {
					strncpy (cqzone, "05",2);
					break;
				}
			}

		}

		if(x == ve_cty) {
			for (ii=0; ii < strlen(checkcall); ii++) {
				if (checkcall[ii] == '7' ) {
					strncpy (cqzone, "03",2);
					break;
				} else if (checkcall[ii] == '3' || checkcall[ii] == '4' || checkcall[ii] == '5' || checkcall[ii] == '6') {
					strncpy (cqzone, "04",2);
					break;
				}  else  strncpy (cqzone, "05",2);

			}
		}
	}          // end exception

	strcpy(zone_export, cqzone);
	strncpy (ituzone, ituarray[w], 2);


	countrynr  = x;
	strncpy (continent,  datalines[countrynr]+  36 ,3);
	continent[2]  = '\0';
	strcpy(checkcall, membuffer);

	return (x);
	}
/* --------------------for background ---------------------------*/

	int getctydata2(char *checkcall)
	{
	extern char prefixlines[MAX_DBLINES][17];
	extern char cqzone[];
	extern char zonearray[MAX_DBLINES][3];
	extern int dataindex[MAX_DBLINES];
	extern int countrynr;
	extern char datalines[MAX_DATALINES][81];

	char checkbuffer[17] = "";
	char membuffer[17] = "";
	char checkncall[20];

	int i = 0,  w =  0, x = 0;
	int exception;
	char portable = '\0';
	int pp = 0;
	size_t loc;

	strncpy (membuffer, checkcall, 16);
	portable = '\0';

	if (strstr(checkcall, "/QRP") != NULL) //strip the qrp
		checkcall[strlen(checkcall)-4] ='\0';

	loc = strcspn(checkcall, "/");

	if (loc > 3){

		strncpy(checkbuffer, (checkcall  +  loc + 1), (strlen(checkcall) + 1) - loc);


		if (strlen(checkbuffer)  == 1)
					checkcall[loc] = '\0';
		if (checkbuffer[0] == 'M' &&  strlen(checkbuffer)  <= 3)
					checkcall[loc] = '\0';
		if (checkbuffer[0] == 'Q' &&  strlen(checkbuffer) == 3)   /* /QRP */
			checkcall[loc]  =  '\0';
		if  (checkbuffer[0] == 'A' && strlen(checkbuffer) <= 3) /*  /A,  /AM etc */
				checkcall[loc]  =  '\0';
		if  ((strlen(checkbuffer) <= 3) && (checkbuffer[0] <= 57) && (checkbuffer[0] >= 48)) /*  /3,   etc */
				portable  =  checkbuffer[0];

	}
	loc = strcspn(checkcall, "/");


	if (loc != strlen(checkcall)){

		if (loc  <  4)
				checkcall[loc] =  '\0';	/*  "PA/DJ0LN/P   */
		else
		{                                       /*  DJ0LN/P       */

		strncpy(checkcall, checkcall, loc + 1);

	}
	}

	/* ------------------------------------------------------------*/


	if (strlen(checkbuffer) == 1) {                                     /*  /3 */
		for ( pp = strlen(checkcall)-1; pp > 0 ; pp--) {

				if ((checkcall[pp] <= '9') && (checkcall[pp] >= '0'))
					if ((checkbuffer[0] <= '9')&&(checkbuffer[0] >= '0')){
						checkcall[pp] = checkbuffer[0];
						break;
					}
			}
		}  else if (strlen(checkbuffer) > 1)
			strcpy (checkcall, checkbuffer);

	getpx(checkcall);



	/* ------------------------------------------------------------*/

	w=0;

		for (pp = 1; pp <= strlen(checkcall); pp++) {

			strncpy(checkncall , checkcall, pp);
			checkncall[pp]='\0';


			for  (i=0  ;  i  <= MAX_DBLINES  ;  i++){


				if ((strncmp(checkncall, prefixlines[i] , strlen(prefixlines[i])) == 0)) {

					if (strlen(checkncall) == strlen(prefixlines[i])){
						w = i;
						x = dataindex[i];
						break;
					}

				}
			}
		}

	exception = 0;

	if (strlen(zonearray[w]) > 0) {
		exception = 1;
		strncpy (cqzone,  zonearray[w], 2);
	}
	else strncpy(cqzone, datalines[x] + 26, 2);

	countrynr  = x;

	strcpy(checkcall, membuffer);

	return (x);

	}
