/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

	/* ------------------------------------------------------------
 	*
 	*          parameterdialog
 	*--------------------------------------------------------------*/

#include "changepars.h"

int changepars(void){

extern int use_rxvt;
extern int cluster;
extern int shortqsonr;
extern int searchflg;
extern int demode;
extern int contest;
extern int announcefilter;
extern int showscore_flag;
extern int zonedisplay;
extern int trxmode;
extern char backgrnd_str[];
extern char hiscall[];
extern int rit;
extern int trx_control;
extern int editor;
extern int packetinterface;
extern int ctcomp;

#ifdef HAVE_LIBHAMLIB
extern RIG *my_rig;
extern freq_t outfreq;
#else
extern int outfreq;
#endif

extern int simulator;
extern int keyerport;

char  parameterstring[20];
char parameters[38][19];
int i, k, nopar  = 0;
int maxpar  = 37;

strcpy(parameters[0] ,  "SPOT");
strcpy(parameters[1] ,  "MAP");
strcpy(parameters[2] ,  "CLOFF");
strcpy(parameters[3] ,  "CLUSTER");
strcpy(parameters[4] ,  "SHORT");
strcpy(parameters[5] ,  "LONG");
strcpy(parameters[6] ,  "MESSAGE");
strcpy(parameters[7] ,  "LIST");
strcpy(parameters[8] ,  "CHECK");
strcpy(parameters[9] ,  "NOCHECK");
strcpy(parameters[10],  "TONE");
strcpy(parameters[11],  "EDIT");
strcpy(parameters[12],  "VIEW");
strcpy(parameters[13],  "HELP");
strcpy(parameters[14],  "DEMODE");
strcpy(parameters[15],  "CONTEST");
strcpy(parameters[16],  "FILTER");
strcpy(parameters[17],  "SCORE");
strcpy(parameters[18],  "WRITE");
strcpy(parameters[19],  "EXIT");
strcpy(parameters[20],  "TXFILE");
strcpy(parameters[21],  "ZONES");
strcpy(parameters[22],  "CTY");
strcpy(parameters[23],  "MODE");
strcpy(parameters[24],  "SET");
strcpy(parameters[25],  "MULTI");
strcpy(parameters[26],  "PROP");
strcpy(parameters[27],  "RITCLEAR");
strcpy(parameters[28],  "TRXCONTROL");
strcpy(parameters[29],  "CFG");
strcpy(parameters[30],  "CWMODE");
strcpy(parameters[31],  "SSBMODE");
strcpy(parameters[32],  "DIGIMODE");
strcpy(parameters[33],  "PACKET");
strcpy(parameters[34],  "SIMULATOR");
strcpy(parameters[35],  "INFO");
strcpy(parameters[36],  "FREQ");
strcpy(parameters[37],  "RECONNECT");

	nopar = 0;
	
	attroff(A_STANDOUT);
	attron(COLOR_PAIR(COLOR_GREEN));
	mvprintw(12,29,  "PARAMETER?  ");
	refresh();
	
	mvprintw(12,29, "            ");
	mvprintw(12, 29, "");
	refresh();
	
	echo();
	getstr(parameterstring);
    noecho();

    for (k = 0;  parameterstring[k]; k++)
     	parameterstring[k]  = toupper(parameterstring[k]);

	
	for (i=0 ; i <=  maxpar ; i++){
		if  (strncmp(parameterstring, parameters[i],  3) == 0){
		 	break;
		}
	}
	
	switch(i)
	{
		case 0:     		/* SPOTS) */
		{
			cluster = SPOTS;
			break;
		}
		case 1:             /* BANDMAP */
		{
			cluster = MAP;
			break;
		}
		case 2:             /* CLOFF  */
		{
			cluster = NOCLUSTER;
			break;
		}
		case 3:				/* CLUSTER  */
		{
			cluster = CLUSTER;
			announcefilter = FILTER_ALL;
			break;
		}
		case 4:				/* SHORTNR  */
		{
			shortqsonr = SHORTCW;
			break;
		}
		case 5:				/* LONGNR  */
		{
			shortqsonr = LONGCW;
			break;
		}
		case 6:				/* MESSAGE  */
		{
			message_change(i);
			break;
		}		

		case 7:				/* LIST  */
		{
			listmessages();
			break;
		}	
		case 8:				/* CHECK  */
		{
				searchflg = SEARCHWINDOW ;
			break;
		}		
		case 9:				/* NOCHECK  */
		{
				searchflg = 0 ;
			break;	
		}				
		case  10:			/*  TONE   */
		{
		 		set_tone();
			break;
		}
		case  11:			/*  EDIT   */
		{
			logedit();
			break;
		}
		case  12:			/*  VIEW   */
		{
			logview();
			break;
		}
		case  13:			/*  HELP   */
		{
			show_help();
			break;
		}
		case  14:			/*  DEMODE   */
		{
			if  (demode == SEND_DE )
				demode = 0;
			else
				demode = SEND_DE;
			mvprintw(13, 29,  "DE-mode is %d", demode);
			refresh();
			sleep(1);
			
			break;
		}
		case  15:			/*  CONTEST   */
		{
			if  (contest == CONTEST)
				contest = 0;
			else {
				contest = CONTEST;
				searchflg  = SEARCHWINDOW;
				}
			mvprintw(13, 29,  "CONTEST-mode is %d", contest);
			refresh();
			sleep(1);
		
			break;
		}
		case  16:			/*  FILTER   */
		{
			announcefilter++;
			if (announcefilter >3 ) announcefilter =0;
			mvprintw(13, 29,  "FILTER-mode is %d", announcefilter);
			refresh();
			sleep(1);

			break;
		}
		case  17:			/*  SCORE   */
		{
			if  (showscore_flag == 0)
				showscore_flag = 1;
			else {
				showscore_flag  = 0;
				
				}
			mvprintw(13, 29,  "Show score-mode is %d", showscore_flag);
			refresh();
			sleep(1);
		
			break;
		}
		case  18:			/*  WRITE CABRILLO FILE   */
		{
			write_cabrillo();
			
			mvprintw(13, 29,  "writing  cabrillo file");
			refresh();
			sleep(1);
		
			break;
		}
		case 19:     		/* EXIT */
		{
			writeparas();
			endwin();
//			system(cleanup_location);
//			system("tlf_cleanup");

 			puts("\n\nThanks for using TLF.. 73\n");     	
			exit(0);
			break;
		}
		case  20:			/*  TXFILE   */
		{
			break;
		}
		case  21:			/*  ZONES   */
		{
			if  (zonedisplay == 0)
				zonedisplay = 1;
			else {
				zonedisplay  = 0;
				
				}

			break;
		}
		case 22:            /* COUNTRIES */
		{
			show_mults();
			refresh();
			sleep(1);
		
			break;
		}
		case  23:			/*  MODE   */
		{
			if  (trxmode == CWMODE)
				trxmode = SSBMODE;
			else if (trxmode == SSBMODE)
				trxmode = DIGIMODE;
			else
				trxmode = CWMODE;

			if (trxmode == CWMODE){
				mvprintw(13, 29,  "TRXMODE = CW");
			}else if (trxmode == SSBMODE)
				mvprintw(13, 29,  "TRXMODE = SSB");
			else
				mvprintw(13, 29,  "TRXMODE = DIG");
			refresh();
			sleep(1);
		
			break;
		}
  		case 24:            /* SET PARAMETERS */
		{
			clear();
			if (editor == EDITOR_JOE)
				system("joe logcfg.dat");
			else if (editor == EDITOR_VI)
				system("vi logcfg.dat");
			else
				system("e3 logcfg.dat");
			
			read_logcfg();
			writeparas();
			mvprintw(24,0, "Logcfg.dat loaded, parameters written..");
			refresh();
		    clear_display();
			break;
		}
         		case  25:			/*  MULTI   */
		{
			multiplierinfo();

			break;
		}
			case 26:            /* CONDX */
		{
			muf();
		    clear_display();
			break;
		}
  			case  27:			/*  RITCLEAR   */
		{
				if  (rit == RITCLEAR)
					rit = 0;
				else {
					rit = RITCLEAR;
				
				}
				if (rit == RITCLEAR){
					mvprintw(13, 29,  "RIT clear on");
				}else{
					mvprintw(13, 29,  "RIT clear off");
				}
			refresh();
			sleep(1);
		
			break;
		}
  		case  28:			/*  trx ctl   */
		{
				if  (trx_control == 1)
					trx_control = 0;
				else {
					trx_control = 1;
				
				}
				if (trx_control == 1){
					mvprintw(13, 29,  "TRX control on");
				}else{
					mvprintw(13, 29,  "TRX control off");
				}
			refresh();
			sleep(1);

			break;
		}
		case 29:            /* LOAD PARAMETERS */
		{
			clear();
			if (editor == EDITOR_JOE)
				system("joe logcfg.dat");
			else if (editor == EDITOR_VI)
				system("vi logcfg.dat");
			else
				system("e3 logcfg.dat");

			read_logcfg();
			writeparas();
			mvprintw(24,0, "Logcfg.dat loaded, parameters written..");
			refresh();
		    clear_display();
			break;
		}
		case 30:				/* CW  */
		{
			trxmode = CWMODE;

			if(trx_control == 1)  
				outfreq =  SETCWMODE;
			break;
		}
		case 31:				/* SHORTNR  */
		{
			trxmode = SSBMODE;
				outfreq = SETSSBMODE;
			break;
		}
		case 32:				/* SHORTNR  */
		{
			trxmode = DIGIMODE;
			break;
		}
		case 33:				/* PACKET  */
		{
			if (packetinterface > 0) packet();
			break;
		}
		case 34:				/* SIMULATOR  */
		{
			if (simulator == 0){
				simulator=1;
				if (ctcomp == 1) {
					mvprintw(13,19, "The simulator only works in TRmode. Switching to TRmode");
					ctcomp=0;
				}
				else
					mvprintw(13, 29, "Simulator on");

				refresh();

				if (keyerport == NET_KEYER){

					if (netkeyer (K_WORDMODE, NULL) < 0){
						mvprintw(24,0, "keyer not active; switching to SSB");
						trxmode = SSBMODE;
						clear_display();
					}
				}
			}  else {
				simulator=0;
				mvprintw(13, 29, "Simulator off");
				refresh();

				if (keyerport == NET_KEYER){

					if (netkeyer (K_RESET, NULL) < 0){
						mvprintw(24,0, "keyer not active; switching to SSB");
						trxmode = SSBMODE;
						clear_display();
					}
				}

			}
			break;
		}
		case 35:				/* INFO  */
		{
			networkinfo();
			break;
		}
		case 36:             /* CLOFF  */
		{
			cluster = FREQWINDOW;
			break;
		}

		case 37:				/* RECONNECT  */
		{
			if (packetinterface > 0) {
				cleanup_telnet();
				init_packet();
				packet();
			}
			break;
		}

		default:
		{
		
		nopar = 1;
		
		}
	}
	
	if (nopar != 1){
		mvprintw(12, 29, "OK !        ");
		writeparas();
		}
	else{
		
		mvprintw(12, 29, "INVALID PAR!");
		backgrnd_str[80]  = '\0';
		mvprintw(13,  0, backgrnd_str);
		mvprintw(13,0, "");
		
		for (i  = 0 ;  i <= maxpar ;  i++){	
			printw( parameters[i] );
			addch(' ');
			}
			
		refresh();
		sleep(2);
		
	}
	
	refresh();

	if (use_rxvt == 0) attron(COLOR_PAIR(NORMCOLOR) | A_BOLD   );
	else   attron(COLOR_PAIR(NORMCOLOR) );
	
	mvprintw(12, 29, "            ");
	mvprintw(12, 29, "");
	refresh();
	hiscall[0] = '\0';
	

 return(0);
 }

/* -------------------------------------------------------------- */

int networkinfo(void){

extern int use_rxvt;
extern int recv_packets;
extern int recv_error;
extern int send_packets[];
extern int send_error[];
extern int lan_active;
extern int nodes;
extern char bc_hostaddress[MAXNODES][16];


int i, j, inode, key;

		clear();

		if (use_rxvt == 0) attron(COLOR_PAIR(COLOR_CYAN) | A_BOLD | A_STANDOUT);
		else  attron(COLOR_PAIR(COLOR_CYAN) | A_STANDOUT);

		for (j = 0; j <= 24; j++)
  			mvprintw(j,0,"                                                                                ");

	  	if (lan_active == 1)
	  		mvprintw(1,10, "Network status: on");
	  	else
	  		mvprintw(1,10, "Network status: off");

		mvprintw(3,28, "Packets rcvd: %d | %d", recv_packets, recv_error);

  		for (inode = 0; inode < nodes; inode++) {
  			mvprintw(4 + inode,10, "%s", bc_hostaddress[inode]);
  			mvprintw(4 + inode, 28, "Packets sent: %d | %d ", send_packets[inode], send_error[inode], nodes);
	  	}
	  	refresh();

	  	mvprintw(23,22," --- Press a key to continue --- ");
	  	refresh();

	  	key = getch();

	  	if (use_rxvt == 0) attron(COLOR_PAIR(COLOR_WHITE) | A_BOLD | A_STANDOUT);
		else    attron(COLOR_PAIR(COLOR_WHITE)  | A_STANDOUT);
	 	for (i = 0; i <= 24; i++)
		 	mvprintw(i,0,"                                                                                ");

		clear_display();

return(0);

}

/* -------------------------------------------------------------- */

int multiplierinfo(void){

extern int use_rxvt;
extern int arrlss;
extern int serial_section_mult;
extern int sectn_mult;
extern char mults[MAX_MULTS][12];
extern int mult_bands[MAX_MULTS];
extern char mults_possible[MAX_MULTS][12];
extern int multcount;

int j, k,key, vert, hor, cnt, found;
char mprint[50];
char chmult[4];

		clear();

		if (use_rxvt == 0) attron(COLOR_PAIR(COLOR_CYAN) | A_BOLD | A_STANDOUT);
		else   attron(COLOR_PAIR(COLOR_CYAN)  | A_STANDOUT);

		for (j = 0; j <= 24; j++)
  			mvprintw(j,0,"                                                                                ");

		if (arrlss == 1) {
			mvprintw(2, 20, "ARRL SWEEPSTAKES -- REMAINING SECTIONS");
			cnt=0;
			for (vert = 9;  vert < 18; vert++) {

				for (hor = 5; hor < 15;  hor++){
					mprint[0]='\0';
					strcat(mprint, mults_possible[cnt]);
					strcat (mprint, " ");
					mprint[4]='\0';

					found = 0;
					for (j = 0; j < multcount+1; j++) {
						strncpy (chmult, mults_possible[cnt], 3);
						if (strlen(chmult) == 2) strcat (chmult, " ");

//mvprintw(14,0, "|%s|%s|", mults[j], chmult);
//refresh();
//sleep(1);

						if (strcmp(mults[j], chmult) == 0)
							found = 1;
					}
					if (found == 1)

							if (use_rxvt == 0) attron(COLOR_PAIR(COLOR_GREEN) | A_BOLD | A_STANDOUT);
							else  attron(COLOR_PAIR(COLOR_GREEN) |  A_STANDOUT);

					 else
							if (use_rxvt == 0) attron(COLOR_PAIR(COLOR_CYAN) | A_BOLD | A_STANDOUT);
							else   attron(COLOR_PAIR(COLOR_CYAN) | A_STANDOUT);

					if ((strlen(mprint) >1) && (strcmp (mprint, "W ") != 0)) mvprintw(vert, hor*4, "%s",mprint);

					cnt++;

					if (cnt >= MAX_MULTS)  break;
				}
				if (cnt >= MAX_MULTS)  break;
			}
		}

		if (serial_section_mult == 1|| sectn_mult == 1) {
			mvprintw(0, 30, "REMAINING SECTIONS");
			cnt=0;
			for (vert = 2;  vert < 22; vert++) {

				for (hor = 0; hor < 7;  hor++){
					mprint[0]='\0';
					strcat(mprint, mults_possible[cnt]);
					if (strlen(mprint) == 0 ) break;
					if (strlen(mprint) == 1 ) strcat (mprint, "   ");
					if (strlen(mprint) == 2 ) strcat (mprint, "  ");
					if (strlen(mprint) == 3 ) strcat (mprint, " ");
					if (strlen(mprint) > 3) mprint[4] = '\0';

					for (k=1 ; k <= MAX_MULTS; k++) {
						if (strstr(mults[k], mults_possible[cnt]) != NULL)
							break;
					}

					if ((mult_bands[k] &  BAND160 ) != 0) strcat (mprint, "*");
					else strcat(mprint, "-");
					if ((mult_bands[k] &  BAND80 ) != 0) strcat (mprint, "*");
					else strcat(mprint, "-");
					if ((mult_bands[k] &  BAND40 ) != 0) strcat (mprint, "*");
					else strcat(mprint, "-");
					if ((mult_bands[k] &  BAND20 ) != 0) strcat (mprint, "*");
					else strcat(mprint, "-");
					if ((mult_bands[k] &  BAND15 ) != 0) strcat (mprint, "*");
					else strcat(mprint, "-");
					if ((mult_bands[k] &  BAND10 ) != 0) strcat (mprint, "*");
					else strcat(mprint, "-");

					mprint[11]='\0';
					mvprintw(vert, 2 + hor*11, "%s",mprint);
					cnt++;

				}
				if (cnt >= MAX_MULTS)  break;
			}
		}


		if(use_rxvt == 0) attron(COLOR_PAIR(COLOR_CYAN) | A_BOLD | A_STANDOUT);
		else    attron(COLOR_PAIR(COLOR_CYAN) |  A_STANDOUT);

		mvprintw(23,22," --- Press a key to continue --- ");

		refresh();

	  	key = getch();

	  	if (use_rxvt == 0) attron(COLOR_PAIR(COLOR_WHITE) | A_BOLD | A_STANDOUT);
		else  attron(COLOR_PAIR(COLOR_WHITE) | A_STANDOUT);

		for (j = 0; j <= 24; j++)
		 	mvprintw(j,0,"                                                                                ");

		clear_display();

return(0);

}
