// Strut.hh for Fluxbox Window Manager
// Copyright (c) 2003-2004 Henrik Kinnunen (fluxgen at users.sourceforge.net)
//                     and Simon Bowden    (rathnor at users.sourceforge.net)
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

// $Id: Strut.hh,v 1.3 2004/01/19 18:30:59 fluxgen Exp $

#ifndef STRUT_HH
#define STRUT_HH

class Strut {
public:
    Strut(int left, int right, 
          int top, int bottom):m_left(left), m_right(right), 
                               m_top(top), m_bottom(bottom) { }
    inline int left() const { return m_left; }
    inline int right() const { return m_right; }
    inline int bottom() const { return m_bottom; }
    inline int top() const { return m_top; }
    bool operator == (const Strut &test) const {
        return (left() == test.left() &&
                right() == test.right() &&
                top() == test.top() &&
                bottom() == test.bottom());
    }
private:
    int m_left, m_right, m_top, m_bottom;
};

#endif // STRUT_HH
