#include <OI/oi.H>			/* BrowseDir.C */
#include "dirent.h"
#include "strings.h"
		void			fill_text_with_dir(OI_base_text*,char*);
int main (int argc, char **argv)
{
		OI_ef_entry_chk_status	use_entry(OI_entry_field*,void*,OI_ef_entry_chk_status);
		void			did_click (OI_d_tech*,void*,OI_number,OI_number,OI_number,OI_number,OI_number);
		OI_connection		*conp;
		OI_app_window		*wp;
		OI_entry_field		*efp;
		OI_scroll_text		*stp;
		char			*filenamp;
	
	if (conp = OI_init(&argc,argv,"BrowseDir")) {
		wp = oi_create_app_window("main",1,1,"Directory Browser");
		wp->set_layout(OI_layout_column);
		efp = oi_create_entry_field("file_field",50,"Directory:",NULL,1000);
		efp->layout_associated_object(wp,1,0,OI_active);
		filenamp = OI_translate_filename("$HOME");
		efp->set_text(filenamp);
		stp = oi_create_scroll_text("sc_text",OI_scroll_bar_both,7,60);
		stp->layout_associated_object(wp,1,1,OI_active);
		stp->set_click(did_click,efp);
		efp->set_entry_check(use_entry,stp);
		fill_text_with_dir(stp,efp->part_text());
		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active);
		OI_begin_interaction();
	}
}
OI_ef_entry_chk_status	use_entry(OI_entry_field *efp, void *argp, OI_ef_entry_chk_status stat)
{
		char	*filenamp;

	if (stat == OI_ef_entry_chk_ok) {
		filenamp = OI_translate_filename(efp->part_text());
		efp->set_text(filenamp,OI_no);
		fill_text_with_dir((OI_base_text*)argp,filenamp);
	}
	return(stat);
}
void fill_text_with_dir(OI_base_text *btp, char *dirnamp)
{
	DIR	*dirp;
	dirent	*direntp;
	btp->clear_text();
	if (dirp = opendir(dirnamp)) {
		while(direntp = readdir(dirp)) 
			btp->insert_line(-1,direntp->d_name);
		closedir(dirp);
	}
	else
		btp->push_help_str("Not a directory",OI_yes);
	return;
}
void did_click(OI_d_tech *objp, void *argp, OI_number, OI_number, OI_number, OI_number lin, OI_number)
{
		OI_base_text	*btp;
		OI_entry_field	*efp;
		char		buffer[1000];

		btp = (OI_base_text*)objp;
		efp = (OI_entry_field*)argp;
		strcpy(buffer,efp->part_text());
		strcat(buffer,"/");
		strcat(buffer,btp->text(lin));
		efp->set_text(buffer,OI_yes);
		return;
}
