//
//	Periodic Chart of OI objects
//
#if defined(ultrix) || defined(SVR4) || defined(hpux)
#include <unistd.h>
#else
#include <sysent.h>
#endif
#if defined(HP_UX)
#include <stdlib.h>
#endif
# include <stdlib.h>

#include <OI/oi.H>
#ifdef TL_DEBUG
#include <toml.h>
#endif /* TL_DEBUG */

OI_connection	*conp;
OI_slider	*intrvl_slp;

static void	animate( OI_menu_cell*, void*, OI_number );
static void	place_objects_into_row1( OI_app_window * wp, OI_number row );
static void	place_objects_into_row2( OI_app_window * wp, OI_number row );
static void	place_objects_into_row3( OI_app_window * wp, OI_number row );
static void	add_popup_menu_on_app_win( OI_app_window * wp);
static OI_menu	*create_main_menu();


void
main( int argc, char **argv )
{ 
	OI_app_window		*wp;

#ifdef TL_DEBUG
	tomlProtocolFilename("protocol.tmp");
#endif /* TL_DEBUG */

	if ( !( conp = OI_init( &argc, argv, "Speriodic" ) ) ) exit( 1 );
	wp = oi_create_app_window( "app_window", 100, 100, "ParcPlace Object Interface Objects" );
	wp->set_layout( OI_layout_row );

	place_objects_into_row1( wp, 1 );
	place_objects_into_row2( wp, 2 );
	place_objects_into_row3( wp, 3 );

	wp->set_main_menu( create_main_menu() );

	add_popup_menu_on_app_win(wp);

	wp->set_associated_object( conp->root(), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE );

#ifdef TL_DEBUG
	tomlProtocolReport();
	tomlProtocolFlush();
#endif /* TL_DEBUG */

	OI_begin_interaction();
}

void
echo_arg (OI_menu_cell *cellp, void *argp, OI_number) {
	cellp->push_help_str((char*)argp);
}

void
add_popup_menu_on_app_win( OI_app_window *wp) {

	OI_menu	*mnu ;
	static	OI_cell_spec	popup_cells[] =
	{ 
		{ "red", "red", &echo_arg, NULL, NULL, "Paint the town ..." },
		{ "blue", "blue", &echo_arg, NULL, NULL, "The sky is a brilliant ..." },
		{ "orange", "orange", &echo_arg, NULL, NULL, "... Crush" },
		{ "yellow", "yellow", &echo_arg, NULL, NULL, "... fever" },
		{ "green", "green", &echo_arg, NULL, NULL, "The grass is ...er on the other side." },
	};

	mnu = oi_create_button_menu( "popup_mnu", OI_count(popup_cells), popup_cells, OI_VERTICAL);
	mnu->set_associated_object( wp, OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE_NOT_DISPLAYED);
}

static OI_menu *
create_main_menu()
{
	OI_menu	*pd ;
	OI_menu	*mnu ;
	static	OI_cell_spec	colors[] =
	{ 
		{ "red", "red" },
		{ "orange", "orange" },
		{ "yellow", "yellow" },
		{ "green", "green" },
		{ "blue", "blue" },
	};
	static	OI_cell_spec	numbers[] =
	{ 
		{ "one", "one" },
		{ "two", "two" },
		{ "three", "three" },
	};
	static	OI_cell_spec	states[] =
	{ 
		{ "Texas", "Texas" },
		{ "Colorado", "Colorado" },
		{ "Vermont", "Vermont" },
		{ "Oregon", "Oregon" },
	};
	static	OI_cell_spec	objects[] =
	{ 
		{ "menu", "menu" },
		{ "slider", "slider" },
		{ "gauge", "gauge" },
		{ "box", "box" },
		{ "window", "window" },
		{ "panner", "panner" },
	};
	static	OI_cell_spec	main_menu[] =
	{ 
		{ "Colors", "Colors" },
		{ "States", "States" },
		{ "Objects", "Objects" },
		{ "Numbers", "Numbers" },
	};


	mnu = oi_create_button_menu( "main_menu", OI_n_cells( main_menu ), main_menu, OI_HORIZONTAL );
	pd = oi_create_button_menu( "colors", OI_n_cells( colors ), colors, OI_VERTICAL );
	pd->set_associated_object( mnu->descendant( "Colors" ), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE_NOT_DISPLAYED );
	pd = oi_create_button_menu( "states", OI_n_cells( states ), states, OI_VERTICAL );
	pd->set_associated_object( mnu->descendant( "States" ), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE_NOT_DISPLAYED );
	pd = oi_create_button_menu( "objects", OI_n_cells( objects ), objects, OI_VERTICAL );
	pd->set_associated_object( mnu->descendant( "Objects" ), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE_NOT_DISPLAYED );
	pd = oi_create_button_menu( "numbers", OI_n_cells( numbers ), numbers, OI_VERTICAL );
	pd->set_associated_object( mnu->descendant( "Numbers" ), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE_NOT_DISPLAYED );
	return( mnu );
}

/*
 ******************************************************************************
 *
 *	Function Name:	upd_gauge
 *
 *		Description: 
 *			update gauge with current value of slider
 *
 *		Returns:
 * 
 *		Side Effects:
 *			descendant "gauge" has its current value changed
 *
 *		Warnings:
 *			Assumes gauge and slider have the same span
 *
 ******************************************************************************
 */
static void
upd_gauge(
			OI_ctlr_1d	*slp,		/* ptr to slider */
			void		*,
			OI_scroll_event	,
			long		)
{
 /*	External Procedures: */
 /*	Local Variables: */
			OI_gauge	*gp ;		/* ptr to gauge */
 /*
	Procedure:
		Go up tree to parent app_window and back down to find gauge.
		Set gauge value to current handle position for slider.
 */

	gp = (OI_gauge*) slp->app_window()->descendant("gauge") ;
	gp->set_value(slp->value()) ;
	return ;
}

static void	
place_objects_into_row1( OI_app_window * wp, OI_number row )
{
	OI_number		column = 10;
	OI_box			*bp;
	OI_box			*eb0a;
	OI_box			*eb0b;
	OI_box			*eb0c;
	OI_scroll_box		*sbp;
	OI_entry_field		*efp;
	OI_seq_entry_field	*sefp;
	OI_gauge		*gaugep;
	OI_glyph		*gp;
	OI_static_text		*tp;
	OI_d_tech		*objp;
	OI_menu_cell		*cellp;
	OI_scroll_bar		*sbarp;
	OI_menu			*bmp;


	bp = oi_create_box( "box", 1, 1 );
	bp->set_layout( OI_layout_column, 20 );
	{
		tp = oi_create_static_text( "box_lbl", "Box" );
		tp->layout_associated_object( bp, (OI_number)0, 0, OI_ACTIVE );
	}
	bp->layout_associated_object( wp, column++, row, OI_ACTIVE );

	sbp = oi_create_scroll_box( "scroll_box", OI_SCROLL_BAR_BOTH, 150, 100, 600, 400 );
	sbp->layout_associated_object( wp, column++, row, OI_ACTIVE );
	sbp->set_layout(OI_layout_row) ;
	objp = OI_obj_setup( "objbox.cf" );
	objp->set_frame_width( 0 );
	objp->layout_associated_object( sbp, (OI_number)0, 0, OI_ACTIVE );

	eb0a = oi_create_box( "ef_box", 1, 1 );
	eb0a->set_layout( OI_layout_column );
	eb0a->set_frame_width( 0 );
	{
		efp = oi_create_entry_field( "entry_field", 10, "Entry Field:", "Default Text", 30 );
		efp->layout_associated_object( eb0a, 0, 10, OI_ACTIVE );
		sefp = oi_create_seq_entry_field( "seq_entry_field", 10, "Sequenced:" );
		sefp->layout_associated_object( eb0a, 0, 20, OI_ACTIVE );
	}
	eb0a->layout_associated_object( wp, column++, row, OI_ACTIVE );

	gaugep = oi_create_gauge(
		"gauge", 100, OI_VERTICAL, 100, 0, "Temp: ", OI_gauge_ends_numeric, NULL, NULL, OI_yes, 5, OI_GAUGE_TICKS_ALL );
	gaugep->layout_associated_object( wp, column++, row, OI_ACTIVE );

	intrvl_slp = oi_create_slider(
		"slider", 100, OI_VERTICAL, 100, 0, &upd_gauge, NULL, "Interval:",
		OI_SLIDER_ENDS_NONE, NULL, NULL, OI_SLIDER_CURRENT_RW, 5, OI_SLIDER_TICKS_ALL );
	intrvl_slp->layout_associated_object( wp, column++, row, OI_ACTIVE );
	intrvl_slp->set_value(50) ;

	eb0b = oi_create_box( "glyph_box", 1, 1 );
	eb0b->set_layout( OI_layout_column );
	eb0b->set_frame_width( 0 );
	{
		gp = oi_create_glyph( "glyph", "mail.bm" );
		gp->layout_associated_object( eb0b, 0, 10, OI_ACTIVE );
		cellp = oi_create_menu_cell( "animate", "Animate", &animate, gp );
		bmp = oi_button_menu( NULL, 1, &cellp );
		bmp->layout_associated_object( eb0b, 0, 20, OI_ACTIVE );
	}
	eb0b->layout_associated_object( wp, column++, row, OI_ACTIVE );

	eb0c = oi_create_box( "scrollbar_box", 1, 1 );
	eb0c->set_layout( OI_layout_row );
	eb0c->set_frame_width( 0 );
	{
		sbarp = oi_create_scroll_bar( "scroll_bar", 100, OI_VERTICAL );
		sbarp->set_span( 100 );
		sbarp->set_view( 40, 1 );
		sbarp->set_gravity( OI_grav_center );
		sbarp->layout_associated_object( eb0c, 0, 10, OI_ACTIVE );

		tp = oi_create_static_text( "scrlbar_lbl", "Scroll Bar" );
		tp->layout_associated_object( eb0c, 0, 20, OI_ACTIVE );
	}
	eb0c->layout_associated_object( wp, column++, row, OI_ACTIVE );
}

static void	
place_objects_into_row2( OI_app_window * wp, OI_number row )
{
	OI_number		column = 10;
	OI_menu			*excl_rect_mp;
	OI_menu			*excl_chk_mp;
	OI_menu			*poly_rect_mp;
	OI_menu			*poly_chk_mp;
	OI_menu			*abbr_mp;
	OI_scroll_menu		*scrl_mp;
	OI_menu			*pd_bmp;
	OI_dialog_box		*dbp;
	OI_menu			*bmp;
	OI_static_text		*tp;
	OI_box			*eb2a;

	static	OI_cell_spec	excl_cells[] =
	{ 
		{ "train", "Train"}, 
		{ "plane", "Plane"}, 
		{ "auto", "Automobile"}, 
		{ "space_ship", "Space Ship"}, 
		{ "boat", "boat.bm", NULL, NULL, NULL_PMF, NULL, OI_ICON_CELL}, 
		{ "foot", "foot.bm", NULL, NULL, NULL_PMF, NULL, OI_ICON_CELL}, 
		{ "horse", "Horse"}, 
		{ "bike", "Bicycle"}, 
		{ "skate", "Skateboard"}, 
	};
	static	OI_cell_spec	poly_cells[] =
	{ 
		{ "fed", "Federal Income"}, 
		{ "state", "State Income"}, 
		{ "state_sales", "State Sales"}, 
		{ "county_sales", "County Sales"}, 
		{ "city_sales", "City Sales"}, 
		{ "excise", "Excise"}, 
		{ "gas", "gas.bm", NULL, NULL, NULL_PMF, NULL, OI_ICON_CELL}, 
		{ "birth", "Birth"}, 
		{ "death", "Death"}, 
	};
	static	OI_cell_spec	pd_cells[] =
	{ 
		{ "home", "Go Home"}, 
		{ "work", "Go To Work"}, 
	};
	static	OI_menu_spec	pd_mnu = { NULL, OI_n_cells( pd_cells ), pd_cells, OI_VERTICAL, NULL };
	static	OI_cell_spec	cells[] =
	{ 
		{ "nothing", "do_nothing.bm", NULL, NULL, NULL_PMF, NULL, OI_ICON_CELL}, 
		{ "pd", "Pull Down", NULL, NULL, NULL_PMF, NULL, OI_TEXT_CELL, &pd_mnu}, 
	};
	static	OI_cell_spec	db_cells[] =
	{ 
		{ "dialogbox", "Dialog Box"}, 
	};


	excl_chk_mp = oi_create_excl_check_menu(
		"excl_check_menu", OI_n_cells( excl_cells ), excl_cells, OI_VERTICAL, "Mode of Transport" );
	excl_chk_mp->layout_associated_object( wp, column++, row, OI_ACTIVE );

	excl_rect_mp = oi_create_excl_rect_menu(
		"excl_rect_menu", OI_n_cells( excl_cells ), excl_cells, OI_VERTICAL, "Mode of Transport" );
	excl_rect_mp->layout_associated_object( wp, column++, row, OI_ACTIVE );

	poly_chk_mp = oi_create_poly_check_menu(
		"poly_check_menu", OI_n_cells( poly_cells ), poly_cells, OI_VERTICAL, "Taxes You Pay" );
	poly_chk_mp->layout_associated_object( wp, column++, row, OI_ACTIVE );

	poly_rect_mp = oi_create_poly_rect_menu(
		"poly_rect_menu", OI_n_cells( poly_cells ), poly_cells, OI_VERTICAL, "Taxes You Pay" );
	poly_rect_mp->layout_associated_object( wp, column++, row, OI_ACTIVE );

	eb2a = oi_create_box( "menu_box", 1, 1 );
	eb2a->set_layout( OI_layout_row );
	eb2a->set_frame_width( 0 );
	{
		abbr_mp = oi_create_abbr_menu(
			"abbr_menu", OI_EXCL_CHECK_MENU, OI_n_cells( excl_cells ),
			excl_cells, OI_VERTICAL, "Mode of Transport " );
		abbr_mp->layout_associated_object( eb2a, (OI_number)0, 0, OI_ACTIVE );

		scrl_mp = oi_create_scroll_menu(
			"scroll_menu", OI_SCROLL_BAR_VERTICAL, 5, OI_POLY_RECT_MENU,
			OI_n_cells( poly_cells ), poly_cells, OI_VERTICAL, "Taxes You Pay" );
		scrl_mp->layout_associated_object( eb2a, 0, 10, OI_ACTIVE );

		pd_bmp = oi_create_button_menu( "pd_button_menu", OI_n_cells( cells ), cells, OI_HORIZONTAL );
		pd_bmp->set_left_space(15);
		pd_bmp->set_gravity(OI_grav_southwest);
		pd_bmp->layout_associated_object( eb2a, 10, 10, OI_ACTIVE );

		bmp = oi_create_button_menu( "db_button_menu", OI_n_cells( db_cells ), db_cells, OI_HORIZONTAL );
		dbp = oi_create_dialog_box( "dialog_box", 200, 100 );
		dbp->set_layout(OI_layout_row) ;
		tp = oi_create_static_text( "db_lbl", "Dialog Box" );
		tp->set_gravity(OI_grav_center) ;
		tp->set_space(20) ;
		tp->layout_associated_object( dbp, (OI_number)0, 0, OI_ACTIVE );
		dbp->set_associated_object( bmp->subobject( "dialogbox" ), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE_NOT_DISPLAYED );
		bmp->layout_associated_object( eb2a, 10, 0, OI_ACTIVE );
	}
	eb2a->layout_associated_object( wp, column++, row, OI_ACTIVE );
}


static void	
place_objects_into_row3( OI_app_window * wp, OI_number row )
{
	OI_number		column = 10;
	OI_multi_text		*mtp;
	OI_scroll_text		*scrl_mtp;
	OI_panner		*panp;
	OI_static_text		*stp;
	OI_static_text		*tp;
	OI_box			*eb3a;

	mtp = oi_create_multi_text( "multi_text", 10, 40 );
	mtp->set_text_to_file( "mlttxt.txt" );
	mtp->set_size_track(OI_size_track_full);
	mtp->layout_associated_object( wp, column++, row, OI_ACTIVE );

	scrl_mtp = oi_create_scroll_text( "scroll_text", OI_SCROLL_BAR_BOTH, 10, 40, 40, 80 );
	scrl_mtp->set_text_to_file( "scrltxt.txt" );
	scrl_mtp->set_size_track(OI_size_track_full);
	scrl_mtp->layout_associated_object( wp, column++, row, OI_ACTIVE );

	eb3a = oi_create_box( "panner_box", 1, 1 );
	eb3a->set_layout( OI_layout_row );
	eb3a->set_frame_width( 0 );
	{
		panp = oi_create_panner( "panner", 150, 100 );
		panp->set_span( 600, 400 );
		panp->set_view( 150, 100 );
		panp->layout_associated_object( eb3a, 0, 10, OI_ACTIVE );

		tp = oi_create_static_text( "panner_lbl", "Panner" );
		tp->set_gravity( OI_grav_center );
		tp->layout_associated_object( eb3a, 0, 20, OI_ACTIVE );

		stp = oi_create_static_text( "static_text", "Static Text" );
		stp->layout_associated_object( eb3a, 0, 30, OI_ACTIVE );
	}
	eb3a->layout_associated_object( wp, column++, row, OI_ACTIVE );
}


static void
animate( OI_menu_cell*, void *argp, OI_number )
{ 
	OI_glyph		*gp = ( OI_glyph * ) argp;
	static	OI_bool		first = OI_YES;
	static	OI_number	n_frame = 0;
	static	Pixmap		*pmp;			// ptr to vector of pixmaps for animation

	if ( first ) n_frame = ( OI_number ) conp->uniform_pixmap_series( &pmp, "mail_@.bm" );
	first = OI_NO;
	gp->animate( intrvl_slp->handle_loc(), n_frame, pmp );
}
