#include <stdlib.h>	// needed for exit()
#include <OI/appwin.H>
#include <OI/scrlmnu.H>
#include <OI/scrlbar.H>

		OI_app_window	*mainp;	// ptr to main window

/******************************************************************************
 *
 *	Function Name:	main
 *
 *		Description: 
 *			Ganged scrolling demo
 *			This demo program shows how to set up a pair of scroll
 *			menus such that they are both controlled by the scroll
 *			bar of the lower one.
 *
 *			There are obvious extensions to more than two scroll
 *			menus, to using scroll boxes and scroll texts instead
 *			of scroll menus, and (much less obviously!) to using
 *			scroll texts with panners instead of scroll bars.
 *
 *		Command line arguments:
 *			With no arguments, ganged scrolling will be implemented
 *			by calling the scroll function for the first menu
 *			directly from the controller in the second menu
 *			With any argument, ganged scrolling will be implemented
 *			via an intermediary function which calls the scroll
 *			function for the first menu.
 * 
 *		Returns:
 * 
 *		Side Effects:
 *
 *		Warnings:
 *			Only works for 4.0 and later
 *			Use earlier rev (1.2) for 3.x libraries
 *
 ******************************************************************************/
void
main(int argc, char *argv[])
{
 /*	External Procedures: */
		void		gang_scroll(OI_ctlr_1d*, void *,
					OI_scroll_event, long);
 /*	Local Variables: */
		int		ret;	// return value
		OI_scroll_menu	*scrlmenu1;
		OI_scroll_menu	*scrlmenu2;
	static	OI_cell_spec	cell_specs[] = {
					{"cell0", "cell 0"},
					{"cell1", "cell 1"},
					{"cell2", "cell 2"},
					{"cell3", "cell 3"},
					{"cell4", "cell 4"},
					{"cell5", "cell 5"},
					{"cell6", "cell 6"},
					{"cell7", "cell 7"},
					{"cell8", "cell 8"},
					{"cell9", "cell 9"}
		};

	if (OI_init(&argc, argv) != NULL) {

		// Create main window and put it on the root
		// This will cause it to fetch resources
		// but because of state OI_not_displayed it won't show up
		mainp = oi_create_app_window("appWindow",
				1, 1, "Ganged Scroll Menus Demo");
		mainp->set_layout(OI_layout_row);
		mainp->set_associated_object(mainp->root(),
				OI_def_loc, OI_def_loc, OI_not_displayed);

		// Create the first scroll menu with no controller,
		// since it will be controlled by the controller in the
		// second
		scrlmenu1 = oi_create_scroll_menu("scrlmenu1",
				0,	// don't want ANY controller here!
				5, OI_BUTTON_MENU,
				OI_n_cells(cell_specs), cell_specs,
				OI_horizontal);
		scrlmenu1->layout_associated_object(mainp, 1, 101, OI_active);

		// Create the second scroll menu
		scrlmenu2 = oi_create_scroll_menu("scrlmenu2",
				OI_scroll_bar_horizontal,
				5, OI_BUTTON_MENU,
				OI_n_cells(cell_specs), cell_specs,
				OI_horizontal);
		scrlmenu2->layout_associated_object(mainp, 1, 102, OI_active);


		// Add an additional callback to the bottom scroll_bar
		// This callback will make the top menu scroll in parallel
		// Two possible solutions:

		// 1. Just tell the bottom menu's scroll_bar to directly 
		//    call the top menu's scroll member function
		//    This works because the scroll member function only
		//    uses the ctlr1d argument to determine the direction
		//    to scroll.
		//    This has the advantage of working regardless of the
		//    orientation of the menus, as long as they are the same.
		if (argc == 1)
			scrlmenu2->horz_scroll_bar()->callback_add("cbCtlr1d",
				scrlmenu1, (OI_memfnp) &OI_scroll_menu::scroll);

		// 2. A more obvious solution is to add an intermediary
		//    callback which calls the scroll member function and
		//    explicitly tells it the direction to scroll
		if (argc > 1)
			scrlmenu2->horz_scroll_bar()->callback_add("cbCtlr1d",
				(OI_fnp) &gang_scroll);

		mainp->set_state(OI_active);
		OI_begin_interaction();

		OI_fini();
		ret = 0;
	}
	else
		ret = 1;
	exit(ret);
}

/*
 ******************************************************************************
 *
 *	Function Name:	gang_scroll
 *
 *		Description: 
 *			Intermediary scroll callback to cause scroll_menu1 to
 *			scroll when scroll_menu2's controller is moved
 *
 *		Returns:
 * 
 *		Side Effects:
 *			scrlmenu1 is caused to scroll
 *
 *		Warnings:
 *			Not used unless program is run with some argument
 *			to cause method 2 in main to be used
 *
 *	RCSid = "$Id: gang_scroll.C,v 1.3.1.1 1993/06/10 19:56:21 mth Exp $"
 *
 ******************************************************************************
 */
void
gang_scroll(
		OI_ctlr_1d	*,	// ptr to controller which changed
		void		*,	// unused user arg
		OI_scroll_event	t,	// type of movement
		long		n)	// direction and amount of movement
{
 /*	External Procedures: */
 /*	Local Variables: */
		OI_scroll_menu	*scrlmenu1;	// ptr to first scroll menu
 /*
	Procedure:
		OI_scroll_menu::scroll is not a documented function,
		but is available as a publicly visible function for use
		within the toolkit, so we have (slightly sneaky) access to it.

		The scroll function for the bottom scroll menu will be
		called automatically; so just call the scroll function
		for the other (top) menu.
 */

	scrlmenu1 = (OI_scroll_menu*) mainp->descendant("scrlmenu1");
	scrlmenu1->scroll(NULL,(void *)OI_horizontal,t,n);
	return;
}

