#include <OI/oi.H>
#include <sys/types.h>
#include <sys/param.h>
#include <string.h>
#include <malloc.h>
#include <dirent.h>

#ifdef ultrix
extern "C" {
	char *strdup (const char *);
}
#endif

/*
 *	The filename completion stuff isn't as complete as I'd like,
 *	however, it is a good example.  Further additions to the file
 *	name completion could include:
 *		- detecting directories and appending a "/"
 *		- setting the filter to the directory and prefix name
 *		- Should not assume that there is an enclosing app-window
 *		- The abilty to have ignored suffixes
 *		- Remove the 256 match limit
 */

/*
 *	match_len
 *
 *	Returns the number of characters that are matched in the two strings
 *	passed.
 */
static int match_len (char *st1, char *st2)
{
	for (int i = 0;  st1[i] && st2[i] && st1[i] == st2[i]; i++)
		;
	return i;
}

/*
 *	filename_completion
 *
 *	Given the partial file name and directory, this routine will return those
 *	characters that follow the partial filename that will complete the largest
 *	portion of the filename that has the partial filename prefix.
 */
char *filename_completion (char *dir, char *part_file, OI_d_tech *objp)
{
	const int	MAX_MATCH = 256;
	static char	ret_buf[MAXPATHLEN];
	int		part_len;
	DIR		*dirp;
	int		matches;
	int		min;
	int		len;
	char		*file_matches[MAX_MATCH];
	struct dirent	*dirent;
	
	part_len = strlen (part_file);
	
	/*
	 *	Try to open the directory
	 */
	dirp = opendir (dir);
	if (dirp == NULL) {
		objp -> push_help_str ("Can't stat directory", OI_YES);
		return NULL;
	}

	/*
	 *	Loop through the directory, skipping the "." and ".."
	 *	entries.  For each name that matches the prefix we are
	 *	looking for, add it to the list of matches.  Warning,
	 *	this code assumes a fixed max number of matches.
	 */
	readdir(dirp);		// Skip "."
	readdir(dirp);		// Skip ".."
	matches = 0;
	while (dirent = readdir (dirp)) {
		if (strncmp (dirent -> d_name, part_file, part_len) == 0)
			if (matches < MAX_MATCH)
				file_matches[matches++] = strdup (dirent->d_name);
	}
	closedir (dirp);
	
	if (matches) {
		/*
		 *	Find out what the longest sub-match is.  Copy
		 *	it into ret_buf so we can return it.
		 */
		min = MAXPATHLEN;
		for (int i = 0; i < matches; i++) {
			if (strcmp (file_matches[i], part_file) == 0 && matches > 1)
				objp -> push_help_str ("Complete but not unique", OI_YES);
			if ((len = match_len (file_matches[0], file_matches[i])) < min)
				min = len;
		}
		if (part_len == min && matches == 1)
			objp -> push_help_str ("Sole completion", OI_YES);
		strcpy (ret_buf, file_matches[0]+part_len);
		ret_buf[min - part_len] = '\0';

		/*
		 *	Free up the strings we've used.
		 */
		for (i = 0; i < matches; i++)
			free (file_matches[i]);
		return ret_buf;
	}
	else {
		objp -> push_help_str ("No files match", OI_YES);
		return NULL;
	}
}


/*
 *	parse_path_in_ef
 *
 *	Tries to figure out what directory and file are specified in the current entry field.  If the entry
 *	field is part of a file dialog box, then its current directory will be used when none is given.
 */
void parse_path_in_ef (OI_entry_field *efp, char *dir, char *file)
{
	char		*tmp;

	/*
	 *	Try to figure out the directory and file in that dir.
	 */
	dir[0] = '\0';
	file[0] = '\0';
	if (efp -> part_text())
		strcpy (dir, OI_translate_filename (efp -> part_text()));
	if (strchr (dir, '/') == NULL) {
#ifdef UNIMPLEMENTED
		if (efp->parent()->is_derived_from("OI_FILE_DIALOG_BOX"))
#else
		if (efp->parent()->is_derived_from("OI_DIALOG_BOX"))
#endif
			strcpy (dir, ((OI_file_dialog_box *) efp->parent())->directory());
		else
			strcpy (dir, ".");
		if (efp -> part_text ())
			strcpy (file, efp -> part_text());
	}
	else {
		tmp = strrchr (dir, '/');
		*tmp = '\0';
		strcpy (file, tmp + 1);
	}

}

/*
 *	entry_field_complete
 *
 *	Completes the filename in the passed entry field.
 */
int entry_field_complete (OI_entry_field *efp)
{
	char		*match_characters;
	char		dir[MAXPATHLEN];
	char		part_file[MAXPATHLEN];
	
	parse_path_in_ef (efp, dir, part_file);
	match_characters = filename_completion (dir, part_file, efp);
	if (match_characters == NULL)
		return 1;
	else {
		while (*match_characters)
			efp -> insert_char (efp -> length(), *match_characters++);
		return 0;
	}
}
