(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     79200,       1454]
NotebookOptionsPosition[     77344,       1398]
NotebookOutlinePosition[     77754,       1416]
CellTagsIndexPosition[     77711,       1413]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"List", " ", "of", " ", "fast", " ", "Deleglise"}], "-", 
      RowBox[{"Rivat", " ", "alpha", " ", "factors", " ", "for", " ", "x"}]}],
      " ", "\[LessEqual]", " ", 
     RowBox[{
      RowBox[{"10", "^", "24"}], " ", "found", " ", "by", " ", "running", " ",
       "pi", 
      RowBox[{"(", "x", ")"}], " ", "benchmarks", " ", "using", " ", "the", 
      " ", "find_fastest", 
      RowBox[{"_alpha", ".", "sh"}], " ", "script"}]}], " ", "*)"}],
   FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"alphaDelegliseRivat", " ", "=", "  ", 
   RowBox[{"{", " ", 
    StyleBox[
     RowBox[{"(*", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "alpha"}], "}"}], " ", "*)"}],
     FontColor->GrayLevel[0.5]], " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "1"}], ",", " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "2"}], ",", " ", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "3"}], ",", " ", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "4"}], ",", " ", "1.095"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "5"}], ",", " ", "1.174"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "6"}], ",", "1.310"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "7"}], ",", "1.591"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "8"}], ",", "2.095"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "9"}], ",", "3.178"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "10"}], ",", "3.795"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "11"}], ",", "4.779"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "12"}], ",", "6.103"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "13"}], ",", " ", "7.810"}], "}"}], ",", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "14"}], ",", " ", "10.545"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "15"}], ",", "  ", "13.969"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "16"}], ",", " ", "17.461"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "17"}], ",", "20.862"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "18"}], ",", "24.146"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "19"}], ",", " ", "28.184"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "20"}], ",", " ", "33.230"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "21"}], ",", "38.64"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "22"}], ",", "44.296"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "23"}], ",", " ", "50.845"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "24"}], ",", "57.647"}], "}"}]}], " ", 
    "}"}]}]}]], "Input",
 CellChangeTimes->{{3.6342144496271477`*^9, 3.634214449657395*^9}, {
   3.634214864029477*^9, 3.63421494098*^9}, 3.634215356502603*^9, 
   3.634216732913278*^9, 3.634216792517975*^9, 3.63421709738085*^9, {
   3.634217195246738*^9, 3.634217197246505*^9}, {3.634217320052363*^9, 
   3.634217367277713*^9}, {3.6342192048076153`*^9, 3.634219307206225*^9}, 
   3.634219457717223*^9, 3.634221586293499*^9, 3.634221968584746*^9, {
   3.6342228535540867`*^9, 3.634222862580043*^9}, 3.634223353992779*^9, 
   3.6342233882826033`*^9, {3.634223716705235*^9, 3.634223825740685*^9}, {
   3.6342238590483427`*^9, 3.6342238608323727`*^9}, 3.63422389508031*^9, 
   3.634224030492651*^9, {3.634224559774934*^9, 3.6342246092169867`*^9}, 
   3.6342248191341457`*^9, {3.634225569467923*^9, 3.6342255941483097`*^9}, {
   3.634225633631463*^9, 3.6342256750199957`*^9}, 3.6343114986871243`*^9, {
   3.634312463124134*^9, 3.6343124795414143`*^9}, {3.634312904268826*^9, 
   3.634312904506991*^9}, {3.634313367970984*^9, 3.634313368055884*^9}, 
   3.634313817457871*^9, {3.634314175987664*^9, 3.634314176376103*^9}, {
   3.6343171981207*^9, 3.634317211797673*^9}, {3.634317529596525*^9, 
   3.634317585048218*^9}, {3.634317938842206*^9, 3.6343179668452272`*^9}, {
   3.634318190910866*^9, 3.6343182011224823`*^9}, {3.634319765173918*^9, 
   3.634319766739089*^9}, 3.634322605909387*^9, 3.634323178377804*^9, {
   3.634323230262714*^9, 3.634323263081522*^9}, {3.6344011758057423`*^9, 
   3.63440130575837*^9}, {3.634402543519903*^9, 3.634402558551346*^9}, {
   3.63440260432032*^9, 3.634402626740971*^9}, 3.63440282142768*^9, {
   3.6344036808761063`*^9, 3.634403695996646*^9}, {3.6344044546637*^9, 
   3.6344044703783817`*^9}, {3.634404530992594*^9, 3.634404583478207*^9}, {
   3.634405067624672*^9, 3.6344051075921297`*^9}, {3.6344059778692904`*^9, 
   3.6344059931868887`*^9}, {3.634579131561199*^9, 3.6345791589678097`*^9}, {
   3.6345792166729317`*^9, 3.6345792468346148`*^9}, {3.634579300959697*^9, 
   3.634579302111292*^9}, 3.634579335693976*^9, 3.6345793680151443`*^9, {
   3.634579409052127*^9, 3.634579412365301*^9}, {3.634579592533288*^9, 
   3.6345796209021063`*^9}, {3.6345796554563637`*^9, 
   3.6345796559051332`*^9}, {3.6345809701196413`*^9, 3.634580983033938*^9}, {
   3.652357164198679*^9, 3.652357208881404*^9}, {3.652357273549094*^9, 
   3.6523574609038973`*^9}, {3.652357493110022*^9, 3.652357504908649*^9}, {
   3.652357540322856*^9, 3.652357579047759*^9}, {3.65235764357404*^9, 
   3.652357662826145*^9}, {3.652358277632721*^9, 3.652358304331625*^9}, {
   3.652358354711768*^9, 3.652358367532495*^9}, {3.652358471062765*^9, 
   3.652358471363777*^9}, {3.652358588438684*^9, 3.652358638513836*^9}, {
   3.652359279591865*^9, 3.652359285196542*^9}, {3.652460993573386*^9, 
   3.652460993685218*^9}, 3.652715829378139*^9, {3.652799019844857*^9, 
   3.6527990707682953`*^9}, {3.652799145827832*^9, 3.652799311039904*^9}, 
   3.652799360585042*^9, {3.6527996459634*^9, 3.652799653384603*^9}, {
   3.652799986396648*^9, 3.652799987009795*^9}, {3.6528938276496162`*^9, 
   3.652893832824053*^9}, {3.707277472695118*^9, 3.7072775116155453`*^9}, {
   3.7072775692608023`*^9, 3.7072775693953238`*^9}, {3.707277719056685*^9, 
   3.707277719198053*^9}, {3.707277860816516*^9, 3.707277861264237*^9}, {
   3.707277896219*^9, 3.707277920312046*^9}, {3.707303362684276*^9, 
   3.707303375580131*^9}, {3.7073034361543922`*^9, 3.7073034363449*^9}, {
   3.707549793030284*^9, 3.707549794045802*^9}, {3.70754982546942*^9, 
   3.70754988570748*^9}, 3.7075502239768867`*^9, {3.707550344650425*^9, 
   3.7075503447605963`*^9}},ExpressionUUID->"59b8fd83-44b9-4878-bb3f-\
7551643fd9cd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10000", ",", "1.095`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100000", ",", "1.174`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000000", ",", "1.31`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10000000", ",", "1.591`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100000000", ",", "2.095`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000000000", ",", "3.178`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10000000000", ",", "3.795`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100000000000", ",", "4.779`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000000000000", ",", "6.103`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10000000000000", ",", "7.81`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100000000000000", ",", "10.545`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000000000000000", ",", "13.969`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10000000000000000", ",", "17.461`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100000000000000000", ",", "20.862`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000000000000000000", ",", "24.146`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10000000000000000000", ",", "28.184`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100000000000000000000", ",", "33.23`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000000000000000000000", ",", "38.64`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10000000000000000000000", ",", "44.296`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100000000000000000000000", ",", "50.845`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000000000000000000000000", ",", "57.647`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.709371084704584*^9},ExpressionUUID->"e7c25df3-ae70-405e-965d-\
ab5c722ae35f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLinearPlot", "[", 
  RowBox[{"alphaDelegliseRivat", ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", " ", 
   RowBox[{"Joined", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.63421355862941*^9, 3.634213562891761*^9}, {
   3.634214411288012*^9, 3.634214412137083*^9}, 3.6342144658301353`*^9, {
   3.6342149593437853`*^9, 3.634214961416874*^9}, {3.634310891624807*^9, 
   3.6343109273369293`*^9}, {3.6343110236625843`*^9, 
   3.6343110629678717`*^9}, {3.634311122293149*^9, 3.634311131795865*^9}, 
   3.6343111637447233`*^9, {3.634311250145281*^9, 3.6343112515669603`*^9}, {
   3.634311442467537*^9, 3.634311459050597*^9}, {3.6343116042250013`*^9, 
   3.6343116171153812`*^9}, 3.6343227418249397`*^9, {3.634403951550028*^9, 
   3.6344039592049627`*^9}, 
   3.6345809039040937`*^9},ExpressionUUID->"e9d1e34b-5900-401c-b4fc-\
eb3f0c6e8b6e"],

Cell[BoxData[
 GraphicsBox[{{{}, GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGCQBmIQjQo+2IuFbt29MZvJAZUvBOcv+N8/s2uhNJq8kkPr
68Adcq0f7aNXLdKax6bukCQQYbnlxCeoem2Hbxox/Ye+frEvXmXXYi1n4HD7
Z13WnpKfUP1GDoe/ghQwOOz4r/1ZfaeJA1vjVOfuHE4HiHnmDiDdGjF8Dv9C
JJNEQiwdWML4dDfJCjtAzLd22Pb575WKTAkH51VsFxne2zrYcl1fXGAr7wCx
z8EBxOMSV3U48v/n/G8ujg6Pl84+ovBB2wFiv5PDnpLJEixlhg7pqwqu50xy
dnipZsix5o4J1D0uDj7mnY4JqhYOXKHP+R7fd3U4WbZvvpS+DdR97hD75jo4
rPkf6xap6+EQBAyN14HOUPd6Otw89z34saqbg/+qK7Xnq7wg/snxhLrf2wFo
+tMLl3wc0GMEJg/jAwDm4qub
     "], {{{}, {
        {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[None],
          GraphicsGroupBox[{
           PolygonBox[{{1, 26, 27, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15,
             14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 
            2}}]}]}}, {}, {}}, {{}, {}, {
        {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
         0.012833333333333334`], AbsoluteThickness[1.6], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25}]}}}}], {}, {}, {{}, {}}, {{}, {}}}},
  
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-2.032750902408807, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Exp[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Exp[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-1.151292546497023, 55.262042231857095`}, {0, 57.647}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], Automatic}, {{{-2.3025850929940455`, 
       FormBox["0.1`", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox[
        TagBox[
         InterpretationBox["\"1000.0\"", 1000., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1.}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {16.11809565095832, 
       FormBox[
        TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {25.328436022934504`, 
       FormBox[
        TemplateBox[{"10", "11"}, "Superscript", SyntaxForm -> 
         SuperscriptBox], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {34.538776394910684`, 
       FormBox[
        TemplateBox[{"10", "15"}, "Superscript", SyntaxForm -> 
         SuperscriptBox], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {43.74911676688687, 
       FormBox[
        TemplateBox[{"10", "19"}, "Superscript", SyntaxForm -> 
         SuperscriptBox], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {52.95945713886305, 
       FormBox[
        TemplateBox[{"10", "23"}, "Superscript", SyntaxForm -> 
         SuperscriptBox], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
       0.}, {
        AbsoluteThickness[0.1]}}, {11.512925464970229`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
       0.}, {
        AbsoluteThickness[0.1]}}, {20.72326583694641, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
       0.}, {
        AbsoluteThickness[0.1]}}, {29.933606208922594`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
       0.}, {
        AbsoluteThickness[0.1]}}, {39.14394658089878, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
       0.}, {
        AbsoluteThickness[0.1]}}, {48.35428695287496, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
       0.}, {
        AbsoluteThickness[0.1]}}, {57.564627324851145`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
       0.}, {
        AbsoluteThickness[0.1]}}}, Automatic}]]], "Output",
 CellChangeTimes->{
  3.709371087771514*^9},ExpressionUUID->"ab9ff723-6dac-4fc5-adbc-\
696d2196bcbf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{
    "alpha", " ", "is", " ", "a", " ", "tuning", " ", "factor", " ", "that", 
     " ", "balances", " ", "the", " ", "compuation", " ", "of", " ", "the", 
     " ", "easy", " ", "special", " ", "leaves", " ", "and", " ", "the", " ", 
     "hard", " ", "special", " ", 
     RowBox[{"leaves", ".", " ", "The"}], " ", "formula", " ", "below", " ", 
     "is", " ", "used", " ", "in", " ", "the", " ", "file", " ", 
     RowBox[{"src", "/", 
      RowBox[{"primecount", ".", "cpp"}]}], " ", "to", " ", "calculate", " ", 
     "a", " ", "fast", " ", "alpha", " ", "factor", " ", "for", " ", "the", 
     " ", "computation", " ", "of", " ", "pi", 
     RowBox[{
      RowBox[{"(", "x", ")"}], "."}]}], " ", "*)"}],
   FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"NonlinearModelFit", "[", 
   RowBox[{"alphaDelegliseRivat", ",", " ", 
    RowBox[{
     RowBox[{"a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Log", "[", "x", "]"}], ")"}], "^", "3"}]}], " ", "+", " ", 
     RowBox[{"b", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Log", "[", "x", "]"}], ")"}], "^", "2"}]}], " ", "+", " ", 
     RowBox[{"c", " ", 
      RowBox[{"Log", "[", "x", "]"}]}], " ", "+", " ", "d"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", " ", "c", ",", " ", "d"}], "}"}], ",", " ", 
    "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.652358724257576*^9, 3.652358806604454*^9}, {
   3.6523588510261183`*^9, 3.6523588531451893`*^9}, {3.652358884592828*^9, 
   3.652359081773032*^9}, {3.652799874265688*^9, 3.6527998777122717`*^9}, {
   3.652893838655382*^9, 3.652893845206745*^9}, 
   3.6528940353068323`*^9},ExpressionUUID->"338a445a-aae9-45e7-907e-\
7f25b0cf0cf4"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{"1.372401709401704`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.11040708527974058`", " ", 
        RowBox[{"Log", "[", "x", "]"}]}], "+", 
       RowBox[{"0.0018112980022214197`", " ", 
        SuperscriptBox[
         RowBox[{"Log", "[", "x", "]"}], "2"]}], "+", 
       RowBox[{"0.00033826000801937927`", " ", 
        SuperscriptBox[
         RowBox[{"Log", "[", "x", "]"}], "3"]}]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Nonlinear", {$CellContext`a -> 0.00033826000801937927`, $CellContext`b -> 
      0.0018112980022214197`, $CellContext`c -> -0.11040708527974058`, \
$CellContext`d -> 
      1.372401709401704}, {{$CellContext`x}, $CellContext`d + $CellContext`c 
       Log[$CellContext`x] + $CellContext`b 
       Log[$CellContext`x]^2 + $CellContext`a Log[$CellContext`x]^3}}, {
    1}, {{1, 1}, {10, 1}, {100, 1}, {1000, 1}, {10000, 1.095}, {
     100000, 1.174}, {1000000, 1.31}, {10000000, 1.591}, {100000000, 2.095}, {
     1000000000, 3.178}, {10000000000, 3.795}, {100000000000, 4.779}, {
     1000000000000, 6.103}, {10000000000000, 7.81}, {
     100000000000000, 10.545}, {1000000000000000, 13.969}, {
     10000000000000000, 17.461}, {100000000000000000, 20.862}, {
     1000000000000000000, 24.146}, {10000000000000000000, 28.184}, {
     100000000000000000000, 33.23}, {1000000000000000000000, 38.64}, {
     10000000000000000000000, 44.296}, {100000000000000000000000, 50.845}, {
     1000000000000000000000000, 57.647}}, 
    Function[Null, 
     Internal`LocalizedBlock[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d, $CellContext`x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellFrame->{{0, 0}, {2, 0}},
 CellChangeTimes->{
  3.70937109102711*^9},ExpressionUUID->"86550fda-9363-4a86-825c-f3438c19b4d5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"List", " ", "of", " ", "fast", " ", "Lagarias"}], "-", "Miller",
      "-", 
     RowBox[{
     "Odlyzko", " ", "alpha", " ", "factors", " ", "found", " ", "by", " ", 
      "running", " ", "pi", 
      RowBox[{"(", "x", ")"}], " ", 
      RowBox[{"benchmarks", "."}]}]}], " ", "*)"}],
   FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"alphaLMO", " ", "=", " ", 
   RowBox[{"{", 
    StyleBox[
     RowBox[{"(*", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "alpha"}], "}"}], " ", "*)"}],
     FontColor->GrayLevel[0.5]], " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "10"}], ",", " ", "1.208"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "11"}], ",", " ", "1.281"}], "}"}], ",", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "12"}], ",", " ", "1.364"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "13"}], ",", " ", "1.679"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "14"}], ",", " ", "1.890"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "15"}], ",", "2.011"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "16"}], ",", " ", "2.113"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "17"}], ",", " ", "2.359"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "18"}], ",", " ", "2.556"}], "}"}]}], 
    "}"}]}]}]], "Input",
 CellChangeTimes->{{3.63421344494037*^9, 3.634213445624035*^9}, {
   3.634215431555122*^9, 3.634215513284093*^9}, {3.634215600175366*^9, 
   3.634215619788096*^9}, 3.634215656990878*^9, 3.634215720809465*^9, {
   3.6342157667969522`*^9, 3.634215767165007*^9}, {3.634215844568947*^9, 
   3.634215848768384*^9}, {3.634215892499003*^9, 3.6342158991052933`*^9}, {
   3.6342159486720448`*^9, 3.634215967468809*^9}, {3.634216242103594*^9, 
   3.634216251921739*^9}, 3.634217349492552*^9, {3.634314695950554*^9, 
   3.6343147086478233`*^9}, 3.634322609691835*^9, {3.6343231672555017`*^9, 
   3.634323170063471*^9}, 3.6343232738673983`*^9, {3.634323441217924*^9, 
   3.6343234449257107`*^9}, {3.634404012629353*^9, 3.6344040279052*^9}, {
   3.634405024424403*^9, 3.634405024582734*^9}, {3.6345813154704723`*^9, 
   3.63458132685883*^9}, {3.652340017483922*^9, 3.652340090042877*^9}, {
   3.6523401226925707`*^9, 3.6523401631045513`*^9}, {3.652340205179083*^9, 
   3.6523402578472652`*^9}, {3.652340388683112*^9, 3.652340400128792*^9}, 
   3.652340486932126*^9, {3.6523432960802717`*^9, 3.652343320573119*^9}, {
   3.652343353095994*^9, 3.652343375283201*^9}, {3.652358670776546*^9, 
   3.652358671261818*^9}, {3.652359327963564*^9, 3.6523593575432653`*^9}, {
   3.652799391654447*^9, 3.6527994077294073`*^9}, {3.652799459199575*^9, 
   3.6527994601652946`*^9}, {3.652894051835206*^9, 
   3.652894053576467*^9}},ExpressionUUID->"98e07a75-ba0c-4e32-ac60-\
ce3dcb649c89"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10000000000", ",", "1.208`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100000000000", ",", "1.281`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000000000000", ",", "1.364`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10000000000000", ",", "1.679`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100000000000000", ",", "1.89`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000000000000000", ",", "2.011`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10000000000000000", ",", "2.113`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100000000000000000", ",", "2.359`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000000000000000000", ",", "2.556`"}], "}"}]}], "}"}]], "Output",\

 CellID->108,ExpressionUUID->"366182ce-8fa5-4cb2-85e6-63c7740efff0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLinearPlot", "[", 
  RowBox[{"alphaLMO", ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", " ", 
   RowBox[{"Joined", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6343148187325907`*^9, 3.6343148346924543`*^9}, 
   3.634323448934331*^9, 
   3.634403977189968*^9},ExpressionUUID->"381aa3c9-7179-4b58-b173-\
8ed7facd4779"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    GraphicsComplexBox[{{0., 1.}, {23.025850929940457`, 1.208}, {
     25.328436022934504`, 1.281}, {27.631021115928547`, 1.364}, {
     29.933606208922594`, 1.679}, {32.23619130191664, 1.89}, {
     34.538776394910684`, 2.011}, {36.841361487904734`, 2.113}, {
     39.14394658089878, 2.359}, {41.44653167389282, 2.556}, {0., 0.}, {
     41.44653167389282, 0.}}, {{{}, {
        {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[None],
          GraphicsGroupBox[{
           PolygonBox[{{1, 11, 12, 10, 9, 8, 7, 6, 5, 4, 3, 
            2}}]}]}}, {}, {}}, {{}, {}, {
        {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
         0.012833333333333334`], AbsoluteThickness[1.6], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 
          10}]}}}}], {}, {}, {{}, {}}, {{}, {}}}},
  BoxID -> 
  "{\"jsonData\":\"{\\\"width\\\":360.0,\\\"type\\\":\\\"Graphics\\\",\\\"\
UserCoords\\\":[-3.84276,2.69992,42.5212,-0.223926],\\\"offset\\\":[-66.0,-5.\
0],\\\"primitives\\\":[{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[82,5],[82,217],[425,217],[425,5]]},{\\\"type\\\
\":\\\"Polygon\\\",\\\"faceForm\\\":{\\\"color\\\":[93.9455,129.23,181],\\\"\
opacity\\\":0.2},\\\"edgeForm\\\":{\\\"color\\\":[93.9455,129.23,181],\\\"\
capForm\\\":\\\"Square\\\",\\\"opacity\\\":0.2,\\\"thickness\\\":[],\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.23931},\\\"dashing\\\":[]\
},\\\"antialiased\\\":false,\\\"fillrule\\\":\\\"EvenOdd\\\",\\\"points\\\":[[\
95.8377,135.815],[95.8377,212.768],[417.656,212.768],[417.656,16.0749],[399.\
777,31.2347],[381.898,50.1653],[364.019,58.0146],[346.141,67.3259],[328.262,\
83.5631],[310.383,107.803],[292.504,114.191],[274.626,119.808]]},{\\\"points\\\
\":[[95.8377,135.815],[274.626,119.808],[292.504,114.191],[310.383,107.803],[\
328.262,83.5631],[346.141,67.3259],[364.019,58.0146],[381.898,50.1653],[399.\
777,31.2347],[417.656,16.0749]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":\
true,\\\"edgeForm\\\":{\\\"color\\\":[93.9455,129.23,181],\\\"capForm\\\":\\\"\
Square\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":1.6},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"type\\\":\\\"Group\\\",\\\"name\\\":\\\"Frame\\\",\
\\\"primitives\\\":[],\\\"metadata\\\":{\\\"left\\\":-1.74493,\\\"top\\\":2.\
69342,\\\"bottom\\\":-0.0549677,\\\"right\\\":42.328}},{\\\"type\\\":\\\"\
Group\\\",\\\"name\\\":\\\"Axes\\\",\\\"primitives\\\":[{\\\"transform\\\":[1.\
0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230]\
,[426,230],[426,5]]},{\\\"points\\\":[[95.8377,212.768],[95.8377,209.346]],\\\
\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\"edgeForm\\\":{\\\"color\
\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"opacity\\\":1,\\\"\
thickness\\\":{\\\"absolute\\\":0.1},\\\"joinForm\\\":{\\\"type\\\":\\\"Miter\
\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":null},{\\\"type\\\":\
\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[0.5,1],\\\"localRect\\\":{\\\"\
left\\\":0,\\\"top\\\":0,\\\"bottom\\\":11,\\\"right\\\":6},\\\"transform\\\":\
[1,0,0,1,92.8377,217.768],\\\"pos\\\":[0,0]},\\\"boxdata\\\":\\\"\\\\\
nStyleBox[\\\\\\\"1\\\\\\\",\\\\n FontFamily->\\\\\\\"Arial\\\\\\\",\\\\n \
FontSize->10,\\\\n FontWeight->\\\\\\\"Plain\\\\\\\",\\\\n \
FontSlant->\\\\\\\"Plain\\\\\\\",\\\\n FontTracking->\\\\\\\"Plain\\\\\\\",\\\
\\n PrivateFontOptions->{\\\\\\\"OperatorSubstitution\\\\\\\"->True},\\\\n \
FontColor->GrayLevel[0.4],\\\\n FontOpacity->1,\\\\n Background->None]\\\"},{\
\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\\\"\
path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[167.353,212.\
768],[167.353,209.346]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\
\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.1},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[0.5,1],\\\"\
localRect\\\":{\\\"left\\\":0,\\\"top\\\":0,\\\"bottom\\\":13,\\\"right\\\":\
19},\\\"transform\\\":[1,0,0,1,157.853,215.768],\\\"pos\\\":[9.21034,0]},\\\"\
boxdata\\\":\\\"\\\\nStyleBox[\\\\n TemplateBox[{\\\\\\\"10\\\\\\\",\\\\\\\"4\
\\\\\\\"},\\\\n  \\\\\\\"Superscript\\\\\\\"],\\\\n FontFamily->\\\\\\\"Arial\
\\\\\\\",\\\\n FontSize->10,\\\\n FontWeight->\\\\\\\"Plain\\\\\\\",\\\\n \
FontSlant->\\\\\\\"Plain\\\\\\\",\\\\n FontTracking->\\\\\\\"Plain\\\\\\\",\\\
\\n PrivateFontOptions->{\\\\\\\"OperatorSubstitution\\\\\\\"->True},\\\\n \
FontColor->GrayLevel[0.4],\\\\n FontOpacity->1,\\\\n Background->None]\\\"},{\
\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\\\"\
path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[238.868,212.\
768],[238.868,209.346]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\
\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.1},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[0.5,1],\\\"\
localRect\\\":{\\\"left\\\":0,\\\"top\\\":0,\\\"bottom\\\":13,\\\"right\\\":\
19},\\\"transform\\\":[1,0,0,1,229.368,215.768],\\\"pos\\\":[18.4207,0]},\\\"\
boxdata\\\":\\\"\\\\nStyleBox[\\\\n TemplateBox[{\\\\\\\"10\\\\\\\",\\\\\\\"8\
\\\\\\\"},\\\\n  \\\\\\\"Superscript\\\\\\\"],\\\\n FontFamily->\\\\\\\"Arial\
\\\\\\\",\\\\n FontSize->10,\\\\n FontWeight->\\\\\\\"Plain\\\\\\\",\\\\n \
FontSlant->\\\\\\\"Plain\\\\\\\",\\\\n FontTracking->\\\\\\\"Plain\\\\\\\",\\\
\\n PrivateFontOptions->{\\\\\\\"OperatorSubstitution\\\\\\\"->True},\\\\n \
FontColor->GrayLevel[0.4],\\\\n FontOpacity->1,\\\\n Background->None]\\\"},{\
\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\\\"\
path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[310.383,212.\
768],[310.383,209.346]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\
\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.1},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[0.5,1],\\\"\
localRect\\\":{\\\"left\\\":0,\\\"top\\\":0,\\\"bottom\\\":13,\\\"right\\\":\
25},\\\"transform\\\":[1,0,0,1,297.883,215.768],\\\"pos\\\":[27.631,0]},\\\"\
boxdata\\\":\\\"\\\\nStyleBox[\\\\n \
TemplateBox[{\\\\\\\"10\\\\\\\",\\\\\\\"12\\\\\\\"},\\\\n  \
\\\\\\\"Superscript\\\\\\\"],\\\\n FontFamily->\\\\\\\"Arial\\\\\\\",\\\\n \
FontSize->10,\\\\n FontWeight->\\\\\\\"Plain\\\\\\\",\\\\n \
FontSlant->\\\\\\\"Plain\\\\\\\",\\\\n FontTracking->\\\\\\\"Plain\\\\\\\",\\\
\\n PrivateFontOptions->{\\\\\\\"OperatorSubstitution\\\\\\\"->True},\\\\n \
FontColor->GrayLevel[0.4],\\\\n FontOpacity->1,\\\\n Background->None]\\\"},{\
\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\\\"\
path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[381.898,212.\
768],[381.898,209.346]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\
\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.1},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[0.5,1],\\\"\
localRect\\\":{\\\"left\\\":0,\\\"top\\\":0,\\\"bottom\\\":13,\\\"right\\\":\
25},\\\"transform\\\":[1,0,0,1,369.398,215.768],\\\"pos\\\":[36.8414,0]},\\\"\
boxdata\\\":\\\"\\\\nStyleBox[\\\\n \
TemplateBox[{\\\\\\\"10\\\\\\\",\\\\\\\"16\\\\\\\"},\\\\n  \
\\\\\\\"Superscript\\\\\\\"],\\\\n FontFamily->\\\\\\\"Arial\\\\\\\",\\\\n \
FontSize->10,\\\\n FontWeight->\\\\\\\"Plain\\\\\\\",\\\\n \
FontSlant->\\\\\\\"Plain\\\\\\\",\\\\n FontTracking->\\\\\\\"Plain\\\\\\\",\\\
\\n PrivateFontOptions->{\\\\\\\"OperatorSubstitution\\\\\\\"->True},\\\\n \
FontColor->GrayLevel[0.4],\\\\n FontOpacity->1,\\\\n Background->None]\\\"},{\
\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\\\"\
path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[131.595,212.\
768],[131.595,211.057]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\
\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.1},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[0,0.9992],\\\
\"localRect\\\":{\\\"left\\\":0,\\\"top\\\":-1,\\\"bottom\\\":0,\\\"right\\\":\
1},\\\"transform\\\":[1,0,0,1,131.595,227.767],\\\"pos\\\":[4.60517,0]},\\\"\
boxdata\\\":\\\"StyleBox[FormBox[InterpretationBox[StyleBox[GraphicsBox[\
BoxStoreID -> \\\\\\\"110\\\\\\\", ImageSize -> {1, 1}, BaselinePosition -> \
Baseline, ImageSize -> {0., 0.}, BoxID -> \\\\\\\"{\\\\\\\\\\\\\\\"jsonData\\\
\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"type\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Graphics\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\
\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"height\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\": 1.000000,\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"width\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\": \
1.000000,\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"offset\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\": [-66.000000, -5.000000],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\"UserCoords\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": [-1.041667, \
-0.000000, 1.041667, -2.083333],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\"AxesOrigin\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": [0.000000, 0.000000],\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\": [\\\\\\\\\\\\\\\\n{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"type\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Group\\\\\\\\\\\\\\\\\\\\\
\\\\\\\\\\\", \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"name\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Frame\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"metadata\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\": {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-1.04167, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"top\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": 1.04, \\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": 1.04167, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"bottom\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-1.04},\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\":[]}, \
\\\\\\\\\\\\\\\\n{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"type\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Group\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\", \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"name\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Axes\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"metadata\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"TBD\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\
\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\\\\\\\\\\\
\\\\\\\\\":[]}],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"PlotRange\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\": {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\": 0.000000, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"top\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\": -1.499200, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
1.000000, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"bottom\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-0.500800}\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"\
requestedImageSize\\\\\\\\\\\\\\\":[1,1]}\\\\\\\"], CacheGraphics -> False], \
Spacer[{0., 0.}], Selectable -> False], TraditionalForm], FontFamily -> \
\\\\\\\"Arial\\\\\\\", FontSize -> 10, FontWeight -> \\\\\\\"Plain\\\\\\\", \
FontSlant -> \\\\\\\"Plain\\\\\\\", FontTracking -> \\\\\\\"Plain\\\\\\\", \
FontColor -> GrayLevel[0.4], FontOpacity -> 1, Background -> \
None]\\\"},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\
\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[203.\
11,212.768],[203.11,211.057]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":\
false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\
\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.1},\\\"joinForm\\\"\
:{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\
\\\":null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[0,0.\
9992],\\\"localRect\\\":{\\\"left\\\":0,\\\"top\\\":-1,\\\"bottom\\\":0,\\\"\
right\\\":1},\\\"transform\\\":[1,0,0,1,203.11,227.767],\\\"pos\\\":[13.8155,\
0]},\\\"boxdata\\\":\\\"StyleBox[FormBox[InterpretationBox[StyleBox[\
GraphicsBox[BoxStoreID -> \\\\\\\"111\\\\\\\", ImageSize -> {1, 1}, \
BaselinePosition -> Baseline, ImageSize -> {0., 0.}, BoxID -> \\\\\\\"{\\\\\\\
\\\\\\\\\"jsonData\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"{\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\"type\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Graphics\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\
\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"height\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\": 1.000000,\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"width\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\": \
1.000000,\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"offset\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\": [-66.000000, -5.000000],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\"UserCoords\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": [-1.041667, \
-0.000000, 1.041667, -2.083333],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\"AxesOrigin\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": [0.000000, 0.000000],\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\": [\\\\\\\\\\\\\\\\n{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"type\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Group\\\\\\\\\\\\\\\\\\\\\
\\\\\\\\\\\", \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"name\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Frame\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"metadata\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\": {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-1.04167, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"top\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": 1.04, \\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": 1.04167, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"bottom\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-1.04},\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\":[]}, \
\\\\\\\\\\\\\\\\n{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"type\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Group\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\", \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"name\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Axes\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"metadata\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"TBD\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\
\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\\\\\\\\\\\
\\\\\\\\\":[]}],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"PlotRange\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\": {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\": 0.000000, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"top\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\": -1.499200, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
1.000000, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"bottom\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-0.500800}\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"\
requestedImageSize\\\\\\\\\\\\\\\":[1,1]}\\\\\\\"], CacheGraphics -> False], \
Spacer[{0., 0.}], Selectable -> False], TraditionalForm], FontFamily -> \
\\\\\\\"Arial\\\\\\\", FontSize -> 10, FontWeight -> \\\\\\\"Plain\\\\\\\", \
FontSlant -> \\\\\\\"Plain\\\\\\\", FontTracking -> \\\\\\\"Plain\\\\\\\", \
FontColor -> GrayLevel[0.4], FontOpacity -> 1, Background -> \
None]\\\"},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\
\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[274.\
626,212.768],[274.626,211.057]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":\
false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\
\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.1},\\\"joinForm\\\"\
:{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\
\\\":null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[0,0.\
9992],\\\"localRect\\\":{\\\"left\\\":0,\\\"top\\\":-1,\\\"bottom\\\":0,\\\"\
right\\\":1},\\\"transform\\\":[1,0,0,1,274.626,227.767],\\\"pos\\\":[23.0259,\
0]},\\\"boxdata\\\":\\\"StyleBox[FormBox[InterpretationBox[StyleBox[\
GraphicsBox[BoxStoreID -> \\\\\\\"112\\\\\\\", ImageSize -> {1, 1}, \
BaselinePosition -> Baseline, ImageSize -> {0., 0.}, BoxID -> \\\\\\\"{\\\\\\\
\\\\\\\\\"jsonData\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"{\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\"type\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Graphics\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\
\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"height\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\": 1.000000,\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"width\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\": \
1.000000,\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"offset\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\": [-66.000000, -5.000000],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\"UserCoords\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": [-1.041667, \
-0.000000, 1.041667, -2.083333],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\"AxesOrigin\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": [0.000000, 0.000000],\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\": [\\\\\\\\\\\\\\\\n{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"type\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Group\\\\\\\\\\\\\\\\\\\\\
\\\\\\\\\\\", \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"name\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Frame\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"metadata\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\": {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-1.04167, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"top\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": 1.04, \\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": 1.04167, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"bottom\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-1.04},\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\":[]}, \
\\\\\\\\\\\\\\\\n{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"type\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Group\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\", \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"name\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Axes\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"metadata\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"TBD\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\
\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\\\\\\\\\\\
\\\\\\\\\":[]}],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"PlotRange\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\": {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\": 0.000000, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"top\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\": -1.499200, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
1.000000, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"bottom\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-0.500800}\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"\
requestedImageSize\\\\\\\\\\\\\\\":[1,1]}\\\\\\\"], CacheGraphics -> False], \
Spacer[{0., 0.}], Selectable -> False], TraditionalForm], FontFamily -> \
\\\\\\\"Arial\\\\\\\", FontSize -> 10, FontWeight -> \\\\\\\"Plain\\\\\\\", \
FontSlant -> \\\\\\\"Plain\\\\\\\", FontTracking -> \\\\\\\"Plain\\\\\\\", \
FontColor -> GrayLevel[0.4], FontOpacity -> 1, Background -> \
None]\\\"},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\
\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[346.\
141,212.768],[346.141,211.057]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":\
false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\
\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.1},\\\"joinForm\\\"\
:{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\
\\\":null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[0,0.\
9992],\\\"localRect\\\":{\\\"left\\\":0,\\\"top\\\":-1,\\\"bottom\\\":0,\\\"\
right\\\":1},\\\"transform\\\":[1,0,0,1,346.141,227.767],\\\"pos\\\":[32.2362,\
0]},\\\"boxdata\\\":\\\"StyleBox[FormBox[InterpretationBox[StyleBox[\
GraphicsBox[BoxStoreID -> \\\\\\\"113\\\\\\\", ImageSize -> {1, 1}, \
BaselinePosition -> Baseline, ImageSize -> {0., 0.}, BoxID -> \\\\\\\"{\\\\\\\
\\\\\\\\\"jsonData\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"{\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\"type\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Graphics\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\
\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"height\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\": 1.000000,\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"width\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\": \
1.000000,\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"offset\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\": [-66.000000, -5.000000],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\"UserCoords\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": [-1.041667, \
-0.000000, 1.041667, -2.083333],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\"AxesOrigin\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": [0.000000, 0.000000],\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\": [\\\\\\\\\\\\\\\\n{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"type\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Group\\\\\\\\\\\\\\\\\\\\\
\\\\\\\\\\\", \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"name\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Frame\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"metadata\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\": {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-1.04167, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"top\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": 1.04, \\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": 1.04167, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"bottom\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-1.04},\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\":[]}, \
\\\\\\\\\\\\\\\\n{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"type\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Group\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\", \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"name\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Axes\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"metadata\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"TBD\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\
\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\\\\\\\\\\\
\\\\\\\\\":[]}],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"PlotRange\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\": {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\": 0.000000, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"top\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\": -1.499200, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
1.000000, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"bottom\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-0.500800}\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"\
requestedImageSize\\\\\\\\\\\\\\\":[1,1]}\\\\\\\"], CacheGraphics -> False], \
Spacer[{0., 0.}], Selectable -> False], TraditionalForm], FontFamily -> \
\\\\\\\"Arial\\\\\\\", FontSize -> 10, FontWeight -> \\\\\\\"Plain\\\\\\\", \
FontSlant -> \\\\\\\"Plain\\\\\\\", FontTracking -> \\\\\\\"Plain\\\\\\\", \
FontColor -> GrayLevel[0.4], FontOpacity -> 1, Background -> \
None]\\\"},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\
\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[417.\
656,212.768],[417.656,211.057]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":\
false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\
\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.1},\\\"joinForm\\\"\
:{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\
\\\":null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[0,0.\
9992],\\\"localRect\\\":{\\\"left\\\":0,\\\"top\\\":-1,\\\"bottom\\\":0,\\\"\
right\\\":1},\\\"transform\\\":[1,0,0,1,417.656,227.767],\\\"pos\\\":[41.4465,\
0]},\\\"boxdata\\\":\\\"StyleBox[FormBox[InterpretationBox[StyleBox[\
GraphicsBox[BoxStoreID -> \\\\\\\"114\\\\\\\", ImageSize -> {1, 1}, \
BaselinePosition -> Baseline, ImageSize -> {0., 0.}, BoxID -> \\\\\\\"{\\\\\\\
\\\\\\\\\"jsonData\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"{\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\"type\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Graphics\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\
\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"height\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\": 1.000000,\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"width\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\": \
1.000000,\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"offset\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\": [-66.000000, -5.000000],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\"UserCoords\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": [-1.041667, \
-0.000000, 1.041667, -2.083333],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\"AxesOrigin\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": [0.000000, 0.000000],\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\": [\\\\\\\\\\\\\\\\n{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"type\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Group\\\\\\\\\\\\\\\\\\\\\
\\\\\\\\\\\", \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"name\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Frame\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"metadata\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\": {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-1.04167, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"top\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": 1.04, \\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": 1.04167, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"bottom\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-1.04},\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\":[]}, \
\\\\\\\\\\\\\\\\n{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"type\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Group\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\", \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"name\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Axes\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\\\\\
\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"metadata\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\": \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"TBD\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\",\\\\\
\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"primitives\\\\\\\\\\\\\\\\\\\\\\\
\\\\\\\\\":[]}],\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"PlotRange\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\": {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\": 0.000000, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"top\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\": -1.499200, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
1.000000, \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"bottom\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\": \
-0.500800}\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"\
requestedImageSize\\\\\\\\\\\\\\\":[1,1]}\\\\\\\"], CacheGraphics -> False], \
Spacer[{0., 0.}], Selectable -> False], TraditionalForm], FontFamily -> \
\\\\\\\"Arial\\\\\\\", FontSize -> 10, FontWeight -> \\\\\\\"Plain\\\\\\\", \
FontSlant -> \\\\\\\"Plain\\\\\\\", FontTracking -> \\\\\\\"Plain\\\\\\\", \
FontColor -> GrayLevel[0.4], FontOpacity -> 1, Background -> \
None]\\\"},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\
\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[82.\
2889,212.768],[424.5,212.768]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":\
false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\
\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\"\
:{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\
\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\
\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[84,\
212.768],[88,212.768]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\
\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\
\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[84,205.\
073],[86.4,205.073]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\"\
edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\
\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[84,197.\
377],[86.4,197.377]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\"\
edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\
\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[84,189.\
682],[86.4,189.682]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\"\
edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\
\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[84,181.\
987],[86.4,181.987]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\"\
edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\
\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[84,174.\
291],[88,174.291]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\"\
edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[1,0.5],\\\"\
localRect\\\":{\\\"left\\\":0,\\\"top\\\":0,\\\"bottom\\\":11,\\\"right\\\":\
15},\\\"transform\\\":[1,0,0,1,66,168.791],\\\"pos\\\":[-1.52456,0.5]},\\\"\
boxdata\\\":\\\"\\\\nStyleBox[\\\\\\\"0.5\\\\\\\",\\\\n \
FontFamily->\\\\\\\"Arial\\\\\\\",\\\\n FontSize->10,\\\\n FontWeight->\\\\\\\
\"Plain\\\\\\\",\\\\n FontSlant->\\\\\\\"Plain\\\\\\\",\\\\n FontTracking->\\\
\\\\\"Plain\\\\\\\",\\\\n PrivateFontOptions->{\\\\\\\"OperatorSubstitution\\\
\\\\\"->True},\\\\n FontColor->GrayLevel[0.4],\\\\n FontOpacity->1,\\\\n \
Background->None]\\\"},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,166.596],[86.4,166.596]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\
\":false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"\
Butt\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,158.901],[86.4,158.901]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\
\":false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"\
Butt\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,151.205],[86.4,151.205]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\
\":false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"\
Butt\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,143.51],[86.4,143.51]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\"\
:false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\
\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\
\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"\
faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\
\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\"\
:[[84,135.815],[88,135.815]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":\
false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\
\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\"\
:{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\
\\\":null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[1,0.5],\
\\\"localRect\\\":{\\\"left\\\":0,\\\"top\\\":0,\\\"bottom\\\":11,\\\"right\\\
\":15},\\\"transform\\\":[1,0,0,1,66,130.315],\\\"pos\\\":[-1.52456,1]},\\\"\
boxdata\\\":\\\"\\\\nStyleBox[\\\\\\\"1.0\\\\\\\",\\\\n \
FontFamily->\\\\\\\"Arial\\\\\\\",\\\\n FontSize->10,\\\\n FontWeight->\\\\\\\
\"Plain\\\\\\\",\\\\n FontSlant->\\\\\\\"Plain\\\\\\\",\\\\n FontTracking->\\\
\\\\\"Plain\\\\\\\",\\\\n PrivateFontOptions->{\\\\\\\"OperatorSubstitution\\\
\\\\\"->True},\\\\n FontColor->GrayLevel[0.4],\\\\n FontOpacity->1,\\\\n \
Background->None]\\\"},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,128.119],[86.4,128.119]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\
\":false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"\
Butt\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,120.424],[86.4,120.424]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\
\":false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"\
Butt\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,112.729],[86.4,112.729]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\
\":false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"\
Butt\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,105.033],[86.4,105.033]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\
\":false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"\
Butt\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,97.3378],[88,97.3378]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\"\
:false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\
\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\
\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"\
faceform\\\":null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":\
[1,0.5],\\\"localRect\\\":{\\\"left\\\":0,\\\"top\\\":0,\\\"bottom\\\":11,\\\"\
right\\\":15},\\\"transform\\\":[1,0,0,1,66,91.8378],\\\"pos\\\":[-1.52456,1.\
5]},\\\"boxdata\\\":\\\"\\\\nStyleBox[\\\\\\\"1.5\\\\\\\",\\\\n \
FontFamily->\\\\\\\"Arial\\\\\\\",\\\\n FontSize->10,\\\\n FontWeight->\\\\\\\
\"Plain\\\\\\\",\\\\n FontSlant->\\\\\\\"Plain\\\\\\\",\\\\n FontTracking->\\\
\\\\\"Plain\\\\\\\",\\\\n PrivateFontOptions->{\\\\\\\"OperatorSubstitution\\\
\\\\\"->True},\\\\n FontColor->GrayLevel[0.4],\\\\n FontOpacity->1,\\\\n \
Background->None]\\\"},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,89.6425],[86.4,89.6425]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\
\":false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"\
Butt\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,81.9471],[86.4,81.9471]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\
\":false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"\
Butt\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,74.2518],[86.4,74.2518]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\
\":false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"\
Butt\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,66.5564],[86.4,66.5564]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\
\":false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"\
Butt\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,58.8611],[88,58.8611]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\"\
:false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\
\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\
\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"\
faceform\\\":null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":\
[1,0.5],\\\"localRect\\\":{\\\"left\\\":0,\\\"top\\\":0,\\\"bottom\\\":11,\\\"\
right\\\":15},\\\"transform\\\":[1,0,0,1,66,53.3611],\\\"pos\\\":[-1.52456,2]}\
,\\\"boxdata\\\":\\\"\\\\nStyleBox[\\\\\\\"2.0\\\\\\\",\\\\n FontFamily->\\\\\
\\\"Arial\\\\\\\",\\\\n FontSize->10,\\\\n FontWeight->\\\\\\\"Plain\\\\\\\",\
\\\\n FontSlant->\\\\\\\"Plain\\\\\\\",\\\\n \
FontTracking->\\\\\\\"Plain\\\\\\\",\\\\n \
PrivateFontOptions->{\\\\\\\"OperatorSubstitution\\\\\\\"->True},\\\\n \
FontColor->GrayLevel[0.4],\\\\n FontOpacity->1,\\\\n Background->None]\\\"},{\
\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\\\"\
path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[84,51.1657],[\
86.4,51.1657]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\"\
edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\
\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[84,43.\
4704],[86.4,43.4704]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\"\
edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\
\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[84,35.775]\
,[86.4,35.775]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\"\
edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\
\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[84,28.\
0797],[86.4,28.0797]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\"\
edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\":\\\"clip\\\",\
\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\\\":[[84,20.\
3843],[88,20.3843]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":false,\\\"\
edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\",\\\"\
opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\":{\\\"\
type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\\\":\
null},{\\\"type\\\":\\\"Inset\\\",\\\"metadata\\\":{\\\"opos\\\":[1,0.5],\\\"\
localRect\\\":{\\\"left\\\":0,\\\"top\\\":0,\\\"bottom\\\":11,\\\"right\\\":\
15},\\\"transform\\\":[1,0,0,1,66,14.8843],\\\"pos\\\":[-1.52456,2.5]},\\\"\
boxdata\\\":\\\"\\\\nStyleBox[\\\\\\\"2.5\\\\\\\",\\\\n \
FontFamily->\\\\\\\"Arial\\\\\\\",\\\\n FontSize->10,\\\\n FontWeight->\\\\\\\
\"Plain\\\\\\\",\\\\n FontSlant->\\\\\\\"Plain\\\\\\\",\\\\n FontTracking->\\\
\\\\\"Plain\\\\\\\",\\\\n PrivateFontOptions->{\\\\\\\"OperatorSubstitution\\\
\\\\\"->True},\\\\n FontColor->GrayLevel[0.4],\\\\n FontOpacity->1,\\\\n \
Background->None]\\\"},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,12.6889],[86.4,12.6889]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\
\":false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"\
Butt\\\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"\
joinForm\\\":{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\
\\\"faceform\\\":null},{\\\"transform\\\":[1.0,0.0,0.0,1.0,0.0,0.0],\\\"type\\\
\":\\\"clip\\\",\\\"path\\\":[[66,5],[66,230],[426,230],[426,5]]},{\\\"points\
\\\":[[84,216.998],[84,5.5]],\\\"type\\\":\\\"Line\\\",\\\"antialiased\\\":\
false,\\\"edgeForm\\\":{\\\"color\\\":[102,102,102],\\\"capForm\\\":\\\"Butt\\\
\",\\\"opacity\\\":1,\\\"thickness\\\":{\\\"absolute\\\":0.2},\\\"joinForm\\\"\
:{\\\"type\\\":\\\"Miter\\\",\\\"d\\\":3.25},\\\"dashing\\\":[]},\\\"faceform\
\\\":null}],\\\"metadata\\\":\\\"TBD\\\"}],\\\"AxesOrigin\\\":[-1.52456,0.0],\
\\\"height\\\":225.0,\\\"PlotRange\\\":{\\\"left\\\":16.2889,\\\"top\\\":-114.\
5,\\\"bottom\\\":96.9981,\\\"right\\\":358.5}}\",\"requestedImageSize\":null}",
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-1.5245631768066048`, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Exp[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Exp[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.8634694098727672, 41.44653167389282}, {0, 2.556}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], Automatic}, {{{0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {9.210340371976184, 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {18.420680743952367`, 
       FormBox[
        TemplateBox[{"10", "8"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {27.631021115928547`, 
       FormBox[
        TemplateBox[{"10", "12"}, "Superscript", SyntaxForm -> 
         SuperscriptBox], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {36.841361487904734`, 
       FormBox[
        TemplateBox[{"10", "16"}, "Superscript", SyntaxForm -> 
         SuperscriptBox], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
       0.}, {
        AbsoluteThickness[0.1]}}, {13.815510557964274`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
       0.}, {
        AbsoluteThickness[0.1]}}, {23.025850929940457`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
       0.}, {
        AbsoluteThickness[0.1]}}, {32.23619130191664, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
       0.}, {
        AbsoluteThickness[0.1]}}, {41.44653167389282, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
       0.}, {
        AbsoluteThickness[0.1]}}}, Automatic}]]], "Output",
 CellID->115,ExpressionUUID->"c2651b20-4e49-4bb1-9969-3b9e31e37c73"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{
    "alpha", " ", "is", " ", "a", " ", "tuning", " ", "factor", " ", "that", 
     " ", "balances", " ", "the", " ", "compuation", " ", "of", " ", "the", 
     " ", "easy", " ", "special", " ", "leaves", " ", "and", " ", "the", " ", 
     "hard", " ", "special", " ", 
     RowBox[{"leaves", ".", " ", "The"}], " ", "formula", " ", "below", " ", 
     "is", " ", "used", " ", "in", " ", "the", " ", "file", " ", 
     RowBox[{"src", "/", 
      RowBox[{"primecount", ".", "cpp"}]}], " ", "to", " ", "calculate", " ", 
     "a", " ", "fast", " ", "alpha", " ", "factor", " ", "for", " ", "the", 
     " ", "computation", " ", "of", " ", "pi", 
     RowBox[{
      RowBox[{"(", "x", ")"}], "."}]}], " ", "*)"}],
   FontColor->GrayLevel[0.5]]}]], "Input",
 CellChangeTimes->{{3.652359107254675*^9, 3.652359108209537*^9}, {
   3.652893880030965*^9, 3.652893884628096*^9}, 
   3.6528940589063597`*^9},ExpressionUUID->"395d2b11-0885-4260-8798-\
56cd1cf28627"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonlinearModelFit", "[", 
  RowBox[{"alphaLMO", ",", " ", 
   RowBox[{
    RowBox[{"a", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Log", "[", "x", "]"}], ")"}], "^", "2"}]}], " ", "+", " ", 
    RowBox[{"b", "  ", 
     RowBox[{"Log", "[", "x", "]"}]}], " ", "+", " ", "c"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", " ", "c"}], "}"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.634216277450708*^9, 3.63421631260785*^9}, {
   3.634216345523642*^9, 3.634216356164029*^9}, {3.6343148016652737`*^9, 
   3.6343148100460567`*^9}, 3.634322645710272*^9, {3.634323063590989*^9, 
   3.634323065777611*^9}, 3.634323459263245*^9, {3.634323494476931*^9, 
   3.634323495748851*^9}},ExpressionUUID->"4ac9bd14-2037-4ad0-a96d-\
768fc4d12dd4"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{"0.9909481657262897`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.026141119143409854`", " ", 
        RowBox[{"Log", "[", "x", "]"}]}], "+", 
       RowBox[{"0.0015651182060183828`", " ", 
        SuperscriptBox[
         RowBox[{"Log", "[", "x", "]"}], "2"]}]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Nonlinear", {
     a -> 0.0015651182060183828`, b -> -0.026141119143409854`, c -> 
      0.9909481657262897}, {{x}, c + b Log[x] + a Log[x]^2}}, {
    1}, {{1, 1}, {10000000000, 1.208}, {100000000000, 1.281}, {
     1000000000000, 1.364}, {10000000000000, 1.679}, {
     100000000000000, 1.89}, {1000000000000000, 2.011}, {
     10000000000000000, 2.113}, {100000000000000000, 2.359}, {
     1000000000000000000, 2.556}}, 
    Function[Null, 
     Internal`LocalizedBlock[{a, b, c, x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellID->118,ExpressionUUID->"87239b17-b0ff-4373-a479-d45c34b74720"]
}, Open  ]]
},
WindowSize->{1216, 756},
WindowMargins->{{59, Automatic}, {Automatic, 23}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (March 16, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 7071, 149, 138, "Input", "ExpressionUUID" -> \
"59b8fd83-44b9-4878-bb3f-7551643fd9cd"],
Cell[7654, 173, 2045, 56, 117, "Output", "ExpressionUUID" -> \
"e7c25df3-ae70-405e-965d-ab5c722ae35f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9736, 234, 894, 15, 32, "Input", "ExpressionUUID" -> \
"e9d1e34b-5900-401c-b4fc-eb3f0c6e8b6e"],
Cell[10633, 251, 6000, 146, 250, "Output", "ExpressionUUID" -> \
"ab9ff723-6dac-4fc5-adbc-696d2196bcbf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16670, 402, 1822, 39, 117, "Input", "ExpressionUUID" -> \
"338a445a-aae9-45e7-907e-7f25b0cf0cf4"],
Cell[18495, 443, 1993, 44, 54, "Output", "ExpressionUUID" -> \
"86550fda-9363-4a86-825c-f3438c19b4d5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20525, 492, 3151, 71, 96, "Input", "ExpressionUUID" -> \
"98e07a75-ba0c-4e32-ac60-ce3dcb649c89"],
Cell[23679, 565, 884, 24, 54, "Output", "ExpressionUUID" -> \
"366182ce-8fa5-4cb2-85e6-63c7740efff0",
 CellID->108]
}, Open  ]],
Cell[CellGroupData[{
Cell[24600, 594, 378, 8, 32, "Input", "ExpressionUUID" -> \
"381aa3c9-7179-4b58-b173-8ed7facd4779"],
Cell[24981, 604, 49321, 713, 244, "Output", "ExpressionUUID" -> \
"c2651b20-4e49-4bb1-9969-3b9e31e37c73",
 CellID->115]
}, Open  ]],
Cell[74317, 1320, 1048, 21, 75, "Input", "ExpressionUUID" -> \
"395d2b11-0885-4260-8798-56cd1cf28627"],
Cell[CellGroupData[{
Cell[75390, 1345, 793, 18, 32, "Input", "ExpressionUUID" -> \
"4ac9bd14-2037-4ad0-a96d-768fc4d12dd4"],
Cell[76186, 1365, 1142, 30, 44, "Output", "ExpressionUUID" -> \
"87239b17-b0ff-4373-a479-d45c34b74720",
 CellID->118]
}, Open  ]]
}
]
*)

