r"""
Small-Step Walks

The following connection problem came up in relation to work by Alin Bostan,
Frédéric Chyzak, Mark van Hoeij, Manuel Kauers and Lucien Pech on small-step
walks in the quarter plane. (A. Bostan and M. Kauers, Automatic Classification
of Restricted Lattice Walks, FPSAC'09; A. Bostan, F. Chyzak, M. van Hoeij,
M. Kauers and L. Pech, Hypergeometric expressions for generating functions of
walks with small steps in the quarter plane, arXiv:1606.02982 [math.CO], <URL:
http://specfun.inria.fr/chyzak/ssw/index.html>):

    sage: from ore_algebra import *
    sage: Pols.<t> = QQ[]
    sage: Dops.<Dt> = OreAlgebra(Pols)

    sage: dop = ((20643840*t^11-8650752*t^10+24975360*t^9+1711488*t^8+52224*t^7
    ....:      -978144*t^6-179040*t^5-52176*t^4-12552*t^3-4944*t^2-552*t-96)
    ....:    +(103219200*t^12-53280768*t^11+115279872*t^10-2172288*t^9
    ....:      -10069632*t^8-2219040*t^7-435456*t^6+269016*t^5-25992*t^4
    ....:      +17496*t^3+5496*t^2+648*t+96)*Dt
    ....:    +(103219200*t^13-63307776*t^12+99222528*t^11-4771776*t^10
    ....:      -27972480*t^9+4192752*t^8-1230384*t^7+880272*t^6-126672*t^5
    ....:      +52656*t^4-1620*t^3-600*t^2-96*t)*Dt^2
    ....:    +(34406400*t^14-24444928*t^13+25568256*t^12+606272*t^11
    ....:      -17373888*t^10+4926192*t^9-857568*t^8+477496*t^7-48240*t^6
    ....:      +13480*t^5-3036*t^4-1308*t^3+48*t^2)*Dt^3
    ....:    +(4300800*t^15-3473408*t^14+1988608*t^13+777472*t^12-3375296*t^11
    ....:      +1221168*t^10-155184*t^9+62906*t^8+8591*t^7-5998*t^6+113*t^5
    ....:      -396*t^4+84*t^3)*Dt^4
    ....:    +(172032*t^16-155648*t^15+20480*t^14+78016*t^13-188224*t^12
    ....:      +78144*t^11-6528*t^10+701*t^9+2131*t^8-1183*t^7+97*t^6-30*t^5
    ....:      +12*t^4)*Dt^5)
    sage: mat = dop.numerical_transition_matrix([0, 1/3+i/10, 1/3]) # long time (11.3 s)
    sage: (mat*vector([0, 0, 1, 3, 7]))[0] # long time
    [...] + [0.50000...]*I

An example provided by Bruno Salvy that originates in the same work::

    sage: dop = (
    ....:     ( 171286399549440000*t^20
    ....:     + 2638485953445888000*t^19
    ....:     + 19331169764297932800*t^18
    ....:     + 95547038245909954560*t^17
    ....:     + 305922196246028156928*t^16
    ....:     + 250620273081532809216*t^15
    ....:     - 2109325213532559730176*t^14
    ....:     - 7145884271499315095808*t^13
    ....:     - 3430293600467311627698*t^12
    ....:     + 20682911567733215854068*t^11
    ....:     + 47990562381910083377106*t^10
    ....:     + 78674260785883006097916*t^9
    ....:     + 156502192094889767842500*t^8
    ....:     + 231740151845288523481116*t^7
    ....:     + 201550717065636967782456*t^6
    ....:     + 109094259844540767186468*t^5
    ....:     + 46937243865521456982810*t^4
    ....:     + 11205839292077098881648*t^3
    ....:     - 601419249399863477178*t^2
    ....:     + 361456534097310660768*t
    ....:     - 11410096578718039740)
    ....: +   ( 2226723194142720000*t^21
    ....:     + 35748717973733376000*t^20
    ....:     + 272004146532974592000*t^19
    ....:     + 1385814067053110231040*t^18
    ....:     + 4750869512437585477632*t^17
    ....:     + 6491619741541967069184*t^16
    ....:     - 20930172847184317008384*t^15
    ....:     - 99865645807353716063232* t^14
    ....:     - 94203810665451596781882*t^13
    ....:     + 250496473567072068898632*t^12
    ....:     + 819756706073592525484554*t^11
    ....:     + 1244053067847876051182784*t^10
    ....:     + 1605471860922878957020740*t^9
    ....:     + 1858802515746125008520124*t^8
    ....:     + 1555098899837038744278384*t^7
    ....:     + 870965837475739000453332*t^6
    ....:     + 371928114059772941512650*t ^5
    ....:     + 111125056454683385893452*t^4
    ....:     + 12722529787944270840918*t^3
    ....:     + 5066358677363468512332*t^2
    ....:     + 454433524450107373980*t
    ....:     + 73842306926255686800)*Dt
    ....: +   ( 4881662387159040000*t^22
    ....:     + 80753049735266304000*t^21
    ....:     + 629405519148063129600*t^20
    ....:     + 3255761659317458042880*t^19
    ....:     + 11552806180152728469504*t^ 18
    ....:     + 19283253514830100021248*t^17
    ....:     - 33248338221487272438528*t^16
    ....:     - 217892506229074630571904*t^15
    ....:     - 271811139427074116734479*t^14
    ....:     + 450690310348484671418814*t^13
    ....:     + 1849575994108796733911568*t^12
    ....:     + 2851291232570334753432288*t^11
    ....:     + 3264271481752484577090075*t^10
    ....:     + 3417228683787005624529288* t^9
    ....:     + 2815825484330035867357848*t^8
    ....:     + 1620282647986272503444484*t^7
    ....:     + 713280447784092767136615*t^6
    ....:     + 231725308173375223947474*t^5
    ....:     + 34052911521663351312936*t^4
    ....:     + 9507737103734602795644*t^3
    ....:     - 2476374668076035988675*t^2
    ....:     - 849186529651940398200*t)*Dt^2
    ....: +   ( 3568466657280000000*t^23
    ....:     + 60607789352878080000*t^22
    ....:     + 481880675918807040000*t^21
    ....:     + 2518387330058645667840*t^20
    ....:     + 9135487122412799803392*t^19
    ....:     + 17195487476874947149824*t^18
    ....:     - 15742726783931920414464*t^17
    ....:     - 154414229634782039308032*t^16
    ....:     - 232860763488679684519257*t^15
    ....:     + 253989014873059993363452*t^14
    ....:     + 1320153225125680773206514*t^13
    ....:     + 2090065454667377615740554*t^12
    ....:     + 2261726431419225885336495*t^11
    ....:     + 2228988872540629548125064*t^10
    ....:     + 1801556701939225599554484*t^9
    ....:     + 1029322603680496535767752*t^8
    ....:     + 419184263491501550940405*t^7
    ....:     + 93410473794219576003672*t^6
    ....:     - 30381530117047380669222*t^5
    ....:     - 25721411491709226834498*t^4
    ....:     - 15248703228467129341515*t^3
    ....:     - 4072403226983001127020*t^2)*Dt^3
    ....: +   ( 1106224663756800000*t^24
    ....:     + 19256387536158720000*t^23
    ....:     + 155854909499965440000*t^22
    ....:     + 820768926988031754240*t^21
    ....:     + 3020814626208274778112*t^20
    ....:     + 6164339216610525179904*t^19
    ....:     - 2449275739278857645184*t^18
    ....:     - 45832064756814927087552*t^17
    ....:     - 80318434574942982693432*t^16
    ....:     + 56165563325296843771032*t^15
    ....:     + 391193059247216199680904*t^14
    ....:     + 640022510382155408250144*t^13
    ....:     + 670214676801655249559280*t^12
    ....:     + 619661933236562324459904*t^11
    ....:     + 459901226012972655621744*t^10
    ....:     + 222539574832726591922832*t^9
    ....:     + 48716923385181953894760*t^8
    ....:     - 36328880339408087086968*t^7
    ....:     - 56461452018421838909112*t^6
    ....:     - 32807014115021290700208*t^5
    ....:     - 13424480013754209443040*t^4
    ....:     - 3475511245995767658720*t^3)*Dt^4
    ....: +   ( 158439919583232000*t^25
    ....:     + 2823482633512550400*t^24
    ....:     + 23232099174477987840*t^23
    ....:     + 123066073706197155840*t^22
    ....:     + 456994176870853896192*t^21
    ....:     + 986294464354070581248*t^20
    ....:     - 40851351958749464448*t^19
    ....:     - 6257517734649635487360*t^18
    ....:     - 12453050537819654635080*t^17
    ....:     + 4973247815417675742096*t^16
    ....:     + 52940756439371347553808*t^15
    ....:     + 90134498420892294542640*t^14
    ....:     + 92840779759664202045048*t^13
    ....:     + 78982085750700931593984*t^12
    ....:     + 46048936082557508210016*t^11
    ....:     + 7342300324280009410272*t^10
    ....:     - 14197463182376967351960*t^9
    ....:     - 21899606469934233857328*t^8
    ....:     - 19992291410589627258864*t^7
    ....:     - 10726942654794782574864*t^6
    ....:     - 3902885744775768223128*t^5
    ....:     - 1002286246012377188832*t^4)*Dt^5
    ....: +   ( 10229604417536000*t^26
    ....:     + 186465670450380800*t^25
    ....:     + 1558247276799590400*t^24
    ....:     + 8291985290526720000*t^23
    ....:     + 30926861387906079744*t^22
    ....:     + 69352122316429357056*t^21
    ....:     + 14433073350071466240*t^20
    ....:     - 386261218806867357696*t^19
    ....:     - 858449497858188502320*t^18
    ....:     + 130797285809167964736*t^17
    ....:     + 3204661566080663640288*t^16
    ....:     + 5731598104156998387072*t^15
    ....:     + 5913428713345357471440*t^14
    ....:     + 4528670768491283936640*t^13
    ....:     + 1299386979692729270208*t^12
    ....:     - 1886679250327506243456*t^11
    ....:     - 2957766894527887422864*t^10
    ....:     - 3000496027940943666624*t^9
    ....:     - 2420888498530584285600*t^8
    ....:     - 1253326746737469420288*t^7
    ....:     - 430086384539334981648*t^6
    ....:     - 110271178343208492288*t^5)*Dt^6
    ....: +   ( 237897777152000*t^27
    ....:     + 4432499782451200*t^26
    ....:     + 37590867534151680*t^25
    ....:     + 200731571750830080*t^24
    ....:     + 749073871711429632*t^23
    ....:     + 1721213540464951296*t^22
    ....:     + 653298204354250752 *t^21
    ....:     - 8678888448500772864*t^20
    ....:     - 21218173039262960784*t^19
    ....:     - 1318058326269457920*t^18
    ....:     + 69416022010979773728*t^17
    ....:     + 132117007259649386016*t^16
    ....:     + 139651813549919190384*t^15
    ....:     + 95121191333814111360*t^14
    ....:     - 16866880701113776320*t^13
    ....:     - 117120864788249018112*t^12
    ....:     - 132153632111141165232*t^11
    ....:     - 118665540330140802240*t^10
    ....:     - 91264771850857236576*t^9
    ....:     - 46315245385604508192*t^8
    ....:     - 15345679965249398832*t^7
    ....:     - 3938256369400303296*t^6)*Dt^7
    ....: )
    sage: ini = [ 59/36, 547/2160, 1/2*229/252, 1/6*-20249/68040,
    ....:         1/24*1412134/280665, 1/120*1787365/2918916,
    ....:         1/720*194607493/2189187 ]
    sage: dop.numerical_solution(ini, [0,1]) # long time (6.2 s), TODO: double-check result
    [10.662510694...]
"""
