package jnormaliz;

import org.apache.commons.exec.ProcessDestroyer;


/**
 * Simple process destroyer to allow interruption of computation
 */
public class NormalizProcessDestroyer implements ProcessDestroyer {

    private Process process;

    public boolean add(final Process process) {
        if (this.process != null) {
            throw new RuntimeException("Only one process allowed");
        }
        this.process = process;
        return true;
    }

    public boolean remove(final Process process) {
        if (this.process == process) {
            this.process = null;
            return true;
        } else {
            return false;
        }
    }

    public int size() {
        return process != null ? 1 : 0;
    }

    public boolean stop() {
        try {
            process.destroy();
            return true;
        } catch (Exception ex) {
            return false;
        }
    }
}
