package jnormaliz;

import javax.swing.JOptionPane;
import org.jdesktop.application.SingleFrameApplication;

/**
 * The Application class of the jNormaliz
 */
public class JNormalizApplication extends SingleFrameApplication  {

    /**
     * At startup create and show the main frame of the application.
     * Also make initializations needed
     */
    @Override protected void startup() {

        // Creates main interface view
        MainView jNormalizView = new MainView(this);

        // Adds exit listener to catch attempts to close the application
        addExitListener(jNormalizView);

        show(jNormalizView);

        // Warns if Normaliz executables were not found
        if(!NormalizWorker.findNormalizExecutables())
            JOptionPane.showMessageDialog(jNormalizView.getFrame(),
                    "One (or more) Normaliz executable was not found.\n"+
                    "The executables should be in the same folder as jNormaliz", "Attention",
                    JOptionPane.WARNING_MESSAGE);
    }

    /**
     * This method is to initialize the specified window by injecting resources.
     * Windows shown in our application come fully initialized from the GUI
     * builder, so this additional configuration is not needed.
     */
    @Override protected void configureWindow(java.awt.Window root) {
    }

    /**
     * A convenient static getter for the application instance.
     * @return the instance of JNormalizApplication
     */
    public static JNormalizApplication getApplication() {
        return JNormalizApplication.getInstance(JNormalizApplication.class);
    }

    /**
     * Main method launching the application.
     */
    public static void main(String[] args)  {
        launch(JNormalizApplication.class, args);
    }
}
