/*
 * Decompiled with CFR 0.152.
 */
package jnormaliz;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.swing.SwingWorker;
import jnormaliz.JNormalizApplication;
import jnormaliz.MainView;
import jnormaliz.NormalizConfig;
import jnormaliz.NormalizProcessDestroyer;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizWorker
extends SwingWorker<Boolean, String> {
    private boolean executionOk = false;
    private boolean interrupted = false;
    private final NormalizConfig normalizConfig;
    private final MainView view;
    private final NormalizProcessDestroyer processDestroyer = new NormalizProcessDestroyer();
    private static File executable;
    private static final SimpleDateFormat dateFormat;

    public static boolean findNormalizExecutables() {
        String exec64 = "./normaliz";
        String extension = System.getProperty("os.name").startsWith("Windows") ? ".exe" : "";
        executable = new File("./normaliz" + extension);
        return executable.canExecute();
    }

    public NormalizWorker(NormalizConfig normalizConfig) {
        this.normalizConfig = normalizConfig;
        this.view = (MainView)JNormalizApplication.getApplication().getMainView();
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        String consoleText;
        CommandLine commandLine = new CommandLine(executable);
        if (!executable.canExecute()) {
            commandLine = new CommandLine("normaliz");
        }
        switch (this.normalizConfig.precision) {
            case PRECISION64: {
                break;
            }
            case PRECISIONBIG: {
                commandLine.addArgument("-B");
                break;
            }
            default: {
                throw new RuntimeException("Unknown precision");
            }
        }
        commandLine.addArgument("-c");
        switch (this.normalizConfig.computationType) {
            case DEFAULT: {
                break;
            }
            case SUPPORT_HYPERPLANES: {
                commandLine.addArgument("-s");
                break;
            }
            case TRIANGULATION: {
                commandLine.addArgument("-t");
                break;
            }
            case VOLUME: {
                commandLine.addArgument("-v");
                break;
            }
            case VOLUME_DEGREE_1_ELEMENTS: {
                commandLine.addArgument("-v1");
                break;
            }
            case HILBERT_BASIS_VOLUME: {
                commandLine.addArgument("-n");
                break;
            }
            case HILBERT_BASIS: {
                commandLine.addArgument("-N");
                break;
            }
            case DEGREE_1_ELEMENTS: {
                commandLine.addArgument("-1");
                break;
            }
            case HILBERT_SERIES: {
                commandLine.addArgument("-q");
                break;
            }
            case HILBERT_SERIES_DEGREE_1_ELEMENTS: {
                commandLine.addArgument("-p");
                break;
            }
            case HILBERT_BASIS_SERIES: {
                commandLine.addArgument("-h");
                break;
            }
            default: {
                throw new RuntimeException("Unknown computation type");
            }
        }
        switch (this.normalizConfig.algorithm) {
            case PRIMAL: {
                break;
            }
            case DUAL: {
                commandLine.addArgument("-d");
                break;
            }
            case APPROXIMATION: {
                commandLine.addArgument("-r");
                break;
            }
            default: {
                throw new RuntimeException("Unknown algorithm");
            }
        }
        switch (this.normalizConfig.outputFiles) {
            case SOME: {
                commandLine.addArgument("-f");
                break;
            }
            case ALL: {
                commandLine.addArgument("-a");
                break;
            }
            case ONLY_OUT: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown output files");
            }
        }
        switch (this.normalizConfig.nmzIntegrateOptions) {
            case EHRHART: {
                commandLine.addArgument("-E");
                break;
            }
            case LEADING: {
                commandLine.addArgument("-L");
                break;
            }
            case LEBESQUE: {
                commandLine.addArgument("-I");
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown output files");
            }
        }
        if (this.normalizConfig.testArithmeticOverflow) {
            commandLine.addArgument("-e");
        }
        if (this.normalizConfig.writeTriangulationFile) {
            commandLine.addArgument("-T");
        }
        if (this.normalizConfig.writeStanleyDecompositionFile) {
            commandLine.addArgument("-y");
        }
        if (this.normalizConfig.controlParalellization) {
            commandLine.addArgument("-x=" + this.normalizConfig.numberParallelThreads);
        }
        commandLine.addArgument(this.normalizConfig.getInFileWithoutExt());
        DefaultExecutor executor = new DefaultExecutor();
        executor.setProcessDestroyer((ProcessDestroyer)this.processDestroyer);
        ExecuteResultHandler executeResultHandler = new ExecuteResultHandler(){

            public void onProcessComplete(int exitValue) {
                NormalizWorker.this.executionOk = true;
            }

            public void onProcessFailed(ExecuteException e) {
                NormalizWorker.this.executionOk = false;
            }
        };
        PipedInputStream inputStream = new PipedInputStream();
        PipedOutputStream outputStream = new PipedOutputStream(inputStream);
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        this.publish("\n=====<<<<< " + dateFormat.format(Calendar.getInstance().getTime()) + " >>>>>=====\n");
        this.publish(commandLine.toString() + "\n");
        executor.execute(commandLine, executeResultHandler);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        do {
            if ((consoleText = bufferedReader.readLine()) == null) continue;
            this.publish(consoleText + "\n");
        } while (consoleText != null);
        return this.executionOk;
    }

    @Override
    protected void process(List<String> chunks) {
        for (String s : chunks) {
            this.view.updateConsole(s);
        }
    }

    @Override
    protected void done() {
        if (!this.interrupted) {
            this.view.jobFinished(this.executionOk);
        }
    }

    public void stop() {
        this.interrupted = true;
        this.processDestroyer.stop();
    }

    static {
        dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    }
}

