/*
 * Decompiled with CFR 0.152.
 */
package jnormaliz;

import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import jnormaliz.JNormalizApplication;
import jnormaliz.MainView;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class NewFileDialog
extends JDialog {
    private final JFileChooser fileChooser;
    private final MainView mainView;
    private File selectedFile = null;
    private JFormattedTextField columnsFormattedTextField;
    private JTextField fileTextField;
    private JTextArea folderTextArea;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JComboBox modeComboBox;
    private JFormattedTextField rowsFormattedTextField;

    public NewFileDialog(MainView parent, boolean modal) {
        super((Frame)parent.getFrame(), modal);
        this.initComponents();
        this.setIconImage(Application.getInstance(Application.class).getContext().getResourceMap(NewFileDialog.class).getImageIcon("Application.icon").getImage());
        this.mainView = parent;
        this.fileChooser = new JFileChooser((File)null);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setFileFilter(MainView.inputFileFilter);
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.fileChooser.setApproveButtonText("Select");
        this.fileChooser.setDialogTitle("New input file");
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.fileTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.modeComboBox = new JComboBox();
        this.jLabel5 = new JLabel();
        this.rowsFormattedTextField = new JFormattedTextField();
        this.columnsFormattedTextField = new JFormattedTextField();
        this.jScrollPane1 = new JScrollPane();
        this.folderTextArea = new JTextArea();
        ResourceMap resourceMap = Application.getInstance(JNormalizApplication.class).getContext().getResourceMap(NewFileDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setIconImage(null);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setName("Form");
        ApplicationActionMap actionMap = Application.getInstance(JNormalizApplication.class).getContext().getActionMap(NewFileDialog.class, this);
        this.jButton1.setAction(actionMap.get("chooseFolderAction"));
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setDefaultCapable(false);
        this.jButton1.setFocusCycleRoot(true);
        this.jButton1.setName("jButton1");
        this.jButton2.setAction(actionMap.get("okAction"));
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setName("jButton2");
        this.jButton3.setAction(actionMap.get("cancelAction"));
        this.jButton3.setText(resourceMap.getString("jButton3.text", new Object[0]));
        this.jButton3.setDefaultCapable(false);
        this.jButton3.setName("jButton3");
        this.fileTextField.setEditable(false);
        this.fileTextField.setText(resourceMap.getString("fileTextField.text", new Object[0]));
        this.fileTextField.setName("fileTextField");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.modeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Integral closure", "Normalization", "Polytope", "Rees algebra", "Hyperplanes", "Equations", "Congruences", "Lattice ideal"}));
        this.modeComboBox.setName("modeComboBox");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.rowsFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.rowsFormattedTextField.setText(resourceMap.getString("rowsFormattedTextField.text", new Object[0]));
        this.rowsFormattedTextField.setName("rowsFormattedTextField");
        this.columnsFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.columnsFormattedTextField.setText(resourceMap.getString("columnsFormattedTextField.text", new Object[0]));
        this.columnsFormattedTextField.setName("columnsFormattedTextField");
        this.jScrollPane1.setName("jScrollPane1");
        this.folderTextArea.setBackground(this.getBackground());
        this.folderTextArea.setColumns(20);
        this.folderTextArea.setEditable(false);
        this.folderTextArea.setFont(this.getFont());
        this.folderTextArea.setRows(1);
        this.folderTextArea.setName("folderTextArea");
        this.jScrollPane1.setViewportView(this.folderTextArea);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 457, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.columnsFormattedTextField, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING).addComponent(this.rowsFormattedTextField, GroupLayout.Alignment.LEADING, -1, 97, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modeComboBox, -2, 167, -2).addComponent(this.jLabel5))).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING).addComponent(this.fileTextField, -1, 370, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jButton2, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3, -2, 78, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileTextField, -2, -1, -2).addComponent(this.jButton1)).addGap(11, 11, 11).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modeComboBox, -2, -1, -2).addComponent(this.rowsFormattedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnsFormattedTextField, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton3)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    void showDialog(File lastDirectoryUsed) {
        this.selectedFile = new File(lastDirectoryUsed, "untitled.in");
        this.fileTextField.setText(this.selectedFile.getName());
        this.folderTextArea.setText(this.selectedFile.getParent());
        this.rowsFormattedTextField.setText("");
        this.columnsFormattedTextField.setText("");
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Action
    public void chooseFolderAction() {
        this.fileChooser.setSelectedFile(this.selectedFile);
        int result = this.fileChooser.showOpenDialog(this);
        if (result == 0) {
            File chosenFile = this.fileChooser.getSelectedFile();
            if (!chosenFile.getName().endsWith(".in")) {
                JOptionPane.showMessageDialog(this, "Input files should have .in extension", "Error", 0);
                return;
            }
            this.selectedFile = chosenFile;
            this.fileTextField.setText(this.selectedFile.getName());
            this.folderTextArea.setText(this.selectedFile.getParent());
        }
    }

    @Action
    public void okAction() {
        int result;
        int rows = Integer.parseInt(this.rowsFormattedTextField.getText());
        if (rows < 1) {
            JOptionPane.showMessageDialog(this, "'Rows' should be a positive integer", "Error", 0);
            return;
        }
        int columns = Integer.parseInt(this.columnsFormattedTextField.getText());
        if (columns < 1) {
            JOptionPane.showMessageDialog(this, "'Columns' should be a positive integer", "Error", 0);
            return;
        }
        if (this.selectedFile.exists() && (result = JOptionPane.showConfirmDialog(this, "File exists. Overwrite it?", "Attention", 2)) != 0) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(this.selectedFile);
            printWriter.println(rows);
            printWriter.println(columns);
            for (int i = 0; i < rows; ++i) {
                boolean firstColumn = true;
                for (int j = 0; j < columns; ++j) {
                    if (firstColumn) {
                        printWriter.print("0");
                        firstColumn = false;
                        continue;
                    }
                    printWriter.print(" 0");
                }
                printWriter.print("\r");
            }
            switch (this.modeComboBox.getSelectedIndex()) {
                case 0: {
                    printWriter.println("integral_closure\r");
                    break;
                }
                case 1: {
                    printWriter.println("normalization\r");
                    break;
                }
                case 2: {
                    printWriter.println("polytope\r");
                    break;
                }
                case 3: {
                    printWriter.println("rees_algebra\r");
                    break;
                }
                case 4: {
                    printWriter.println("hyperplanes\r");
                    break;
                }
                case 5: {
                    printWriter.println("equations\r");
                    break;
                }
                case 6: {
                    printWriter.println("congruences\r");
                    break;
                }
                case 7: {
                    printWriter.println("lattice_ideal\r");
                }
            }
            printWriter.close();
            if (this.mainView.loadInputFile(this.selectedFile)) {
                this.mainView.setInputFile(null);
                this.mainView.setInputFile(this.selectedFile);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Unable to create file:\n" + ex.getMessage(), "Error", 0);
            Logger.getLogger(NewFileDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setVisible(false);
    }

    @Action
    public void cancelAction() {
        this.setVisible(false);
    }
}

