/*
 * Decompiled with CFR 0.152.
 */
package jnormaliz;

import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.MemoryStats;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DefaultEditorKit;
import javax.swing.undo.UndoManager;
import jnormaliz.AboutBoxDialog;
import jnormaliz.ElapsedTime;
import jnormaliz.FileUtils;
import jnormaliz.HelpAlgorithmsDialog;
import jnormaliz.JNormalizApplication;
import jnormaliz.NewFileDialog;
import jnormaliz.NormalizConfig;
import jnormaliz.NormalizWorker;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class MainView
extends FrameView
implements UndoableEditListener,
ChangeListener,
DocumentListener,
Application.ExitListener,
ActionListener {
    private File outputFile = null;
    private final NewFileDialog newFileDialog = new NewFileDialog(this, true);
    private NormalizWorker normalizWorker = null;
    static final FileNameExtensionFilter inputFileFilter = new FileNameExtensionFilter("Normaliz input files (*.in)", "in");
    private final UndoManager undoManager = new UndoManager();
    private final Timer timer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            MainView.this.elapsedTimeLabel.setText("Elapsed time: " + MainView.this.elapsedTime.getElapsedTime());
            MainView.this.updateMemory();
        }
    });
    final Timer memoryTimer = new Timer(10000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            MainView.this.updateMemory();
        }
    });
    private final ElapsedTime elapsedTime = new ElapsedTime();
    private final JavaSysMon javaSysMon;
    private File inputFile;
    private final JFileChooser fileChooser = new JFileChooser();
    private final HelpAlgorithmsDialog normalizAlgorithms = new HelpAlgorithmsDialog(this.getFrame());
    private boolean inputFileChangeSinceLastRun = true;
    private File outputFileWhenNormalizWasRun = null;
    private final Desktop desktop;
    private boolean fileChanged = false;
    private boolean fileLoaded = false;
    private boolean textualTabSelected = false;
    private boolean running = false;
    private boolean undo = false;
    private JRadioButton NmzIntegrateDefaultRadioButton;
    private JRadioButton NmzIntegrateEhrhartRadioButton;
    private JRadioButton NmzIntegrateLeadingRadioButton;
    private JRadioButton NmzIntegrateLebesqueRadioButton;
    private ButtonGroup NmzIntegrateOptionsButtonGroup;
    private JPanel NmzIntegrateOptionsPanel;
    private JComboBox algorithmComboBox;
    private JMenuItem closeMenuItem;
    private JComboBox computationTypeComboBox;
    private JPanel consoleTab;
    private JTextArea consoleTextArea;
    private JCheckBox controlParalellizationCheckBox;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JLabel elapsedTimeLabel;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JTextArea inputDataTextArea;
    private JButton inputFilePathButton;
    private JSpinner inputFontSizeSpinner;
    private JSpinner inputNumberParallelThreads;
    private JPanel inputTab;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPopupMenu.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JToolBar jToolBar1;
    private Label label1;
    private Label label2;
    private JPanel mainPanel;
    private JProgressBar memoryProgressBar;
    private JMenuBar menuBar;
    private JMenuItem newMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem openWebMenuItem;
    private JRadioButton outputAllRadioButton;
    private JRadioButton outputDefaultRadioButton;
    private JRadioButton outputIntermediateRadioButton;
    private ButtonGroup outputOptionsButtonGroup;
    private JPanel outputOptionsPanel;
    private JPanel outputTab;
    private JMenuItem pasteMenuItem;
    private JLabel physicalMemoryTitleLabel;
    private JComboBox precisionComboBox;
    private JMenuItem printMenuItem;
    private JTextArea resultTextArea;
    private JScrollPane resultsScrollPane;
    private JButton runButton;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JLabel statusAnimationLabel;
    private JPanel statusPanel;
    private JButton stopButton;
    private JLabel syncWarningLabel;
    private JTabbedPane tabbedPane;
    private JCheckBox testArithOverflowCheckBox;
    private JMenuItem undoMenuItem;
    private JCheckBox writeStanleyDecompositionFileCheckBox;
    private JCheckBox writeTriangulationFileCheckBox;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
        if (inputFile != null) {
            this.outputFile = new File(FileUtils.makeOutFileName(this.getInputFile().getAbsolutePath()));
            this.setFileLoaded(true);
            this.resultTextArea.setText("");
            this.tabbedPane.setTitleAt(0, inputFile.getName());
            this.tabbedPane.setTitleAt(1, this.outputFile.getName());
            this.inputFilePathButton.setText("<html><a href=''>" + inputFile.getParentFile().getAbsolutePath() + "</a></html>");
        } else {
            this.setFileLoaded(false);
            this.outputFile = null;
            this.inputFilePathButton.setText("");
        }
        this.undoManager.discardAllEdits();
        this.updateUndoState();
        this.updateFrameTitle();
    }

    public boolean isFileChanged() {
        return this.fileChanged;
    }

    private void updateFrameTitle() {
        String newTitle = this.getResourceMap().getString("Application.title", new Object[0]);
        if (this.getInputFile() != null) {
            newTitle = newTitle + " - " + this.getInputFile().getName();
            if (this.fileChanged) {
                newTitle = newTitle + "*";
            }
        }
        this.getFrame().setTitle(newTitle);
    }

    private void updateUndoState() {
        this.setUndo(this.undoManager.canUndo());
    }

    private void stopTimer() {
        this.timer.stop();
        this.elapsedTimeLabel.setText("Elapsed time: " + this.elapsedTime.getElapsedTime());
    }

    public void jobFinished(boolean result) {
        this.stopTimer();
        this.setRunning(false);
        this.normalizWorker = null;
        if (!result) {
            JOptionPane.showMessageDialog(null, "Normaliz execution finished abnormally. Output results were NOT updated.\nSee console for more information", "ERROR", 0);
        } else {
            try {
                if (this.outputFileWhenNormalizWasRun == this.outputFile) {
                    this.resultTextArea.read(new FileReader(this.outputFile), null);
                    this.tabbedPane.setSelectedComponent(this.outputTab);
                }
                if (!this.inputFileChangeSinceLastRun) {
                    this.syncWarningLabel.setText("");
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.getFrame(), "Could not read output file:\n" + e.getMessage(), "Error", 2);
            }
        }
    }

    public void updateConsole(String text) {
        this.consoleTextArea.append(text);
    }

    public void updateMemory() {
        if (this.javaSysMon != null) {
            long totalMemory = this.javaSysMon.physical().getTotalBytes() / 0x100000L;
            long freeMemory = this.javaSysMon.physical().getFreeBytes() / 0x100000L;
            String displayedTotalMemory = totalMemory >= 1024L ? String.format("%.1fG", (double)totalMemory / 1024.0) : String.format("%dM", totalMemory);
            String displayedFreeMemory = freeMemory >= 1024L ? String.format("%.1fG", (double)freeMemory / 1024.0) : String.format("%dM", freeMemory);
            this.memoryProgressBar.setMinimum(0);
            this.memoryProgressBar.setMaximum((int)totalMemory);
            this.memoryProgressBar.setValue((int)freeMemory);
            this.memoryProgressBar.setString(displayedFreeMemory + " / " + displayedTotalMemory);
            this.memoryProgressBar.setToolTipText("Free " + displayedFreeMemory + " / Total " + displayedTotalMemory);
        }
    }

    public MainView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        this.desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        this.fileChooser.setFileFilter(inputFileFilter);
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        JavaSysMon jsm = new JavaSysMon();
        if (jsm.osName() == null) {
            this.javaSysMon = null;
        } else {
            this.javaSysMon = jsm;
            this.memoryTimer.start();
            this.updateMemory();
            MemoryStats memoryStats = jsm.physical();
            if (memoryStats.getFreeBytes() == memoryStats.getTotalBytes()) {
                Logger.getLogger(MainView.class.getName()).log(Level.WARNING, "Total memory == free memory, probably due to incorrect java runtime architecture");
            }
        }
        ResourceMap resourceMap = this.getResourceMap();
        this.getFrame().setIconImage(resourceMap.getImageIcon("Application.icon").getImage());
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainView.this.busyIconIndex = (MainView.this.busyIconIndex + 1) % MainView.this.busyIcons.length;
                MainView.this.statusAnimationLabel.setIcon(MainView.this.busyIcons[MainView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (MainView.this.tabbedPane.getSelectedComponent() == MainView.this.inputTab || MainView.this.tabbedPane.getSelectedComponent() == MainView.this.outputTab || MainView.this.tabbedPane.getSelectedComponent() == MainView.this.consoleTab) {
                    MainView.this.setTextualTabSelected(true);
                } else {
                    MainView.this.setTextualTabSelected(false);
                }
            }
        });
        this.setInputFile(null);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = JNormalizApplication.getApplication().getMainFrame();
            this.aboutBox = new AboutBoxDialog(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        this.aboutBox.setVisible(true);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.inputTab = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.inputDataTextArea = new JTextArea();
        this.inputFilePathButton = new JButton();
        this.outputTab = new JPanel();
        this.resultsScrollPane = new JScrollPane();
        this.resultTextArea = new JTextArea();
        this.syncWarningLabel = new JLabel();
        this.consoleTab = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.consoleTextArea = new JTextArea();
        this.jButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.testArithOverflowCheckBox = new JCheckBox();
        this.outputOptionsPanel = new JPanel();
        this.outputIntermediateRadioButton = new JRadioButton();
        this.outputAllRadioButton = new JRadioButton();
        this.outputDefaultRadioButton = new JRadioButton();
        this.writeTriangulationFileCheckBox = new JCheckBox();
        this.writeStanleyDecompositionFileCheckBox = new JCheckBox();
        this.inputFontSizeSpinner = new JSpinner();
        this.jLabel4 = new JLabel();
        this.label1 = new Label();
        this.controlParalellizationCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.inputNumberParallelThreads = new JSpinner();
        this.jLabel5 = new JLabel();
        this.NmzIntegrateOptionsPanel = new JPanel();
        this.NmzIntegrateEhrhartRadioButton = new JRadioButton();
        this.NmzIntegrateLeadingRadioButton = new JRadioButton();
        this.NmzIntegrateDefaultRadioButton = new JRadioButton();
        this.NmzIntegrateLebesqueRadioButton = new JRadioButton();
        this.label2 = new Label();
        this.statusPanel = new JPanel();
        this.elapsedTimeLabel = new JLabel();
        this.physicalMemoryTitleLabel = new JLabel();
        this.memoryProgressBar = new JProgressBar();
        this.statusAnimationLabel = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.runButton = new JButton();
        this.stopButton = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.computationTypeComboBox = new JComboBox();
        this.precisionComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.algorithmComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.newMenuItem = new JMenuItem();
        this.closeMenuItem = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.printMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.copyMenuItem = new JMenuItem();
        this.cutMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.openWebMenuItem = new JMenuItem();
        this.jMenuItem9 = new JMenuItem();
        this.jMenuItem8 = new JMenuItem();
        this.outputOptionsButtonGroup = new ButtonGroup();
        this.NmzIntegrateOptionsButtonGroup = new ButtonGroup();
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setLayout(new GridBagLayout());
        this.tabbedPane.setCursor(new Cursor(0));
        this.tabbedPane.setName("tabbedPane");
        this.inputTab.setName("inputTab");
        this.jScrollPane2.setName("jScrollPane2");
        this.inputDataTextArea.setColumns(20);
        this.inputDataTextArea.setEditable(!this.isRunning());
        this.inputDataTextArea.setFont(new Font("Courier New 12 Simplu 12 Simplu", 0, 12));
        this.inputDataTextArea.setRows(5);
        this.inputDataTextArea.setName("inputDataTextArea");
        this.jScrollPane2.setViewportView(this.inputDataTextArea);
        ApplicationActionMap actionMap = Application.getInstance(JNormalizApplication.class).getContext().getActionMap(MainView.class, this);
        this.inputFilePathButton.setAction(actionMap.get("openDirectoryAction"));
        this.inputFilePathButton.setBorderPainted(false);
        this.inputFilePathButton.setContentAreaFilled(false);
        this.inputFilePathButton.setHideActionText(true);
        this.inputFilePathButton.setHorizontalAlignment(2);
        this.inputFilePathButton.setName("inputFilePathButton");
        GroupLayout inputTabLayout = new GroupLayout(this.inputTab);
        this.inputTab.setLayout(inputTabLayout);
        inputTabLayout.setHorizontalGroup(inputTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, inputTabLayout.createSequentialGroup().addContainerGap().addGroup(inputTabLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.inputFilePathButton, GroupLayout.Alignment.LEADING, -1, 662, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 662, Short.MAX_VALUE)).addContainerGap()));
        inputTabLayout.setVerticalGroup(inputTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, inputTabLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 381, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputFilePathButton).addContainerGap()));
        this.tabbedPane.addTab("Input data", this.inputTab);
        this.outputTab.setName("outputTab");
        this.resultsScrollPane.setName("resultsScrollPane");
        this.resultTextArea.setColumns(20);
        this.resultTextArea.setEditable(false);
        this.resultTextArea.setFont(new Font("Courier New 12 Simplu 12 Simplu", 0, 12));
        this.resultTextArea.setRows(5);
        this.resultTextArea.setName("resultTextArea");
        this.resultsScrollPane.setViewportView(this.resultTextArea);
        this.syncWarningLabel.setForeground(Color.red);
        this.syncWarningLabel.setText("SYNC WARNING");
        this.syncWarningLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.syncWarningLabel.setName("syncWarningLabel");
        GroupLayout outputTabLayout = new GroupLayout(this.outputTab);
        this.outputTab.setLayout(outputTabLayout);
        outputTabLayout.setHorizontalGroup(outputTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outputTabLayout.createSequentialGroup().addContainerGap().addGroup(outputTabLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.syncWarningLabel, GroupLayout.Alignment.LEADING, -1, 662, Short.MAX_VALUE).addComponent(this.resultsScrollPane, GroupLayout.Alignment.LEADING, -1, 662, Short.MAX_VALUE)).addContainerGap()));
        outputTabLayout.setVerticalGroup(outputTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outputTabLayout.createSequentialGroup().addContainerGap().addComponent(this.resultsScrollPane, -1, 374, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.syncWarningLabel).addContainerGap()));
        this.tabbedPane.addTab("Output", this.outputTab);
        this.consoleTab.setName("consoleTab");
        this.jScrollPane1.setName("jScrollPane1");
        this.consoleTextArea.setColumns(20);
        this.consoleTextArea.setEditable(false);
        this.consoleTextArea.setFont(new Font("Courier New 12 Simplu 12 Simplu", 0, 12));
        this.consoleTextArea.setRows(5);
        this.consoleTextArea.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        this.consoleTextArea.setName("consoleTextArea");
        this.jScrollPane1.setViewportView(this.consoleTextArea);
        this.jButton1.setAction(actionMap.get("clearConsole"));
        this.jButton1.setName("jButton1");
        GroupLayout consoleTabLayout = new GroupLayout(this.consoleTab);
        this.consoleTab.setLayout(consoleTabLayout);
        consoleTabLayout.setHorizontalGroup(consoleTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, consoleTabLayout.createSequentialGroup().addContainerGap().addGroup(consoleTabLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton1, -2, 108, -2).addComponent(this.jScrollPane1, -1, 662, Short.MAX_VALUE)).addContainerGap()));
        consoleTabLayout.setVerticalGroup(consoleTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, consoleTabLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 367, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap()));
        this.tabbedPane.addTab("Console", this.consoleTab);
        this.jPanel2.setMinimumSize(new Dimension(0, 120));
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setPreferredSize(new Dimension(0, 120));
        this.testArithOverflowCheckBox.setSelected(true);
        this.testArithOverflowCheckBox.setText("Run tests for arithmetic overflow");
        this.testArithOverflowCheckBox.setAlignmentX(0.5f);
        this.testArithOverflowCheckBox.setName("testArithOverflowCheckBox");
        this.outputOptionsPanel.setBorder(BorderFactory.createTitledBorder("Output options"));
        this.outputOptionsPanel.setToolTipText("Chooses which output files will be produced by Normaliz");
        this.outputOptionsPanel.setName("outputOptionsPanel");
        this.outputOptionsButtonGroup.add(this.outputIntermediateRadioButton);
        this.outputIntermediateRadioButton.setText("Write .out, .gen, .inv, .typ, .cst");
        this.outputIntermediateRadioButton.setName("outputIntermediateRadioButton");
        this.outputOptionsButtonGroup.add(this.outputAllRadioButton);
        this.outputAllRadioButton.setText("Write all output file types");
        this.outputAllRadioButton.setName("outputAllRadioButton");
        this.outputOptionsButtonGroup.add(this.outputDefaultRadioButton);
        this.outputDefaultRadioButton.setSelected(true);
        this.outputDefaultRadioButton.setText("Write just .out");
        this.outputDefaultRadioButton.setName("outputDefaultRadioButton");
        this.writeTriangulationFileCheckBox.setText("Write triangulation");
        this.writeTriangulationFileCheckBox.setName("writeTriangulationFileCheckBox");
        this.writeStanleyDecompositionFileCheckBox.setText("Write Stanley decomposition");
        this.writeStanleyDecompositionFileCheckBox.setName("writeStanleyDecompositionFileCheckBox");
        GroupLayout outputOptionsPanelLayout = new GroupLayout(this.outputOptionsPanel);
        this.outputOptionsPanel.setLayout(outputOptionsPanelLayout);
        outputOptionsPanelLayout.setHorizontalGroup(outputOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputOptionsPanelLayout.createSequentialGroup().addGroup(outputOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.outputDefaultRadioButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.outputAllRadioButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.outputIntermediateRadioButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addComponent(this.writeTriangulationFileCheckBox).addComponent(this.writeStanleyDecompositionFileCheckBox)).addContainerGap(78, Short.MAX_VALUE)));
        outputOptionsPanelLayout.setVerticalGroup(outputOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputOptionsPanelLayout.createSequentialGroup().addComponent(this.outputDefaultRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.outputIntermediateRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.outputAllRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.writeTriangulationFileCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.writeStanleyDecompositionFileCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.inputFontSizeSpinner.setName("inputFontSizeSpinner");
        this.inputFontSizeSpinner.setValue(12);
        this.inputFontSizeSpinner.addChangeListener(this);
        this.jLabel4.setText("Font size for textual data (input file, output file and console)");
        this.jLabel4.setName("jLabel4");
        this.label1.setAlignment(1);
        this.label1.setFont(new Font("Dialog", 1, 12));
        this.label1.setName("Normaliz options");
        this.label1.setText("Normaliz options");
        this.controlParalellizationCheckBox.setText("Control the number of parallel threads");
        this.controlParalellizationCheckBox.setAlignmentX(0.5f);
        this.controlParalellizationCheckBox.setName("controlParalellizationCheckBox");
        this.jLabel1.setText(" Maximum number of parallel threads");
        this.jLabel1.setAlignmentX(0.5f);
        this.jLabel1.setName("jLabel1");
        this.inputNumberParallelThreads.setName("inputNumberPararallelThreads");
        this.inputNumberParallelThreads.setValue(1);
        this.jLabel5.setFont(new Font("Dialog", 1, 12));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("NmzIntegrate options");
        this.jLabel5.setHorizontalTextPosition(0);
        this.jLabel5.setName("jLabel5");
        this.NmzIntegrateOptionsPanel.setBorder(BorderFactory.createTitledBorder("NmzIntegrate options"));
        this.NmzIntegrateOptionsPanel.setToolTipText("Chooses which NmzIntegrate option will be used by Normaliz");
        this.NmzIntegrateOptionsPanel.setName("NmzIntegrateOptionsPanel");
        this.NmzIntegrateOptionsButtonGroup.add(this.NmzIntegrateEhrhartRadioButton);
        this.NmzIntegrateEhrhartRadioButton.setText("Generalized Ehrhart series");
        this.NmzIntegrateEhrhartRadioButton.setName("GeneralizedEhrhartseriesRadioButton1");
        this.NmzIntegrateOptionsButtonGroup.add(this.NmzIntegrateLeadingRadioButton);
        this.NmzIntegrateLeadingRadioButton.setText("Leading coefficient of quasipolynomial");
        this.NmzIntegrateLeadingRadioButton.setName("NmzIntegrateLeadingRadioButton");
        this.NmzIntegrateOptionsButtonGroup.add(this.NmzIntegrateDefaultRadioButton);
        this.NmzIntegrateDefaultRadioButton.setSelected(true);
        this.NmzIntegrateDefaultRadioButton.setText("None");
        this.NmzIntegrateDefaultRadioButton.setName("NmzIntegrateDefaultRadioButton");
        this.NmzIntegrateOptionsButtonGroup.add(this.NmzIntegrateLebesqueRadioButton);
        this.NmzIntegrateLebesqueRadioButton.setText("Lebesque integral");
        this.NmzIntegrateLebesqueRadioButton.setName("NmzIntegrateLebesqueRadioButton");
        GroupLayout NmzIntegrateOptionsPanelLayout = new GroupLayout(this.NmzIntegrateOptionsPanel);
        this.NmzIntegrateOptionsPanel.setLayout(NmzIntegrateOptionsPanelLayout);
        NmzIntegrateOptionsPanelLayout.setHorizontalGroup(NmzIntegrateOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(NmzIntegrateOptionsPanelLayout.createSequentialGroup().addGroup(NmzIntegrateOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(NmzIntegrateOptionsPanelLayout.createSequentialGroup().addComponent(this.NmzIntegrateEhrhartRadioButton, -1, 156, Short.MAX_VALUE).addGap(207, 207, 207)).addComponent(this.NmzIntegrateLebesqueRadioButton).addComponent(this.NmzIntegrateLeadingRadioButton, -1, 363, Short.MAX_VALUE).addComponent(this.NmzIntegrateDefaultRadioButton, -2, 302, -2)).addContainerGap()));
        NmzIntegrateOptionsPanelLayout.setVerticalGroup(NmzIntegrateOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(NmzIntegrateOptionsPanelLayout.createSequentialGroup().addComponent(this.NmzIntegrateDefaultRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.NmzIntegrateEhrhartRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.NmzIntegrateLeadingRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.NmzIntegrateLebesqueRadioButton).addContainerGap(42, Short.MAX_VALUE)));
        this.label2.setAlignment(1);
        this.label2.setFont(new Font("Dialog", 1, 12));
        this.label2.setName("jNormaliz options");
        this.label2.setText("jNormaliz options");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputOptionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.label1, -1, 271, Short.MAX_VALUE).addComponent(this.testArithOverflowCheckBox, GroupLayout.Alignment.TRAILING, -1, 271, Short.MAX_VALUE).addComponent(this.controlParalellizationCheckBox, GroupLayout.Alignment.TRAILING, -1, 271, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 271, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.inputNumberParallelThreads, -2, 47, -2).addGap(228, 228, 228))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.NmzIntegrateOptionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.inputFontSizeSpinner, GroupLayout.Alignment.LEADING, -2, 48, -2).addComponent(this.jLabel4, -1, 381, Short.MAX_VALUE).addComponent(this.label2, GroupLayout.Alignment.LEADING, -1, 381, Short.MAX_VALUE).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING, -1, 381, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel2Layout.createSequentialGroup().addGap(223, 223, 223).addComponent(this.testArithOverflowCheckBox, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.controlParalellizationCheckBox, -2, 36, -2)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.label1, GroupLayout.Alignment.TRAILING, -1, 38, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.NmzIntegrateOptionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.outputOptionsPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label2, -1, -1, Short.MAX_VALUE))).addGap(7, 7, 7).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -1, 33, Short.MAX_VALUE).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inputNumberParallelThreads, -2, -1, -2).addComponent(this.inputFontSizeSpinner, -2, -1, -2)).addContainerGap(53, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Options", this.jPanel2);
        this.tabbedPane.setSelectedIndex(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 147;
        gridBagConstraints.ipady = 86;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.mainPanel.add((Component)this.tabbedPane, gridBagConstraints);
        this.statusPanel.setMinimumSize(new Dimension(0, 30));
        this.statusPanel.setName("statusPanel");
        this.statusPanel.setPreferredSize(new Dimension(512, 30));
        this.elapsedTimeLabel.setText("Elapsed time: -");
        this.elapsedTimeLabel.setName("elapsedTimeLabel");
        this.physicalMemoryTitleLabel.setHorizontalAlignment(4);
        this.physicalMemoryTitleLabel.setText("Physical mem. (free/total):");
        this.physicalMemoryTitleLabel.setName("physicalMemoryTitleLabel");
        this.memoryProgressBar.setBackground(new Color(255, 255, 255));
        this.memoryProgressBar.setName("memoryProgressBar");
        this.memoryProgressBar.setStringPainted(true);
        this.statusAnimationLabel.setHorizontalAlignment(0);
        this.statusAnimationLabel.setHorizontalTextPosition(0);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.elapsedTimeLabel, -1, 166, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.physicalMemoryTitleLabel, -2, 222, -2).addGap(84, 84, 84).addComponent(this.memoryProgressBar, -2, 178, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel, -2, 17, -2)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.statusAnimationLabel, -1, 30, Short.MAX_VALUE).addComponent(this.elapsedTimeLabel, -1, 30, Short.MAX_VALUE).addComponent(this.physicalMemoryTitleLabel, -2, 30, -2).addComponent(this.memoryProgressBar, -2, -1, -2)).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 224;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 16;
        this.mainPanel.add((Component)this.statusPanel, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setName("jToolBar1");
        this.runButton.setAction(actionMap.get("runNormalize"));
        this.runButton.setFocusable(false);
        this.runButton.setHorizontalTextPosition(0);
        this.runButton.setName("runButton");
        this.runButton.setVerticalTextPosition(3);
        this.jToolBar1.add(this.runButton);
        this.stopButton.setAction(actionMap.get("stopNormaliz"));
        this.stopButton.setFocusable(false);
        this.stopButton.setHorizontalTextPosition(0);
        this.stopButton.setName("stopButton");
        this.stopButton.setVerticalTextPosition(3);
        this.jToolBar1.add(this.stopButton);
        this.jSeparator2.setName("jSeparator2");
        this.jToolBar1.add(this.jSeparator2);
        this.jPanel4.setName("jPanel4");
        this.jPanel4.setOpaque(false);
        this.jLabel2.setText("Computation mode");
        this.jLabel2.setName("jLabel2");
        this.computationTypeComboBox.setMaximumRowCount(11);
        this.computationTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"default", "support hyperplanes", "triangulation", "volume", "volume degree 1 elements", "Hilbert basis volume", "Hilbert basis", "degree 1 elements", "Hilbert series", "Hilbert series degree 1 elements", "Hilbert basis series"}));
        this.computationTypeComboBox.setLightWeightPopupEnabled(false);
        this.computationTypeComboBox.setMaximumSize(new Dimension(179, 25));
        this.computationTypeComboBox.setMinimumSize(new Dimension(170, 18));
        this.computationTypeComboBox.setName("computationTypeComboBox");
        this.computationTypeComboBox.setPreferredSize(new Dimension(170, 23));
        this.precisionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"64 bits precision (normaliz)", "Infinite precision (normaliz -B)"}));
        this.precisionComboBox.setMaximumSize(new Dimension(179, 25));
        this.precisionComboBox.setMinimumSize(new Dimension(170, 18));
        this.precisionComboBox.setName("precisionComboBox");
        this.precisionComboBox.setPreferredSize(new Dimension(170, 23));
        this.jLabel3.setText("Precision");
        this.jLabel3.setName("jLabel3");
        this.algorithmComboBox.setMaximumRowCount(3);
        this.algorithmComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"primal", "dual", "approximation"}));
        this.algorithmComboBox.setMaximumSize(new Dimension(179, 25));
        this.algorithmComboBox.setMinimumSize(new Dimension(170, 18));
        this.algorithmComboBox.setName("algorithmComboBox");
        this.algorithmComboBox.setPreferredSize(new Dimension(170, 23));
        this.jLabel6.setText("Algorithm");
        this.jLabel6.setName("jLabel6");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6, -2, 62, -2).addComponent(this.algorithmComboBox, -2, 179, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(100, 100, 100)).addComponent(this.computationTypeComboBox, GroupLayout.Alignment.LEADING, -2, 179, -2)).addGap(1, 1, 1).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.precisionComboBox, -2, 179, -2).addComponent(this.jLabel3)).addGap(37, 37, 37)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel6).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.computationTypeComboBox, -2, 25, -2).addComponent(this.algorithmComboBox, -2, 25, -2)).addComponent(this.precisionComboBox, -2, 25, -2)).addContainerGap()));
        this.jToolBar1.add(this.jPanel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.jToolBar1, gridBagConstraints);
        this.menuBar.setName("menuBar");
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.fileMenu.setName("fileMenu");
        this.openMenuItem.setAction(actionMap.get("loadInputFileAction"));
        this.openMenuItem.setName("openMenuItem");
        this.fileMenu.add(this.openMenuItem);
        this.newMenuItem.setAction(actionMap.get("newFileAction"));
        this.newMenuItem.setName("newMenuItem");
        this.fileMenu.add(this.newMenuItem);
        this.closeMenuItem.setAction(actionMap.get("closeFileAction"));
        this.closeMenuItem.setName("closeMenuItem");
        this.fileMenu.add(this.closeMenuItem);
        this.jMenuItem3.setAction(actionMap.get("openDirectoryAction"));
        this.jMenuItem3.setName("jMenuItem3");
        this.fileMenu.add(this.jMenuItem3);
        this.jSeparator3.setName("jSeparator3");
        this.fileMenu.add(this.jSeparator3);
        this.saveMenuItem.setAction(actionMap.get("saveFileAction"));
        this.saveMenuItem.setName("saveMenuItem");
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setAction(actionMap.get("saveFileAsAction"));
        this.saveAsMenuItem.setName("saveAsMenuItem");
        this.fileMenu.add(this.saveAsMenuItem);
        this.jSeparator4.setName("jSeparator4");
        this.fileMenu.add(this.jSeparator4);
        this.printMenuItem.setAction(actionMap.get("printAction"));
        this.printMenuItem.setName("printMenuItem");
        this.fileMenu.add(this.printMenuItem);
        this.jSeparator1.setName("jSeparator1");
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setAction(actionMap.get("quit"));
        this.exitMenuItem.setName("exitMenuItem");
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.jMenu2.setMnemonic('E');
        this.jMenu2.setText("Edit");
        this.jMenu2.setName("jMenu2");
        this.undoMenuItem.setAction(actionMap.get("undoAction"));
        this.undoMenuItem.setName("undoMenuItem");
        this.jMenu2.add(this.undoMenuItem);
        this.jSeparator5.setName("jSeparator5");
        this.jMenu2.add(this.jSeparator5);
        this.copyMenuItem.setAction(new DefaultEditorKit.CopyAction());
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.setName("copyMenuItem");
        this.copyMenuItem.addActionListener(this);
        this.jMenu2.add(this.copyMenuItem);
        this.cutMenuItem.setAction(new DefaultEditorKit.CutAction());
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.setName("cutMenuItem");
        this.jMenu2.add(this.cutMenuItem);
        this.pasteMenuItem.setAction(new DefaultEditorKit.PasteAction());
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.setName("pasteMenuItem");
        this.jMenu2.add(this.pasteMenuItem);
        this.menuBar.add(this.jMenu2);
        this.jMenu3.setText("Normaliz");
        this.jMenu3.setName("jMenu3");
        this.jMenuItem1.setAction(actionMap.get("runNormalize"));
        this.jMenuItem1.setName("jMenuItem1");
        this.jMenu3.add(this.jMenuItem1);
        this.jMenuItem2.setAction(actionMap.get("stopNormaliz"));
        this.jMenuItem2.setName("jMenuItem2");
        this.jMenu3.add(this.jMenuItem2);
        this.menuBar.add(this.jMenu3);
        this.jMenu1.setMnemonic('H');
        this.jMenu1.setText("Help");
        this.jMenu1.setName("jMenu1");
        this.jMenuItem6.setAction(actionMap.get("helpJNormalizAction"));
        this.jMenuItem6.setName("jMenuItem6");
        this.jMenu1.add(this.jMenuItem6);
        this.jMenuItem7.setAction(actionMap.get("helpNormaliz"));
        this.jMenuItem7.setName("jMenuItem7");
        this.jMenu1.add(this.jMenuItem7);
        this.openWebMenuItem.setAction(actionMap.get("openWebAction"));
        this.openWebMenuItem.setName("openWebMenuItem");
        this.jMenu1.add(this.openWebMenuItem);
        this.jMenuItem9.setAction(actionMap.get("helpAlgorith"));
        this.jMenuItem9.setName("jMenuItem9");
        this.jMenu1.add(this.jMenuItem9);
        this.jMenuItem8.setAction(actionMap.get("showAboutBox"));
        this.jMenuItem8.setName("jMenuItem8");
        this.jMenu1.add(this.jMenuItem8);
        this.menuBar.add(this.jMenu1);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
        this.setToolBar(this.jToolBar1);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.copyMenuItem) {
            this.copyMenuItemActionPerformed(evt);
        }
    }

    public void stateChanged(ChangeEvent evt) {
        if (evt.getSource() == this.inputFontSizeSpinner) {
            this.inputFontSizeSpinnerStateChanged(evt);
        }
    }

    private void inputFontSizeSpinnerStateChanged(ChangeEvent evt) {
        Font currentFont = this.inputDataTextArea.getFont();
        Font newFont = new Font(currentFont.getName(), currentFont.getStyle(), (Integer)this.inputFontSizeSpinner.getValue());
        this.inputDataTextArea.setFont(newFont);
        this.resultTextArea.setFont(newFont);
        this.consoleTextArea.setFont(newFont);
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
    }

    @Action(enabledProperty="runnable")
    public void runNormalize() {
        this.setRunning(true);
        this.saveFileAction();
        this.inputFileChangeSinceLastRun = false;
        this.outputFileWhenNormalizWasRun = this.outputFile;
        NormalizConfig config = new NormalizConfig();
        switch (this.precisionComboBox.getSelectedIndex()) {
            case 0: {
                config.precision = NormalizConfig.Precision.PRECISION64;
                break;
            }
            case 1: {
                config.precision = NormalizConfig.Precision.PRECISIONBIG;
                break;
            }
            default: {
                throw new RuntimeException("Unknown precision value: " + this.precisionComboBox.getSelectedIndex());
            }
        }
        switch (this.computationTypeComboBox.getSelectedIndex()) {
            case 0: {
                config.computationType = NormalizConfig.ComputationType.DEFAULT;
                break;
            }
            case 1: {
                config.computationType = NormalizConfig.ComputationType.SUPPORT_HYPERPLANES;
                break;
            }
            case 2: {
                config.computationType = NormalizConfig.ComputationType.TRIANGULATION;
                break;
            }
            case 3: {
                config.computationType = NormalizConfig.ComputationType.VOLUME;
                break;
            }
            case 4: {
                config.computationType = NormalizConfig.ComputationType.VOLUME_DEGREE_1_ELEMENTS;
                break;
            }
            case 5: {
                config.computationType = NormalizConfig.ComputationType.HILBERT_BASIS_VOLUME;
                break;
            }
            case 6: {
                config.computationType = NormalizConfig.ComputationType.HILBERT_BASIS;
                break;
            }
            case 7: {
                config.computationType = NormalizConfig.ComputationType.DEGREE_1_ELEMENTS;
                break;
            }
            case 8: {
                config.computationType = NormalizConfig.ComputationType.HILBERT_SERIES;
                break;
            }
            case 9: {
                config.computationType = NormalizConfig.ComputationType.HILBERT_SERIES_DEGREE_1_ELEMENTS;
                break;
            }
            case 10: {
                config.computationType = NormalizConfig.ComputationType.HILBERT_BASIS_SERIES;
                break;
            }
            default: {
                throw new RuntimeException("Unknown computation type");
            }
        }
        switch (this.algorithmComboBox.getSelectedIndex()) {
            case 0: {
                config.algorithm = NormalizConfig.Algorithm.PRIMAL;
                break;
            }
            case 1: {
                config.algorithm = NormalizConfig.Algorithm.DUAL;
                break;
            }
            case 2: {
                config.algorithm = NormalizConfig.Algorithm.APPROXIMATION;
                break;
            }
            default: {
                throw new RuntimeException("Unknown algorithm");
            }
        }
        config.outputFiles = this.outputIntermediateRadioButton.isSelected() ? NormalizConfig.OutputFiles.SOME : (this.outputAllRadioButton.isSelected() ? NormalizConfig.OutputFiles.ALL : NormalizConfig.OutputFiles.ONLY_OUT);
        config.nmzIntegrateOptions = this.NmzIntegrateEhrhartRadioButton.isSelected() ? NormalizConfig.NmzIntegrateOptions.EHRHART : (this.NmzIntegrateLeadingRadioButton.isSelected() ? NormalizConfig.NmzIntegrateOptions.LEADING : (this.NmzIntegrateLebesqueRadioButton.isSelected() ? NormalizConfig.NmzIntegrateOptions.LEBESQUE : NormalizConfig.NmzIntegrateOptions.NONE));
        config.testArithmeticOverflow = this.testArithOverflowCheckBox.isSelected();
        config.writeTriangulationFile = this.writeTriangulationFileCheckBox.isSelected();
        config.writeStanleyDecompositionFile = this.writeStanleyDecompositionFileCheckBox.isSelected();
        config.controlParalellization = this.controlParalellizationCheckBox.isSelected();
        config.numberParallelThreads = (Integer)this.inputNumberParallelThreads.getValue();
        config.inFile = this.getInputFile();
        this.outputFileWhenNormalizWasRun = config.nmzIntegrateOptions != NormalizConfig.NmzIntegrateOptions.NONE ? (this.outputFile = new File(FileUtils.makeOutFileNameNmzIntegrate(this.getInputFile().getAbsolutePath()))) : (this.outputFile = new File(FileUtils.makeOutFileName(this.getInputFile().getAbsolutePath())));
        this.normalizWorker = new NormalizWorker(config);
        this.elapsedTime.reset();
        this.elapsedTimeLabel.setText("Elapsed time: 0:00:00");
        this.timer.start();
        this.normalizWorker.execute();
        this.tabbedPane.setSelectedComponent(this.consoleTab);
    }

    @Action
    public void clearConsole() {
        this.consoleTextArea.setText(null);
    }

    @Action
    public void loadInputFileAction() {
        if (!this.checkSaveBeforeClosing("Save it before loading another file?")) {
            return;
        }
        int result = this.fileChooser.showOpenDialog(this.getFrame());
        if (result == 1) {
            return;
        }
        if (result == 0) {
            File file = this.fileChooser.getSelectedFile();
            if (!file.getName().endsWith(".in")) {
                JOptionPane.showMessageDialog(this.getFrame(), "Only *.in files allowed as input files", "Error", 0);
                return;
            }
            boolean loaded = this.loadInputFile(file);
            if (loaded) {
                this.setInputFile(file);
                this.loadOutputFile(this.outputFile);
                this.tabbedPane.setSelectedComponent(this.inputTab);
            }
        }
    }

    public boolean loadInputFile(File file) {
        try {
            this.inputDataTextArea.read(new FileReader(file), null);
            this.inputDataTextArea.getDocument().addUndoableEditListener(this);
            this.inputDataTextArea.getDocument().addDocumentListener(this);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.getFrame(), "Unable to load file " + file.getAbsolutePath() + ":\n" + ex.getMessage(), "Error", 0);
            Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        this.setFileChanged(false);
        this.syncWarningLabel.setText("Warning: Normaliz has not been run yet. Output file may be out of sync with input file");
        return true;
    }

    public boolean loadOutputFile(File file) {
        try {
            if (file.exists()) {
                this.resultTextArea.read(new FileReader(file), null);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.getFrame(), "Unable to load output file " + file.getAbsolutePath() + ":\n" + ex.getMessage(), "Error", 2);
            Logger.getLogger(MainView.class.getName()).log(Level.WARNING, null, ex);
            return false;
        }
        this.setFileChanged(false);
        return true;
    }

    @Action(enabledProperty="running")
    public void stopNormaliz() {
        this.normalizWorker.stop();
        this.normalizWorker = null;
        this.stopTimer();
        JOptionPane.showMessageDialog(null, "Normaliz execution interrupted. Output results were NOT updated.", "Attention", 2);
        this.setRunning(false);
    }

    @Action(enabledProperty="fileChanged")
    public void saveFileAction() {
        try {
            this.inputDataTextArea.write(new FileWriter(this.getInputFile()));
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Unable to save file\nReason: " + ex.getMessage(), "Error", 0);
            Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        this.setFileChanged(false);
    }

    @Action(enabledProperty="fileLoaded")
    public void closeFileAction() {
        if (this.isRunning()) {
            int result = JOptionPane.showConfirmDialog(this.getFrame(), "Closing the file will interrupt computation. Are you sure?", "Warning", 2);
            if (result == 0) {
                this.stopNormaliz();
            } else {
                return;
            }
        }
        if (!this.checkSaveBeforeClosing("Save it before closing?")) {
            return;
        }
        this.setInputFile(null);
    }

    @Action(enabledProperty="fileLoaded")
    public void saveFileAsAction() {
        this.fileChooser.setSelectedFile(this.inputFile);
        int result = this.fileChooser.showSaveDialog(this.mainPanel);
        if (result == 0) {
            File chosenFile = this.fileChooser.getSelectedFile();
            if (!chosenFile.getName().endsWith(".in")) {
                JOptionPane.showMessageDialog(this.getFrame(), "Input files must have the .in extension", "Invalid file name", 0);
                return;
            }
            if (chosenFile.exists() && (result = JOptionPane.showConfirmDialog(this.getFrame(), "File already exists. Overwrite it?", "Attention", 0, 2)) == 1) {
                return;
            }
            this.setInputFile(chosenFile);
            this.saveFileAction();
        }
    }

    public boolean checkSaveBeforeClosing(String message) {
        if (this.getInputFile() == null || !this.fileChanged) {
            return true;
        }
        int result = JOptionPane.showConfirmDialog(this.getFrame(), message, "Attention", 1, 2);
        switch (result) {
            case 0: {
                this.saveFileAction();
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new RuntimeException("Internal Error");
    }

    @Action
    public void newFileAction() {
        if (!this.checkSaveBeforeClosing("Save it before creating new file?")) {
            return;
        }
        this.newFileDialog.showDialog(this.fileChooser.getCurrentDirectory());
    }

    @Action(enabledProperty="undo")
    public void undoAction() {
        this.undoManager.undo();
        this.updateUndoState();
    }

    public boolean isFileLoaded() {
        return this.fileLoaded;
    }

    public void setFileLoaded(boolean b) {
        boolean old = this.isFileLoaded();
        this.fileLoaded = b;
        this.firePropertyChange("fileLoaded", old, this.isFileLoaded());
        this.firePropertyChange("runnable", !this.isRunnable(), this.isRunnable());
        if (this.isFileLoaded() && this.tabbedPane.getComponentAt(0) != this.inputTab) {
            this.tabbedPane.insertTab(this.outputFile.getName(), null, this.outputTab, null, 0);
            this.tabbedPane.insertTab(this.getInputFile().getName(), null, this.inputTab, null, 0);
            this.tabbedPane.setSelectedComponent(this.inputTab);
        } else if (!this.isFileLoaded() && this.tabbedPane.getComponentAt(0) == this.inputTab) {
            this.tabbedPane.remove(this.inputTab);
            this.tabbedPane.remove(this.outputTab);
        }
    }

    @Action(enabledProperty="textualTabSelected")
    public void printAction() {
        MessageFormat footer = new MessageFormat("Page {0}");
        HashPrintRequestAttributeSet p = new HashPrintRequestAttributeSet();
        try {
            if (this.tabbedPane.getSelectedComponent() == this.inputTab) {
                MessageFormat header = new MessageFormat(this.getInputFile().getName());
                p.add(new JobName(this.getInputFile().getName() + " - jNormaliz", null));
                this.inputDataTextArea.print(header, footer, true, null, p, true);
            } else if (this.tabbedPane.getSelectedComponent() == this.outputTab) {
                MessageFormat header = new MessageFormat(this.outputFile.getName());
                p.add(new JobName(this.outputFile.getName() + " - jNormaliz", null));
                this.resultTextArea.print(header, footer, true, null, p, true);
            } else if (this.tabbedPane.getSelectedComponent() == this.consoleTab) {
                MessageFormat header = new MessageFormat("Console");
                p.add(new JobName("console text - jNormaliz", null));
                this.consoleTextArea.print(header, footer, true, null, p, true);
            }
        }
        catch (PrinterException ex) {
            JOptionPane.showMessageDialog(this.getFrame(), "Unable to print: " + ex.getMessage(), "Error", 0);
            Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isTextualTabSelected() {
        return this.textualTabSelected;
    }

    public void setTextualTabSelected(boolean b) {
        boolean old = this.isTextualTabSelected();
        this.textualTabSelected = b;
        this.firePropertyChange("textualTabSelected", old, this.isTextualTabSelected());
    }

    @Action
    public void helpNormaliz() {
        if (this.desktop != null) {
            File helpPdf = new File("doc", "Normaliz_2.12.pdf");
            if (!helpPdf.exists()) {
                JOptionPane.showMessageDialog(this.getFrame(), "Help file not found", "Error", 0);
                return;
            }
            try {
                this.desktop.open(helpPdf);
            }
            catch (IOException ex) {
                Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Action
    public void helpAlgorith() {
        this.normalizAlgorithms.setVisible(true);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean b) {
        boolean old = this.isRunning();
        this.running = b;
        this.firePropertyChange("running", old, this.isRunning());
        this.firePropertyChange("runnable", !this.isRunnable(), this.isRunnable());
        if (b) {
            this.busyIconTimer.start();
        } else {
            this.busyIconTimer.stop();
            this.statusAnimationLabel.setIcon(this.idleIcon);
        }
    }

    public boolean isRunnable() {
        return !this.isRunning() && this.isFileLoaded();
    }

    public boolean isUndo() {
        return this.undo;
    }

    void setUndo(boolean b) {
        boolean old = this.isUndo();
        this.undo = b;
        this.firePropertyChange("undo", old, this.isUndo());
    }

    private void setFileChanged(boolean b) {
        boolean old = this.getFileChanged();
        this.fileChanged = b;
        this.firePropertyChange("fileChanged", old, this.getFileChanged());
        this.updateFrameTitle();
        if (b) {
            this.inputFileChangeSinceLastRun = true;
            this.syncWarningLabel.setText("Warning: input file changed since last Normaliz run");
        }
    }

    private boolean getFileChanged() {
        return this.fileChanged;
    }

    @Action
    public void openWebAction() {
        if (this.desktop != null) {
            try {
                this.desktop.browse(new URI("http://www.mathematik.uni-osnabrueck.de/normaliz/"));
            }
            catch (Exception ex) {
                Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public boolean canExit(EventObject event) {
        if (!this.checkSaveBeforeClosing("Save it before exiting?")) {
            return false;
        }
        if (this.isRunning()) {
            int result = JOptionPane.showOptionDialog(this.getFrame(), "Do you want to interrupt current running task?", "Attention", 1, 3, null, null, null);
            switch (result) {
                case 0: {
                    this.normalizWorker.stop();
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void willExit(EventObject event) {
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.undoManager.undoableEditHappened(e);
        this.updateUndoState();
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.fileChanged) {
            this.setFileChanged(true);
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.fileChanged) {
            this.setFileChanged(true);
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    @Action
    public void helpJNormalizAction() {
        if (this.desktop != null) {
            File helpPdf = new File("doc", "jNormaliz_1.6.pdf");
            if (!helpPdf.exists()) {
                JOptionPane.showMessageDialog(this.getFrame(), "Help file not found:\n" + helpPdf.getAbsolutePath(), "Error", 0);
                return;
            }
            try {
                this.desktop.open(helpPdf);
            }
            catch (IOException ex) {
                Logger.getLogger(MainView.class.getName()).log(Level.WARNING, null, ex);
            }
        }
    }

    @Action(enabledProperty="fileLoaded")
    public void openDirectoryAction() {
        if (this.desktop != null) {
            try {
                this.desktop.open(this.inputFile.getParentFile());
            }
            catch (IOException ex) {
                Logger.getLogger(MainView.class.getName()).log(Level.WARNING, null, ex);
            }
        }
    }
}

