/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class NativeLibraryLoader {
    NativeLibraryLoader() {
    }

    public void loadLibrary(String libraryName) {
        try {
            InputStream is = this.getClass().getResourceAsStream("/" + libraryName);
            File tempNativeLib = this.getTempFile(libraryName);
            FileOutputStream os = new FileOutputStream(tempNativeLib);
            this.copyAndClose(is, os);
            System.load(tempNativeLib.getAbsolutePath());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't load native library " + libraryName, ioe);
        }
    }

    private void copyAndClose(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) >= 0) {
            os.write(buffer, 0, len);
        }
        is.close();
        os.close();
    }

    private File getTempFile(String libraryName) throws IOException {
        int suffixSeparator = libraryName.lastIndexOf(".");
        String suffix = null;
        String prefix = libraryName;
        if (suffixSeparator >= 0) {
            suffix = libraryName.substring(suffixSeparator);
            prefix = libraryName.substring(0, suffixSeparator - 1);
        }
        File tempFile = File.createTempFile(prefix, suffix);
        tempFile.deleteOnExit();
        return tempFile;
    }
}

