/*
mpcx_reconstruct

returns the product of several polynomials

Copyright (C) 2009, 2010, 2011 Andreas Enge

This file is part of the MPFRCX Library.

The MPFRCX Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The MPFRCX Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the MPC Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
*/

#include "mpfrcx-impl.h"

void mpcx_reconstruct (mpcx_ptr rop, mpcx_t *factors, int no)
   /* takes an array of no polynomials and multiplies them all together   */
   /* into rop                                                            */

{
   int i, layer = 1;
   mpcx_t *op;

   op = (mpcx_t *) malloc (no * sizeof (mpcx_t));
   /* copy factors into op */
   for (i = 0; i < no; i++)
      mpcx_init_set (op [i], factors [i]);

   while (no > 1) {
      for (i = 0; i < no / 2; i++)
         /* replace op [i] by op [2i] * op [2i+1] */
         mpcx_mul (op [i], op [2*i], op [2*i+1]);
      if (no % 2 != 0)
         mpcx_swap (op [no / 2], op [no - 1]);
      for (i = (no + 1) / 2; i < no; i++)
         mpcx_clear (op [i]);
      no = (no + 1) / 2;
      layer++;
   }

   /* The result is now in op [0]. */
   mpcx_set (rop, op [0]);
   mpcx_clear (op [0]);
   free (op);
}
