/****************************************************************************
**
*W  objpcgel.c                  GAP source                       Frank Celler
**
**
*Y  Copyright (C)  1996,  Lehrstuhl D für Mathematik,  RWTH Aachen,  Germany
*Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
*Y  Copyright (C) 2002 The GAP Group
*/
#include        "system.h"              /* Ints, UInts                     */


#include        "gasman.h"              /* garbage collector               */
#include        "objects.h"             /* objects                         */
#include        "scanner.h"             /* scanner                         */

#include        "gvars.h"               /* global variables                */
#include        "gap.h"                 /* error handling, initialisation  */
#include        "tls.h"                 /* thread-local storage            */

#include        "calls.h"               /* generic call mechanism          */

#include        "records.h"             /* generic records                 */
#include        "precord.h"             /* plain records                   */

#include        "lists.h"               /* generic lists                   */
#include        "plist.h"               /* plain lists                     */
#include        "string.h"              /* strings                         */

#include        "ariths.h"              /* basic arithmetic                */
#include        "bool.h"                /* booleans                        */

#include        "code.h"                /* coder                           */
#include        "tls.h"                 /* thread-local storage            */
#include        "objfgelm.h"            /* objects of free groups          */
#include        "objscoll.h"            /* single collector                */

#include        "objpcgel.h"            /* objects of polycyclic groups    */

#include	"thread.h"		/* threads			   */


/****************************************************************************
**

*F * * * * * * * * * * * * * * *  boxed objects * * * * * * * * * * * * * * *
*/

/****************************************************************************
**

*F  FuncLessBoxedObj( <self>, <left>, <right> )
*/
libGAP_Obj libGAP_FuncLessBoxedObj ( libGAP_Obj self, libGAP_Obj left, libGAP_Obj right )
{
    return libGAP_LT( libGAP_ADDR_OBJ(left)[1], libGAP_ADDR_OBJ(right)[1] ) ? libGAP_False : libGAP_True;
}


/****************************************************************************
**
*F  FuncEqualBoxedObj( <self>, <left>, <right> )
*/
libGAP_Obj libGAP_FuncEqualBoxedObj ( libGAP_Obj self, libGAP_Obj left, libGAP_Obj right )
{
    return libGAP_EQ( libGAP_ADDR_OBJ(left)[1], libGAP_ADDR_OBJ(right)[1] ) ? libGAP_False : libGAP_True;
}


/****************************************************************************
**

*F * * * * * * * * * * * * * * * pc word aspect * * * * * * * * * * * * * * *
*/

/****************************************************************************
**

*F  FuncNBitsPcWord_Comm( <self>, <left>, <right> )
*/
libGAP_Obj libGAP_FuncNBitsPcWord_Comm ( libGAP_Obj self, libGAP_Obj left, libGAP_Obj right )
{
    return libGAP_FuncFinPowConjCol_ReducedComm(
        self, libGAP_COLLECTOR_PCWORD(left), left, right );
}


/****************************************************************************
**
*F  FuncNBitsPcWord_Conjugate( <self>, <left>, <right> )
*/
libGAP_Obj libGAP_FuncNBitsPcWord_Conjugate ( libGAP_Obj self, libGAP_Obj left, libGAP_Obj right )
{
    left = libGAP_FuncFinPowConjCol_ReducedProduct(
                self, libGAP_COLLECTOR_PCWORD(left), left, right );
    return libGAP_FuncFinPowConjCol_ReducedLeftQuotient(
                self, libGAP_COLLECTOR_PCWORD(left), right, left );
}


/****************************************************************************
**
*F  FuncNBitsPcWord_LeftQuotient( <self>, <left>, <right> )
*/
libGAP_Obj libGAP_FuncNBitsPcWord_LeftQuotient ( libGAP_Obj self, libGAP_Obj left, libGAP_Obj right )
{
    return libGAP_FuncFinPowConjCol_ReducedLeftQuotient(
        self, libGAP_COLLECTOR_PCWORD(left), left, right );
}


/****************************************************************************
**
*F  FuncNBitsPcWord_PowerSmallInt( <self>, <left>, <right> )
*/
libGAP_Obj libGAP_FuncNBitsPcWord_PowerSmallInt ( libGAP_Obj self, libGAP_Obj left, libGAP_Obj right )
{
    return libGAP_FuncFinPowConjCol_ReducedPowerSmallInt(
        self, libGAP_COLLECTOR_PCWORD(left), left, right );
}


/****************************************************************************
**
*F  FuncNBitsPcWord_Product( <self>, <left>, <right> )
*/
libGAP_Obj libGAP_FuncNBitsPcWord_Product ( libGAP_Obj self, libGAP_Obj left, libGAP_Obj right )
{
    return libGAP_FuncFinPowConjCol_ReducedProduct(
        self, libGAP_COLLECTOR_PCWORD(left), left, right );
}


/****************************************************************************
**
*F  FuncNBitsPcWord_Quotient( <self>, <left>, <right> )
*/
libGAP_Obj libGAP_FuncNBitsPcWord_Quotient ( libGAP_Obj self, libGAP_Obj left, libGAP_Obj right )
{
    return libGAP_FuncFinPowConjCol_ReducedQuotient(
        self, libGAP_COLLECTOR_PCWORD(left), left, right );
}


/****************************************************************************
**

*F * * * * * * * * * * * * * * free word aspect * * * * * * * * * * * * * * *
*/

/****************************************************************************
**

*F  Func8Bits_DepthOfPcElement( <self>, <pcgs>, <w> )
*/
libGAP_Obj libGAP_Func8Bits_DepthOfPcElement ( libGAP_Obj self, libGAP_Obj pcgs, libGAP_Obj w )
{
    libGAP_Int         ebits;          /* number of bits in the exponent          */

    /* if the pc element is the identity we have to ask the pcgs           */
    if ( libGAP_NPAIRS_WORD(w) == 0 )
        return libGAP_INTOBJ_INT( libGAP_LEN_LIST(pcgs) + 1 );

    /* otherwise it is the generators number of the first syllable         */
    else {
        ebits = libGAP_EBITS_WORD(w);
        return libGAP_INTOBJ_INT(((((libGAP_UInt1*)libGAP_DATA_WORD(w))[0]) >> ebits)+1);
    }
}


/****************************************************************************
**
*F  Func8Bits_ExponentOfPcElement( <self>, <pcgs>, <w>, <pos> )
*/
libGAP_Obj libGAP_Func8Bits_ExponentOfPcElement ( libGAP_Obj self, libGAP_Obj pcgs, libGAP_Obj w, libGAP_Obj pos )
{
    libGAP_UInt        expm;           /* signed exponent mask                    */
    libGAP_UInt        exps;           /* sign exponent mask                      */
    libGAP_UInt        ebits;          /* number of exponent bits                 */
    libGAP_UInt        npos;           /* the wanted generator number             */
    libGAP_UInt        num;            /* number of syllables in <w>              */
    libGAP_UInt1 *     ptr;            /* pointer to the syllables of <w>         */
    libGAP_UInt        i;              /* loop                                    */
    libGAP_UInt        gen;            /* current generator number                */

    /* all exponents are zero if the pc element if the identity            */
    num = libGAP_NPAIRS_WORD(w);
    if ( num == 0 )
        return libGAP_INTOBJ_INT(0);

    /* otherwise find the syllable belonging to <exp>                      */
    else {
        ebits = libGAP_EBITS_WORD(w);
        exps  = 1UL << (ebits-1);
        expm  = exps - 1;
        npos  = libGAP_INT_INTOBJ(pos);
        ptr   = ((libGAP_UInt1*)libGAP_DATA_WORD(w));
        for ( i = 1;  i <= num;  i++, ptr++ ) {
            gen = ((*ptr) >> ebits) + 1;
            if ( gen == npos ) {
                if ( (*ptr) & exps )
                    return libGAP_INTOBJ_INT(((*ptr)&expm)-exps);
                else
                    return libGAP_INTOBJ_INT((*ptr)&expm);
            }
            if ( npos < gen )
                return libGAP_INTOBJ_INT(0);
        }
        return libGAP_INTOBJ_INT(0);
    }
}


/****************************************************************************
**
*F  Func8Bits_LeadingExponentOfPcElement( <self>, <pcgs>, <w> )
*/
libGAP_Obj libGAP_Func8Bits_LeadingExponentOfPcElement ( libGAP_Obj self, libGAP_Obj pcgs, libGAP_Obj w )
{
    libGAP_UInt        expm;           /* signed exponent mask                    */
    libGAP_UInt        exps;           /* sign exponent mask                      */
    libGAP_UInt1       p;              /* first syllable                          */

    /* the leading exponent is zero iff the pc element if the identity     */
    if ( libGAP_NPAIRS_WORD(w) == 0 )
        return libGAP_Fail;

    /* otherwise it is the exponent of the first syllable                  */
    else {
        exps = 1UL << (libGAP_EBITS_WORD(w)-1);
        expm = exps - 1;
        p = ((libGAP_UInt1*)libGAP_DATA_WORD(w))[0];
        if ( p & exps )
            return libGAP_INTOBJ_INT((p&expm)-exps);
        else
            return libGAP_INTOBJ_INT(p&expm);
    }
}

/****************************************************************************
**
*F  Func8Bits_ExponentsOfPcElement( <self>, <pcgs>, <w> )
*/
libGAP_Obj libGAP_Func8Bits_ExponentsOfPcElement ( libGAP_Obj self, libGAP_Obj pcgs, libGAP_Obj w)
{
    libGAP_UInt	len;		/* length of pcgs */
    libGAP_Obj		el;		/* exponents list */
    libGAP_UInt        le;
    libGAP_UInt	indx;
    libGAP_UInt        expm;           /* signed exponent mask                    */
    libGAP_UInt        exps;           /* sign exponent mask                      */
    libGAP_UInt        ebits;          /* number of exponent bits                 */
 /* UInt        npos;           / the wanted generator number             */
    libGAP_UInt        num;            /* number of syllables in <w>              */
    libGAP_UInt1 *     ptr;            /* pointer to the syllables of <w>         */
    libGAP_UInt        i,j;            /* loop                                    */
    libGAP_UInt        gen;            /* current generator number                */

    len=libGAP_LEN_LIST(pcgs);
    el=libGAP_NEW_PLIST(libGAP_T_PLIST_CYC,len);
    libGAP_SET_LEN_PLIST(el,len);

    /* Check if the exponent vector is the empty list. */
    if( len == 0 ) { libGAP_RetypeBag( el, libGAP_T_PLIST_EMPTY ); return el; }

    indx=1; /* current index in el we assign to */
    num = libGAP_NPAIRS_WORD(w);

    le=1; /* last exponent which has been assigned+1 */

    ebits = libGAP_EBITS_WORD(w);
    exps  = 1UL << (ebits-1);
    expm  = exps - 1;

    ptr   = ((libGAP_UInt1*)libGAP_DATA_WORD(w));
    for ( i = 1;  i <= num;  i++, ptr++ ) {
      gen = ((*ptr) >> ebits) + 1;
      for (j=le; j< gen;j++) {
        /* zero out intermediate entries */
	libGAP_SET_ELM_PLIST(el,indx,libGAP_INTOBJ_INT(0));
	indx++;
      }

      if ( (*ptr) & exps )
	  libGAP_SET_ELM_PLIST(el,indx,libGAP_INTOBJ_INT(((*ptr)&expm)-exps));
      else
	  libGAP_SET_ELM_PLIST(el,indx,libGAP_INTOBJ_INT((*ptr)&expm));
      indx++;
      le=gen+1;
    }

    /* zeroes at the end */
    for (j=le; j<=len;j++) {
      /* zero out  */
      libGAP_SET_ELM_PLIST(el,indx,libGAP_INTOBJ_INT(0));
      indx++;
    }

    libGAP_CHANGED_BAG(el);
    return el;
}


/****************************************************************************
**

*F  Func16Bits_DepthOfPcElement( <self>, <pcgs>, <w> )
*/
libGAP_Obj libGAP_Func16Bits_DepthOfPcElement ( libGAP_Obj self, libGAP_Obj pcgs, libGAP_Obj w )
{
    libGAP_Int         ebits;          /* number of bits in the exponent          */

    /* if the pc element is the identity we have to ask the pcgs           */
    if ( libGAP_NPAIRS_WORD(w) == 0 )
        return libGAP_INTOBJ_INT( libGAP_LEN_LIST(pcgs) + 1 );

    /* otherwise it is the generators number of the first syllable         */
    else {
        ebits = libGAP_EBITS_WORD(w);
        return libGAP_INTOBJ_INT(((((libGAP_UInt2*)libGAP_DATA_WORD(w))[0]) >> ebits)+1);
    }
}


/****************************************************************************
**
*F  Func16Bits_ExponentOfPcElement( <self>, <pcgs>, <w>, <pos> )
*/
libGAP_Obj libGAP_Func16Bits_ExponentOfPcElement ( libGAP_Obj self, libGAP_Obj pcgs, libGAP_Obj w, libGAP_Obj pos )
{
    libGAP_UInt        expm;           /* signed exponent mask                    */
    libGAP_UInt        exps;           /* sign exponent mask                      */
    libGAP_UInt        ebits;          /* number of exponent bits                 */
    libGAP_UInt        npos;           /* the wanted generator number             */
    libGAP_UInt        num;            /* number of syllables in <w>              */
    libGAP_UInt2 *     ptr;            /* pointer to the syllables of <w>         */
    libGAP_UInt        i;              /* loop                                    */
    libGAP_UInt        gen;            /* current generator number                */

    /* all exponents are zero if the pc element if the identity            */
    num = libGAP_NPAIRS_WORD(w);
    if ( num == 0 )
        return libGAP_INTOBJ_INT(0);

    /* otherwise find the syllable belonging to <exp>                      */
    else {
        ebits = libGAP_EBITS_WORD(w);
        exps  = 1UL << (ebits-1);
        expm  = exps - 1;
        npos  = libGAP_INT_INTOBJ(pos);
        ptr   = ((libGAP_UInt2*)libGAP_DATA_WORD(w));
        for ( i = 1;  i <= num;  i++, ptr++ ) {
            gen = ((*ptr) >> ebits) + 1;
            if ( gen == npos ) {
                if ( (*ptr) & exps )
                    return libGAP_INTOBJ_INT(((*ptr)&expm)-exps);
                else
                    return libGAP_INTOBJ_INT((*ptr)&expm);
            }
            if ( npos < gen )
                return libGAP_INTOBJ_INT(0);
        }
        return libGAP_INTOBJ_INT(0);
    }
}


/****************************************************************************
**
*F  Func16Bits_LeadingExponentOfPcElement( <self>, <pcgs>, <w> )
*/
libGAP_Obj libGAP_Func16Bits_LeadingExponentOfPcElement ( libGAP_Obj self, libGAP_Obj pcgs, libGAP_Obj w )
{
    libGAP_UInt        expm;           /* signed exponent mask                    */
    libGAP_UInt        exps;           /* sign exponent mask                      */
    libGAP_UInt2       p;              /* first syllable                          */

    /* the leading exponent is zero iff the pc element if the identity     */
    if ( libGAP_NPAIRS_WORD(w) == 0 )
        return libGAP_Fail;

    /* otherwise it is the exponent of the first syllable                  */
    else {
        exps = 1UL << (libGAP_EBITS_WORD(w)-1);
        expm = exps - 1;
        p = ((libGAP_UInt2*)libGAP_DATA_WORD(w))[0];
        if ( p & exps )
            return libGAP_INTOBJ_INT((p&expm)-exps);
        else
            return libGAP_INTOBJ_INT(p&expm);
    }
}

/****************************************************************************
**
*F  Func16Bits_ExponentsOfPcElement( <self>, <pcgs>, <w> )
*/
libGAP_Obj libGAP_Func16Bits_ExponentsOfPcElement ( libGAP_Obj self, libGAP_Obj pcgs, libGAP_Obj w)
{
    libGAP_UInt	len;		/* length of pcgs */
    libGAP_Obj		el;		/* exponents list */
    libGAP_UInt        le;
    libGAP_UInt	indx;
    libGAP_UInt        expm;           /* signed exponent mask                    */
    libGAP_UInt        exps;           /* sign exponent mask                      */
    libGAP_UInt        ebits;          /* number of exponent bits                 */
 /* UInt        npos;           / the wanted generator number             */
    libGAP_UInt        num;            /* number of syllables in <w>              */
    libGAP_UInt2 *     ptr;            /* pointer to the syllables of <w>         */
    libGAP_UInt        i,j;            /* loop                                    */
    libGAP_UInt        gen;            /* current generator number                */

    len=libGAP_LEN_LIST(pcgs);
    el=libGAP_NEW_PLIST(libGAP_T_PLIST_CYC,len);
    libGAP_SET_LEN_PLIST(el,len);

    /* Check if the exponent vector is the empty list. */
    if( len == 0 ) { libGAP_RetypeBag( el, libGAP_T_PLIST_EMPTY ); return el; }

    indx=1; /* current index in el we assign to */
    num = libGAP_NPAIRS_WORD(w);

    le=1; /* last exponent which has been assigned+1 */

    ebits = libGAP_EBITS_WORD(w);
    exps  = 1UL << (ebits-1);
    expm  = exps - 1;

    ptr   = ((libGAP_UInt2*)libGAP_DATA_WORD(w));
    for ( i = 1;  i <= num;  i++, ptr++ ) {
      gen = ((*ptr) >> ebits) + 1;
      for (j=le; j< gen;j++) {
        /* zero out intermediate entries */
	libGAP_SET_ELM_PLIST(el,indx,libGAP_INTOBJ_INT(0));
	indx++;
      }

      if ( (*ptr) & exps )
	  libGAP_SET_ELM_PLIST(el,indx,libGAP_INTOBJ_INT(((*ptr)&expm)-exps));
      else
	  libGAP_SET_ELM_PLIST(el,indx,libGAP_INTOBJ_INT((*ptr)&expm));
      indx++;
      le=gen+1;
    }

    /* zeroes at the end */
    for (j=le; j<=len;j++) {
      /* zero out  */
      libGAP_SET_ELM_PLIST(el,indx,libGAP_INTOBJ_INT(0));
      indx++;
    }

    libGAP_CHANGED_BAG(el);
    return el;
}


/****************************************************************************
**
*F  Func32Bits_DepthOfPcElement( <self>, <pcgs>, <w> )
*/
libGAP_Obj libGAP_Func32Bits_DepthOfPcElement ( libGAP_Obj self, libGAP_Obj pcgs, libGAP_Obj w )
{
    libGAP_Int         ebits;          /* number of bits in the exponent          */

    /* if the pc element is the identity we have to ask the pcgs           */
    if ( libGAP_NPAIRS_WORD(w) == 0 )
        return libGAP_INTOBJ_INT( libGAP_LEN_LIST(pcgs) + 1 );

    /* otherwise it is the generators number of the first syllable         */
    else {
        ebits = libGAP_EBITS_WORD(w);
        return libGAP_INTOBJ_INT(((((libGAP_UInt4*)libGAP_DATA_WORD(w))[0]) >> ebits)+1);
    }
}


/****************************************************************************
**
*F  Func32Bits_ExponentOfPcElement( <self>, <pcgs>, <w>, <pos> )
*/
libGAP_Obj libGAP_Func32Bits_ExponentOfPcElement ( libGAP_Obj self, libGAP_Obj pcgs, libGAP_Obj w, libGAP_Obj pos )
{
    libGAP_UInt        expm;           /* signed exponent mask                    */
    libGAP_UInt        exps;           /* sign exponent mask                      */
    libGAP_UInt        ebits;          /* number of exponent bits                 */
    libGAP_UInt        npos;           /* the wanted generator number             */
    libGAP_UInt        num;            /* number of syllables in <w>              */
    libGAP_UInt4 *     ptr;            /* pointer to the syllables of <w>         */
    libGAP_UInt        i;              /* loop                                    */
    libGAP_UInt        gen;            /* current generator number                */

    /* all exponents are zero if the pc element if the identity            */
    num = libGAP_NPAIRS_WORD(w);
    if ( num == 0 )
        return libGAP_INTOBJ_INT(0);

    /* otherwise find the syllable belonging to <exp>                      */
    else {
        ebits = libGAP_EBITS_WORD(w);
        exps  = 1UL << (ebits-1);
        expm  = exps - 1;
        npos  = libGAP_INT_INTOBJ(pos);
        ptr   = ((libGAP_UInt4*)libGAP_DATA_WORD(w));
        for ( i = 1;  i <= num;  i++, ptr++ ) {
            gen = ((*ptr) >> ebits) + 1;
            if ( gen == npos ) {
                if ( (*ptr) & exps )
                    return libGAP_INTOBJ_INT(((*ptr)&expm)-exps);
                else
                    return libGAP_INTOBJ_INT((*ptr)&expm);
            }
            if ( npos < gen )
                return libGAP_INTOBJ_INT(0);
        }
        return libGAP_INTOBJ_INT(0);
    }
}


/****************************************************************************
**
*F  Func32Bits_LeadingExponentOfPcElement( <self>, <pcgs>, <w> )
*/
libGAP_Obj libGAP_Func32Bits_LeadingExponentOfPcElement ( libGAP_Obj self, libGAP_Obj pcgs, libGAP_Obj w )
{
    libGAP_UInt        expm;           /* signed exponent mask                    */
    libGAP_UInt        exps;           /* sign exponent mask                      */
    libGAP_UInt4       p;              /* first syllable                          */

    /* the leading exponent is zero iff the pc element if the identity     */
    if ( libGAP_NPAIRS_WORD(w) == 0 )
        return libGAP_Fail;

    /* otherwise it is the exponent of the first syllable                  */
    else {
        exps = 1UL << (libGAP_EBITS_WORD(w)-1);
        expm = exps - 1;
        p = ((libGAP_UInt4*)libGAP_DATA_WORD(w))[0];
        if ( p & exps )
            return libGAP_INTOBJ_INT((p&expm)-exps);
        else
            return libGAP_INTOBJ_INT(p&expm);
    }
}

/****************************************************************************
**
*F  Func32Bits_ExponentsOfPcElement( <self>, <pcgs>, <w> )
*/
libGAP_Obj libGAP_Func32Bits_ExponentsOfPcElement ( libGAP_Obj self, libGAP_Obj pcgs, libGAP_Obj w)
{
    libGAP_UInt	len;		/* length of pcgs */
    libGAP_Obj		el;		/* exponents list */
    libGAP_UInt        le;
    libGAP_UInt	indx;
    libGAP_UInt        expm;           /* signed exponent mask                    */
    libGAP_UInt        exps;           /* sign exponent mask                      */
    libGAP_UInt        ebits;          /* number of exponent bits                 */
/*  UInt        npos;           / the wanted generator number             */
    libGAP_UInt        num;            /* number of syllables in <w>              */
    libGAP_UInt4 *     ptr;            /* pointer to the syllables of <w>         */
    libGAP_UInt        i,j;            /* loop                                    */
    libGAP_UInt        gen;            /* current generator number                */

    len=libGAP_LEN_LIST(pcgs);
    el=libGAP_NEW_PLIST(libGAP_T_PLIST_CYC,len);
    libGAP_SET_LEN_PLIST(el,len);

    /* Check if the exponent vector is the empty list. */
    if( len == 0 ) { libGAP_RetypeBag( el, libGAP_T_PLIST_EMPTY ); return el; }

    indx=1; /* current index in el we assign to */
    num = libGAP_NPAIRS_WORD(w);

    le=1; /* last exponent which has been assigned+1 */

    ebits = libGAP_EBITS_WORD(w);
    exps  = 1UL << (ebits-1);
    expm  = exps - 1;

    ptr   = ((libGAP_UInt4*)libGAP_DATA_WORD(w));
    for ( i = 1;  i <= num;  i++, ptr++ ) {
      gen = ((*ptr) >> ebits) + 1;
      for (j=le; j< gen;j++) {
        /* zero out intermediate entries */
	libGAP_SET_ELM_PLIST(el,indx,libGAP_INTOBJ_INT(0));
	indx++;
      }

      if ( (*ptr) & exps )
	  libGAP_SET_ELM_PLIST(el,indx,libGAP_INTOBJ_INT(((*ptr)&expm)-exps));
      else
	  libGAP_SET_ELM_PLIST(el,indx,libGAP_INTOBJ_INT((*ptr)&expm));
      indx++;
      le=gen+1;
    }

    /* zeroes at the end */
    for (j=le; j<=len;j++) {
      /* zero out  */
      libGAP_SET_ELM_PLIST(el,indx,libGAP_INTOBJ_INT(0));
      indx++;
    }

    libGAP_CHANGED_BAG(el);
    return el;
}


/****************************************************************************
**

*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * *
*/


/****************************************************************************
**


*V  GVarFuncs . . . . . . . . . . . . . . . . . . list of functions to export
*/
static libGAP_StructGVarFunc libGAP_GVarFuncs [] = {

    { "LessBoxedObj", 2, "lobj, lobj",
      libGAP_FuncLessBoxedObj, "src/objpcgel.c:LessBoxedObj" },

    { "EqualBoxedObj", 2, "lobj, lobj",
      libGAP_FuncEqualBoxedObj, "src/objpcgel.c:EqualBoxedObj" },

    { "NBitsPcWord_Comm", 2, "n_bits_pcword, n_bits_pcword",
      libGAP_FuncNBitsPcWord_Comm, "src/objpcgel.c:NBitsPcWord_Comm" },

    { "NBitsPcWord_Conjugate", 2, "n_bits_pcword, n_bits_pcword",
      libGAP_FuncNBitsPcWord_Conjugate, "src/objpcgel.c:NBitsPcWord_Conjugate" },

    { "NBitsPcWord_LeftQuotient", 2, "n_bits_pcword, n_bits_pcword",
      libGAP_FuncNBitsPcWord_LeftQuotient, "src/objpcgel.c:NBitsPcWord_LeftQuotient" },

    { "NBitsPcWord_PowerSmallInt", 2, "n_bits_pcword, small_integer",
      libGAP_FuncNBitsPcWord_PowerSmallInt, "src/objpcgel.c:NBitsPcWord_PowerSmallInt" },

    { "NBitsPcWord_Product", 2, "n_bits_pcword, n_bits_pcword",
      libGAP_FuncNBitsPcWord_Product, "src/objpcgel.c:NBitsPcWord_Product" },

    { "NBitsPcWord_Quotient", 2, "n_bits_pcword, n_bits_pcword",
      libGAP_FuncNBitsPcWord_Quotient, "src/objpcgel.c:NBitsPcWord_Quotient" },

    { "8Bits_DepthOfPcElement", 2, "8_bits_pcgs, 8_bits_pcword",
      libGAP_Func8Bits_DepthOfPcElement, "src/objpcgel.c:8Bits_DepthOfPcElement" },

    { "8Bits_ExponentOfPcElement", 3, "8_bits_pcgs, 8_bits_pcword, int",
      libGAP_Func8Bits_ExponentOfPcElement, "src/objpcgel.c:8Bits_ExponentOfPcElement" },

    { "8Bits_LeadingExponentOfPcElement", 2, "8_bits_pcgs, 8_bits_word",
      libGAP_Func8Bits_LeadingExponentOfPcElement, "src/objpcgel.c:8Bits_LeadingExponentOfPcElement" },

    { "8Bits_ExponentsOfPcElement", 2, "8_bits_pcgs, 8_bits_pcword",
      libGAP_Func8Bits_ExponentsOfPcElement, "src/objpcgel.c:8Bits_ExponentsOfPcElement" },

    { "16Bits_DepthOfPcElement", 2, "16_bits_pcgs, 16_bits_pcword",
      libGAP_Func16Bits_DepthOfPcElement, "src/objpcgel.c:16Bits_DepthOfPcElement" },

    { "16Bits_ExponentOfPcElement", 3, "16_bits_pcgs, 16_bits_pcword, int",
      libGAP_Func16Bits_ExponentOfPcElement, "src/objpcgel.c:16Bits_ExponentOfPcElement" },

    { "16Bits_LeadingExponentOfPcElement", 2, "16_bits_pcgs, 16_bits_word",
      libGAP_Func16Bits_LeadingExponentOfPcElement, "src/objpcgel.c:16Bits_LeadingExponentOfPcElement" },

    { "16Bits_ExponentsOfPcElement", 2, "16_bits_pcgs, 16_bits_pcword",
      libGAP_Func16Bits_ExponentsOfPcElement, "src/objpcgel.c:16Bits_ExponentsOfPcElement" },

    { "32Bits_DepthOfPcElement", 2, "32_bits_pcgs, 32_bits_pcword",
      libGAP_Func32Bits_DepthOfPcElement, "src/objpcgel.c:32Bits_DepthOfPcElement" },

    { "32Bits_ExponentOfPcElement", 3, "32_bits_pcgs, 32_bits_pcword, int",
      libGAP_Func32Bits_ExponentOfPcElement, "src/objpcgel.c:32Bits_ExponentOfPcElement" },

    { "32Bits_LeadingExponentOfPcElement", 2, "32_bits_pcgs, 32_bits_word",
      libGAP_Func32Bits_LeadingExponentOfPcElement, "src/objpcgel.c:32Bits_LeadingExponentOfPcElement" },

    { "32Bits_ExponentsOfPcElement", 2, "32_bits_pcgs, 32_bits_pcword",
      libGAP_Func32Bits_ExponentsOfPcElement, "src/objpcgel.c:32Bits_ExponentsOfPcElement" },

    { 0 }

};


/****************************************************************************
**

*F  InitKernel( <module> )  . . . . . . . . initialise kernel data structures
*/
static libGAP_Int libGAP_InitKernel (
    libGAP_StructInitInfo *    libGAP_module )
{
    /* init filters and functions                                          */
    libGAP_InitHdlrFuncsFromTable( libGAP_GVarFuncs );

    /* return success                                                      */
    return 0;
}


/****************************************************************************
**
*F  InitLibrary( <module> ) . . . . . . .  initialise library data structures
*/
static libGAP_Int libGAP_InitLibrary (
    libGAP_StructInitInfo *    libGAP_module )
{
    /* export position numbers 'PCWP_SOMETHING'                            */
    libGAP_AssGVar( libGAP_GVarName( "PCWP_FIRST_ENTRY" ),
             libGAP_INTOBJ_INT(libGAP_PCWP_FIRST_ENTRY) );
    libGAP_AssGVar( libGAP_GVarName( "PCWP_NAMES" ),
             libGAP_INTOBJ_INT(libGAP_PCWP_NAMES) );
    libGAP_AssGVar( libGAP_GVarName( "PCWP_COLLECTOR" ),
             libGAP_INTOBJ_INT(libGAP_PCWP_COLLECTOR) );
    libGAP_AssGVar( libGAP_GVarName( "PCWP_FIRST_FREE" ),
             libGAP_INTOBJ_INT(libGAP_PCWP_FIRST_FREE) );

    /* init filters and functions                                          */
    libGAP_InitGVarFuncsFromTable( libGAP_GVarFuncs );

    /* return success                                                      */
    return 0;
}


/****************************************************************************
**
*F  InitInfoPcElements()  . . . . . . . . . . . . . . table of init functions
*/
static libGAP_StructInitInfo libGAP_module = {
    libGAP_MODULE_BUILTIN,                     /* type                           */
    "objpcgel",                         /* name                           */
    0,                                  /* revision entry of c file       */
    0,                                  /* revision entry of h file       */
    0,                                  /* version                        */
    0,                                  /* crc                            */
    libGAP_InitKernel,                         /* initKernel                     */
    libGAP_InitLibrary,                        /* initLibrary                    */
    0,                                  /* checkInit                      */
    0,                                  /* preSave                        */
    0,                                  /* postSave                       */
    0                                   /* postRestore                    */
};

libGAP_StructInitInfo * libGAP_InitInfoPcElements ( void )
{
    return &libGAP_module;
}


/****************************************************************************
**

*E  objpcgel.c  . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/
