/****************************************************************************
**
*W  compiler.h                  GAP source                   Ferenc Ràkòczi
*W                                                         & Martin Schönert
**
**
*Y  Copyright (C)  1997,  Lehrstuhl D für Mathematik,  RWTH Aachen,  Germany
*Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
*Y  Copyright (C) 2002 The GAP Group
**
**  This file declares the functions of the GAP to C compiler.
*/

#ifndef libGAP_GAP_COMPILER_H
#define libGAP_GAP_COMPILER_H


/****************************************************************************
**
*F  CompileFunc(<output>,<func>,<name>,<magic1>,<magic2>) . . . . . . compile
*/
extern libGAP_Int libGAP_CompileFunc (
            libGAP_Char *              output,
            libGAP_Obj                 func,
            libGAP_Char *              name,
            libGAP_Int                 magic1,
            libGAP_Char *              magic2 );

/****************************************************************************
**
*F  SetCompileOpts( <string> ) . . parse the compiler options from <string>
**                                 and set the appropriate variables
**                                 unrecognised options are ignored for now
*/

extern void libGAP_SetCompileOpts( libGAP_Char *opts );


/****************************************************************************
**

*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * *
*/

/****************************************************************************
**

*F  InitInfoCompiler() . . . . . . . . . . . . . . .  table of init functions
*/
libGAP_StructInitInfo * libGAP_InitInfoCompiler ( void );


#endif // GAP_COMPILER_H

/****************************************************************************
**

*E  compiler.h  . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/
