/****************************************************************************
**
*W  saveload.h                  GAP source                   Steve Linton
**
**
*Y  Copyright (C)  1997,  Lehrstuhl D für Mathematik,  RWTH Aachen,  Germany
*Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
*Y  Copyright (C) 2002 The GAP Group
**
**  This file declares the functions concerned with saving and loading
**  the workspace. There are support functions in gasman.c and elsewhere
**  throughout the kernel
*/

#ifndef libGAP_GAP_SAVELOAD_H
#define libGAP_GAP_SAVELOAD_H

/***************************************************************************
**

*F  SaveWorkspace( <fname> ) . . . . . .save the workspace to the named file
**
**  'SaveWorkspace' is the entry point to the workspace saving. It is not
**  installed as a GAP function, but instead as a keyword, so that we can be
**  sure it is only being called from the top-most prompt level
**  The file saveload.tex in the dev directory describes the saved format
**  in more detail. Most of the work will be done from inside GASMAN, because
**  we need to fiddle with Bag internals somewhat
**
**  The return value is either True or Fail
*/

extern libGAP_Obj libGAP_SaveWorkspace( libGAP_Obj fname );

extern void libGAP_LoadWorkspace( libGAP_Char *fname);

extern void libGAP_SaveUInt1(libGAP_UInt1 x);
extern void libGAP_SaveUInt2(libGAP_UInt2 x);
extern void libGAP_SaveUInt4(libGAP_UInt4 x);
extern void libGAP_SaveUInt(libGAP_UInt x);
#ifdef libGAP_SYS_IS_64_BIT
extern void libGAP_SaveUInt8(libGAP_UInt8 x);
#endif
extern void libGAP_SaveCStr(const libGAP_Char *s);
extern void libGAP_SaveString(libGAP_Obj string);
extern void libGAP_LoadString(libGAP_Obj string);
extern void libGAP_SaveSubObj(libGAP_Obj o);
extern void libGAP_SaveHandler(libGAP_ObjFunc hdlr);

extern libGAP_UInt1 libGAP_LoadUInt1( void );
extern libGAP_UInt2 libGAP_LoadUInt2( void );
extern libGAP_UInt4 libGAP_LoadUInt4( void );
extern libGAP_UInt libGAP_LoadUInt( void );
#ifdef libGAP_SYS_IS_64_BIT
extern libGAP_UInt8 libGAP_LoadUInt8( void);
#endif
extern void libGAP_LoadCStr(libGAP_Char *buf, libGAP_UInt maxlen );
extern libGAP_Obj libGAP_LoadSubObj( void );
extern libGAP_ObjFunc libGAP_LoadHandler();



/***************************************************************************
**

*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * *
*/


/****************************************************************************
**

*F  InitInfoSaveLoad()  . . . . . . . . . . . . . . . table of init functions
*/
libGAP_StructInitInfo * libGAP_InitInfoSaveLoad ( void );


#endif // GAP_SAVELOAD_H

/****************************************************************************
**

*E  saveload.h  . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/
