/****************************************************************************
**
*W  objcftl.c                      GAP source                   Werner Nickel
**
**  Objects Collected From The Left.
**  This file contains a collector from the left for polycyclic
**  presentations.
*/
#include "system.h"


#include        "gasman.h"              /* garbage collector               */
#include        "objects.h"             /* objects                         */
#include        "scanner.h"             /* scanner                         */
#include        "gvars.h"               /* global variables                */
#include        "calls.h"               /* generic call mechanism          */
#include        "gap.h"                 /* error handling, initialisation  */
#include        "bool.h"                /* booleans                        */
#include        "integer.h"             /* integers                        */
#include        "ariths.h"              /* fast integers                   */

#include        "records.h"             /* generic records                 */
#include        "precord.h"             /* plain records                   */

#include        "lists.h"               /* generic lists                   */
#include        "plist.h"               /* plain lists                     */
#include        "string.h"              /* strings                         */

#include        "dt.h"                  /* deep thought                    */

#include        "objcftl.h"             /* from the left collect           */


#define libGAP_IS_INT_ZERO( n )  (libGAP_IS_INTOBJ(n) && ((n) == libGAP_INTOBJ_INT(0))) 

#define libGAP_GET_COMMUTE( libGAP_g )  libGAP_INT_INTOBJ(libGAP_ELM_PLIST(commute,(libGAP_g))) 

#define libGAP_GET_EXPONENT( libGAP_g ) ( ((libGAP_g) <= libGAP_LEN_PLIST(exp)) ? \
                            libGAP_ELM_PLIST( exp, (libGAP_g) ) : (libGAP_Obj)0 )
#define libGAP_GET_POWER( libGAP_g )    ( ((libGAP_g) <= libGAP_LEN_PLIST(pow)) ? \
                            libGAP_ELM_PLIST( pow, (libGAP_g) ) : (libGAP_Obj)0 )
#define libGAP_GET_IPOWER( libGAP_g )   ( ((libGAP_g) <= libGAP_LEN_PLIST(ipow)) ? \
                            libGAP_ELM_PLIST( ipow, (libGAP_g) ) : (libGAP_Obj)0 )

#define libGAP_GET_CONJ( h, libGAP_g ) ( (h <= libGAP_LEN_PLIST( conj ) && \
                            libGAP_g <= libGAP_LEN_PLIST(libGAP_ELM_PLIST( conj, h ))) ? \
                           libGAP_ELM_PLIST( libGAP_ELM_PLIST( conj, h ), libGAP_g ) : (libGAP_Obj)0 )

#define libGAP_GET_ICONJ( h, libGAP_g ) ( (h <= libGAP_LEN_PLIST( iconj ) && \
                             libGAP_g <= libGAP_LEN_PLIST(libGAP_ELM_PLIST( iconj, h ))) ? \
                            libGAP_ELM_PLIST( libGAP_ELM_PLIST( iconj, h ), libGAP_g ) : (libGAP_Obj)0 )

#define libGAP_PUSH_STACK( word, exp ) {  \
  st++; \
  libGAP_SET_ELM_PLIST( wst,  st, word ); \
  libGAP_SET_ELM_PLIST( west, st, exp );  \
  libGAP_SET_ELM_PLIST( sst,  st, libGAP_INTOBJ_INT(1) ); \
  libGAP_SET_ELM_PLIST( est,  st, libGAP_ELM_PLIST( word, 2 ) ); \
  libGAP_CHANGED_BAG( wst ); libGAP_CHANGED_BAG( west ); libGAP_CHANGED_BAG( est ); }

                                
void libGAP_AddIn( libGAP_Obj list, libGAP_Obj w, libGAP_Obj e ) {

  libGAP_Int    libGAP_g,  i;
  libGAP_Obj    r,  s,  t;

  for( i = 1; i < libGAP_LEN_PLIST(w); i += 2 ) {
      libGAP_g = libGAP_INT_INTOBJ( libGAP_ELM_PLIST( w, i ) );

      s = libGAP_ELM_PLIST( w, i+1 );
      libGAP_C_PROD_FIA( t, s, e );      /*   t = s * e   */

      r = libGAP_ELM_PLIST( list, libGAP_g );
      libGAP_C_SUM_FIA( s, t, r );       /*   s = r + s * e   */

      libGAP_SET_ELM_PLIST( list, libGAP_g, s );  libGAP_CHANGED_BAG( list );
  }

}

libGAP_Obj libGAP_CollectPolycyc (
    libGAP_Obj pcp,
    libGAP_Obj list,
    libGAP_Obj word )
{
    libGAP_Int    ngens   = libGAP_INT_INTOBJ( libGAP_ADDR_OBJ(pcp)[ libGAP_PC_NUMBER_OF_GENERATORS ] );
    libGAP_Obj    commute = libGAP_ADDR_OBJ(pcp)[ libGAP_PC_COMMUTE ];

    libGAP_Obj    gens    = libGAP_ADDR_OBJ(pcp)[ libGAP_PC_GENERATORS ];
    libGAP_Obj    igens   = libGAP_ADDR_OBJ(pcp)[ libGAP_PC_INVERSES ];

    libGAP_Obj    pow     = libGAP_ADDR_OBJ(pcp)[ libGAP_PC_POWERS ];
    libGAP_Obj    ipow    = libGAP_ADDR_OBJ(pcp)[ libGAP_PC_INVERSEPOWERS ];
    libGAP_Obj    exp     = libGAP_ADDR_OBJ(pcp)[ libGAP_PC_EXPONENTS ];

    libGAP_Obj    wst  = libGAP_ADDR_OBJ(pcp)[ libGAP_PC_WORD_STACK ];
    libGAP_Obj    west = libGAP_ADDR_OBJ(pcp)[ libGAP_PC_WORD_EXPONENT_STACK ];
    libGAP_Obj    sst  = libGAP_ADDR_OBJ(pcp)[ libGAP_PC_SYLLABLE_STACK ];
    libGAP_Obj    est  = libGAP_ADDR_OBJ(pcp)[ libGAP_PC_EXPONENT_STACK ];

    libGAP_Obj    conj=0, iconj=0;   /*QQ initialize to please compiler */

    libGAP_Int    st, bottom = libGAP_INT_INTOBJ( libGAP_ADDR_OBJ(pcp)[ libGAP_PC_STACK_POINTER ] );

    libGAP_Int    libGAP_g, syl, h, hh;

    libGAP_Obj    e, ee, ge, mge, we, s, t;
    libGAP_Obj    w, x = (libGAP_Obj)0, y = (libGAP_Obj)0;


    if( libGAP_LEN_PLIST(word) == 0 ) return (libGAP_Obj)0;

    if( libGAP_LEN_PLIST(list) < ngens ) {
        libGAP_ErrorQuit( "vector too short", 0L, 0L );
        return (libGAP_Obj)0;
    }
    if( libGAP_LEN_PLIST(word) % 2 != 0 ) {
        libGAP_ErrorQuit( "Length of word odd", 0L, 0L );
        return (libGAP_Obj)0;
    }

    st = bottom;
    libGAP_PUSH_STACK( word, libGAP_INTOBJ_INT(1) );

    while( st > bottom ) {

      w   = libGAP_ELM_PLIST( wst, st );
      syl = libGAP_INT_INTOBJ( libGAP_ELM_PLIST( sst, st ) );
      libGAP_g   = libGAP_INT_INTOBJ( libGAP_ELM_PLIST( w, syl )  );

      if( st > bottom+1 && syl==1 && libGAP_g == libGAP_GET_COMMUTE(libGAP_g) ) {
        /* Collect word^exponent in one go. */

        e = libGAP_ELM_PLIST( west, st );

        /* Add in. */
        libGAP_AddIn( list, w, e );

        /* Reduce. */
        for( h = libGAP_g; h <= ngens; h++ ) {
          s = libGAP_ELM_PLIST( list, h );
          if( libGAP_IS_INT_ZERO( s ) ) continue;

          y = (libGAP_Obj)0;
          if( (e = libGAP_GET_EXPONENT( h )) != (libGAP_Obj)0 ) {
              if( !libGAP_LtInt( s, e ) ) {
                  t = libGAP_ModInt( s, e );
                  libGAP_SET_ELM_PLIST( list, h, t ); libGAP_CHANGED_BAG( list );
                  if( (y = libGAP_GET_POWER( h )) ) e = libGAP_QuoInt( s, e );
              }
              else if( libGAP_LtInt( s, libGAP_INTOBJ_INT(0) ) ) {
                  t = libGAP_ModInt( s, e );
                  libGAP_SET_ELM_PLIST( list, h, t ); libGAP_CHANGED_BAG( list );
              
                  if( (y = libGAP_GET_IPOWER( h )) ) {
                      e = libGAP_QuoInt( s, e );
                      if( !libGAP_IS_INT_ZERO( t ) ) e = libGAP_DiffInt( e, libGAP_INTOBJ_INT(1) );
                      e = libGAP_ProdInt( e, libGAP_INTOBJ_INT(-1) );
                  }
              }
          }
          if( y != (libGAP_Obj)0 ) libGAP_AddIn( list, y, e );

        }

        st--;

      }
      else {
        if( libGAP_g == libGAP_GET_COMMUTE( libGAP_g ) ) {
          s = libGAP_ELM_PLIST( list, libGAP_g ); 
          t = libGAP_ELM_PLIST( est, st ); 
          libGAP_C_SUM_FIA( ge, s, t );
          libGAP_SET_ELM_PLIST( est, st, libGAP_INTOBJ_INT(0) );
        }
        else {
          /* Assume that the top of the exponent stack is non-zero. */
          e = libGAP_ELM_PLIST( est, st );
          
          if( libGAP_LtInt( libGAP_INTOBJ_INT(0), e ) ) {
            libGAP_C_DIFF_FIA( ee, e, libGAP_INTOBJ_INT(1) );  e = ee;
            libGAP_SET_ELM_PLIST( est, st, e );
            conj  = libGAP_ADDR_OBJ(pcp)[libGAP_PC_CONJUGATES];
            iconj = libGAP_ADDR_OBJ(pcp)[libGAP_PC_INVERSECONJUGATES];
            
            libGAP_C_SUM_FIA( ge, libGAP_ELM_PLIST( list, libGAP_g ), libGAP_INTOBJ_INT(1) );
          }
          else {
            libGAP_C_SUM_FIA( ee, e, libGAP_INTOBJ_INT(1) );  e = ee;
            libGAP_SET_ELM_PLIST( est, st, e );
            conj  = libGAP_ADDR_OBJ(pcp)[libGAP_PC_CONJUGATESINVERSE];
            iconj = libGAP_ADDR_OBJ(pcp)[libGAP_PC_INVERSECONJUGATESINVERSE];
            
            libGAP_C_DIFF_FIA( ge, libGAP_ELM_PLIST( list, libGAP_g ), libGAP_INTOBJ_INT(1) );
          }
        }
        libGAP_SET_ELM_PLIST( list, libGAP_g, ge );  libGAP_CHANGED_BAG( list );


        /* Reduce the exponent.  We delay putting the power onto the 
           stack until all the conjugates are on the stack.  The power is
           stored in  y, its exponent in ge.  */
        y = (libGAP_Obj)0;
        if( (e = libGAP_GET_EXPONENT( libGAP_g )) ) {
            if( !libGAP_LtInt( ge, e ) ) {
                mge = libGAP_ModInt( ge, e );
                libGAP_SET_ELM_PLIST( list, libGAP_g, mge ); libGAP_CHANGED_BAG( list );
            
                if( (y = libGAP_GET_POWER( libGAP_g )) ) ge = libGAP_QuoInt( ge, e );
            }
            else if( libGAP_LtInt( ge, libGAP_INTOBJ_INT(0) ) ) {
                mge = libGAP_ModInt( ge, e );
                libGAP_SET_ELM_PLIST( list, libGAP_g, mge ); libGAP_CHANGED_BAG( list );
            
                if( (y = libGAP_GET_IPOWER( libGAP_g )) ) {
                    ge = libGAP_QuoInt( ge, e );
                    if( !libGAP_IS_INT_ZERO( mge ) ) 
                        ge = libGAP_DiffInt( ge, libGAP_INTOBJ_INT(1) );
                    ge = libGAP_ProdInt( ge, libGAP_INTOBJ_INT(-1) );
                }
            }
        }
        
        hh = h = libGAP_GET_COMMUTE( libGAP_g );
        
        /* Find the place where we start to collect. */
        for( ; h > libGAP_g; h-- ) {
            e = libGAP_ELM_PLIST( list, h );
            if( !libGAP_IS_INT_ZERO(e) ) {
            
                if( libGAP_LtInt( libGAP_INTOBJ_INT(0), e ) ) {
                    if( libGAP_GET_CONJ( h, libGAP_g ) ) break;
                }
                else {
                    if( libGAP_GET_ICONJ( h, libGAP_g ) ) break;
                }
            }
        }

        /* Put those onto the stack, if necessary. */
        if( h > libGAP_g || y != (libGAP_Obj)0 ) 
          for( ; hh > h; hh-- ) {
            e = libGAP_ELM_PLIST( list, hh );
            if( !libGAP_IS_INT_ZERO(e) ) {
              libGAP_SET_ELM_PLIST( list, hh, libGAP_INTOBJ_INT(0) );
              
              if( libGAP_LtInt( libGAP_INTOBJ_INT(0), e ) ) {
                  x = libGAP_ELM_PLIST(  gens, hh );
              }
              else {
                  x = libGAP_ELM_PLIST( igens, hh );
                  libGAP_C_PROD_FIA( ee, e, libGAP_INTOBJ_INT(-1) );  e = ee;
              }
              
              libGAP_PUSH_STACK( x, e );
            }
          }
        
        
        for( ; h > libGAP_g; h-- ) {
          e = libGAP_ELM_PLIST( list, h );
          if( !libGAP_IS_INT_ZERO(e) ) {
            libGAP_SET_ELM_PLIST( list, h, libGAP_INTOBJ_INT(0) );
            
            x = (libGAP_Obj)0;
            if( libGAP_LtInt( libGAP_INTOBJ_INT(0), e ) ) x = libGAP_GET_CONJ( h, libGAP_g );
            else                            x = libGAP_GET_ICONJ( h, libGAP_g );
            
            if( x == (libGAP_Obj)0 )  {
              if( libGAP_LtInt( libGAP_INTOBJ_INT(0), e ) ) x = libGAP_ELM_PLIST(  gens, h );
              else                            x = libGAP_ELM_PLIST( igens, h );
            
            }
            if( libGAP_LtInt( e, libGAP_INTOBJ_INT(0) ) ) {
              libGAP_C_PROD_FIA( ee, e, libGAP_INTOBJ_INT(-1) );  e = ee;
            }
            libGAP_PUSH_STACK( x, e );
          }
        }
        
        if( y != (libGAP_Obj)0 ) libGAP_PUSH_STACK( y, ge );
      }

      while( st > bottom && libGAP_IS_INT_ZERO( libGAP_ELM_PLIST( est, st ) ) ) {
        w   = libGAP_ELM_PLIST( wst, st );
        syl = libGAP_INT_INTOBJ( libGAP_ELM_PLIST( sst, st ) ) + 2;
        if( syl > libGAP_LEN_PLIST( w ) ) {
          we = libGAP_DiffInt( libGAP_ELM_PLIST( west, st ), libGAP_INTOBJ_INT(1) );
          if( libGAP_EqInt( we, libGAP_INTOBJ_INT(0) ) ) { st--; }
          else {
            libGAP_SET_ELM_PLIST( west, st, we );
            libGAP_SET_ELM_PLIST( sst,  st, libGAP_INTOBJ_INT(1) );
            libGAP_SET_ELM_PLIST( est,  st, libGAP_ELM_PLIST( w, 2 ) );
            libGAP_CHANGED_BAG( west ); libGAP_CHANGED_BAG( est );
          }
        }
        else {
          libGAP_SET_ELM_PLIST( sst, st, libGAP_INTOBJ_INT(syl) );
          libGAP_SET_ELM_PLIST( est, st, libGAP_ELM_PLIST( w, syl+1 ));
          libGAP_CHANGED_BAG( est );
        }
      }
    }

    libGAP_ADDR_OBJ(pcp)[ libGAP_PC_STACK_POINTER ] = libGAP_INTOBJ_INT( bottom );
    return (libGAP_Obj)0;
}

libGAP_Obj libGAP_FuncCollectPolycyc (
    libGAP_Obj self,
    libGAP_Obj pcp,
    libGAP_Obj list,
    libGAP_Obj word )
{
  libGAP_CollectPolycyc( pcp, list, word );
  return (libGAP_Obj)0;
}

/****************************************************************************
**

*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * *
*/


/****************************************************************************
**

*V  GVarFuncs . . . . . . . . . . . . . . . . . . list of functions to export
*/
static libGAP_StructGVarFunc libGAP_GVarFuncs [] = {

    { "CollectPolycyclic", 3, "pcp, list, word",
      libGAP_FuncCollectPolycyc, "src/objcftl.c:CollectPolycyclic" },

    { 0 }

};


/****************************************************************************
**

*F  InitKernel( <module> )  . . . . . . . . initialise kernel data structures
*/
static libGAP_Int libGAP_InitKernel (
    libGAP_StructInitInfo *    libGAP_module )
{
    /* Keep track of variables containing library functions called in this */
    /* module.                                                             */

    /* init filters and functions                                          */
    libGAP_InitHdlrFuncsFromTable( libGAP_GVarFuncs );

    /* return success                                                      */
    return 0;
}


/****************************************************************************
**
*F  PostRestore( <module> ) . . . . . . . . . . . . . after restore workspace
*/
static libGAP_Int libGAP_PostRestore (
    libGAP_StructInitInfo *    libGAP_module )
{
    /* return success                                                      */
    return 0;
}


/****************************************************************************
**
*F  InitLibrary( <module> ) . . . . . . .  initialise library data structures
*/
static libGAP_Int libGAP_InitLibrary (
    libGAP_StructInitInfo *    libGAP_module )
{
    libGAP_AssGVar( libGAP_GVarName( "PC_NUMBER_OF_GENERATORS" ),
             libGAP_INTOBJ_INT( libGAP_PC_NUMBER_OF_GENERATORS ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_GENERATORS" ),
             libGAP_INTOBJ_INT( libGAP_PC_GENERATORS ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_INVERSES" ),
             libGAP_INTOBJ_INT( libGAP_PC_INVERSES ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_COMMUTE" ),
             libGAP_INTOBJ_INT( libGAP_PC_COMMUTE ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_POWERS" ),
             libGAP_INTOBJ_INT( libGAP_PC_POWERS ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_INVERSEPOWERS" ),
             libGAP_INTOBJ_INT( libGAP_PC_INVERSEPOWERS ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_EXPONENTS" ),
             libGAP_INTOBJ_INT( libGAP_PC_EXPONENTS ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_CONJUGATES" ),
             libGAP_INTOBJ_INT( libGAP_PC_CONJUGATES ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_INVERSECONJUGATES" ),
             libGAP_INTOBJ_INT( libGAP_PC_INVERSECONJUGATES ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_CONJUGATESINVERSE" ),
             libGAP_INTOBJ_INT( libGAP_PC_CONJUGATESINVERSE ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_INVERSECONJUGATESINVERSE" ),
             libGAP_INTOBJ_INT( libGAP_PC_INVERSECONJUGATESINVERSE ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_DEEP_THOUGHT_POLS" ),
             libGAP_INTOBJ_INT( libGAP_PC_DEEP_THOUGHT_POLS ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_DEEP_THOUGHT_BOUND" ),
             libGAP_INTOBJ_INT( libGAP_PC_DEEP_THOUGHT_BOUND ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_ORDERS" ), libGAP_INTOBJ_INT( libGAP_PC_ORDERS ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_WORD_STACK" ),
             libGAP_INTOBJ_INT( libGAP_PC_WORD_STACK ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_STACK_SIZE" ),
             libGAP_INTOBJ_INT( libGAP_PC_STACK_SIZE ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_WORD_EXPONENT_STACK" ),
             libGAP_INTOBJ_INT( libGAP_PC_WORD_EXPONENT_STACK ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_SYLLABLE_STACK" ),
             libGAP_INTOBJ_INT( libGAP_PC_SYLLABLE_STACK ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_EXPONENT_STACK" ),
             libGAP_INTOBJ_INT( libGAP_PC_EXPONENT_STACK ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_STACK_POINTER" ),
             libGAP_INTOBJ_INT( libGAP_PC_STACK_POINTER ) );
    libGAP_AssGVar( libGAP_GVarName( "PC_DEFAULT_TYPE" ), libGAP_INTOBJ_INT( libGAP_PC_DEFAULT_TYPE ) );

    /* init filters and functions                                          */
    libGAP_InitGVarFuncsFromTable( libGAP_GVarFuncs );

    /* return success                                                      */
    return 0;
}


/****************************************************************************
**
*F  InitInfoPcc() . . . . . . . . . . . . . . . . . . table of init functions
*/
static libGAP_StructInitInfo libGAP_module = {
    libGAP_MODULE_BUILTIN,                     /* type                           */
    "objcftl",                          /* name                           */
    0,                                  /* revision entry of c file       */
    0,                                  /* revision entry of h file       */
    0,                                  /* version                        */
    0,                                  /* crc                            */
    libGAP_InitKernel,                         /* initKernel                     */
    libGAP_InitLibrary,                        /* initLibrary                    */
    0,                                  /* checkInit                      */
    0,                                  /* preSave                        */
    0,                                  /* postSave                       */
    libGAP_PostRestore                         /* postRestore                    */
};

libGAP_StructInitInfo * libGAP_InitInfoPcc ( void )
{
    libGAP_FillInVersion( &libGAP_module );
    return &libGAP_module;
}


/****************************************************************************
**

*E  objcftl.c . . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/

