/* Copyright (C) 2005-2008 Damien Stehle.
Copyright (C) 2007 David Cade.

This file is part of the fplll Library.

The fplll Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The DPE Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the DPE Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */


#ifndef WRAPPER_H
#define WRAPPER_H

class wrapper
{
  double eta,delta;
  int max_exp;
  int max_exp_current;
  int n;
  int d;
  int prec;
  ZZ_mat<mpz_t>*B1;
  ZZ_mat<long int>*B2;
  ZZ_mat<double>*B3;
  bool fast_int,heuristic_int,proved_int;
  int fl_use;

  bool little(int kappa,int precision);
  int heuristicLoop(int precision);
  int provedLoop(int precision);
  int LastLLL();

public:
  wrapper(ZZ_mat<mpz_t>*B,int precision=0,double eta=0.51,double delta=0.99);
  int LLL();
  ZZ_mat<mpz_t>*GetBase(){return B1;};
};


#include "wrapper.cpp"

#endif

