/* Copyright (C) 2008 Xavier Pujol.

This file is part of the fplll Library.

The fplll Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The fplll Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the fplll Library; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

#ifndef TOOLS_H
#define TOOLS_H

#include "util.h"

void minkowskiTheorem(Float& result, FloatVect& rdiag);
void costEstimate(Float& cost, const Float& A, const FloatVect& rdiag, int dmax);

void gramSchmidt(const FloatMatrix& b, FloatMatrix& mu,
  FloatVect& rdiag, Float& basisMin);
void gramSchmidt(const FloatMatrix& b, FloatMatrix& mu, FloatVect& rdiag);

void getGSCoords(const FloatMatrix& matrix, const FloatMatrix& mu, const FloatVect& rdiag,
  const FloatVect& v, FloatVect& vcoord);
void babai(const FloatMatrix& matrix, const FloatMatrix& mu, const FloatVect& rdiag,
  const FloatVect& target, FloatVect& targetcoord);

const double PI = 3.1415926535897932;

const double hermite_constant[] = {
 1.000000000, 1.154710000, 1.259930000, 1.414220000, 1.515720000,
 1.665360000, 1.811450000, 2.000000000, 2.208179027, 2.438027308,
 2.691800385, 2.971988578, 3.281341424, 3.622894657, 4.000000000,
 4.000000000, 4.000000000, 4.000000000, 4.000000000, 4.000000000,
 4.000000000, 4.000000000, 4.000000000, 4.000000000, 4.248508708,
 4.512456559, 4.792802746, 5.090566050, 5.406828548, 5.742739541,
 6.099519736, 6.478465678, 6.880954460, 7.308448735, 7.762502022,
 8.244764358, 8.756988292, 9.301035251, 9.878882312, 10.49262938,
 10.81228308, 11.05102817, 11.28968041, 11.52824362, 11.76672137,
 12.00511703, 12.24343377, 12.48167456, 12.71984223, 12.95793944,
 13.19596869, 13.43393239, 13.67183277, 13.90967198, 14.14745207,
 14.38517495, 14.62284246, 14.86045637, 15.09801832, 15.33552993,
 15.57299269, 15.81040805, 16.04777742, 16.28510210, 16.52238336,
 16.75962243, 16.99682045, 17.23397855, 17.47109780, 17.70817921,
 17.94522379, 18.18223247, 18.41920616, 18.65614575, 18.89305208,
 19.12992595, 19.36676815, 19.60357944, 19.84036055, 20.07711217,
 20.31383498, 20.55052964, 20.78719678, 21.02383701, 21.26045092,
 21.49703908, 21.73360204, 21.97014034, 22.20665449, 22.44314501,
 22.67961237, 22.91605704, 23.15247948, 23.38888014, 23.62525944,
 23.86161779, 24.09795561, 24.33427329, 24.57057121, 24.80684974
};

#endif
