/* Copyright (C) 2005-2008Damien Stehle.
Copyright (C) 2007 David Cade.

This file is part of the fplll Library.

The fplll Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The DPE Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the DPE Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

#ifndef FPLLL_H
#define FPLLL_H

#include <cstdio>

#if defined(__sun)|| defined(__CYGWIN__)
#include <ieeefp.h>
extern "C" long double ldexpl(long double x, int exp);
#define NAN __builtin_nanf("")
#endif


#include "util.h"

#include "proved.h"
#include "heuristic.h"
#include "fast.h"
#include "wrapper.h"

#ifndef FAST_BUILD
  #include "fast_earlyred.h"
  #include "heuristic_early_red.h"
#endif

#endif
