/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.api.Interface;
import javajs.util.P3;
import org.jmol.c.STR;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.renderbio.RocketRenderer;
import org.jmol.renderbio.StrandsRenderer;
import org.jmol.shapebio.BioShape;

public class RocketsRenderer
extends StrandsRenderer {
    boolean isRockets;
    protected boolean helixRockets = true;
    protected boolean renderArrowHeads;
    protected P3[] cordMidPoints;
    private RocketRenderer rr;

    @Override
    protected void renderBioShape(BioShape bioShape) {
        if (!this.setupRR(bioShape, true)) {
            return;
        }
        this.calcRopeMidPoints();
        this.renderRockets();
        this.vwr.freeTempPoints(this.cordMidPoints);
    }

    protected void renderRockets() {
        if (this.rr == null) {
            this.rr = ((RocketRenderer)Interface.getInterface("org.jmol.renderbio.RocketRenderer")).set(this);
        }
        this.rr.renderRockets();
    }

    protected boolean setupRR(BioShape bioShape, boolean isRockets) {
        this.isRockets = isRockets;
        if (this.wireframeOnly) {
            this.renderStrands();
        } else if (!(this.wingVectors == null || this.isCarbohydrate || isRockets && this.isNucleic)) {
            boolean val;
            boolean bl = val = !this.vwr.getBoolean(603979900);
            if (!this.isNucleic && this.renderArrowHeads != val) {
                bioShape.falsifyMesh();
                this.renderArrowHeads = val;
            }
            return true;
        }
        return false;
    }

    protected void calcRopeMidPoints() {
        int midPointCount = this.monomerCount + 1;
        this.cordMidPoints = this.vwr.allocTempPoints(midPointCount);
        ProteinStructure proteinstructurePrev = null;
        int ptLastRocket = -10;
        P3 pt1 = new P3();
        P3 pt2 = new P3();
        for (int i = 0; i <= this.monomerCount; ++i) {
            P3 point = this.cordMidPoints[i];
            if (i < this.monomerCount && (this.helixRockets && this.structureTypes[i] == STR.HELIX || this.isRockets && this.structureTypes[i] == STR.SHEET)) {
                ProteinStructure proteinstructure = (ProteinStructure)this.monomers[i].getStructure();
                if (proteinstructure == proteinstructurePrev) {
                    pt1.add(pt2);
                    ptLastRocket = i;
                } else {
                    proteinstructurePrev = proteinstructure;
                    pt1.setT(proteinstructure.getAxisStartPoint());
                    pt2.sub2(proteinstructure.getAxisEndPoint(), pt1);
                    pt2.scale(1.0f / (float)(proteinstructure.nRes - 1));
                    if (ptLastRocket == i - 3) {
                        this.cordMidPoints[i - 1].ave(this.cordMidPoints[i - 2], pt1);
                    }
                }
                point.setT(pt1);
                continue;
            }
            if (ptLastRocket == i - 1 && i > 1) {
                this.cordMidPoints[i - 1].setT(this.cordMidPoints[i > 2 ? i - 3 : i - 2]);
            }
            point.setT(proteinstructurePrev == null ? this.controlPoints[i] : proteinstructurePrev.getAxisEndPoint());
            proteinstructurePrev = null;
        }
        this.controlPoints = this.cordMidPoints;
        this.calcScreenControlPoints();
    }
}

