/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.java.BS;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.modelset.Atom;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class MepCalculation
extends QuantumCalculation {
    protected static final int ONE_OVER_D = 0;
    protected static final int E_MINUS_D_OVER_2 = 1;
    protected static final int ONE_OVER_ONE_PLUS_D = 2;
    protected static final int E_MINUS_D = 3;
    protected int distanceMode = 0;
    private float[] potentials;
    private P3[] atomCoordAngstroms;
    private BS bsSelected;
    private Viewer vwr;
    protected Map<String, Object> htAtomicPotentials;
    protected String resourceName;

    public MepCalculation() {
        this.rangeBohrOrAngstroms = 8.0f;
        this.distanceMode = 0;
        this.unitFactor = 1.0f;
    }

    public void set(Viewer vwr) {
        this.vwr = vwr;
    }

    public void assignPotentials(Atom[] atoms, float[] potentials, BS bsAromatic, BS bsCarbonyl, BS bsIgnore, String data) {
        this.getAtomicPotentials(data, null);
        for (int i = 0; i < atoms.length; ++i) {
            float f;
            if (bsIgnore != null && bsIgnore.get(i)) {
                f = Float.NaN;
            } else {
                f = this.getTabulatedPotential(atoms[i]);
                if (Float.isNaN(f)) {
                    f = 0.0f;
                }
            }
            if (Logger.debugging) {
                Logger.debug(atoms[i].getInfo() + " " + f);
            }
            potentials[i] = f;
        }
    }

    public void setup(int calcType, float[] potentials, P3[] atomCoordAngstroms, BS bsSelected) {
        if (calcType >= 0) {
            this.distanceMode = calcType;
        }
        this.potentials = potentials;
        this.atomCoordAngstroms = atomCoordAngstroms;
        this.bsSelected = bsSelected;
    }

    public void calculate(VolumeData volumeData, BS bsSelected, P3[] xyz, Atom[] atoms, float[] potentials, int calcType) {
        this.setup(calcType, potentials, atoms, bsSelected);
        this.voxelData = volumeData.getVoxelData();
        this.countsXYZ = volumeData.getVoxelCounts();
        this.initialize(this.countsXYZ[0], this.countsXYZ[1], this.countsXYZ[2], null);
        this.setupCoordinates(volumeData.getOriginFloat(), volumeData.getVolumetricVectorLengths(), bsSelected, xyz, atoms, null, false);
        this.setXYZBohr(this.points);
        this.process();
    }

    public float getValueAtPoint(P3 pt) {
        float value = 0.0f;
        int i = this.bsSelected.nextSetBit(0);
        while (i >= 0) {
            float x = this.potentials[i];
            float d2 = pt.distanceSquared(this.atomCoordAngstroms[i]);
            value += this.valueFor(x, d2, this.distanceMode);
            i = this.bsSelected.nextSetBit(i + 1);
        }
        return value;
    }

    @Override
    protected void process() {
        int atomIndex = this.qmAtoms.length;
        while (--atomIndex >= 0) {
            this.thisAtom = this.qmAtoms[atomIndex];
            if (this.thisAtom == null) continue;
            float x0 = this.potentials[atomIndex];
            if (Logger.debugging) {
                Logger.debug("process map for atom " + atomIndex + this.thisAtom + "  charge=" + x0);
            }
            this.thisAtom.setXYZ(this, true);
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                float dX = this.X2[ix];
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    float dXY = dX + this.Y2[iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float[] fArray = this.voxelData[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + this.valueFor(x0, dXY + this.Z2[iz], this.distanceMode);
                    }
                }
            }
        }
    }

    public float valueFor(float x0, float d2, int distanceMode) {
        switch (distanceMode) {
            case 0: {
                return d2 == 0.0f ? x0 * Float.POSITIVE_INFINITY : x0 / (float)Math.sqrt(d2);
            }
            case 2: {
                return x0 / (1.0f + (float)Math.sqrt(d2));
            }
            case 1: {
                return x0 * (float)Math.exp(-Math.sqrt(d2) / 2.0);
            }
            case 3: {
                return x0 * (float)Math.exp(-Math.sqrt(d2));
            }
        }
        return x0;
    }

    protected float getTabulatedPotential(Atom atom) {
        String key;
        Object o;
        String name = atom.getAtomType();
        String g1 = atom.getGroup1('\u0000');
        String type = atom.getBioStructureTypeName();
        if (g1.length() == 0 && (g1 = atom.getGroup3(true)) == null) {
            g1 = "";
        }
        if ((o = this.htAtomicPotentials.get(key = g1 + name)) == null && type.length() > 0) {
            o = this.htAtomicPotentials.get("_" + type.charAt(0) + name);
        }
        return o instanceof Float ? ((Float)o).floatValue() : Float.NaN;
    }

    protected void getAtomicPotentials(String data, String resourceName) {
        BufferedReader br = null;
        this.htAtomicPotentials = new Hashtable<String, Object>();
        try {
            String line;
            BufferedReader bufferedReader = br = data == null ? FileManager.getBufferedReaderForResource(this.vwr, this, "org/jmol/quantum/", resourceName) : Rdr.getBR(data);
            while ((line = br.readLine()) != null) {
                String[] vs;
                if (line.startsWith("#") || (vs = PT.getTokens(line)).length < 2) continue;
                if (Logger.debugging) {
                    Logger.debug(line);
                }
                this.htAtomicPotentials.put(vs[0], Float.valueOf(PT.parseFloat(vs[1])));
            }
            br.close();
        }
        catch (Exception e) {
            Logger.error("Exception " + e.toString() + " in getResource " + resourceName);
            try {
                br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void createCube() {
    }
}

