/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Parser;

public class VaspPoscarReader
extends AtomSetCollectionReader {
    protected Lst<String> atomLabels;
    private boolean haveAtomLabels = true;
    private boolean atomsLabeledInline;
    private float scaleFac;
    protected int ac;
    protected String title;
    protected boolean quiet;
    protected String[] defaultLabels;
    protected String[] elementLabel;
    int radiusPt = Integer.MIN_VALUE;
    int elementPt = Integer.MIN_VALUE;

    protected void initializeReader() throws Exception {
        this.readStructure(null);
        this.continuing = false;
    }

    protected void readStructure(String titleMsg) throws Exception {
        this.title = this.rd().trim();
        this.readUnitCellVectors();
        this.readMolecularFormula();
        this.readCoordinates();
        this.asc.setAtomSetName(this.title + (titleMsg == null ? "" : "[" + titleMsg + "]"));
    }

    protected void finalizeSubclassReader() throws Exception {
        if (!this.haveAtomLabels && !this.atomsLabeledInline) {
            this.appendLoadNote("VASP POSCAR reader using pseudo atoms Al B C Db...");
        }
        this.finalizeReaderASCR();
    }

    protected void readUnitCellVectors() throws Exception {
        boolean isVolume;
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(true);
        this.scaleFac = this.parseFloatStr(this.rdline().trim());
        boolean bl = isVolume = this.scaleFac < 0.0f;
        if (isVolume) {
            this.scaleFac = (float)Math.pow(-this.scaleFac, 0.3333333333333333);
        }
        float[] unitCellData = new float[9];
        String s = this.rdline() + " " + this.rdline() + " " + this.rdline();
        Parser.parseStringInfestedFloatArray((String)s, null, (float[])unitCellData);
        if (isVolume) {
            M3 m = M3.newA9((float[])unitCellData);
            this.scaleFac /= m.determinant3();
        }
        if (this.scaleFac != 1.0f) {
            int i = 0;
            while (i < unitCellData.length) {
                int n = i++;
                unitCellData[n] = unitCellData[n] * this.scaleFac;
            }
        }
        this.addPrimitiveLatticeVector(0, unitCellData, 0);
        this.addPrimitiveLatticeVector(1, unitCellData, 3);
        this.addPrimitiveLatticeVector(2, unitCellData, 6);
    }

    protected void readMolecularFormula() throws Exception {
        String[] elementCounts;
        if (this.elementLabel == null) {
            this.elementLabel = PT.getTokens((String)this.discardLinesUntilNonBlank());
        }
        if (PT.parseInt((String)this.elementLabel[0]) == Integer.MIN_VALUE) {
            this.atomsLabeledInline = false;
            elementCounts = PT.getTokens((String)this.rdline());
            while (this.line != null && (elementCounts.length == 0 || this.parseIntStr(elementCounts[0]) == Integer.MIN_VALUE)) {
                elementCounts = PT.getTokens((String)this.rdline());
            }
        } else {
            elementCounts = this.elementLabel;
            this.elementLabel = PT.split((String)this.title, (String)" ");
            if (this.elementLabel.length != elementCounts.length || this.elementLabel[0].length() > 2) {
                this.elementLabel = PT.split((String)"Al B C Db Eu F Ga Hf I K Li Mn N O P Ru S Te U V W Xe Yb Zn", (String)" ");
                this.haveAtomLabels = false;
            }
        }
        String[] labels = this.elementLabel;
        SB mf = new SB();
        this.atomLabels = new Lst();
        this.ac = 0;
        for (int i = 0; i < elementCounts.length; ++i) {
            int n = Integer.parseInt(elementCounts[i]);
            this.ac += n;
            String label = labels[i];
            mf.append(" ").append(label).appendI(n);
            int j = n;
            while (--j >= 0) {
                this.atomLabels.addLast((Object)label);
            }
        }
        String s = mf.toString();
        if (!this.quiet) {
            this.appendLoadNote(this.ac + " atoms identified for" + s);
        }
        this.asc.newAtomSet();
        this.asc.setAtomSetName(s);
    }

    protected void readCoordinates() throws Exception {
        boolean isCartesian;
        boolean isSelective = this.discardLinesUntilNonBlank().toLowerCase().contains("selective");
        if (isSelective) {
            this.rd();
        }
        if (isCartesian = this.line.toLowerCase().contains("cartesian")) {
            this.setFractionalCoordinates(false);
        }
        for (int i = 0; i < this.ac; ++i) {
            String label;
            float radius = Float.NaN;
            String[] tokens = PT.getTokens((String)this.rdline());
            if (this.radiusPt == Integer.MIN_VALUE) {
                int j = tokens.length;
                while (--j > 2) {
                    if (tokens[j].equals("radius")) {
                        this.radiusPt = j + 1;
                        continue;
                    }
                    if (this.getElement(tokens[j]) == null) continue;
                    this.elementPt = j;
                    this.atomsLabeledInline = true;
                }
            }
            if (this.radiusPt >= 0) {
                radius = this.parseFloatStr(tokens[this.radiusPt]);
            }
            String string = label = this.atomsLabeledInline ? tokens[this.elementPt] : (String)this.atomLabels.get(i);
            if (isCartesian) {
                for (int j = 0; j < 3; ++j) {
                    tokens[j] = "" + this.parseFloatStr(tokens[j]) * this.scaleFac;
                }
            }
            Atom atom = this.addAtomXYZSymName(tokens, 0, null, label);
            if (!Float.isNaN(radius)) {
                atom.radius = radius * this.scaleFac;
            }
            if (this.asc.bsAtoms == null) continue;
            this.asc.bsAtoms.set(atom.index);
        }
    }

    protected String getElement(String token) {
        String s = null;
        switch (token.length()) {
            default: {
                String string = s = token.length() > 2 ? token.substring(0, 2) : null;
                if (s != null && JmolAdapter.getElementNumber((String)s) >= 0) {
                    return s;
                }
            }
            case 1: {
                s = token.substring(0);
                if (JmolAdapter.getElementNumber((String)s) < 0) break;
                return s;
            }
            case 0: 
        }
        return null;
    }

    protected String rdline() throws Exception {
        this.rd();
        if (this.line != null && this.line.startsWith("[")) {
            this.line = this.line.substring(this.line.indexOf("]") + 1).trim();
        }
        return this.line;
    }
}

