/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.CU;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Pixelator;

class TextRenderer {
    private int height;
    private int ascent;
    private int width;
    private int mapWidth;
    private int size;
    private byte[] tmap;
    private boolean isInvalid;
    private static final byte[] translucency = new byte[]{7, 6, 5, 4, 3, 2, 1, 8};
    private static boolean working;
    private static final Map<Font, Map<String, TextRenderer>> htFont3d;
    private static final Map<Font, Map<String, TextRenderer>> htFont3dAntialias;

    static synchronized void clearFontCache() {
        if (working) {
            return;
        }
        htFont3d.clear();
        htFont3dAntialias.clear();
    }

    static int plot(int x, int y, int z, int argb, int bgargb, String text, Font font3d, Graphics3D g3d, JmolRendererInterface jr, boolean antialias) {
        if (text.length() == 0) {
            return 0;
        }
        if (text.indexOf("<su") >= 0 || text.indexOf("<color") >= 0) {
            return TextRenderer.plotByCharacter(x, y, z, argb, bgargb, text, font3d, g3d, jr, antialias);
        }
        int offset = font3d.getAscent();
        TextRenderer text3d = TextRenderer.getPlotText3D(x, y -= offset, g3d, text, font3d, antialias);
        if (text3d.isInvalid) {
            return text3d.width;
        }
        if (antialias && (argb & 0xC0C0C0) == 0) {
            argb |= 0x40404;
        }
        int textHeight = text3d.height;
        int textWidth = text3d.width;
        byte[] tmap = text3d.tmap;
        Graphics3D g = g3d;
        int width = g.width;
        int height = g.height;
        int[] zbuf = g.zbuf;
        Pixelator p = g.pixel;
        int tLog = g.translucencyLog;
        if (jr != null || (x < 0 || x + text3d.width > width || y < 0 || y + text3d.height > height) && (jr = g3d) != null) {
            int off = 0;
            for (int i = 0; i < textHeight; ++i) {
                for (int j = 0; j < textWidth; ++j) {
                    byte shade;
                    if ((shade = tmap[off++]) == 0) continue;
                    jr.plotImagePixel(argb, x + j, y + i, z, shade, bgargb, width, height, zbuf, p, tLog);
                }
            }
        } else {
            int i = 0;
            int off = 0;
            int pbufOffset = y * width + x;
            while (i < textHeight) {
                for (int j = 0; j < textWidth; ++j) {
                    p.addImagePixel(tmap[off++], tLog, pbufOffset++, z, argb, bgargb);
                }
                ++i;
                pbufOffset += width - textWidth;
            }
        }
        return text3d.width;
    }

    private static int plotByCharacter(int x, int y, int z, int argb, int bgargb, String text, Font font3d, Graphics3D g3d, JmolRendererInterface jmolRenderer, boolean antialias) {
        int w = 0;
        int len = text.length();
        int suboffset = Math.round((float)font3d.getHeight() * 0.25f);
        int supoffset = -Math.round((float)font3d.getHeight() * 0.3f);
        int argb0 = 0;
        for (int i = 0; i < len; ++i) {
            if (text.charAt(i) == '<') {
                if (i + 5 < len && text.substring(i, i + 6).equals("<color")) {
                    argb0 = argb;
                    int pt = text.indexOf(">", i);
                    if (pt < 0) continue;
                    argb = CU.getArgbFromString(text.substring(i + 7, pt).trim());
                    i = pt;
                    continue;
                }
                if (i + 7 < len && text.substring(i, i + 8).equals("</color>")) {
                    i += 7;
                    argb = argb0;
                    continue;
                }
                if (i + 4 < len && text.substring(i, i + 5).equals("<sub>")) {
                    i += 4;
                    y += suboffset;
                    continue;
                }
                if (i + 4 < len && text.substring(i, i + 5).equals("<sup>")) {
                    i += 4;
                    y += supoffset;
                    continue;
                }
                if (i + 5 < len && text.substring(i, i + 6).equals("</sub>")) {
                    i += 5;
                    y -= suboffset;
                    continue;
                }
                if (i + 5 < len && text.substring(i, i + 6).equals("</sup>")) {
                    i += 5;
                    y -= supoffset;
                    continue;
                }
            }
            int width = TextRenderer.plot(x + w, y, z, argb, bgargb, text.substring(i, i + 1), font3d, g3d, jmolRenderer, antialias);
            w += width;
        }
        return w;
    }

    private TextRenderer(String text, Font font3d) {
        this.ascent = font3d.getAscent();
        this.height = font3d.getHeight();
        this.width = font3d.stringWidth(text);
        if (this.width == 0) {
            return;
        }
        this.mapWidth = this.width;
        this.size = this.mapWidth * this.height;
    }

    private static synchronized TextRenderer getPlotText3D(int x, int y, Graphics3D g3d, String text, Font font3d, boolean antialias) {
        working = true;
        Map<Font, Map<String, TextRenderer>> ht = antialias ? htFont3dAntialias : htFont3d;
        Map<String, TextRenderer> htForThisFont = ht.get(font3d);
        TextRenderer text3d = null;
        boolean newFont = false;
        boolean newText = false;
        if (htForThisFont != null) {
            text3d = htForThisFont.get(text);
        } else {
            htForThisFont = new Hashtable<String, TextRenderer>();
            newFont = true;
        }
        if (text3d == null) {
            text3d = new TextRenderer(text, font3d);
            newText = true;
        }
        boolean bl = text3d.isInvalid = text3d.width == 0 || x + text3d.width <= 0 || x >= g3d.width || y + text3d.height <= 0 || y >= g3d.height;
        if (text3d.isInvalid) {
            return text3d;
        }
        if (newFont) {
            ht.put(font3d, htForThisFont);
        }
        if (newText) {
            text3d.setTranslucency(text, font3d, g3d);
            htForThisFont.put(text, text3d);
        }
        working = false;
        return text3d;
    }

    private void setTranslucency(String text, Font font3d, Graphics3D g3d) {
        int[] pixels = g3d.apiPlatform.getTextPixels(text, font3d, g3d.platform.getGraphicsForTextOrImage(this.mapWidth, this.height), g3d.platform.offscreenImage, this.mapWidth, this.height, this.ascent);
        if (pixels == null) {
            return;
        }
        this.tmap = new byte[this.size];
        int i = pixels.length;
        while (--i >= 0) {
            int p = pixels[i] & 0xFF;
            if (p == 0) continue;
            this.tmap[i] = translucency[p >> 5];
        }
    }

    static {
        htFont3d = new Hashtable<Font, Map<String, TextRenderer>>();
        htFont3dAntialias = new Hashtable<Font, Map<String, TextRenderer>>();
    }
}

