/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Vibration;

public class BilbaoReader
extends AtomSetCollectionReader {
    private boolean getHigh;
    private boolean getSym;
    private boolean normDispl;
    private boolean doDisplace;
    private String kvec;
    private int i0;
    private int nAtoms;
    private boolean isBCSfile;

    public void initializeReader() throws Exception {
        this.normDispl = !this.checkFilterKey("NONORM");
        this.doDisplace = this.isTrajectory;
        this.getSym = true;
        this.getHigh = this.checkFilterKey("HIGH") && !this.doDisplace;
        this.asc.vibScale = 1;
        this.appendLoadNote("Bilbao Crystallographic Server\ncryst@wm.lc.ehu.es");
        if (this.rd().indexOf("<") < 0) {
            this.readBilbaoDataFile();
            this.continuing = false;
        }
    }

    protected boolean checkLine() throws Exception {
        if (this.line.contains(">Bilbao Crystallographic Server<")) {
            this.line = this.line.substring(this.line.lastIndexOf(">") + 1).trim();
            if (this.line.length() > 0) {
                this.appendLoadNote(this.line + "\n");
            }
        } else if (this.line.contains("High symmetry structure<")) {
            if (this.getHigh) {
                this.readBilbaoFormat("high symmetry", Float.NaN);
            }
        } else if (this.line.contains("Low symmetry structure<")) {
            if (!this.doDisplace) {
                this.readBilbaoFormat("low symmetry", Float.NaN);
            }
        } else if (this.line.contains("structure in the subgroup basis<")) {
            if (!this.doDisplace) {
                this.readBilbaoFormat("high symmetry in the subgroup basis", Float.NaN);
            }
        } else if (this.line.contains("Low symmetry structure after the origin shift<")) {
            this.readBilbaoFormat("low symmetry after origin shift", Float.NaN);
        } else if (this.line.contains("<h3>Irrep:")) {
            this.readVirtual();
        }
        return true;
    }

    private void readBilbaoDataFile() throws Exception {
        this.isBCSfile = true;
        this.checkComment();
        while (this.line != null) {
            this.readBilbaoFormat(null, Float.NaN);
            if (this.rdLine() == null || this.line.indexOf("##disp-par##") < 0) {
                this.applySymmetryAndSetTrajectory();
                continue;
            }
            this.readDisplacements(1.0f);
            this.rdLine();
        }
    }

    private boolean checkComment() {
        if (!this.line.startsWith("#") || this.line.indexOf("disp-par") >= 0) {
            return false;
        }
        if (this.isBCSfile) {
            this.appendLoadNote(this.line);
            if (this.line.startsWith("# Title:")) {
                this.asc.setAtomSetName(this.line.substring(8).trim());
            }
        }
        return true;
    }

    private void readBilbaoFormat(String string, float f) throws Exception {
        int n;
        this.setFractionalCoordinates(true);
        if (!this.doGetModel(++this.modelNumber, string)) {
            return;
        }
        this.asc.newAtomSet();
        this.setTitle(string);
        int n2 = this.line.indexOf("<pre>");
        if (n2 >= 0) {
            this.line = this.line.substring(n2 + 5);
        }
        int n3 = this.parseIntStr(this.line);
        while (n3 < 0 && this.rdLine() != null) {
            n3 = this.parseIntStr(this.line);
        }
        this.setSpaceGroupName("bilbao:" + n3);
        float[] fArray = new float[6];
        this.fillFloatArray(null, 0, fArray);
        for (n = 0; n < 6; ++n) {
            this.setUnitCellItem(n, fArray[n]);
        }
        this.i0 = this.asc.ac;
        n = this.nAtoms = this.parseIntStr(this.rdLine());
        while (--n >= 0) {
            String[] stringArray = BilbaoReader.getTokensStr((String)this.rdLine());
            if (!this.getSym && stringArray[1].contains("_")) continue;
            this.addAtomXYZSymName(stringArray, 3, stringArray[0], stringArray[0] + stringArray[1]);
        }
        if (Float.isNaN(f)) {
            if (n2 >= 0) {
                this.applySymmetryAndSetTrajectory();
            }
            return;
        }
        this.line = null;
        this.readDisplacements(f);
    }

    private void readDisplacements(float f) throws Exception {
        Atom atom;
        int n;
        for (n = 0; n < this.nAtoms; ++n) {
            if (this.line == null) {
                this.rdLine();
            }
            atom = PT.split((String)this.line, (String)"x|x");
            if (this.getSym || !atom[0].contains("_")) {
                this.asc.atoms[this.i0 + n].vib = V3.new3((float)this.parseFloatStr((String)atom[1]), (float)this.parseFloatStr((String)atom[2]), (float)this.parseFloatStr((String)atom[3]));
            }
            this.line = null;
        }
        this.applySymmetryAndSetTrajectory();
        n = this.asc.ac;
        while (--n >= this.i0) {
            atom = this.asc.atoms[n];
            if (atom.vib == null) continue;
            Vibration vibration = new Vibration();
            vibration.setT((T3)atom.vib);
            atom.vib = vibration;
            this.asc.getSymmetry().toCartesian((T3)vibration, true);
            vibration.scale(1.0f / f);
        }
        this.appendLoadNote(this.asc.ac - this.i0 + " displacements");
    }

    private void setTitle(String string) {
        if (string != null) {
            this.asc.setAtomSetName(string);
            this.appendLoadNote(string);
        }
    }

    private String rdLine() throws Exception {
        while (this.rd() != null && (this.line.length() == 0 || this.checkComment())) {
        }
        return this.line;
    }

    private void readVirtual() throws Exception {
        if (this.line.contains("<h3>K-vector:")) {
            this.kvec = this.line.substring(this.line.indexOf("("), this.line.indexOf(")") + 1);
        }
        String string = this.getLinesUntil("\"BCS\"");
        int n = string.indexOf("The amplitude");
        n = string.indexOf("=", n);
        String string2 = string.substring(n + 2, string.indexOf(" ", n + 2));
        float f = this.normDispl ? this.parseFloatStr(string2) : 1.0f;
        String string3 = this.getAttr(string, "irrep");
        if (string3.indexOf(":") >= 0) {
            string3 = string3.substring(0, string3.indexOf(":"));
        }
        this.line = this.line.substring(this.line.indexOf("value=") + 7);
        this.readBilbaoFormat(this.kvec + " " + string3 + " (" + string2 + " Ang.)", f);
    }

    private String getAttr(String string, String string2) {
        int n = string.indexOf("value", string.indexOf("\"" + string2 + "\""));
        string = PT.getQuotedStringAt((String)string, (int)n);
        string = PT.rep((String)string, (String)"<i>", (String)"");
        string = PT.rep((String)string, (String)"</i>", (String)"");
        return string.trim();
    }

    private String getLinesUntil(String string) throws Exception {
        SB sB = new SB();
        do {
            sB.append(this.line);
        } while (!this.rd().contains(string));
        return sB.toString();
    }
}

