/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.BC;
import javajs.util.OC;
import javajs.util.SB;

public class BinaryDocument
extends BC
implements GenericBinaryDocument {
    protected DataInputStream stream;
    protected boolean isRandom = false;
    protected boolean isBigEndian = true;
    byte[] t8 = new byte[8];
    long nBytes;
    OC out;

    @Override
    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.out != null) {
            this.out.closeChannel();
        }
    }

    @Override
    public void setStream(BufferedInputStream bufferedInputStream, boolean bl) {
        if (bufferedInputStream != null) {
            this.stream = new DataInputStream(bufferedInputStream);
        }
        this.isBigEndian = bl;
    }

    @Override
    public void setStreamData(DataInputStream dataInputStream, boolean bl) {
        if (dataInputStream != null) {
            this.stream = dataInputStream;
        }
        this.isBigEndian = bl;
    }

    public void setRandom(boolean bl) {
        this.isRandom = bl;
    }

    @Override
    public byte readByte() throws Exception {
        ++this.nBytes;
        return this.ioReadByte();
    }

    private byte ioReadByte() throws Exception {
        byte by = this.stream.readByte();
        if (this.out != null) {
            this.out.writeByteAsInt(by);
        }
        return by;
    }

    @Override
    public int readByteArray(byte[] byArray, int n, int n2) throws Exception {
        int n3 = this.ioRead(byArray, n, n2);
        if (n3 > 0) {
            this.nBytes += (long)n3;
        }
        int n4 = n3;
        if (n3 > 0 && n3 < n2) {
            while (n4 < n2 && n3 > 0) {
                n3 = this.ioRead(byArray, n4, n2 - n4);
                if (n3 <= 0) continue;
                this.nBytes += (long)n3;
                n4 += n3;
            }
        }
        return n4;
    }

    private int ioRead(byte[] byArray, int n, int n2) throws Exception {
        int n3 = this.stream.read(byArray, n, n2);
        if (n3 > 0 && this.out != null) {
            this.writeBytes(byArray, n, n3);
        }
        return n3;
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws Exception {
        this.out.write(byArray, n, n2);
    }

    @Override
    public String readString(int n) throws Exception {
        byte[] byArray = new byte[n];
        int n2 = this.readByteArray(byArray, 0, n);
        return new String(byArray, 0, n2, "UTF-8");
    }

    @Override
    public short readShort() throws Exception {
        this.nBytes += 2L;
        short s = this.isBigEndian ? this.ioReadShort() : (short)(this.ioReadByte() & 0xFF | (this.ioReadByte() & 0xFF) << 8);
        return s;
    }

    private short ioReadShort() throws Exception {
        short s = this.stream.readShort();
        if (this.out != null) {
            this.writeShort(s);
        }
        return s;
    }

    public void writeShort(short s) throws Exception {
        this.out.writeByteAsInt(s >> 8);
        this.out.writeByteAsInt(s);
    }

    @Override
    public int readIntLE() throws Exception {
        this.nBytes += 4L;
        return this.readLEInt();
    }

    @Override
    public int readInt() throws Exception {
        this.nBytes += 4L;
        return this.isBigEndian ? this.ioReadInt() : this.readLEInt();
    }

    private int ioReadInt() throws Exception {
        int n = this.stream.readInt();
        if (this.out != null) {
            this.writeInt(n);
        }
        return n;
    }

    public void writeInt(int n) throws Exception {
        this.out.writeByteAsInt(n >> 24);
        this.out.writeByteAsInt(n >> 16);
        this.out.writeByteAsInt(n >> 8);
        this.out.writeByteAsInt(n);
    }

    @Override
    public int swapBytesI(int n) {
        return n >> 24 & 0xFF | (n >> 16 & 0xFF) << 8 | (n >> 8 & 0xFF) << 16 | (n & 0xFF) << 24;
    }

    @Override
    public short swapBytesS(short s) {
        return (short)(s >> 8 & 0xFF | (s & 0xFF) << 8);
    }

    @Override
    public int readUnsignedShort() throws Exception {
        this.nBytes += 2L;
        int n = this.ioReadByte() & 0xFF;
        int n2 = this.ioReadByte() & 0xFF;
        return this.isBigEndian ? (n << 8) + n2 : (n2 << 8) + n;
    }

    @Override
    public long readLong() throws Exception {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadLong() : (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 54;
    }

    private long ioReadLong() throws Exception {
        long l = this.stream.readLong();
        if (this.out != null) {
            this.writeLong(l);
        }
        return l;
    }

    public void writeLong(long l) throws Exception {
        this.writeInt((int)(l >> 32 & 0xFFFFFFFFL));
        this.writeInt((int)(l & 0xFFFFFFFFL));
    }

    private int readLEInt() throws Exception {
        this.ioRead(this.t8, 0, 4);
        return BinaryDocument.bytesToInt(this.t8, 0, false);
    }

    @Override
    public float readFloat() throws Exception {
        return BinaryDocument.intToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws Exception {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadDouble() : Double.longBitsToDouble(this.readLELong());
    }

    private double ioReadDouble() throws Exception {
        double d = this.stream.readDouble();
        if (this.out != null) {
            this.writeLong(Double.doubleToRawLongBits(d));
        }
        return d;
    }

    private long readLELong() throws Exception {
        return (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 56;
    }

    @Override
    public void seek(long l) {
        try {
            if (l == this.nBytes) {
                return;
            }
            if (l < this.nBytes) {
                this.stream.reset();
                if (this.out != null && this.nBytes != 0L) {
                    this.out.reset();
                }
                this.nBytes = 0L;
            } else {
                l -= this.nBytes;
            }
            if (this.out == null) {
                this.stream.skipBytes((int)l);
            } else {
                this.readByteArray(new byte[(int)l], 0, (int)l);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    @Override
    public long getPosition() {
        return this.nBytes;
    }

    @Override
    public void setOutputChannel(OC oC) {
        this.out = oC;
    }

    @Override
    public SB getAllDataFiles(String string, String string2) {
        return null;
    }

    @Override
    public void getAllDataMapped(String string, String string2, Map<String, String> map) {
    }
}

