/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import org.jmol.adapter.readers.xml.JmolXmlHandler;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.util.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlHandler
extends DefaultHandler
implements JmolXmlHandler {
    private XmlReader xmlReader;
    private String debugContext = "";

    @Override
    public void parseXML(XmlReader xmlReader, Object object, BufferedReader bufferedReader) throws Exception {
        this.xmlReader = xmlReader;
        XMLReader xMLReader = (XMLReader)object;
        xMLReader.setFeature("http://xml.org/sax/features/validation", false);
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xMLReader.setEntityResolver(this);
        xMLReader.setContentHandler(this);
        xMLReader.setErrorHandler(this);
        InputSource inputSource = new InputSource(bufferedReader);
        inputSource.setSystemId("foo");
        xMLReader.parse(inputSource);
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.xmlReader.atts.clear();
        int n = attributes.getLength();
        while (--n >= 0) {
            this.xmlReader.atts.put(attributes.getLocalName(n), attributes.getValue(n));
        }
        if (Logger.debugging) {
            this.debugContext = this.debugContext + " " + string2;
            Logger.debug((String)this.debugContext);
        }
        this.xmlReader.processStartElement(string2);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (Logger.debugging) {
            Logger.debug((String)"");
            this.debugContext = this.debugContext.substring(0, this.debugContext.lastIndexOf(" "));
        }
        this.xmlReader.processEndElement(string2);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.xmlReader.keepChars) {
            this.xmlReader.chars = this.xmlReader.chars == null ? new String(cArray, n, n2) : this.xmlReader.chars + new String(cArray, n, n2);
        }
    }

    public InputSource resolveEntity(String string, String string2, String string3, String string4) {
        if (Logger.debugging) {
            Logger.debug((String)("Not resolving this:\n      name: " + string + "\n  systemID: " + string4 + "\n  publicID: " + string2 + "\n   baseURI: " + string3));
        }
        return null;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (Logger.debugging) {
            Logger.debug((String)("Jmol SAX EntityResolver not resolving:\n  publicID: " + string + "\n  systemID: " + string2));
        }
        return null;
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        Logger.error((String)("SAX ERROR:" + sAXParseException.getMessage()));
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        Logger.error((String)("SAX FATAL:" + sAXParseException.getMessage()));
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        Logger.warn((String)("SAX WARNING:" + sAXParseException.getMessage()));
    }
}

