/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javajs.util.T3;
import org.jmol.java.BS;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;

class IsoIntersectReader
extends AtomDataReader {
    private static final int TYPE_FUNCTION = 0;
    private static final int TYPE_SUM = 1;
    private static final int TYPE_DIFF = 2;
    private static final int TYPE_MAX = 3;
    private static final int TYPE_DIFF_PAIR = 4;
    private final BS myBsA = new BS();
    private final BS myBsB = new BS();
    private BS[][] bsAtomMinMax = new BS[2][];
    private Object[] func;
    private int funcType = 0;
    private float[] thisPlaneB;
    private final float[] values = new float[2];

    IsoIntersectReader() {
    }

    @Override
    void init(SurfaceGenerator surfaceGenerator) {
        this.initADR(surfaceGenerator);
    }

    @Override
    protected boolean readVolumeParameters(boolean bl) {
        this.setup(bl);
        if (bl) {
            return false;
        }
        this.initializeVolumetricData();
        this.volumeData.setUnitVectors();
        this.thisPlaneB = new float[this.volumeData.getYzCount()];
        this.voxelSource = new int[this.volumeData.nPoints];
        this.vl0 = this.volumeData.volumetricVectorLengths[0];
        this.vl1 = this.volumeData.volumetricVectorLengths[1];
        this.vl2 = this.volumeData.volumetricVectorLengths[2];
        this.bsAtomMinMax[0] = new BS[this.nPointsX];
        this.getAtomMinMax(this.myBsA, this.bsAtomMinMax[0]);
        this.bsAtomMinMax[1] = new BS[this.nPointsX];
        this.getAtomMinMax(this.myBsB, this.bsAtomMinMax[1]);
        return true;
    }

    @Override
    protected void setup(boolean bl) {
        this.setup2();
        this.params.fullyLit = true;
        this.point = this.params.point;
        if (this.params.func instanceof String) {
            this.funcType = this.params.func.equals("a-b") ? 2 : (this.params.func.equals("a+b") ? 1 : 3);
        } else if (this.params.func == null || this.atomDataServer == null) {
            this.funcType = 2;
        } else {
            this.func = (Object[])this.params.func;
        }
        if (this.contactPair == null) {
            BS bS = this.params.intersection[0];
            BS bS2 = this.params.intersection[1];
            BS bS3 = new BS();
            bS3.or(bS);
            bS3.or(bS2);
            this.doUseIterator = true;
            this.getAtoms(bS3, this.doAddHydrogens, true, true, false, false, false, Float.NaN);
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                this.myBsA.set(this.myIndex[n]);
                n = bS.nextSetBit(n + 1);
            }
            n = bS2.nextSetBit(0);
            while (n >= 0) {
                this.myBsB.set(this.myIndex[n]);
                n = bS2.nextSetBit(n + 1);
            }
            this.setHeader("VDW intersection surface", this.params.calculationType);
            this.setRanges(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax, 0.0f);
            this.margin = 5.0f;
        } else {
            this.setVolumeData();
        }
        this.isXLowToHigh = true;
        this.isProgressive = true;
    }

    @Override
    public float[] getPlane(int n) {
        if (this.yzCount == 0) {
            this.initPlanes();
        }
        this.thisX = n;
        this.thisPlane = this.yzPlanes[n % 2];
        if (this.contactPair == null) {
            this.thisAtomSet = this.bsAtomMinMax[0][n];
            this.resetPlane(Float.MAX_VALUE);
            this.markSphereVoxels(0.0f, this.params.distance);
            this.thisPlane = this.thisPlaneB;
            this.thisAtomSet = this.bsAtomMinMax[1][n];
            this.resetPlane(Float.MAX_VALUE);
            this.markSphereVoxels(0.0f, this.params.distance);
        } else {
            this.markPlaneVoxels(this.contactPair.myAtoms[0], this.contactPair.radii[0]);
            this.thisPlane = this.thisPlaneB;
            this.markPlaneVoxels(this.contactPair.myAtoms[1], this.contactPair.radii[1]);
        }
        this.thisPlane = this.yzPlanes[n % 2];
        if (!this.setVoxels()) {
            this.resetPlane(0.0f);
        }
        if (this.contactPair == null) {
            this.unsetVoxelData();
        }
        return this.thisPlane;
    }

    private boolean setVoxels() {
        for (int i = 0; i < this.yzCount; ++i) {
            float f = this.thisPlane[i];
            float f2 = this.thisPlaneB[i];
            float f3 = this.getValueAB(f, f2);
            if (Float.isNaN(f3)) {
                return false;
            }
            this.thisPlane[i] = f3;
        }
        return true;
    }

    private float getValueAB(float f, float f2) {
        if (f == Float.MAX_VALUE || f2 == Float.MAX_VALUE || Float.isNaN(f) || Float.isNaN(f2)) {
            return Float.MAX_VALUE;
        }
        switch (this.funcType) {
            case 1: {
                return f + f2;
            }
            case 2: 
            case 4: {
                return f - f2;
            }
            case 3: {
                return f > f2 ? f : f2;
            }
        }
        this.values[0] = f;
        this.values[1] = f2;
        return this.atomDataServer.evalFunctionFloat(this.func[0], this.func[1], this.values);
    }

    @Override
    public float getValueAtPoint(T3 t3, boolean bl) {
        return this.getValueAB(this.getValueAtPoint2(t3, this.myBsA), this.getValueAtPoint2(t3, this.myBsB));
    }

    private float getValueAtPoint2(T3 t3, BS bS) {
        float f = Float.MAX_VALUE;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            float f2 = t3.distance(this.atomXyz[n]) - this.atomRadius[n];
            if (f2 < f) {
                f = f2;
            }
            n = bS.nextSetBit(n + 1);
        }
        return f == Float.MAX_VALUE ? Float.NaN : f;
    }
}

