/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javajs.api.GenericBinaryDocument;
import javajs.api.GenericPlatform;
import javajs.api.GenericZipTools;
import javajs.util.LimitedLineReader;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.ZipTools;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolZipUtilities;
import org.jmol.io.JmolBinary;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class JmolUtil
implements JmolZipUtilities {
    private static final String DELPHI_BINARY_MAGIC_NUMBER = "\u0014\u0000\u0000\u0000";

    private static SB checkSpecialData(GenericZipTools genericZipTools, InputStream inputStream, String[] stringArray) {
        boolean bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".spardir/") && stringArray[i].indexOf("_spartandir") < 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        SB sB = new SB();
        sB.append("Zip File Directory: ").append("\n").append(Escape.eAS(stringArray, true)).append("\n");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        genericZipTools.getAllZipData(inputStream, new String[0], "", "Molecule", hashtable);
        String string = "|";
        String string2 = (String)hashtable.get(string + "output");
        if (string2 == null) {
            string = "|" + stringArray[1];
            string2 = (String)hashtable.get(string + "output");
        }
        sB.append(string2);
        String[] stringArray2 = JmolUtil.getSpartanFileList(string, JmolUtil.getSpartanDirs(string2));
        for (int i = 2; i < stringArray2.length; ++i) {
            String string3 = stringArray2[i];
            if (hashtable.containsKey(string3)) {
                sB.append((String)hashtable.get(string3));
                continue;
            }
            sB.append(string3 + "\n");
        }
        return sB;
    }

    static String[] checkSpecialInZip(String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length < 2) {
            stringArray2 = null;
        } else {
            String string = stringArray[1];
            if (string.endsWith(".spardir/") || stringArray.length == 2) {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "";
                stringArray2 = stringArray3;
                stringArray3[1] = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
            } else {
                stringArray2 = null;
            }
        }
        return stringArray2;
    }

    private static String[] getSpartanDirs(String string) {
        String[] stringArray;
        if (string == null) {
            return new String[0];
        }
        Lst<String> lst = new Lst<String>();
        String string2 = "";
        if (!string.startsWith("java.io.FileNotFoundException") && !string.startsWith("FILE NOT FOUND") && string.indexOf("<html") < 0) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.equals(")")) {
                        lst.addLast(string2);
                    } else if (string3.equals("Start-") && stringTokenizer.nextToken().equals("Molecule")) {
                        lst.addLast(PT.split(stringTokenizer.nextToken(), "\"")[1]);
                    }
                    string2 = string3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (lst.size() == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "M0001";
        } else {
            stringArray = lst.toArray(new String[lst.size()]);
        }
        return stringArray;
    }

    private static String[] getSpartanFileList(String string, String[] stringArray) {
        String[] stringArray2 = new String[2 + stringArray.length * 5];
        stringArray2[0] = "SpartanSmol";
        stringArray2[1] = "Directory Entry ";
        int n = 2;
        if ((string = string.replace('\\', '/')).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = string.endsWith(".zip") ? "|" : "/";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = string + string2;
            string3 = string3 + (Character.isDigit(stringArray[i].charAt(0)) ? "Profile." + stringArray[i] : stringArray[i]) + "/";
            stringArray2[n++] = string3 + "#JMOL_MODEL " + stringArray[i];
            stringArray2[n++] = string3 + "input";
            stringArray2[n++] = string3 + "archive";
            stringArray2[n++] = string3 + "Molecule:asBinaryString";
            stringArray2[n++] = string3 + "proparc";
        }
        return stringArray2;
    }

    private static String shortSceneFilename(String string) {
        int n;
        int n2 = string.indexOf("_scene_") + 7;
        if (n2 < 7) {
            return string;
        }
        String string2 = "";
        if (string.endsWith("|state.spt")) {
            n = string.indexOf(46, n2);
            if (n < 0) {
                return string;
            }
            string2 = string.substring(n2, n);
        }
        n = string.lastIndexOf("|");
        return string.substring(0, n2) + string2 + (n > 0 ? string.substring(n) : "");
    }

    @Override
    public boolean cachePngjFile(JmolBinary jmolBinary, String[] stringArray) {
        stringArray[0] = Rdr.getZipRoot(stringArray[0]);
        String string = JmolUtil.shortSceneFilename(stringArray[0]);
        try {
            stringArray[1] = Rdr.getJzt().cacheZipContents(Rdr.getPngZipStream((BufferedInputStream)jmolBinary.fm.getBufferedInputStreamOrErrorMessageFromName(stringArray[0], null, false, false, null, false, true), true), string, jmolBinary.pngjCache, false);
        }
        catch (Exception exception) {
            return false;
        }
        if (stringArray[1] == null) {
            return false;
        }
        byte[] byArray = stringArray[1].getBytes();
        jmolBinary.pngjCache.put(jmolBinary.fm.getCanonicalName(stringArray[0]), byArray);
        if (string.indexOf("_scene_") >= 0) {
            jmolBinary.pngjCache.put(JmolUtil.shortSceneFilename(stringArray[0]), byArray);
            byArray = (byte[])jmolBinary.pngjCache.remove(string + "|state.spt");
            if (byArray != null) {
                jmolBinary.pngjCache.put(JmolUtil.shortSceneFilename(stringArray[0] + "|state.spt"), byArray);
            }
        }
        for (String string2 : jmolBinary.pngjCache.keySet()) {
            System.out.println(string2);
        }
        return true;
    }

    @Override
    public String determineSurfaceFileType(BufferedReader bufferedReader) {
        String string = null;
        LimitedLineReader limitedLineReader = null;
        try {
            limitedLineReader = new LimitedLineReader(bufferedReader, 16000);
            string = limitedLineReader.getHeader(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (limitedLineReader == null || string == null || string.length() == 0) {
            return null;
        }
        switch (string.charAt(0)) {
            case '@': {
                if (string.indexOf("@text") != 0) break;
                return "Kinemage";
            }
            case '#': {
                if (string.indexOf(".obj") >= 0) {
                    return "Obj";
                }
                if (string.indexOf("MSMS") < 0) break;
                return "Msms";
            }
            case '&': {
                if (string.indexOf("&plot") != 0) break;
                return "Jaguar";
            }
            case '\n': 
            case '\r': {
                if (string.indexOf("ZYX") < 0) break;
                return "Xplor";
            }
        }
        if (string.indexOf("Here is your gzipped map") >= 0) {
            return "UPPSALA" + string;
        }
        if (string.startsWith("4MESHC")) {
            return "Pmesh4";
        }
        if (string.indexOf("! nspins") >= 0) {
            return "CastepDensity";
        }
        if (string.indexOf("<jvxl") >= 0 && string.indexOf("<?xml") >= 0) {
            return "JvxlXml";
        }
        if (string.indexOf("#JVXL+") >= 0) {
            return "Jvxl+";
        }
        if (string.indexOf("#JVXL") >= 0) {
            return "Jvxl";
        }
        if (string.indexOf("<efvet ") >= 0) {
            return "Efvet";
        }
        if (string.indexOf("usemtl") >= 0) {
            return "Obj";
        }
        if (string.indexOf("# object with") == 0) {
            return "Nff";
        }
        if (string.indexOf("BEGIN_DATAGRID_3D") >= 0 || string.indexOf("BEGIN_BANDGRID_3D") >= 0) {
            return "Xsf";
        }
        int n = string.indexOf(0);
        if (n >= 0) {
            if (string.indexOf("PM\u0001\u0000") == 0) {
                return "Pmesh";
            }
            if (string.indexOf(DELPHI_BINARY_MAGIC_NUMBER) == 0) {
                return "DelPhi";
            }
            if (string.indexOf("MAP ") == 208) {
                return "Mrc";
            }
            if (string.length() > 37 && (string.charAt(36) == '\u0000' && string.charAt(37) == 'd' || string.charAt(36) == '\u0000' && string.charAt(37) == 'd')) {
                return "Dsn6";
            }
        }
        if (string.indexOf(" 0.00000e+00 0.00000e+00      0      0\n") >= 0) {
            return "Uhbd";
        }
        string = limitedLineReader.readLineWithNewline();
        if (string.indexOf("object 1 class gridpositions counts") == 0) {
            return "Apbs";
        }
        String[] stringArray = PT.getTokens(string);
        String string2 = limitedLineReader.readLineWithNewline();
        if (stringArray.length == 2 && PT.parseInt(stringArray[0]) == 3 && PT.parseInt(stringArray[1]) != Integer.MIN_VALUE && (stringArray = PT.getTokens(string2)).length == 3 && PT.parseInt(stringArray[0]) != Integer.MIN_VALUE && PT.parseInt(stringArray[1]) != Integer.MIN_VALUE && PT.parseInt(stringArray[2]) != Integer.MIN_VALUE) {
            return "PltFormatted";
        }
        String string3 = limitedLineReader.readLineWithNewline();
        if (string.startsWith("v ") && string2.startsWith("v ") && string3.startsWith("v ")) {
            return "Obj";
        }
        int n2 = PT.parseInt(string3);
        if (n2 == Integer.MIN_VALUE) {
            return string3.indexOf("+") == 0 ? "Jvxl+" : null;
        }
        if (n2 >= 0) {
            return string3.length() < 60 ? "Cube" : null;
        }
        n2 = -n2;
        int n3 = 4 + n2;
        while (--n3 >= 0) {
            string = limitedLineReader.readLineWithNewline();
            if (string != null) continue;
            return null;
        }
        n3 = PT.parseInt(string);
        if (n3 == Integer.MIN_VALUE) {
            return null;
        }
        return n3 < 0 ? "Jvxl" : "Cube";
    }

    @Override
    public Object getAtomSetCollectionOrBufferedReaderFromZip(GenericZipTools genericZipTools, JmolAdapter jmolAdapter, InputStream inputStream, String string, String[] stringArray, Map<String, Object> map, int n, boolean bl) {
        Object object;
        boolean bl2;
        boolean bl3;
        String string2;
        boolean bl4;
        String string3;
        boolean bl5 = n == 1;
        map.put("zipSet", string);
        String[] stringArray2 = (String[])map.get("subFileList");
        if (stringArray2 == null) {
            stringArray2 = JmolUtil.checkSpecialInZip(stringArray);
        }
        String string4 = string3 = stringArray2 == null || n >= stringArray2.length ? null : stringArray2[n];
        if (string3 != null && (string3.startsWith("/") || string3.startsWith("\\"))) {
            string3 = string3.substring(1);
        }
        int n2 = 0;
        if (string3 == null && map.containsKey("modelNumber") && (n2 = ((Integer)map.get("modelNumber")).intValue()) > 0 && bl5) {
            map.remove("modelNumber");
        }
        boolean bl6 = bl4 = (string2 = (String)map.get("manifest")) == null;
        if (bl4) {
            string2 = stringArray.length > 0 ? stringArray[0] : "";
        }
        boolean bl7 = bl3 = string2.length() > 0;
        if (bl3 && Logger.debugging) {
            Logger.debug("manifest for  " + string + ":\n" + string2);
        }
        boolean bl8 = string2.indexOf("IGNORE_ERRORS") >= 0;
        boolean bl9 = string2.indexOf("IGNORE_MANIFEST") >= 0;
        boolean bl10 = bl2 = string2.indexOf("EXCEPT_FILES") >= 0;
        if (bl9 || string3 != null) {
            bl3 = false;
        }
        if (bl4 && bl3 && (object = JmolBinary.getManifestScriptPath(string2)) != null) {
            return "NOTE: file recognized as a script file: " + string + (String)object + "\n";
        }
        object = new Lst();
        Hashtable<String[], Object> hashtable = bl3 ? new Hashtable<String[], Object>() : null;
        boolean bl11 = false;
        Object object2 = JmolUtil.checkSpecialData(genericZipTools, inputStream, stringArray);
        if (object2 instanceof String) {
            return object2;
        }
        SB sB = object2;
        try {
            Object object3;
            Object object4;
            ZipEntry zipEntry;
            if (sB != null) {
                BufferedReader bufferedReader = Rdr.getBR(sB.toString());
                if (bl) {
                    return bufferedReader;
                }
                object2 = jmolAdapter.getAtomSetCollectionFromReader(string, bufferedReader, map);
                if (object2 instanceof String) {
                    return object2;
                }
                if (object2 instanceof AtomSetCollection) {
                    AtomSetCollection atomSetCollection = (AtomSetCollection)object2;
                    if (atomSetCollection.errorMessage != null) {
                        if (bl8) {
                            return null;
                        }
                        return atomSetCollection.errorMessage;
                    }
                    return atomSetCollection;
                }
                if (bl8) {
                    return null;
                }
                return "unknown reader error";
            }
            if (inputStream instanceof BufferedInputStream) {
                inputStream = Rdr.getPngZipStream((BufferedInputStream)inputStream, true);
            }
            ZipInputStream zipInputStream = (ZipInputStream)((Object)Rdr.newZipInputStream(inputStream));
            if (bl3) {
                string2 = '|' + string2.replace('\r', '|').replace('\n', '|') + '|';
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null && (n2 <= 0 || ((ArrayList)object).size() < n2)) {
                Object object5;
                Object object6;
                if (zipEntry.isDirectory()) continue;
                object4 = zipEntry.getName();
                if (string3 != null && !object4.equals(string3)) continue;
                if (string3 != null) {
                    map.put("subFileName", string3);
                }
                if (object4.startsWith("JmolManifest") || bl3 && bl2 == string2.indexOf("|" + (String)object4 + "|") >= 0) continue;
                byte[] byArray = Rdr.getLimitedStreamBytes(zipInputStream, zipEntry.getSize());
                if (Rdr.isGzipB(byArray)) {
                    byArray = Rdr.getLimitedStreamBytes(ZipTools.getUnGzippedInputStream(byArray), -1L);
                }
                if (Rdr.isZipB(byArray) || Rdr.isPngZipB(byArray)) {
                    object3 = Rdr.getBIS(byArray);
                    object6 = Rdr.getZipDirectoryAndClose((BufferedInputStream)object3, "JmolManifest");
                    object3 = Rdr.getBIS(byArray);
                    object5 = this.getAtomSetCollectionOrBufferedReaderFromZip(genericZipTools, jmolAdapter, (InputStream)object3, string + "|" + (String)object4, (String[])object6, map, ++n, bl);
                    if (object5 instanceof String) {
                        if (bl8) continue;
                        return object5;
                    }
                    if (object5 instanceof AtomSetCollection || object5 instanceof Lst) {
                        if (bl3 && !bl2) {
                            hashtable.put((String[])object4, object5);
                            continue;
                        }
                        ((Lst)object).addLast(object5);
                        continue;
                    }
                    if (object5 instanceof BufferedReader) {
                        if (bl5) {
                            zipInputStream.close();
                        }
                        return object5;
                    }
                    if (bl8) continue;
                    zipInputStream.close();
                    return "unknown zip reader error";
                }
                if (Rdr.isPickleB(byArray)) {
                    object3 = Rdr.getBIS(byArray);
                    if (bl5) {
                        zipInputStream.close();
                    }
                    return object3;
                }
                if (Rdr.isCompoundDocumentB(byArray)) {
                    object6 = (GenericBinaryDocument)Interface.getInterface("javajs.util.CompoundDocument");
                    object6.setStream(Rdr.getBIS(byArray), true);
                    object3 = object6.getAllDataFiles("Molecule", "Input").toString();
                } else {
                    object3 = Rdr.fixUTF(byArray);
                }
                object6 = Rdr.getBR((String)object3);
                if (bl) {
                    if (bl5) {
                        zipInputStream.close();
                    }
                    return object6;
                }
                object5 = string + "|" + zipEntry.getName();
                object2 = jmolAdapter.getAtomSetCollectionFromReader((String)object5, object6, map);
                if (!(object2 instanceof AtomSetCollection)) {
                    if (bl8) continue;
                    zipInputStream.close();
                    return "" + object2;
                }
                if (bl3 && !bl2) {
                    hashtable.put((String[])object4, object2);
                } else {
                    ((Lst)object).addLast(object2);
                }
                AtomSetCollection atomSetCollection = (AtomSetCollection)object2;
                if (atomSetCollection.errorMessage == null || bl8) continue;
                zipInputStream.close();
                return atomSetCollection.errorMessage;
            }
            if (bl5) {
                zipInputStream.close();
            }
            if (bl3 && !bl2) {
                object4 = PT.split(string2, "|");
                for (int i = 0; i < ((String[])object4).length; ++i) {
                    object3 = object4[i];
                    if (((String)object3).length() == 0 || ((String)object3).indexOf("#") == 0) continue;
                    if (hashtable.containsKey(object3)) {
                        ((Lst)object).addLast(hashtable.get(object3));
                        continue;
                    }
                    if (!Logger.debugging) continue;
                    Logger.debug("manifested file " + (String)object3 + " was not found in " + string);
                }
            }
            if (!bl5) {
                return object;
            }
            Object object7 = object4 = ((ArrayList)object).size() == 1 && ((ArrayList)object).get(0) instanceof AtomSetCollection ? (AtomSetCollection)((ArrayList)object).get(0) : new AtomSetCollection("Array", null, null, (Lst<?>)object);
            if (object4.errorMessage != null) {
                if (bl8) {
                    return null;
                }
                return object4.errorMessage;
            }
            if (bl11) {
                n2 = 1;
            }
            if (n2 > 0 && n2 <= ((ArrayList)object).size()) {
                return ((ArrayList)object).get(n2 - 1);
            }
            return object4;
        }
        catch (Exception exception) {
            if (bl8) {
                return null;
            }
            Logger.error("" + exception);
            return "" + exception;
        }
        catch (Error error) {
            Logger.errorEx(null, error);
            return "" + error;
        }
    }

    @Override
    public byte[] getCachedPngjBytes(JmolBinary jmolBinary, String string) {
        boolean bl;
        if (string.startsWith("file:///")) {
            string = "file:" + string.substring(7);
        }
        Logger.info("JmolUtil checking PNGJ cache for " + string);
        String string2 = JmolUtil.shortSceneFilename(string);
        if (jmolBinary.pngjCache == null && !jmolBinary.clearAndCachePngjFile(new String[]{string, null})) {
            return null;
        }
        boolean bl2 = bl = string.indexOf(".min.") >= 0;
        if (!bl) {
            String string3 = jmolBinary.fm.getCanonicalName(Rdr.getZipRoot(string));
            if (!jmolBinary.pngjCache.containsKey(string3) && !jmolBinary.clearAndCachePngjFile(new String[]{string, null})) {
                return null;
            }
            if (string.indexOf("|") < 0) {
                string2 = string3;
            }
        }
        if (jmolBinary.pngjCache.containsKey(string2)) {
            Logger.info("FileManager using memory cache " + string2);
            return (byte[])jmolBinary.pngjCache.get(string2);
        }
        if (!bl || !jmolBinary.clearAndCachePngjFile(new String[]{string, null})) {
            return null;
        }
        Logger.info("FileManager using memory cache " + string2);
        return (byte[])jmolBinary.pngjCache.get(string2);
    }

    @Override
    public String[] spartanFileList(GenericZipTools genericZipTools, String string, String string2) {
        String[] stringArray = JmolUtil.getSpartanDirs(string2);
        if (stringArray.length == 0 && string.endsWith(".spardir.zip") && string2.indexOf(".zip|output") >= 0) {
            String string3 = string.replace('\\', '/');
            int n = string.lastIndexOf(".spardir");
            n = string3.lastIndexOf("/");
            string3 = string + "|" + string.substring(n + 1, string.length() - 4);
            return new String[]{"SpartanSmol", string3, string3 + "/output"};
        }
        return JmolUtil.getSpartanFileList(string, stringArray);
    }

    @Override
    public Object getImage(Viewer viewer, Object object, String string) {
        Object object2 = null;
        Object var5_5 = null;
        GenericPlatform genericPlatform = viewer.apiPlatform;
        boolean bl = false;
        String string2 = "" + object;
        if (object instanceof String) {
            if (string2.indexOf("|") > 0) {
                Object object3 = viewer.fm.getFileAsBytes(string2, null, true);
                if (!PT.isAB(object3)) {
                    return "" + object3;
                }
                object2 = viewer.isJS ? object3 : genericPlatform.createImage(object3);
            } else if (!viewer.isJS) {
                if (FileManager.urlTypeIndex(string2) >= 0) {
                    try {
                        object2 = genericPlatform.createImage(new URL((URL)null, string2, null));
                    }
                    catch (Exception exception) {
                        return "bad URL: " + string2;
                    }
                } else {
                    bl = true;
                }
            }
        } else if (viewer.isJS) {
            object2 = object;
        } else {
            bl = true;
        }
        if (bl) {
            object2 = genericPlatform.createImage(object);
        }
        if (object2 == null) {
            return null;
        }
        try {
            if (!genericPlatform.waitForDisplay(var5_5, object2)) {
                return null;
            }
            return genericPlatform.getImageWidth(object2) < 1 ? "invalid or missing image " + string2 : object2;
        }
        catch (Exception exception) {
            return exception.toString() + " opening " + string2;
        }
    }
}

