/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javajs.util.AU;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.c.PAL;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.shape.AtomShape;
import org.jmol.shapespecial.Polyhedron;
import org.jmol.util.Logger;
import org.jmol.util.Normix;

public class Polyhedra
extends AtomShape {
    private static final float DEFAULT_DISTANCE_FACTOR = 1.85f;
    private static final float DEFAULT_FACECENTEROFFSET = 0.25f;
    private static final int EDGES_NONE = 0;
    public static final int EDGES_ALL = 1;
    public static final int EDGES_FRONT = 2;
    private static final int MAX_VERTICES = 150;
    private static final int FACE_COUNT_MAX = 147;
    private P3[] otherAtoms = new P3[151];
    public int polyhedronCount;
    public Polyhedron[] polyhedrons = new Polyhedron[32];
    public int drawEdges;
    private float radius;
    private int nVertices;
    float faceCenterOffset;
    float distanceFactor;
    boolean isCollapsed;
    private boolean iHaveCenterBitSet;
    private boolean bondedOnly;
    private boolean haveBitSetVertices;
    private BS centers;
    private BS bsVertices;
    private BS bsVertexCount;
    private short[] normixesT = new short[150];
    private byte[] planesT = new byte[450];
    private static final P3 randomPoint = P3.new3(3141.0f, 2718.0f, 1414.0f);
    private BS bsTemp;
    private V3 align1 = new V3();
    private V3 align2 = new V3();
    private final V3 vAB = new V3();
    private final V3 vAC = new V3();
    private static float minDistanceForPlanarity = 0.1f;

    @Override
    public void setProperty(String string, Object object, BS bS) {
        if ("init" == string) {
            this.faceCenterOffset = 0.25f;
            this.distanceFactor = 1.85f;
            this.radius = 0.0f;
            this.nVertices = 0;
            this.bsVertices = null;
            this.centers = null;
            this.bsVertexCount = new BS();
            this.iHaveCenterBitSet = false;
            this.isCollapsed = false;
            this.bondedOnly = false;
            this.haveBitSetVertices = false;
            if (Boolean.TRUE == object) {
                this.drawEdges = 0;
            }
            return;
        }
        if ("generate" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
                this.iHaveCenterBitSet = true;
            }
            this.deletePolyhedra();
            this.buildPolyhedra();
            return;
        }
        if ("collapsed" == string) {
            this.isCollapsed = (Boolean)object;
            return;
        }
        if ("nVertices" == string) {
            this.nVertices = (Integer)object;
            this.bsVertexCount.set(this.nVertices);
            return;
        }
        if ("centers" == string) {
            this.centers = (BS)object;
            this.iHaveCenterBitSet = true;
            return;
        }
        if ("to" == string) {
            this.bsVertices = (BS)object;
            return;
        }
        if ("toBitSet" == string) {
            this.bsVertices = (BS)object;
            this.haveBitSetVertices = true;
            return;
        }
        if ("faceCenterOffset" == string) {
            this.faceCenterOffset = ((Float)object).floatValue();
            return;
        }
        if ("distanceFactor" == string) {
            this.distanceFactor = ((Float)object).floatValue();
            return;
        }
        if ("bonds" == string) {
            this.bondedOnly = true;
            return;
        }
        if ("delete" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.deletePolyhedra();
            return;
        }
        if ("on" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.setVisible(true);
            return;
        }
        if ("off" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.setVisible(false);
            return;
        }
        if ("noedges" == string) {
            this.drawEdges = 0;
            return;
        }
        if ("edges" == string) {
            this.drawEdges = 1;
            return;
        }
        if ("frontedges" == string) {
            this.drawEdges = 2;
            return;
        }
        if (string.indexOf("color") == 0) {
            bS = "colorThis" == string && this.iHaveCenterBitSet ? this.centers : this.andBitSet(bS);
            string = "color";
        }
        if (string.indexOf("translucency") == 0) {
            BS bS2 = bS = "translucentThis".equals(object) && this.iHaveCenterBitSet ? this.centers : this.andBitSet(bS);
            if (object.equals("translucentThis")) {
                object = "translucent";
            }
        }
        if ("token" == string) {
            this.setLighting((Integer)object == 1073741964, bS);
            return;
        }
        if ("radius" == string) {
            this.radius = ((Float)object).floatValue();
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            int n2 = this.polyhedronCount;
            while (--n2 >= 0) {
                if (this.polyhedrons[n2].modelIndex == n) {
                    --this.polyhedronCount;
                    this.polyhedrons = (Polyhedron[])AU.deleteElements(this.polyhedrons, n2, 1);
                    continue;
                }
                if (this.polyhedrons[n2].modelIndex <= n) continue;
                --this.polyhedrons[n2].modelIndex;
            }
        }
        this.setPropAS(string, object, bS);
    }

    private void setLighting(boolean bl, BS bS) {
        int n = this.polyhedronCount;
        while (--n >= 0) {
            if (!bS.get(this.polyhedrons[n].centralAtom.i)) continue;
            short[] sArray = this.polyhedrons[n].normixes;
            this.polyhedrons[n].isFullyLit = bl;
            int n2 = sArray.length;
            while (--n2 >= 0) {
                if (sArray[n2] < 0 == bl) continue;
                sArray[n2] = ~sArray[n2];
            }
        }
    }

    private BS andBitSet(BS bS) {
        BS bS2 = new BS();
        int n = this.polyhedronCount;
        while (--n >= 0) {
            bS2.set(this.polyhedrons[n].centralAtom.i);
        }
        bS2.and(bS);
        return bS2;
    }

    private void deletePolyhedra() {
        int n;
        int n2 = 0;
        byte by = PAL.pidOf(null);
        for (n = 0; n < this.polyhedronCount; ++n) {
            Polyhedron polyhedron = this.polyhedrons[n];
            int n3 = polyhedron.centralAtom.i;
            if (this.centers.get(n3)) {
                this.setColixAndPalette((short)0, by, n3);
                continue;
            }
            this.polyhedrons[n2++] = polyhedron;
        }
        for (n = n2; n < this.polyhedronCount; ++n) {
            this.polyhedrons[n] = null;
        }
        this.polyhedronCount = n2;
    }

    private void setVisible(boolean bl) {
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (polyhedron == null || !this.centers.get(polyhedron.centralAtom.i)) continue;
            polyhedron.visible = bl;
        }
    }

    private void buildPolyhedra() {
        boolean bl = this.radius == 0.0f || this.bondedOnly;
        AtomIndexIterator atomIndexIterator = this.ms.getSelectedAtomIterator(null, false, false, false, false);
        int n = this.centers.nextSetBit(0);
        while (n >= 0) {
            Polyhedron polyhedron;
            Polyhedron polyhedron2 = this.haveBitSetVertices ? this.constructBitSetPolyhedron(n) : (polyhedron = bl ? this.constructBondsPolyhedron(n) : this.constructRadiusPolyhedron(n, atomIndexIterator));
            if (polyhedron != null) {
                if (this.polyhedronCount == this.polyhedrons.length) {
                    this.polyhedrons = (Polyhedron[])AU.doubleLength(this.polyhedrons);
                }
                this.polyhedrons[this.polyhedronCount++] = polyhedron;
            }
            if (this.haveBitSetVertices) break;
            n = this.centers.nextSetBit(n + 1);
        }
        atomIndexIterator.release();
    }

    private Polyhedron constructBondsPolyhedron(int n) {
        Atom atom = this.atoms[n];
        Bond[] bondArray = atom.getBonds();
        if (bondArray == null) {
            return null;
        }
        int n2 = 0;
        int n3 = bondArray.length;
        while (--n3 >= 0) {
            Atom atom2;
            Bond bond = bondArray[n3];
            Atom atom3 = atom2 = bond.getAtom1() == atom ? bond.getAtom2() : bond.getAtom1();
            if (this.bsVertices != null && !this.bsVertices.get(atom2.i) || this.radius > 0.0f && bond.getAtom1().distance(bond.getAtom2()) > this.radius) continue;
            this.otherAtoms[n2++] = atom2;
            if (n2 != 150) continue;
            break;
        }
        if (n2 < 3 || this.nVertices > 0 && !this.bsVertexCount.get(n2)) {
            return null;
        }
        return this.validatePolyhedronNew(atom, n2, this.otherAtoms);
    }

    private Polyhedron constructBitSetPolyhedron(int n) {
        int n2 = 0;
        int n3 = this.bsVertices.nextSetBit(0);
        while (n3 >= 0) {
            this.otherAtoms[n2++] = this.atoms[n3];
            n3 = this.bsVertices.nextSetBit(n3 + 1);
        }
        return this.validatePolyhedronNew(this.atoms[n], n2, this.otherAtoms);
    }

    private Polyhedron constructRadiusPolyhedron(int n, AtomIndexIterator atomIndexIterator) {
        Atom atom = this.atoms[n];
        int n2 = 0;
        this.vwr.setIteratorForAtom(atomIndexIterator, n, this.radius);
        while (atomIndexIterator.hasNext()) {
            Atom atom2 = this.atoms[atomIndexIterator.next()];
            if (this.bsVertices != null && !this.bsVertices.get(atom2.i) || atom.distance(atom2) > this.radius || atom2.getAlternateLocationID() != atom.getAlternateLocationID() && atom2.getAlternateLocationID() != '\u0000' && atom.getAlternateLocationID() != '\u0000') continue;
            if (n2 == 150) break;
            this.otherAtoms[n2++] = atom2;
        }
        if (n2 < 3 || this.nVertices > 0 && !this.bsVertexCount.get(n2)) {
            return null;
        }
        return this.validatePolyhedronNew(atom, n2, this.otherAtoms);
    }

    private Polyhedron validatePolyhedronNew(Atom atom, int n, P3[] p3Array) {
        int n2;
        int n3;
        int n4;
        boolean bl;
        V3 v3 = new V3();
        int n5 = 0;
        int n6 = 0;
        int n7 = n;
        int n8 = n7 + 1;
        float f = 0.0f;
        float f2 = 0.0f;
        P3[] p3Array2 = new P3[450];
        p3Array2[n7] = p3Array[n7] = atom;
        for (int i = 0; i < n7; ++i) {
            p3Array2[i] = p3Array[i];
            f2 += p3Array2[n7].distance(p3Array2[i]);
        }
        float f3 = this.distanceFactor;
        BS bS = BS.newN(n7);
        boolean bl2 = bl = (f2 /= (float)n7) == 0.0f;
        block1: while (!bl && f3 < 10.0f) {
            int n9;
            f = f2 * f3;
            bS.setBits(0, n7);
            for (n9 = 0; n9 < n7 - 2; ++n9) {
                for (int i = n9 + 1; i < n7 - 1; ++i) {
                    if (p3Array2[n9].distance(p3Array2[i]) > f) continue;
                    for (n4 = i + 1; n4 < n7; ++n4) {
                        if (p3Array2[n9].distance(p3Array2[n4]) > f || p3Array2[i].distance(p3Array2[n4]) > f) continue;
                        bS.clear(n9);
                        bS.clear(i);
                        bS.clear(n4);
                    }
                }
            }
            bl = true;
            for (n9 = 0; n9 < n7; ++n9) {
                if (!bS.get(n9)) continue;
                bl = false;
                f3 *= 1.05f;
                if (!Logger.debugging) continue block1;
                Logger.debug("Polyhedra distanceFactor for " + n7 + " atoms increased to " + f3 + " in order to include " + ((Atom)p3Array[n9]).getInfo());
                continue block1;
            }
        }
        String string = "";
        String string2 = "";
        for (n4 = 0; n4 < n7 - 2; ++n4) {
            for (n3 = n4 + 1; n3 < n7 - 1; ++n3) {
                for (n2 = n3 + 1; n2 < n7; ++n2) {
                    if (!this.isPlanar(p3Array2[n4], p3Array2[n3], p3Array2[n2], p3Array2[n7])) continue;
                    string = string + this.faceId(n4, n3, n2);
                }
            }
        }
        for (n4 = 0; n4 < n7 - 1; ++n4) {
            for (n3 = n4 + 1; n3 < n7; ++n3) {
                if (!this.isAligned(p3Array2[n4], p3Array2[n3], p3Array2[n7])) continue;
                string2 = string2 + this.faceId(n4, n3, -1);
            }
        }
        P3 p3 = new P3();
        if (this.bsTemp == null) {
            this.bsTemp = Normix.newVertexBitSet();
        }
        for (n3 = 0; n3 < n7 - 2; ++n3) {
            for (n2 = n3 + 1; n2 < n7 - 1; ++n2) {
                if (p3Array2[n3].distance(p3Array2[n2]) > f) continue;
                for (int i = n2 + 1; i < n7; ++i) {
                    if (p3Array2[n3].distance(p3Array2[i]) > f || p3Array2[n2].distance(p3Array2[i]) > f) continue;
                    if (n5 >= 147) {
                        Logger.error("Polyhedron error: maximum face(147) -- reduce RADIUS or DISTANCEFACTOR");
                        return null;
                    }
                    if (n8 >= 150) {
                        Logger.error("Polyhedron error: maximum vertex count(150) -- reduce RADIUS");
                        return null;
                    }
                    boolean bl3 = string.indexOf(this.faceId(n3, n2, i)) >= 0;
                    boolean bl4 = bl3 ? Measure.getNormalFromCenter(randomPoint, p3Array2[n3], p3Array2[n2], p3Array2[i], false, v3) : Measure.getNormalFromCenter(p3Array2[n7], p3Array2[n3], p3Array2[n2], p3Array2[i], true, v3);
                    v3.scale(this.isCollapsed && !bl3 ? this.faceCenterOffset : 0.001f);
                    int n10 = n8;
                    p3.setT(p3Array2[n7]);
                    if (this.isCollapsed && !bl3) {
                        p3Array2[n8] = P3.newP(p3Array2[n7]);
                        p3Array2[n8].add(v3);
                        p3Array[n8] = p3Array2[n8];
                    } else if (bl3) {
                        p3.sub(v3);
                        n10 = n7;
                    }
                    String string3 = this.faceId(n3, n2, -1);
                    if (this.isCollapsed || bl3 && string2.indexOf(string3) < 0) {
                        string2 = string2 + string3;
                        this.planesT[n6++] = (byte)(bl4 ? n3 : n2);
                        this.planesT[n6++] = (byte)(bl4 ? n2 : n3);
                        this.planesT[n6++] = (byte)n10;
                        Measure.getNormalFromCenter(p3Array2[i], p3Array2[n3], p3Array2[n2], p3, false, v3);
                        this.normixesT[n5++] = bl3 ? Normix.get2SidedNormix(v3, this.bsTemp) : Normix.getNormixV(v3, this.bsTemp);
                    }
                    string3 = this.faceId(n3, i, -1);
                    if (this.isCollapsed || bl3 && string2.indexOf(string3) < 0) {
                        string2 = string2 + string3;
                        this.planesT[n6++] = (byte)(bl4 ? n3 : i);
                        this.planesT[n6++] = (byte)n10;
                        this.planesT[n6++] = (byte)(bl4 ? i : n3);
                        Measure.getNormalFromCenter(p3Array2[n2], p3Array2[n3], p3, p3Array2[i], false, v3);
                        this.normixesT[n5++] = bl3 ? Normix.get2SidedNormix(v3, this.bsTemp) : Normix.getNormixV(v3, this.bsTemp);
                    }
                    string3 = this.faceId(n2, i, -1);
                    if (this.isCollapsed || bl3 && string2.indexOf(string3) < 0) {
                        string2 = string2 + string3;
                        this.planesT[n6++] = (byte)n10;
                        this.planesT[n6++] = (byte)(bl4 ? n2 : i);
                        this.planesT[n6++] = (byte)(bl4 ? i : n2);
                        Measure.getNormalFromCenter(p3Array2[n3], p3, p3Array2[n2], p3Array2[i], false, v3);
                        short s = this.normixesT[n5++] = bl3 ? Normix.get2SidedNormix(v3, this.bsTemp) : Normix.getNormixV(v3, this.bsTemp);
                    }
                    if (bl3) continue;
                    if (this.isCollapsed) {
                        ++n8;
                        continue;
                    }
                    this.planesT[n6++] = (byte)(bl4 ? n3 : n2);
                    this.planesT[n6++] = (byte)(bl4 ? n2 : n3);
                    this.planesT[n6++] = (byte)i;
                    this.normixesT[n5++] = Normix.getNormixV(v3, this.bsTemp);
                }
            }
        }
        return new Polyhedron(atom, n7, n8, n5, p3Array, this.normixesT, this.planesT, this.isCollapsed, this.faceCenterOffset, this.distanceFactor);
    }

    private String faceId(int n, int n2, int n3) {
        return P3i.new3(n, n2, n3).toString();
    }

    private boolean isAligned(P3 p3, P3 p32, P3 p33) {
        this.align1.sub2(p3, p33);
        this.align2.sub2(p32, p33);
        float f = this.align1.angle(this.align2);
        return f < 0.01f || f > 3.13f;
    }

    private boolean isPlanar(P3 p3, P3 p32, P3 p33, P3 p34) {
        V3 v3 = new V3();
        float f = Measure.getNormalThroughPoints(p3, p32, p33, v3, this.vAB, this.vAC);
        float f2 = Measure.distanceToPlaneV(v3, f, p34);
        return Math.abs(f2) < minDistanceForPlanarity;
    }

    @Override
    public void setVisibilityFlags(BS bS) {
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            polyhedron.visibilityFlags = polyhedron.visible && bS.get(polyhedron.modelIndex) && !this.ms.isAtomHidden(polyhedron.centralAtom.i) ? this.vf : 0;
        }
    }

    @Override
    public String getShapeState() {
        if (this.polyhedronCount == 0) {
            return "";
        }
        SB sB = new SB();
        for (int i = 0; i < this.polyhedronCount; ++i) {
            sB.append(this.polyhedrons[i].getState());
        }
        if (this.drawEdges == 2) {
            Polyhedra.appendCmd(sB, "polyhedra frontedges");
        } else if (this.drawEdges == 1) {
            Polyhedra.appendCmd(sB, "polyhedra edges");
        }
        sB.append(this.vwr.getAtomShapeState(this));
        return sB.toString();
    }
}

