/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.P3;
import org.jmol.java.BS;
import org.jmol.util.C;
import org.jmol.util.GData;
import org.jmol.viewer.JC;

public abstract class Object2d {
    public boolean isLabelOrHover;
    protected GData gdata;
    public P3 xyz;
    public String target;
    public String script;
    public short colix;
    public short bgcolix;
    public int pointer;
    public int align;
    public int valign;
    public int atomX;
    public int atomY;
    public int atomZ = Integer.MAX_VALUE;
    public int movableX;
    public int movableY;
    public int movableZ;
    public int movableXPercent = Integer.MAX_VALUE;
    public int movableYPercent = Integer.MAX_VALUE;
    public int movableZPercent = Integer.MAX_VALUE;
    protected int offsetX;
    protected int offsetY;
    public int z = 1;
    public int zSlab = Integer.MIN_VALUE;
    public float[] pymolOffset;
    protected int windowWidth;
    protected int windowHeight;
    protected boolean adjustForWindow;
    public float boxWidth;
    public float boxHeight;
    public float boxX;
    public float boxY;
    public int modelIndex = -1;
    public boolean visible = true;
    public boolean hidden = false;
    public float[] boxXY = new float[5];
    public float scalePixelsPerMicron;

    public float getScalePixelsPerMicron() {
        return this.scalePixelsPerMicron;
    }

    public void setScalePixelsPerMicron(float f) {
        this.scalePixelsPerMicron = f;
    }

    protected abstract void recalc();

    public void setModel(int n) {
        this.modelIndex = n;
    }

    public void setVisibility(boolean bl) {
        this.visible = bl;
    }

    public void setXYZ(P3 p3, boolean bl) {
        this.xyz = p3;
        if (p3 == null) {
            this.zSlab = Integer.MIN_VALUE;
        }
        if (bl) {
            this.valign = p3 == null ? 0 : 4;
            this.setAdjustForWindow(p3 == null);
        }
    }

    public void setAdjustForWindow(boolean bl) {
        this.adjustForWindow = bl;
    }

    public void setColix(short s) {
        this.colix = s;
    }

    public void setColixO(Object object) {
        this.colix = C.getColixO(object);
    }

    public void setTranslucent(float f, boolean bl) {
        if (bl) {
            if (this.bgcolix != 0) {
                this.bgcolix = C.getColixTranslucent3(this.bgcolix, !Float.isNaN(f), f);
            }
        } else {
            this.colix = C.getColixTranslucent3(this.colix, !Float.isNaN(f), f);
        }
    }

    public void setBgColix(short s) {
        this.bgcolix = s;
    }

    public void setBgColixO(Object object) {
        this.bgcolix = object == null ? (short)0 : C.getColixO(object);
    }

    private void setMovableX(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = n;
        this.movableXPercent = Integer.MAX_VALUE;
    }

    private void setMovableY(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = n;
        this.movableYPercent = Integer.MAX_VALUE;
    }

    public void setMovableXPercent(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = Integer.MAX_VALUE;
        this.movableXPercent = n;
    }

    public void setMovableYPercent(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = Integer.MAX_VALUE;
        this.movableYPercent = n;
    }

    public void setMovableZPercent(int n) {
        if (this.valign != 4) {
            this.valign = 0;
        }
        this.movableZ = Integer.MAX_VALUE;
        this.movableZPercent = n;
    }

    public void setZs(int n, int n2) {
        this.z = n;
        this.zSlab = n2;
    }

    public void setXYZs(int n, int n2, int n3, int n4) {
        this.setMovableX(n);
        this.setMovableY(n2);
        this.setZs(n3, n4);
    }

    public void setScript(String string) {
        this.script = string == null || string.length() == 0 ? null : string;
    }

    public String getScript() {
        return this.script;
    }

    public void setOffset(int n) {
        this.offsetX = JC.getXOffset(n);
        this.offsetY = JC.getYOffset(n);
        this.pymolOffset = null;
        this.valign = 0;
    }

    public boolean setAlignmentLCR(String string) {
        if ("left".equals(string)) {
            return this.setAlignment(1);
        }
        if ("center".equals(string)) {
            return this.setAlignment(2);
        }
        if ("right".equals(string)) {
            return this.setAlignment(3);
        }
        return false;
    }

    public boolean setAlignment(int n) {
        if (this.align != n) {
            this.align = n;
            this.recalc();
        }
        return true;
    }

    public void setPointer(int n) {
        this.pointer = n;
    }

    public void setBoxOffsetsInWindow(float f, float f2, float f3) {
        float f4 = this.boxX;
        float f5 = this.boxWidth + f;
        if (f4 + f5 > (float)this.windowWidth) {
            f4 = (float)this.windowWidth - f5;
        }
        if (f4 < f) {
            f4 = f;
        }
        this.boxX = f4;
        float f6 = f3;
        float f7 = this.boxHeight;
        if (f6 + f7 > (float)this.windowHeight) {
            f6 = (float)this.windowHeight - f7;
        }
        if (f6 < f2) {
            f6 = f2;
        }
        this.boxY = f6;
    }

    public void setWindow(int n, int n2, float f) {
        this.windowWidth = n;
        this.windowHeight = n2;
        if (this.pymolOffset == null && this.scalePixelsPerMicron < 0.0f && f != 0.0f) {
            this.scalePixelsPerMicron = f;
        }
    }

    public boolean checkObjectClicked(boolean bl, int n, int n2, BS bS) {
        if (this.hidden || this.script == null || this.modelIndex >= 0 && !bS.get(this.modelIndex)) {
            return false;
        }
        if (bl) {
            n <<= 1;
            n2 <<= 1;
        }
        return (float)n >= this.boxX && (float)n <= this.boxX + this.boxWidth && (float)n2 >= this.boxY && (float)n2 <= this.boxY + this.boxHeight;
    }

    public static boolean setProperty(String string, Object object, Object2d object2d) {
        if ("script" == string) {
            if (object2d != null) {
                object2d.setScript((String)object);
            }
            return true;
        }
        if ("xpos" == string) {
            if (object2d != null) {
                object2d.setMovableX((Integer)object);
            }
            return true;
        }
        if ("ypos" == string) {
            if (object2d != null) {
                object2d.setMovableY((Integer)object);
            }
            return true;
        }
        if ("%xpos" == string) {
            if (object2d != null) {
                object2d.setMovableXPercent((Integer)object);
            }
            return true;
        }
        if ("%ypos" == string) {
            if (object2d != null) {
                object2d.setMovableYPercent((Integer)object);
            }
            return true;
        }
        if ("%zpos" == string) {
            if (object2d != null) {
                object2d.setMovableZPercent((Integer)object);
            }
            return true;
        }
        if ("xypos" == string) {
            if (object2d == null) {
                return true;
            }
            P3 p3 = (P3)object;
            object2d.setXYZ(null, true);
            if (p3.z == Float.MAX_VALUE) {
                object2d.setMovableX((int)p3.x);
                object2d.setMovableY((int)p3.y);
            } else {
                object2d.setMovableXPercent((int)p3.x);
                object2d.setMovableYPercent((int)p3.y);
            }
            return true;
        }
        if ("xyz" == string) {
            if (object2d != null) {
                object2d.setXYZ((P3)object, true);
            }
            return true;
        }
        return false;
    }
}

