/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.List;
import javajs.util.PT;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.api.JmolAbstractButton;
import org.jmol.api.JmolViewer;
import org.jmol.awt.Platform;
import org.jmol.console.JmolConsole;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.HelpDialog;
import org.openscience.jmol.app.jmolpanel.console.EnterListener;

public class AppConsole
extends JmolConsole
implements EnterListener {
    public static final String ALL_BUTTONS = "Editor Variables Clear History State UndoRedo Close Help";
    public JDialog jcd;
    protected ConsoleTextPane console;
    private JmolAbstractButton varButton;
    private JmolAbstractButton haltButton;
    private JmolAbstractButton closeButton;
    private JmolAbstractButton clearButton;
    private JmolAbstractButton stepButton;
    private JmolAbstractButton helpButton;
    private JmolAbstractButton undoButton;
    private JmolAbstractButton redoButton;
    private JmolAbstractButton checkButton;
    private JmolAbstractButton topButton;
    private JPanel buttonPanel = new JPanel();
    boolean isError = false;
    ExecuteCommandThread execThread;
    private static int MAXUNDO = 10;
    private String[] undoStack = new String[MAXUNDO + 1];
    private int undoPointer = 0;
    private boolean undoSaved = false;
    private boolean dontsave;

    public AppConsole() {
    }

    @Override
    public void start(Viewer viewer) {
        this.setup(viewer, null, null);
    }

    public AppConsole(JmolViewer jmolViewer, Container container, String string) {
        this.setup((Viewer)jmolViewer, container, string);
    }

    private void setup(Viewer viewer, Container container, String string) {
        this.setViewer(viewer);
        Window window = Platform.getWindow((Container)viewer.getDisplay());
        JFrame jFrame = this.vwrFrame = window instanceof JFrame ? (JFrame)window : null;
        if (container == null) {
            this.jcd = new JDialog(this.vwrFrame, null, false);
            this.jcd.setSize(645, 400);
            this.jcd.setLocationRelativeTo(this.vwrFrame);
            this.externalContainer = this.jcd;
        } else {
            this.externalContainer = container;
            viewer.setConsole(this);
        }
        this.addWindowListener();
        this.layoutWindow(string);
    }

    @Override
    public void sendConsoleEcho(String string) {
        if (string == null) {
            this.updateLabels();
        } else {
            this.console.outputEcho(string);
        }
        this.setError(false);
    }

    @Override
    public void sendConsoleMessage(String string) {
        if (string == null) {
            this.console.clearContent(null);
            this.console.outputStatus("");
        } else if (string.indexOf("ERROR:") >= 0) {
            this.console.outputError(string);
            this.setError(true);
        } else {
            this.console.outputStatus(string);
            this.isError = false;
        }
    }

    @Override
    protected JmolAbstractButton setButton(String string) {
        JmolAbstractButton jmolAbstractButton = super.setButton(string);
        this.buttonPanel.add((JButton)((Object)jmolAbstractButton));
        return jmolAbstractButton;
    }

    @Override
    protected void setupLabels() {
        this.labels.put("Check", GT._("Check"));
        this.labels.put("Clear", GT._("Clear"));
        this.labels.put("Close", GT._("Close"));
        this.labels.put("Halt", GT._("Halt"));
        this.labels.put("Help", GT._("Help"));
        this.labels.put("Editor", GT._("Editor"));
        this.labels.put("History", GT._("History"));
        this.labels.put("State", GT._("State"));
        this.labels.put("Step", GT._("Step"));
        this.labels.put("Top", GT._("Top"));
        this.labels.put("Undo", GT._("Undo"));
        this.labels.put("Redo", GT._("Redo"));
        this.labels.put("Variables", GT._("Variables"));
    }

    @Override
    protected void layoutWindow(String string) {
        this.setTitle();
        this.console = new ConsoleTextPane(this);
        this.console.setPrompt();
        this.console.setDragEnabled(true);
        if (string == null) {
            string = ALL_BUTTONS;
        }
        JScrollPane jScrollPane = new JScrollPane(this.console);
        String[] stringArray = PT.getTokens(string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.enableButton(stringArray[i]);
        }
        AppConsole.setEnabled(this.undoButton, false);
        AppConsole.setEnabled(this.redoButton, false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.buttonPanel, "Center");
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jPanel);
        jScrollPane.setMinimumSize(new Dimension(300, 300));
        jScrollPane.setPreferredSize(new Dimension(5000, 5000));
        jPanel.setMinimumSize(new Dimension(60, 60));
        jPanel.setMaximumSize(new Dimension(1000, 60));
        jPanel.setPreferredSize(new Dimension(60, 60));
        jSplitPane.setDividerSize(0);
        jSplitPane.setResizeWeight(0.95);
        this.getPane().add(jSplitPane);
    }

    private static void setEnabled(JmolAbstractButton jmolAbstractButton, boolean bl) {
        if (jmolAbstractButton != null) {
            jmolAbstractButton.setEnabled(bl);
        }
    }

    private void enableButton(String string) {
        switch ("Check     Clear     Close     Editor    Halt      Help      History   State     Step      Top       UndoRedo  Variables ".indexOf(string)) {
            case 0: {
                this.checkButton = this.setButton("Check");
                break;
            }
            case 10: {
                this.clearButton = this.setButton("Clear");
                break;
            }
            case 20: {
                this.closeButton = this.setButton("Close");
                break;
            }
            case 30: {
                this.editButton = this.setButton("Editor");
                break;
            }
            case 40: {
                this.haltButton = this.setButton("Halt");
                break;
            }
            case 50: {
                this.helpButton = this.setButton("Help");
                break;
            }
            case 60: {
                this.historyButton = this.setButton("History");
                break;
            }
            case 70: {
                this.stateButton = this.setButton("State");
                break;
            }
            case 80: {
                this.stepButton = this.setButton("Step");
                break;
            }
            case 90: {
                this.topButton = this.setButton("Top");
                break;
            }
            case 100: {
                this.undoButton = this.setButton("Undo");
                this.redoButton = this.setButton("Redo");
                break;
            }
            case 110: {
                this.varButton = this.setButton("Variables");
            }
        }
    }

    private void setError(boolean bl) {
        this.isError = bl;
    }

    @Override
    public void enterPressed() {
        this.executeCommandAsThread(null);
    }

    @Override
    protected void execute(String string) {
        this.executeCommandAsThread(string);
    }

    void executeCommandAsThread(String string) {
        if (string == null) {
            string = this.console.getCommandString().trim();
        }
        if (string.equalsIgnoreCase("undo")) {
            this.undoRedo(false);
            this.console.appendNewline();
            this.console.setPrompt();
            return;
        }
        if (string.equalsIgnoreCase("redo")) {
            this.undoRedo(true);
            this.console.appendNewline();
            this.console.setPrompt();
            return;
        }
        if (string.equalsIgnoreCase("exitJmol")) {
            System.exit(0);
        } else if (string.length() == 0) {
            string = "!resume";
            this.undoSetEnabled();
        }
        if (string.length() > 0) {
            this.execThread = new ExecuteCommandThread(string);
            this.execThread.start();
        }
    }

    private void undoClear() {
        if (this.undoButton == null) {
            return;
        }
        for (int i = 0; i <= MAXUNDO; ++i) {
            this.undoStack[i] = null;
        }
        this.undoPointer = 0;
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
    }

    private boolean undoSetEnabled() {
        if (this.undoButton == null) {
            return false;
        }
        boolean bl = this.vwr.getBooleanProperty("undo") && this.vwr.getBooleanProperty("preserveState");
        this.undoButton.setEnabled(bl && this.undoPointer > 0 && this.undoStack[this.undoPointer - 1] != null);
        this.redoButton.setEnabled(bl && this.undoPointer < MAXUNDO && this.undoStack[this.undoPointer + 1] != null);
        return bl;
    }

    private void undoRedo(boolean bl) {
        if (this.undoButton == null) {
            return;
        }
        if (!this.undoSetEnabled()) {
            return;
        }
        int n = this.undoPointer + (bl ? 1 : -1);
        if (!this.undoSaved) {
            this.undoSave(false);
        }
        if (n > MAXUNDO || n < 0) {
            return;
        }
        String string = this.undoStack[n];
        if (string != null) {
            string = string + "#----";
            this.setError(false);
            this.vwr.evalStringQuiet(string);
            this.undoPointer = n;
        }
        this.undoSetEnabled();
    }

    private void undoSave(boolean bl) {
        int n;
        if (this.undoButton == null) {
            return;
        }
        if (!this.vwr.getBooleanProperty("undo") || !this.vwr.getBooleanProperty("preserveState")) {
            return;
        }
        for (n = this.undoPointer + 1; n <= MAXUNDO; ++n) {
            this.undoStack[n] = null;
        }
        Logger.startTimer("(console");
        try {
            this.undoStack[this.undoPointer] = (String)this.vwr.getProperty("readable", "stateInfo", null);
            if (bl && this.undoPointer == MAXUNDO) {
                for (n = 1; n <= MAXUNDO; ++n) {
                    this.undoStack[n - 1] = this.undoStack[n];
                }
                this.undoStack[AppConsole.MAXUNDO] = null;
            } else if (bl) {
                ++this.undoPointer;
            }
        }
        catch (Error error) {
            this.dontsave = true;
        }
        if (this.dontsave || Logger.checkTimer("(console", false) > 2000) {
            this.vwr.setBooleanProperty("undo", false);
            this.undoClear();
            Logger.info("command processing slow; undo disabled");
        } else {
            this.undoSetEnabled();
        }
        this.undoSaved = true;
    }

    void executeCommand(String string) {
        boolean bl;
        this.console.appendNewline();
        this.console.setPrompt();
        if (string.length() == 0) {
            this.console.grabFocus();
            return;
        }
        if (string.charAt(0) != '!' && this.vwr.getBooleanProperty("executionPaused")) {
            string = "!" + string;
        }
        if (string.charAt(0) != '!' && !this.isError) {
            this.undoSave(true);
        }
        this.setError(false);
        this.undoSaved = false;
        String string2 = null;
        boolean bl2 = bl = string.indexOf("WAITTEST ") == 0;
        if (bl) {
            Object object = this.vwr.scriptWaitStatus(string.substring(5), "+fileLoaded,+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated");
            if (object instanceof List) {
                List list = (List)object;
                for (int i = 0; i < list.size(); ++i) {
                    List list2 = (List)list.get(i);
                    for (int j = 0; j < list2.size(); ++j) {
                        List list3 = (List)list2.get(j);
                        Logger.info("msg#=" + list3.get(0) + " " + list3.get(1) + " intInfo=" + list3.get(2) + " stringInfo=" + list3.get(3));
                    }
                }
            }
            this.console.appendNewline();
        } else {
            boolean bl3;
            boolean bl4 = this.vwr.isScriptExecuting();
            string2 = "";
            String string3 = string;
            boolean bl5 = bl3 = string3.charAt(0) == '!';
            if (bl3) {
                string3 = string3.substring(1);
            }
            if (this.vwr.checkHalt(string3, bl3)) {
                String string4 = string2 = bl4 ? "script execution halted with " + string : "no script was executing";
            }
            if (string2.length() > 0) {
                this.console.outputError(string2);
            } else {
                this.vwr.script(string + (string.indexOf("\u0001##") >= 0 ? "" : "\u0001## EDITOR_IGNORE ##"));
            }
        }
        if (string.indexOf("\u0001##") < 0) {
            this.console.grabFocus();
        }
    }

    @Override
    protected void clearContent(String string) {
        this.console.clearContent(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.console.grabFocus();
        Object object = actionEvent.getSource();
        if (object == this.topButton) {
            if (this.scriptEditor != null) {
                this.scriptEditor.gotoTop();
            }
            return;
        }
        if (object == this.checkButton && this.scriptEditor != null) {
            this.scriptEditor.checkScript();
        }
        if (object == this.stepButton) {
            if (this.scriptEditor != null) {
                this.scriptEditor.doStep();
            }
            return;
        }
        if (object == this.closeButton) {
            this.setVisible(false);
            return;
        }
        if (object == this.haltButton) {
            this.vwr.haltScriptExecution();
            return;
        }
        if (object == this.varButton) {
            this.execute("!show variables");
            return;
        }
        if (object == this.clearButton) {
            this.console.clearContent(null);
            return;
        }
        if (object == this.undoButton) {
            this.undoRedo(false);
            return;
        }
        if (object == this.redoButton) {
            this.undoRedo(true);
            return;
        }
        if (object == this.helpButton) {
            URL uRL = this.getClass().getClassLoader().getResource("org/openscience/jmol/Data/guide/ch04.html");
            if (uRL == null) {
                this.vwr.script("help");
            } else {
                new HelpDialog(null, uRL).setVisible(true);
            }
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    public String getText() {
        return this.console.getText();
    }

    class ConsoleDocument
    extends DefaultStyledDocument {
        private ConsoleTextPane consoleTextPane;
        SimpleAttributeSet attError = new SimpleAttributeSet();
        SimpleAttributeSet attEcho;
        SimpleAttributeSet attPrompt;
        SimpleAttributeSet attUserInput;
        SimpleAttributeSet attStatus;
        private Position positionBeforePrompt;
        private Position positionAfterPrompt;
        private int offsetAfterPrompt;

        ConsoleDocument() {
            StyleConstants.setForeground(this.attError, Color.red);
            this.attPrompt = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attPrompt, Color.magenta);
            this.attUserInput = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attUserInput, Color.black);
            this.attEcho = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attEcho, Color.blue);
            StyleConstants.setBold(this.attEcho, true);
            this.attStatus = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attStatus, Color.black);
            StyleConstants.setItalic(this.attStatus, true);
        }

        void setConsoleTextPane(ConsoleTextPane consoleTextPane) {
            this.consoleTextPane = consoleTextPane;
        }

        boolean isAtEnd() {
            return this.consoleTextPane.getCaretPosition() == this.getLength();
        }

        void clearContent() {
            try {
                super.remove(0, this.getLength());
            }
            catch (BadLocationException badLocationException) {
                Logger.errorEx("Could not clear script window content", badLocationException);
            }
        }

        void setPrompt() {
            try {
                super.insertString(this.getLength(), "$ ", this.attPrompt);
                this.setOffsetPositions();
                this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        void setOffsetPositions() {
            try {
                this.offsetAfterPrompt = this.getLength();
                this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
                this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        void setNoPrompt() {
            try {
                this.offsetAfterPrompt = this.getLength();
                this.positionAfterPrompt = this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt);
                this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        void outputBeforePrompt(String string, SimpleAttributeSet simpleAttributeSet) {
            try {
                int n = this.consoleTextPane.getCaretPosition();
                Position position = this.createPosition(n);
                n = this.positionBeforePrompt.getOffset();
                super.insertString(n, string + "\n", simpleAttributeSet);
                this.offsetAfterPrompt += string.length() + 1;
                this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
                this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
                n = position.getOffset();
                this.consoleTextPane.setCaretPosition(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.consoleTextPane.setCaretPosition(this.getLength());
            }
        }

        void outputError(String string) {
            this.outputBeforePrompt(string, this.attError);
        }

        void outputErrorForeground(String string) {
            try {
                super.insertString(this.getLength(), string + "\n", this.attError);
                this.consoleTextPane.setCaretPosition(this.getLength());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        void outputEcho(String string) {
            this.outputBeforePrompt(string, this.attEcho);
        }

        void outputStatus(String string) {
            this.outputBeforePrompt(string, this.attStatus);
        }

        void appendNewline() {
            try {
                super.insertString(this.getLength(), "\n", this.attUserInput);
                this.consoleTextPane.setCaretPosition(this.getLength());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2 = string.indexOf(10);
            if (n2 != 0) {
                if (n < this.offsetAfterPrompt) {
                    n = this.getLength();
                }
                super.insertString(n, string, attributeSet == this.attError ? attributeSet : this.attUserInput);
                this.consoleTextPane.setCaretPosition(n + string.length());
            }
            if (n2 >= 0) {
                this.consoleTextPane.enterPressed();
            }
        }

        String getCommandString() {
            String string = "";
            try {
                int n = this.positionAfterPrompt.getOffset();
                string = this.getText(n, this.getLength() - n);
                while (string.length() > 0 && string.charAt(0) == ' ') {
                    string = string.substring(1);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            return string;
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            if (n < this.offsetAfterPrompt) {
                if ((n2 -= this.offsetAfterPrompt - n) <= 0) {
                    return;
                }
                n = this.offsetAfterPrompt;
            }
            super.remove(n, n2);
        }

        @Override
        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (n < this.offsetAfterPrompt) {
                if (n + n2 < this.offsetAfterPrompt) {
                    n = this.getLength();
                    n2 = 0;
                } else {
                    n2 -= this.offsetAfterPrompt - n;
                    n = this.offsetAfterPrompt;
                }
            }
            super.replace(n, n2, string, attributeSet);
        }

        void replaceCommand(String string, boolean bl) throws BadLocationException {
            if (this.positionAfterPrompt == this.positionBeforePrompt) {
                return;
            }
            this.replace(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, string, bl ? this.attError : this.attUserInput);
        }

        void colorCommand(SimpleAttributeSet simpleAttributeSet) {
            if (this.positionAfterPrompt == this.positionBeforePrompt) {
                return;
            }
            this.setCharacterAttributes(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, simpleAttributeSet, true);
        }
    }

    class ConsoleTextPane
    extends JTextPane {
        private ConsoleDocument consoleDoc;
        private EnterListener enterListener;
        boolean checking;

        ConsoleTextPane(AppConsole appConsole2) {
            super(new ConsoleDocument());
            this.checking = false;
            this.consoleDoc = (ConsoleDocument)this.getDocument();
            this.consoleDoc.setConsoleTextPane(this);
            this.enterListener = appConsole2;
        }

        public String getCommandString() {
            String string = this.consoleDoc.getCommandString();
            return string;
        }

        public void setPrompt() {
            this.consoleDoc.setPrompt();
        }

        public void appendNewline() {
            this.consoleDoc.appendNewline();
        }

        public void outputError(String string) {
            this.consoleDoc.outputError(string);
        }

        public void outputErrorForeground(String string) {
            this.consoleDoc.outputErrorForeground(string);
        }

        public void outputEcho(String string) {
            this.consoleDoc.outputEcho(string);
        }

        public void outputStatus(String string) {
            this.consoleDoc.outputStatus(string);
        }

        public void enterPressed() {
            if (this.enterListener != null) {
                this.enterListener.enterPressed();
            }
        }

        public void clearContent(String string) {
            this.consoleDoc.clearContent();
            if (string != null) {
                this.consoleDoc.outputEcho(string);
            }
            this.setPrompt();
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getID();
            if (n2 == 401) {
                switch (n) {
                    case 67: {
                        if (!keyEvent.isControlDown() || !keyEvent.isAltDown()) break;
                        keyEvent.consume();
                        AppConsole.this.vwr.script("!quit");
                        return;
                    }
                    case 9: {
                        keyEvent.consume();
                        if (!this.consoleDoc.isAtEnd()) break;
                        String string = AppConsole.this.completeCommand(this.consoleDoc.getCommandString());
                        if (string != null) {
                            try {
                                this.consoleDoc.replaceCommand(string, false);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        ++AppConsole.this.nTab;
                        return;
                    }
                    case 27: {
                        keyEvent.consume();
                        try {
                            this.consoleDoc.replaceCommand("", false);
                            break;
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
                AppConsole.this.nTab = 0;
            }
            if (n == 38 && n2 == 401 && !keyEvent.isControlDown()) {
                this.recallCommand(true);
            } else if (n == 40 && n2 == 401 && !keyEvent.isControlDown()) {
                this.recallCommand(false);
            } else if ((n == 40 || n == 38) && n2 == 401 && keyEvent.isControlDown()) {
                super.processKeyEvent(new KeyEvent((Component)keyEvent.getSource(), n2, keyEvent.getWhen(), 0, n, keyEvent.getKeyChar(), keyEvent.getKeyLocation()));
            } else {
                super.processKeyEvent(keyEvent);
                if (n2 == 402 && keyEvent.getModifiers() < 2 && (n > 40 && n < 400 || n == 8)) {
                    this.checkCommand();
                }
            }
        }

        void recallCommand(boolean bl) {
            String string = AppConsole.this.vwr.getSetHistory(bl ? -1 : 1);
            if (string == null) {
                return;
            }
            boolean bl2 = false;
            try {
                if (string.endsWith("#??")) {
                    bl2 = true;
                    string = string.substring(0, string.indexOf("#??"));
                }
                string = PT.trim(string, ";");
                this.consoleDoc.replaceCommand(string, bl2);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        synchronized void checkCommand() {
            String string = this.consoleDoc.getCommandString();
            if (string.length() == 0 || string.charAt(0) == '!' || AppConsole.this.vwr.isScriptExecuting() || AppConsole.this.vwr.getBooleanProperty("executionPaused")) {
                return;
            }
            this.checking = true;
            this.consoleDoc.colorCommand(AppConsole.this.vwr.scriptCheck(string) instanceof String ? this.consoleDoc.attError : this.consoleDoc.attUserInput);
            this.checking = false;
        }
    }

    class ExecuteCommandThread
    extends Thread {
        String strCommand;

        ExecuteCommandThread(String string) {
            this.strCommand = string;
            this.setName("appConsoleExecuteCommandThread");
        }

        @Override
        public void run() {
            try {
                while (AppConsole.this.console.checking) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break;
                    }
                }
                AppConsole.this.executeCommand(this.strCommand);
            }
            catch (Exception exception) {
                Logger.errorEx("execution command interrupted!", exception);
            }
        }
    }
}

