/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.M3;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementPending;
import org.jmol.render.LabelsRenderer;
import org.jmol.shape.Measures;
import org.jmol.util.Point3fi;
import org.jmol.util.Vibration;

public class MeasuresRenderer
extends LabelsRenderer {
    private boolean doJustify;
    private boolean modulating;
    private short mad0;
    private Map<Integer, Point3fi> mpts;
    private Measurement m;
    private Point3fi[] p;
    private int count;
    private A4 aaT;
    private M3 matrixT;

    @Override
    protected void initRenderer() {
        this.mpts = new Hashtable<Integer, Point3fi>();
        this.p = new Point3fi[4];
    }

    @Override
    protected boolean render() {
        if (!this.g3d.checkTranslucent(false)) {
            return false;
        }
        if (this.atomPt == null) {
            this.atomPt = new Point3fi();
        }
        Measures measures = (Measures)this.shape;
        this.doJustify = this.vwr.getBoolean(603979872);
        this.modulating = this.ms.bsModulated != null;
        this.imageFontScaling = this.vwr.getImageFontScaling();
        this.mad0 = measures.mad;
        this.font3d = this.g3d.getFont3DScaled(measures.font3d, this.imageFontScaling);
        this.m = measures.mPending;
        if (!this.isExport && this.m != null && (this.count = this.m.count) != 0) {
            this.renderPendingMeasurement();
        }
        if (!this.vwr.getBoolean(603979926)) {
            return false;
        }
        boolean bl = this.vwr.getBoolean(603979879);
        measures.setVisibilityInfo();
        int n = measures.measurementCount;
        while (--n >= 0) {
            this.m = (Measurement)measures.measurements.get(n);
            if (!this.m.isVisible || !this.m.isValid || (this.count = this.m.count) == 1 && this.m.traceX == Integer.MIN_VALUE) continue;
            this.getPoints();
            this.colix = this.m.colix;
            if (this.colix == 0) {
                this.colix = measures.colix;
            }
            if (this.colix == 0) {
                this.colix = this.vwr.getColixBackgroundContrast();
            }
            this.labelColix = this.m.labelColix;
            if (this.labelColix == 0) {
                this.labelColix = this.vwr.getColixBackgroundContrast();
            } else if (this.labelColix == -1) {
                this.labelColix = this.colix;
            }
            this.g3d.setC(this.colix);
            this.colixA = this.colixB = this.colix;
            this.renderMeasurement(bl);
        }
        return false;
    }

    private void getPoints() {
        int n = this.count;
        while (--n >= 0) {
            Point3fi point3fi;
            int n2 = this.m.getAtomIndex(n + 1);
            Point3fi point3fi2 = point3fi = n2 >= 0 && this.modulating ? this.getModAtom(n2) : this.m.getAtom(n + 1);
            if (point3fi.sD < 0) {
                this.tm.transformPtScr(point3fi, this.pt0i);
                point3fi.sX = this.pt0i.x;
                point3fi.sY = this.pt0i.y;
                point3fi.sZ = this.pt0i.z;
            }
            this.p[n] = point3fi;
        }
        if (this.modulating) {
            this.m.refresh(this.p);
        }
    }

    private Point3fi getModAtom(int n) {
        Integer n2 = n;
        Point3fi point3fi = this.mpts.get(n2);
        if (point3fi != null) {
            n2 = null;
        }
        Vibration vibration = this.ms.getVibration(n, false);
        Atom atom = this.ms.at[n];
        if (vibration == null) {
            point3fi = atom;
        } else {
            if (point3fi == null) {
                point3fi = new Point3fi();
            }
            point3fi.setT(atom);
            if (this.vwr.tm.vibrationOn) {
                this.vwr.tm.getVibrationPoint(vibration, point3fi, Float.NaN);
            }
            point3fi.sD = (short)-1;
        }
        if (n2 != null) {
            this.mpts.put(n2, point3fi);
        }
        return point3fi;
    }

    private void renderMeasurement(boolean bl) {
        String string;
        String string2 = string = bl ? this.m.getString() : null;
        if (string != null) {
            if (string.length() == 0) {
                string = null;
            } else if (this.m.text != null) {
                this.m.text.setText(string);
                this.m.text.setColix(this.labelColix);
            }
        }
        if (this.m.mad == 0) {
            this.dotsOrDashes = false;
            this.mad = this.mad0;
        } else {
            this.mad = (short)this.m.mad;
            this.dotsOrDashes = true;
            this.dashDots = this.mad < 0 ? null : ndots;
        }
        switch (this.count) {
            case 1: {
                this.drawLine(this.p[0].sX, this.p[0].sY, this.p[0].sZ, this.m.traceX, this.m.traceY, this.p[0].sZ, this.mad);
                break;
            }
            case 2: {
                this.renderDistance(string, this.p[0], this.p[1]);
                break;
            }
            case 3: {
                this.renderAngle(string, this.p[0], this.p[1], this.p[2]);
                break;
            }
            case 4: {
                this.renderTorsion(string, this.p[0], this.p[1], this.p[2], this.p[3]);
            }
        }
        this.p[3] = null;
        this.p[2] = null;
        this.p[1] = null;
        this.p[0] = null;
    }

    void renderDistance(String string, Point3fi point3fi, Point3fi point3fi2) {
        int n;
        this.tickInfo = this.m.tickInfo;
        if (this.tickInfo != null) {
            this.drawLine(point3fi.sX, point3fi.sY, point3fi.sZ, point3fi2.sX, point3fi2.sY, point3fi2.sZ, this.mad);
            this.drawTicks(point3fi, point3fi2, this.mad, string != null);
            return;
        }
        int n2 = point3fi.sZ - point3fi.sD - 10;
        int n3 = point3fi2.sZ - point3fi2.sD - 10;
        int n4 = this.drawLine(point3fi.sX, point3fi.sY, n2, point3fi2.sX, point3fi2.sY, n3, this.mad);
        if (string == null) {
            return;
        }
        if (this.mad > 0) {
            n4 <<= 1;
        }
        if ((n = (n2 + n3) / 2) < 1) {
            n = 1;
        }
        int n5 = (point3fi.sX + point3fi2.sX) / 2;
        int n6 = (point3fi.sY + point3fi2.sY) / 2;
        if (this.m.text == null) {
            this.g3d.setC(this.labelColix);
            this.drawString(n5, n6, n, n4, this.doJustify && (n5 - point3fi.sX) * (n6 - point3fi.sY) > 0, false, false, this.doJustify ? 0 : Integer.MAX_VALUE, string);
        } else {
            this.atomPt.ave(point3fi, point3fi2);
            this.atomPt.sX = (point3fi.sX + point3fi2.sX) / 2;
            this.atomPt.sY = (point3fi.sY + point3fi2.sY) / 2;
            this.renderLabelOrMeasure(this.m.text, string);
        }
    }

    private void renderAngle(String string, Point3fi point3fi, Point3fi point3fi2, Point3fi point3fi3) {
        int n = point3fi2.sD + 10;
        int n2 = point3fi.sZ - point3fi.sD - 10;
        int n3 = point3fi2.sZ - n;
        int n4 = point3fi3.sZ - point3fi3.sD - 10;
        int n5 = this.drawLine(point3fi.sX, point3fi.sY, n2, point3fi2.sX, point3fi2.sY, n3, this.mad);
        n5 += this.drawLine(point3fi2.sX, point3fi2.sY, n3, point3fi3.sX, point3fi3.sY, n4, this.mad);
        if (string == null) {
            return;
        }
        n5 = (n5 + 1) / 2;
        if (this.m.value > 175.0f) {
            if (this.m.text == null) {
                int n6 = (int)Math.floor(5.0f * this.imageFontScaling);
                this.g3d.setC(this.labelColix);
                this.drawString(point3fi2.sX + n6, point3fi2.sY - n6, n3, n5, false, false, false, this.doJustify ? 0 : Integer.MAX_VALUE, string);
            } else {
                this.atomPt.setT(point3fi2);
                this.renderLabelOrMeasure(this.m.text, string);
            }
            return;
        }
        if (this.m.isTainted()) {
            float f = Measure.computeAngle(this.p[0], this.p[1], this.p[2], this.vectorT2, this.vectorT3, false);
            this.vectorT.cross(this.vectorT2, this.vectorT3);
            this.m.renderAxis = A4.new4(this.vectorT.x, this.vectorT.y, this.vectorT.z, f);
            this.vectorT2.normalize();
            this.vectorT2.scale(0.5f);
            this.m.renderArc = P3.newP(this.vectorT2);
        }
        if (this.aaT == null) {
            this.aaT = new A4();
            this.matrixT = new M3();
        }
        int n7 = (int)Math.floor((double)this.m.renderAxis.angle / (Math.PI * 2) * 64.0);
        float f = this.m.renderAxis.angle / (float)n7;
        this.aaT.setAA(this.m.renderAxis);
        int n8 = n7 / 2;
        int n9 = n7;
        while (--n9 >= 0) {
            this.aaT.angle = (float)n9 * f;
            this.pointT.setT(this.m.renderArc);
            this.matrixT.setAA(this.aaT).rotate(this.pointT);
            this.pointT.add(point3fi2);
            P3i p3i = this.tm.transformPt(this.pointT);
            int n10 = p3i.z - n;
            if (n10 < 0) {
                n10 = 0;
            }
            this.g3d.drawPixel(p3i.x, p3i.y, n10);
            if (n9 != n8) continue;
            this.pointT.setT(this.m.renderArc);
            this.pointT.scale(1.1f);
            this.matrixT.rotate(this.pointT);
            this.pointT.add(point3fi2);
            this.tm.transformPt(this.pointT);
            int n11 = p3i.z - n;
            if (this.m.text == null) {
                this.g3d.setC(this.labelColix);
                this.drawString(p3i.x, p3i.y, n11, n5, p3i.x < point3fi2.sX, false, false, this.doJustify ? point3fi2.sY : Integer.MAX_VALUE, string);
                continue;
            }
            this.atomPt.setT(this.pointT);
            this.renderLabelOrMeasure(this.m.text, string);
        }
    }

    private void renderTorsion(String string, Point3fi point3fi, Point3fi point3fi2, Point3fi point3fi3, Point3fi point3fi4) {
        int n = point3fi.sZ - point3fi.sD - 10;
        int n2 = point3fi2.sZ - point3fi2.sD - 10;
        int n3 = point3fi3.sZ - point3fi3.sD - 10;
        int n4 = point3fi4.sZ - point3fi4.sD - 10;
        int n5 = this.drawLine(point3fi.sX, point3fi.sY, n, point3fi2.sX, point3fi2.sY, n2, this.mad);
        n5 += this.drawLine(point3fi2.sX, point3fi2.sY, n2, point3fi3.sX, point3fi3.sY, n3, this.mad);
        n5 += this.drawLine(point3fi3.sX, point3fi3.sY, n3, point3fi4.sX, point3fi4.sY, n4, this.mad);
        if (string == null) {
            return;
        }
        n5 /= 3;
        if (this.m.text == null) {
            this.g3d.setC(this.labelColix);
            this.drawString((point3fi.sX + point3fi2.sX + point3fi3.sX + point3fi4.sX) / 4, (point3fi.sY + point3fi2.sY + point3fi3.sY + point3fi4.sY) / 4, (n + n2 + n3 + n4) / 4, n5, false, false, false, this.doJustify ? 0 : Integer.MAX_VALUE, string);
        } else {
            this.atomPt.add2(point3fi, point3fi2);
            this.atomPt.add(point3fi3);
            this.atomPt.add(point3fi4);
            this.atomPt.scale(0.25f);
            this.renderLabelOrMeasure(this.m.text, string);
        }
    }

    private void renderPendingMeasurement() {
        boolean bl;
        this.getPoints();
        boolean bl2 = bl = this.m.traceX == Integer.MIN_VALUE;
        short s = bl ? this.vwr.cm.colixRubberband : (this.count == 2 ? (short)20 : 23);
        this.labelColix = s;
        this.g3d.setC(s);
        if (((MeasurementPending)this.m).haveTarget) {
            this.renderMeasurement(bl);
            return;
        }
        Point3fi point3fi = this.p[this.count - 1];
        if (this.count > 1) {
            this.renderMeasurement(false);
        }
        int n = point3fi.sZ - point3fi.sD - 10;
        int n2 = this.vwr.getCursorX();
        int n3 = this.vwr.getCursorY();
        if (this.g3d.isAntialiased()) {
            n2 <<= 1;
            n3 <<= 1;
        }
        this.drawLine(point3fi.sX, point3fi.sY, n, n2, n3, 0, this.mad);
    }

    @Override
    protected int drawLine(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = (int)(n7 >= 20 && this.exportType != 1 ? this.vwr.tm.scaleToScreen((n3 + n6) / 2, n7) : (float)n7);
        if (this.dotsOrDashes && (this.dashDots == null || this.dashDots == ndots)) {
            this.width = n8;
        }
        return this.drawLine2(n, n2, n3, n4, n5, n6, n8);
    }
}

