/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class EspressoReader
extends AtomSetCollectionReader {
    private float[] cellParams;
    private Double totEnergy;
    private boolean endFlag;
    private float aPar;

    @Override
    protected void initializeReader() {
        this.setSpaceGroupName("P1");
        this.doApplySymmetry = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.contains("lattice parameter (a_0)") || this.line.contains("lattice parameter (alat)")) {
            this.readAparam();
        } else if (this.line.contains("crystal axes:")) {
            this.readCellParam(false);
        } else if (this.line.contains("CELL_PARAMETERS")) {
            this.readCellParam(true);
        } else if (this.line.contains("Cartesian axes")) {
            this.discardLinesUntilContains("positions (");
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtoms();
            }
        } else if (this.line.contains("POSITIONS (")) {
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtoms();
            }
        } else if (this.line.contains("!    total energy")) {
            this.readEnergy();
        } else if (this.line.contains("A final scf")) {
            this.endFlag = true;
        }
        return true;
    }

    private void readAparam() throws Exception {
        this.aPar = this.parseFloatStr(this.getTokens()[4]) * 0.5291772f;
    }

    private void readCellParam(boolean bl) throws Exception {
        int n;
        int n2 = n = bl ? 0 : 3;
        if (bl && this.line.contains("=")) {
            this.aPar = this.parseFloatStr(this.line.substring(this.line.indexOf("=") + 1)) * 0.5291772f;
        }
        this.cellParams = new float[9];
        int n3 = 0;
        for (int i = 0; i < 3; ++i) {
            String[] stringArray = EspressoReader.getTokensStr(this.rd());
            this.cellParams[n3++] = this.parseFloatStr(stringArray[n]) * this.aPar;
            this.cellParams[n3++] = this.parseFloatStr(stringArray[n + 1]) * this.aPar;
            this.cellParams[n3++] = this.parseFloatStr(stringArray[n + 2]) * this.aPar;
        }
    }

    private void newAtomSet() throws Exception {
        this.asc.newAtomSet();
        if (this.totEnergy != null) {
            this.setEnergy();
        }
    }

    private void setCellParams() throws Exception {
        if (this.cellParams != null) {
            this.addPrimitiveLatticeVector(0, this.cellParams, 0);
            this.addPrimitiveLatticeVector(1, this.cellParams, 3);
            this.addPrimitiveLatticeVector(2, this.cellParams, 6);
            this.setSpaceGroupName("P1");
        }
    }

    private void readAtoms() throws Exception {
        this.newAtomSet();
        boolean bl = this.line.contains("alat") || this.line.contains("a_0");
        boolean bl2 = this.line.contains("site n.");
        boolean bl3 = this.line.contains("crystal");
        boolean bl4 = this.line.contains("bohr");
        boolean bl5 = this.line.contains("angstrom");
        if (bl || bl3 || bl5) {
            this.setCellParams();
        }
        this.setFractionalCoordinates(bl3);
        while (this.rd() != null && this.line.length() > 45) {
            String[] stringArray = this.getTokens();
            Atom atom = this.asc.addNewAtom();
            atom.atomName = stringArray[bl4 || stringArray.length == 4 || !bl2 ? 0 : 1];
            int n = bl4 || stringArray.length == 4 || !bl2 ? 1 : stringArray.length - 4;
            float f = this.parseFloatStr(stringArray[n++]);
            float f2 = this.parseFloatStr(stringArray[n++]);
            float f3 = this.parseFloatStr(stringArray[n++]);
            atom.set(f, f2, f3);
            if (bl4) {
                atom.scale(0.5291772f);
            } else if (bl) {
                atom.scale(this.aPar);
            }
            this.setAtomCoord(atom);
        }
        this.applySymmetryAndSetTrajectory();
        if (this.endFlag) {
            this.discardLinesUntilContains("Harris-Foulkes estimate");
        }
    }

    private void readEnergy() throws Exception {
        this.totEnergy = Double.parseDouble(EspressoReader.getTokensStr(this.line.substring(this.line.indexOf("=") + 1))[0]);
    }

    private void setEnergy() {
        this.asc.setAtomSetEnergy("" + this.totEnergy, this.totEnergy.floatValue());
        this.asc.setInfo("Energy", this.totEnergy);
        this.asc.setAtomSetName("E = " + this.totEnergy + " Ry");
    }
}

