/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.adapter.readers.molxyz.MolReader;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class V3000Rdr {
    private MolReader mr;
    private String line;
    private Map<String, String[]> userData;

    V3000Rdr set(AtomSetCollectionReader atomSetCollectionReader) {
        this.mr = (MolReader)atomSetCollectionReader;
        return this;
    }

    void readAtomsAndBonds(String[] stringArray) throws Exception {
        int n = this.mr.parseIntStr(stringArray[3]);
        this.readAtoms(n);
        this.readBonds(this.mr.parseIntStr(stringArray[4]));
        this.readUserData(n);
    }

    private void readAtoms(int n) throws Exception {
        this.mr.discardLinesUntilContains("BEGIN ATOM");
        for (int i = 0; i < n; ++i) {
            this.rd();
            this.checkLineContinuation();
            String[] stringArray = this.mr.getTokens();
            int n2 = this.mr.parseIntStr(stringArray[2]);
            String string = stringArray[3];
            if (string.equals("*")) continue;
            float f = this.mr.parseFloatStr(stringArray[4]);
            float f2 = this.mr.parseFloatStr(stringArray[5]);
            float f3 = this.mr.parseFloatStr(stringArray[6]);
            int n3 = 0;
            int n4 = 0;
            for (int j = 7; j < stringArray.length; ++j) {
                String string2 = stringArray[j].toUpperCase();
                if (string2.startsWith("CHG=")) {
                    n3 = this.mr.parseIntStr(stringArray[j].substring(4));
                    continue;
                }
                if (!string2.startsWith("MASS=")) continue;
                n4 = this.mr.parseIntStr(stringArray[j].substring(5));
            }
            if (n4 > 1 && string.equals("H")) {
                n4 = 1 - n4;
            }
            this.mr.addMolAtom(n2, n4, string, n3, f, f2, f3);
        }
        this.mr.discardLinesUntilContains("END ATOM");
    }

    private void readBonds(int n) throws Exception {
        this.mr.discardLinesUntilContains("BEGIN BOND");
        for (int i = 0; i < n; ++i) {
            this.rd();
            int n2 = 0;
            this.checkLineContinuation();
            String[] stringArray = this.mr.getTokens();
            int n3 = this.mr.parseIntStr(stringArray[3]);
            String string = stringArray[4];
            String string2 = stringArray[5];
            String string3 = this.getField("CFG");
            if (string3 == null) {
                String string4 = this.getField("ENDPTS");
                if (string4 != null && this.line.indexOf("ATTACH=ALL") >= 0) {
                    stringArray = AtomSetCollectionReader.getTokensStr(string4);
                    int n4 = this.mr.parseIntStr(stringArray[0]);
                    int n5 = this.mr.fixOrder(n3, 0);
                    for (int j = 1; j <= n4; ++j) {
                        this.mr.asc.addNewBondFromNames(string, stringArray[j], n5);
                    }
                }
            } else {
                n2 = this.mr.parseIntStr(string3);
            }
            this.mr.addMolBond(string, string2, n3, n2);
        }
        this.mr.discardLinesUntilContains("END BOND");
    }

    private void readUserData(int n) throws Exception {
        Object object;
        this.userData = null;
        String string = null;
        while (!this.rd().contains("END CTAB")) {
            if (!this.line.contains("BEGIN SGROUP")) continue;
            while (!this.rd().contains("END SGROUP")) {
                boolean bl;
                String string2;
                Object object2;
                if (this.userData == null) {
                    this.userData = new Hashtable<String, String[]>();
                }
                if ((object2 = this.getField("ATOMS")) == null || (string2 = this.getField("FIELDNAME")) == null || (object = this.getField("FIELDDATA")) == null) continue;
                boolean bl2 = bl = (string2 = string2.toLowerCase()).indexOf("partial") >= 0;
                if (bl) {
                    if (string == null) {
                        string = string2;
                    } else if (!string.equals(string2)) {
                        bl = false;
                    }
                }
                String[] stringArray = null;
                float f = 0.0f;
                if (bl) {
                    f = this.mr.parseFloatStr((String)object);
                } else {
                    stringArray = this.userData.get(string2);
                    if (stringArray == null) {
                        stringArray = new String[n];
                        this.userData.put(string2, stringArray);
                    }
                }
                try {
                    String[] stringArray2 = AtomSetCollectionReader.getTokensStr((String)object2);
                    int n2 = stringArray2.length;
                    while (--n2 >= 1) {
                        String string3 = stringArray2[n2];
                        if (bl) {
                            this.mr.asc.getAtomFromName((String)string3).partialCharge = f;
                            continue;
                        }
                        stringArray[this.mr.parseIntStr((String)string3) - 1] = object;
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        if (this.userData == null) {
            return;
        }
        for (String string2 : this.userData.keySet()) {
            object = this.userData.get(string2);
            float[] fArray = new float[((String[])object).length];
            for (int i = 0; i < ((String[])object).length; ++i) {
                fArray[i] = object[i] == null ? 0.0f : this.mr.parseFloatStr(object[i]);
            }
            this.mr.asc.setAtomProperties(string2, fArray, -1, false);
        }
    }

    private String getField(String string) {
        int n = this.line.indexOf(string + "=");
        if (n < 0) {
            return null;
        }
        char c = ' ';
        switch (this.line.charAt(n += string.length() + 1)) {
            case '\"': {
                c = '\"';
                break;
            }
            case '(': {
                c = ')';
                break;
            }
            case '+': {
                break;
            }
            default: {
                --n;
            }
        }
        return this.line.substring(n + 1, (this.line + c).indexOf(c, n + 1));
    }

    private String rd() throws Exception {
        this.line = this.mr.rd();
        return this.line;
    }

    private void checkLineContinuation() throws Exception {
        while (this.line.endsWith("-")) {
            String string = this.line;
            this.rd();
            this.line = string + this.line;
        }
    }
}

