/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.T3i;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.renderbio.RocketsRenderer;
import org.jmol.shapebio.BioShape;
import org.jmol.util.C;

public class CartoonRenderer
extends RocketsRenderer {
    private boolean renderAsRockets;
    private boolean renderEdges;
    private boolean ladderOnly;
    private boolean renderRibose;
    P3i ptConnectScr = new P3i();
    P3 ptConnect = new P3();
    private final P3[] rPt = new P3[10];
    private final P3i[] rScr = new P3i[10];
    private final P3[] rPt5 = new P3[5];
    private final P3i[] rScr5 = new P3i[5];
    private P3 basePt;
    private P3i baseScreen;

    @Override
    protected void renderBioShape(BioShape bioShape) {
        if (this.wireframeOnly) {
            this.renderStrands();
            return;
        }
        this.newRockets = true;
        if (this.wingVectors == null || this.isCarbohydrate) {
            return;
        }
        this.getScreenControlPoints();
        if (this.isNucleic) {
            this.renderNucleic();
            return;
        }
        boolean bl = this.vwr.getBoolean(603979820);
        if (this.renderAsRockets != bl) {
            bioShape.falsifyMesh();
            this.renderAsRockets = bl;
        }
        boolean bl2 = bl = !this.vwr.getBoolean(603979900);
        if (this.renderArrowHeads != bl) {
            bioShape.falsifyMesh();
            this.renderArrowHeads = bl;
        }
        this.ribbonTopScreens = this.calcScreens(0.5f);
        this.ribbonBottomScreens = this.calcScreens(-0.5f);
        this.calcRopeMidPoints(this.newRockets);
        if (!this.renderArrowHeads) {
            this.calcScreenControlPoints(this.cordMidPoints);
            this.controlPoints = this.cordMidPoints;
        }
        this.renderRockets();
        this.vwr.freeTempPoints(this.cordMidPoints);
        this.vwr.freeTempScreens(this.ribbonTopScreens);
        this.vwr.freeTempScreens(this.ribbonBottomScreens);
    }

    void renderNucleic() {
        this.renderEdges = this.vwr.getBoolean(603979816);
        this.ladderOnly = this.vwr.getBoolean(603979818);
        this.renderRibose = this.vwr.getBoolean(603979819);
        boolean bl = this.vwr.getBoolean(603979966);
        int n = this.bsVisible.nextSetBit(0);
        while (n >= 0) {
            if (bl) {
                this.ptConnectScr.set((this.controlPointScreens[n].x + this.controlPointScreens[n + 1].x) / 2, (this.controlPointScreens[n].y + this.controlPointScreens[n + 1].y) / 2, (this.controlPointScreens[n].z + this.controlPointScreens[n + 1].z) / 2);
                this.ptConnect.ave((T3)this.controlPoints[n], (T3)this.controlPoints[n + 1]);
            } else {
                this.ptConnectScr.setT((T3i)this.controlPointScreens[n + 1]);
                this.ptConnect.setT((T3)this.controlPoints[n + 1]);
            }
            this.renderHermiteConic(n, false, 4);
            this.colix = this.getLeadColix(n);
            if (this.setBioColix(this.colix)) {
                this.renderNucleicBaseStep((NucleicMonomer)this.monomers[n], this.mads[n], this.ptConnectScr, this.ptConnect);
            }
            n = this.bsVisible.nextSetBit(n + 1);
        }
    }

    @Override
    protected void renderRockets() {
        boolean bl = false;
        boolean bl2 = false;
        ProteinStructure proteinStructure = null;
        int n = this.monomerCount;
        while (--n >= 0) {
            boolean bl3;
            ProteinStructure proteinStructure2 = (ProteinStructure)this.monomers[n].getStructure();
            if (proteinStructure2 != proteinStructure) {
                if (this.renderAsRockets) {
                    bl2 = false;
                }
                bl = false;
            }
            proteinStructure = proteinStructure2;
            boolean bl4 = this.isHelix(n);
            boolean bl5 = this.isSheet(n);
            boolean bl6 = bl3 = this.renderAsRockets || !this.renderArrowHeads ? bl4 : false;
            if (this.bsVisible.get(n) && !bl3) {
                if (bl5 || bl4) {
                    if (bl && bl5 || bl2 && bl4) {
                        this.renderHermiteRibbon(true, n, true);
                    } else {
                        this.renderHermiteArrowHead(n);
                    }
                } else {
                    this.renderHermiteConic(n, true, 7);
                }
            }
            bl = bl5;
            bl2 = bl4;
        }
        if (this.renderAsRockets || !this.renderArrowHeads) {
            this.renderCartoonRockets();
        }
    }

    private void renderCartoonRockets() {
        this.tPending = false;
        int n = this.bsVisible.nextSetBit(0);
        while (n >= 0) {
            if (this.isHelix(n)) {
                this.renderSpecialSegment((AlphaMonomer)this.monomers[n], this.getLeadColix(n), this.mads[n]);
            }
            n = this.bsVisible.nextSetBit(n + 1);
        }
        this.renderPending();
    }

    private void renderNucleicBaseStep(NucleicMonomer nucleicMonomer, short n, P3i p3i, P3 p3) {
        P3 p32;
        P3i p3i2;
        boolean bl;
        if (this.rScr[0] == null) {
            int n2 = 10;
            while (--n2 >= 0) {
                this.rScr[n2] = new P3i();
            }
            n2 = 5;
            while (--n2 >= 0) {
                this.rScr5[n2] = new P3i();
            }
            this.baseScreen = new P3i();
            this.basePt = new P3();
            this.rPt[9] = new P3();
        }
        if (this.renderEdges) {
            this.renderLeontisWesthofEdges(nucleicMonomer, (short)n);
            return;
        }
        nucleicMonomer.getBaseRing6Points(this.rPt);
        this.tm.transformPoints(6, (T3[])this.rPt, this.rScr);
        if (!this.ladderOnly) {
            this.renderRing6();
        }
        if (bl = nucleicMonomer.maybeGetBaseRing5Points(this.rPt5)) {
            if (this.ladderOnly) {
                p3i2 = this.rScr[2];
                p32 = this.rPt[2];
            } else {
                this.tm.transformPoints(5, (T3[])this.rPt5, this.rScr5);
                this.renderRing5();
                p3i2 = this.rScr5[3];
                p32 = this.rPt5[3];
            }
        } else {
            int n3 = this.ladderOnly ? 4 : 2;
            p3i2 = this.rScr[n3];
            p32 = this.rPt[n3];
        }
        this.mad = (short)(n > 1 ? n / 2 : n);
        float f = (float)this.mad / 2000.0f;
        int n4 = (int)this.vwr.tm.scaleToScreen(p3i.z, (int)this.mad);
        if (this.ladderOnly || !this.renderRibose) {
            this.g3d.fillCylinderScreen3I((byte)3, n4, p3i, p3i2, p3, p32, f);
        }
        if (this.ladderOnly) {
            return;
        }
        this.drawEdges(this.rScr, this.rPt, 6);
        if (bl) {
            this.drawEdges(this.rScr5, this.rPt5, 5);
        } else {
            this.renderEdge(this.rScr, this.rPt, 0, 5);
        }
        if (this.renderRibose) {
            this.baseScreen.setT((T3i)p3i2);
            this.basePt.setT((T3)p32);
            nucleicMonomer.getRiboseRing5Points(this.rPt);
            P3 p33 = this.rPt[9];
            p33.set(0.0f, 0.0f, 0.0f);
            for (int i = 0; i < 5; ++i) {
                p33.add((T3)this.rPt[i]);
            }
            p33.scale(0.2f);
            this.tm.transformPoints(10, (T3[])this.rPt, this.rScr);
            this.renderRibose();
            this.renderEdge(this.rScr, this.rPt, 2, 5);
            this.renderEdge(this.rScr, this.rPt, 3, 6);
            this.renderEdge(this.rScr, this.rPt, 6, 7);
            this.renderEdge(this.rScr, this.rPt, 7, 8);
            this.renderCyl(this.rScr[0], this.baseScreen, this.rPt[0], this.basePt);
            this.drawEdges(this.rScr, this.rPt, 5);
        }
    }

    private void drawEdges(P3i[] p3iArray, P3[] p3Array, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            --p3iArray[n2].z;
        }
        n2 = n;
        while (--n2 > 0) {
            this.renderEdge(p3iArray, p3Array, n2, n2 - 1);
        }
    }

    private void renderLeontisWesthofEdges(NucleicMonomer nucleicMonomer, short n) {
        if (!nucleicMonomer.getEdgePoints(this.rPt)) {
            return;
        }
        this.tm.transformPoints(6, (T3[])this.rPt, this.rScr);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 4, true);
        this.mad = (short)(n > 1 ? n / 2 : n);
        this.renderEdge(this.rScr, this.rPt, 0, 1);
        this.renderEdge(this.rScr, this.rPt, 1, 2);
        boolean bl = C.isColixTranslucent((short)this.colix);
        float f = C.getColixTranslucencyLevel((short)this.colix);
        short s = C.getColixTranslucent3((short)10, (boolean)bl, (float)f);
        short s2 = C.getColixTranslucent3((short)11, (boolean)bl, (float)f);
        short s3 = C.getColixTranslucent3((short)7, (boolean)bl, (float)f);
        this.g3d.setC(s);
        this.renderEdge(this.rScr, this.rPt, 2, 3);
        this.g3d.setC(s2);
        this.renderEdge(this.rScr, this.rPt, 3, 4);
        this.g3d.setC(s3);
        this.renderEdge(this.rScr, this.rPt, 4, 5);
    }

    private void renderEdge(P3i[] p3iArray, P3[] p3Array, int n, int n2) {
        this.renderCyl(p3iArray[n], p3iArray[n2], p3Array[n], p3Array[n2]);
    }

    private void renderCyl(P3i p3i, P3i p3i2, P3 p3, P3 p32) {
        this.g3d.fillCylinderScreen3I((byte)3, 3, p3i, p3i2, p3, p32, 0.005f);
    }

    private void renderTriangle(P3i[] p3iArray, P3[] p3Array, int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.g3d.setNoisySurfaceShade(p3iArray[n], p3iArray[n2], p3iArray[n3]);
        }
        this.g3d.fillTriangle3i(p3iArray[n], p3iArray[n2], p3iArray[n3], p3Array[n], p3Array[n2], p3Array[n3]);
    }

    private void renderRing6() {
        this.renderTriangle(this.rScr, this.rPt, 0, 2, 4, true);
        this.renderTriangle(this.rScr, this.rPt, 0, 1, 2, false);
        this.renderTriangle(this.rScr, this.rPt, 0, 4, 5, false);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 4, false);
    }

    private void renderRing5() {
        this.renderTriangle(this.rScr5, this.rPt5, 0, 1, 2, false);
        this.renderTriangle(this.rScr5, this.rPt5, 0, 2, 3, false);
        this.renderTriangle(this.rScr5, this.rPt5, 0, 3, 4, false);
    }

    private void renderRibose() {
        this.renderTriangle(this.rScr, this.rPt, 0, 1, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 1, 2, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 3, 4, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 4, 0, 9, true);
    }
}

