/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.Matrix;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.readers.cif.MSRdr;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.Logger;

class Subsystem {
    private MSRdr msRdr;
    private String code;
    private int d;
    private Matrix w;
    private SymmetryInterface symmetry;
    private Matrix[] modMatrices;
    private boolean isFinalized;

    Subsystem(MSRdr mSRdr, String string, Matrix matrix) {
        this.msRdr = mSRdr;
        this.code = string;
        this.w = matrix;
        this.d = matrix.getArray().length - 3;
    }

    public SymmetryInterface getSymmetry() {
        if (!this.isFinalized) {
            this.setSymmetry(true);
        }
        return this.symmetry;
    }

    public Matrix[] getModMatrices() {
        if (!this.isFinalized) {
            this.setSymmetry(true);
        }
        return this.modMatrices;
    }

    private void setSymmetry(boolean bl) {
        int n;
        Logger.info((String)("[subsystem " + this.code + "]"));
        Matrix matrix = this.w.inverse();
        Logger.info((String)("w=" + this.w));
        Logger.info((String)("w_inv=" + matrix));
        Matrix matrix2 = this.w.getSubmatrix(0, 0, 3, 3);
        Matrix matrix3 = this.w.getSubmatrix(3, 0, this.d, 3);
        Matrix matrix4 = this.w.getSubmatrix(0, 3, 3, this.d);
        Matrix matrix5 = this.w.getSubmatrix(3, 3, this.d, this.d);
        Matrix matrix6 = this.msRdr.getSigma();
        Matrix matrix7 = matrix5.mul(matrix6).add(matrix3).mul(matrix4.mul(matrix6).add(matrix2).inverse());
        Matrix matrix8 = matrix5.sub(matrix7.mul(matrix4));
        Logger.info((String)("sigma_nu = " + matrix7));
        SymmetryInterface symmetryInterface = this.msRdr.cr.asc.getSymmetry();
        V3[] v3Array = symmetryInterface.getUnitCellVectors();
        V3[] v3Array2 = this.reciprocalsOf(v3Array);
        Matrix matrix9 = new Matrix((double[][])null, 3 + this.d, 3);
        Matrix matrix10 = new Matrix((double[][])null, 3, 3);
        double[][] dArray = matrix9.getArray();
        double[][] dArray2 = matrix10.getArray();
        for (int i = 0; i < 3; ++i) {
            dArray2[i] = new double[]{v3Array2[i + 1].x, v3Array2[i + 1].y, v3Array2[i + 1].z};
            dArray[i] = dArray2[i];
        }
        Matrix matrix11 = matrix6.mul(matrix10);
        double[][] dArray3 = matrix11.getArray();
        for (int i = 0; i < this.d; ++i) {
            dArray[i + 3] = dArray3[i];
        }
        dArray3 = this.w.mul(matrix9).getArray();
        V3[] v3Array3 = new V3[4];
        v3Array3[0] = v3Array[0];
        for (n = 0; n < 3; ++n) {
            v3Array3[n + 1] = V3.new3((float)((float)dArray3[n][0]), (float)((float)dArray3[n][1]), (float)((float)dArray3[n][2]));
        }
        v3Array3 = this.reciprocalsOf(v3Array3);
        this.symmetry = Interface.getSymmetry().getUnitCell((T3[])v3Array3, false, null);
        this.modMatrices = new Matrix[]{matrix7, matrix8};
        if (!bl) {
            return;
        }
        this.isFinalized = true;
        Logger.info((String)("unit cell parameters: " + this.symmetry.getUnitCellInfo()));
        this.symmetry.createSpaceGroup(-1, "[subsystem " + this.code + "]", (Object)new Lst());
        n = symmetryInterface.getSpaceGroupOperationCount();
        for (int i = 0; i < n; ++i) {
            Matrix matrix12 = symmetryInterface.getOperationRsVs(i);
            Matrix matrix13 = matrix12.getRotation();
            Matrix matrix14 = matrix12.getTranslation();
            Matrix matrix15 = this.w.mul(matrix13).mul(matrix);
            Matrix matrix16 = this.w.mul(matrix14);
            String string = this.code;
            if (this.isMixed(matrix15)) {
                for (Map.Entry entry : this.msRdr.htSubsystems.entrySet()) {
                    Matrix matrix17;
                    Subsystem subsystem = (Subsystem)entry.getValue();
                    if (subsystem == this || this.isMixed(matrix17 = subsystem.w.mul(matrix13).mul(matrix))) continue;
                    matrix15 = matrix17;
                    matrix16 = subsystem.w.mul(matrix14);
                    string = subsystem.code;
                    break;
                }
            }
            String string2 = this.symmetry.addOp(string, matrix15, matrix16, matrix7);
            Logger.info((String)(this.code + "." + (i + 1) + (this.code.equals(string) ? "   " : ">" + string + " ") + (String)string2));
        }
    }

    private boolean isMixed(Matrix matrix) {
        double[][] dArray = matrix.getArray();
        int n = 3;
        while (--n >= 0) {
            int n2 = 3 + this.d;
            while (--n2 >= 3) {
                if (dArray[n][n2] == 0.0) continue;
                return true;
            }
        }
        return false;
    }

    private V3[] reciprocalsOf(V3[] v3Array) {
        V3[] v3Array2 = new V3[4];
        v3Array2[0] = v3Array[0];
        for (int i = 0; i < 3; ++i) {
            v3Array2[i + 1] = new V3();
            v3Array2[i + 1].cross((T3)v3Array[(i + 1) % 3 + 1], (T3)v3Array[(i + 2) % 3 + 1]);
            v3Array2[i + 1].scale(1.0f / v3Array[i + 1].dot((T3)v3Array2[i + 1]));
        }
        return v3Array2;
    }

    public String toString() {
        return "Subsystem " + this.code + "\n" + this.w;
    }
}

